/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.utils.xlsx;

import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.metadata.Sheet;
import com.alibaba.excel.support.ExcelTypeEnum;
import io.shulie.tro.web.app.utils.xlsx.ExcelUtils;
import io.shulie.tro.web.common.vo.excel.ExcelSheetVO;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

public class ExcelUtils {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, ArrayList<ArrayList<String>>> readExcelForXlsx(MultipartFile file, Integer ignoreRow) {
        HashMap<String, ArrayList<ArrayList<String>>> result = new HashMap<String, ArrayList<ArrayList<String>>>();
        int rowSize = 0;
        BufferedInputStream in = null;
        XSSFWorkbook workbook = null;
        try {
            try {
                in = new BufferedInputStream(file.getInputStream());
                workbook = new XSSFWorkbook((InputStream)in);
            }
            catch (IOException e) {
                log.error("\u5e94\u7528\u7ba1\u7406\u914d\u7f6e\u5bfc\u5165--\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
                throw new RuntimeException("\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef!");
            }
            for (int sheetIndex = 0; sheetIndex < workbook.getNumberOfSheets(); ++sheetIndex) {
                XSSFSheet sheet = workbook.getSheetAt(sheetIndex);
                ArrayList lists = new ArrayList();
                for (int rowIndex = ignoreRow.intValue(); rowIndex <= sheet.getLastRowNum(); ++rowIndex) {
                    XSSFRow row = sheet.getRow(rowIndex);
                    if (null == row) continue;
                    int tempRowSize = row.getLastCellNum() + 1;
                    if (tempRowSize > rowSize) {
                        rowSize = tempRowSize;
                    }
                    ArrayList<String> list = new ArrayList<String>();
                    int col = 0;
                    for (int colIndex = 0; colIndex <= row.getLastCellNum(); ++colIndex) {
                        String value;
                        XSSFCell cell = row.getCell(colIndex);
                        if (cell == null) continue;
                        CellType cellType = cell.getCellTypeEnum();
                        switch (1.$SwitchMap$org$apache$poi$ss$usermodel$CellType[cellType.ordinal()]) {
                            case 1: {
                                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                                    value = String.valueOf(cell.getDateCellValue());
                                    break;
                                }
                                value = String.valueOf(new DecimalFormat("0").format(cell.getNumericCellValue()));
                                break;
                            }
                            case 2: {
                                value = String.valueOf(cell.getStringCellValue());
                                break;
                            }
                            case 3: {
                                value = String.valueOf(cell.getCellFormula());
                                break;
                            }
                            case 4: {
                                value = String.valueOf(cell.getBooleanCellValue());
                                break;
                            }
                            case 5: {
                                value = String.valueOf(cell.getErrorCellValue());
                                break;
                            }
                            default: {
                                value = "";
                            }
                        }
                        list.add(value);
                    }
                    if (col == row.getRowNum() || list.size() <= 0) continue;
                    lists.add(list);
                }
                result.put(sheet.getSheetName(), lists);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
            }
            if (workbook != null) {
                try {
                    workbook.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
            }
        }
        return result;
    }

    public static void exportExcelManySheet(HttpServletResponse response, String fileName, List<ExcelSheetVO<?>> sheetDTOList) throws Exception {
        ServletOutputStream out = null;
        if (CollectionUtils.isEmpty(sheetDTOList)) {
            return;
        }
        try {
            out = response.getOutputStream();
            ExcelWriter writer = new ExcelWriter((OutputStream)out, ExcelTypeEnum.XLSX, true);
            String excelFileName = new String((fileName + "-" + new SimpleDateFormat("yyyy-MM-dd").format(new Date())).getBytes(), "UTF-8");
            for (int i = 0; i < sheetDTOList.size(); ++i) {
                ExcelSheetVO<?> excelSheetDTO = sheetDTOList.get(i);
                Sheet sheet = new Sheet(i + 1, 0, excelSheetDTO.getExcelModelClass());
                sheet.setSheetName(excelSheetDTO.getSheetName());
                writer.write(excelSheetDTO.getData(), sheet);
            }
            response.setContentType("application/octec-stream");
            response.setCharacterEncoding("utf-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(excelFileName + ".xlsx", "UTF-8"));
            writer.finish();
            out.flush();
        }
        catch (Exception e) {
            log.error("\u5bfc\u51faexcel \u5931\u8d25 \uff0c {}", (Object)e.getMessage());
            throw new Exception("\u5bfc\u51fa" + fileName + "\u5217\u8868\u5931\u8d25\uff01");
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }
}

