/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.utils;

import com.pamirs.tro.entity.domain.risk.LinkCount;
import io.shulie.tro.web.data.result.risk.LinkDataResult;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class LinkDataCalcUtil {
    private static final Integer KEEP_SCALE = 8;
    private static final BigDecimal ZERO = new BigDecimal("0");

    public static void main(String[] args) {
        LinkDataResult data1 = new LinkDataResult();
        data1.setEvent("/1");
        data1.setTps(Double.valueOf(1000.0));
        data1.setRt(Double.valueOf(100.0));
        data1.setErrorCount(Integer.valueOf(3));
        LinkDataResult data2 = new LinkDataResult();
        data2.setEvent("/2");
        data2.setTps(Double.valueOf(1200.0));
        data2.setRt(Double.valueOf(150.0));
        data2.setErrorCount(Integer.valueOf(7));
        LinkDataResult data3 = new LinkDataResult();
        data3.setEvent("/3");
        data3.setTps(Double.valueOf(1600.0));
        data3.setRt(Double.valueOf(200.0));
        data3.setErrorCount(Integer.valueOf(18));
        LinkDataResult data31 = new LinkDataResult();
        data31.setEvent("/3/1");
        data31.setTps(Double.valueOf(1000.0));
        data31.setRt(Double.valueOf(100.0));
        data31.setErrorCount(Integer.valueOf(12));
        LinkDataResult data32 = new LinkDataResult();
        data32.setEvent("/3/2");
        data32.setTps(Double.valueOf(600.0));
        data32.setRt(Double.valueOf(50.0));
        data32.setErrorCount(Integer.valueOf(14));
        data3.setSubLink(Arrays.asList(data31, data32));
        LinkDataCalcUtil calcUtil = new LinkDataCalcUtil();
        LinkCount linkCount = new LinkCount();
        calcUtil.calcLinkWeight(linkCount, null, Arrays.asList(data1, data2, data3));
        System.out.println("------- num=" + linkCount.getCount());
    }

    public void getBottleneckInterfaces(List<LinkDataResult> interfaceList, Integer count, BigDecimal avg, List<LinkDataResult> bottleneckList) {
        if (CollectionUtils.isEmpty(interfaceList)) {
            return;
        }
        for (LinkDataResult data : interfaceList) {
            data.setNodeCount(count);
            if (data.getRealWeight().compareTo(avg) >= 0) {
                bottleneckList.add(data);
            }
            this.getBottleneckInterfaces(data.getSubLink(), count, avg, bottleneckList);
        }
    }

    public void calcLinkWeight(LinkCount linkCount, LinkDataResult parent, List<LinkDataResult> sonList) {
        if (CollectionUtils.isEmpty(sonList)) {
            return;
        }
        linkCount.setCount(Integer.valueOf(linkCount.getCount() + sonList.size()));
        if (parent == null) {
            this.calcSonList(sonList);
        } else {
            this.calcParentAndSonList(parent, sonList);
        }
        for (LinkDataResult son : sonList) {
            this.calcLinkWeight(linkCount, son, son.getSubLink());
        }
    }

    private void calcSonList(List<LinkDataResult> sonList) {
        BigDecimal totalTps = sonList.stream().map(data -> new BigDecimal(data.getTps())).reduce(BigDecimal::add).get();
        BigDecimal totalRt = sonList.stream().map(data -> new BigDecimal(data.getRt())).reduce(BigDecimal::add).get();
        BigDecimal totalErrors = sonList.stream().map(data -> new BigDecimal(data.getErrorCount())).reduce(BigDecimal::add).get();
        for (LinkDataResult data2 : sonList) {
            data2.setCalcWeight(this.avg(this.rate(new BigDecimal(data2.getTps()), totalTps), this.rate(new BigDecimal(data2.getRt()), totalRt), this.rate(new BigDecimal(data2.getErrorCount()), totalErrors), totalErrors));
            data2.setRealWeight(data2.getCalcWeight());
        }
    }

    private void calcParentAndSonList(LinkDataResult parent, List<LinkDataResult> sonList) {
        BigDecimal totalTps = sonList.stream().map(data -> new BigDecimal(data.getTps())).reduce(BigDecimal::add).get();
        totalTps = totalTps.add(new BigDecimal(parent.getTps()));
        BigDecimal totalRt = new BigDecimal(parent.getRt());
        BigDecimal totalErrors = sonList.stream().map(data -> new BigDecimal(data.getErrorCount())).reduce(BigDecimal::add).get();
        totalErrors = totalErrors.add(new BigDecimal(parent.getErrorCount()));
        for (LinkDataResult data2 : sonList) {
            data2.setCalcWeight(this.avg(this.rate(new BigDecimal(data2.getTps()), totalTps), this.rate(new BigDecimal(data2.getRt()), totalRt), this.rate(new BigDecimal(data2.getErrorCount()), totalErrors), totalErrors));
            data2.setCalcWeight(this.weight(data2.getCalcWeight(), parent.getCalcWeight()));
            data2.setRealWeight(data2.getCalcWeight());
        }
        BigDecimal totalSonRt = sonList.stream().map(data -> new BigDecimal(data.getRt())).reduce(BigDecimal::add).get();
        parent.setRealWeight(this.avg(this.rate(new BigDecimal(parent.getTps()), totalTps), this.rate(new BigDecimal(parent.getRt()).subtract(totalSonRt), totalRt), this.rate(new BigDecimal(parent.getErrorCount()), totalErrors), totalErrors));
        parent.setRealWeight(this.weight(parent.getRealWeight(), parent.getCalcWeight()));
    }

    private BigDecimal rate(BigDecimal num1, BigDecimal num2) {
        if (num1.compareTo(ZERO) <= 0 || num2.compareTo(ZERO) <= 0) {
            return BigDecimal.ZERO;
        }
        return num1.divide(num2, (int)KEEP_SCALE, RoundingMode.HALF_UP);
    }

    private BigDecimal avg(BigDecimal num1, BigDecimal num2, BigDecimal num3, BigDecimal totalErrors) {
        if (totalErrors.compareTo(ZERO) >= 1) {
            return num1.add(num2).add(num3).divide(new BigDecimal("3"), (int)KEEP_SCALE, RoundingMode.HALF_UP);
        }
        return num1.add(num2).divide(new BigDecimal("2"), (int)KEEP_SCALE, RoundingMode.HALF_UP);
    }

    private BigDecimal weight(BigDecimal num1, BigDecimal num2) {
        return num1.multiply(num2).setScale((int)KEEP_SCALE, RoundingMode.HALF_UP);
    }

    public BigDecimal calcAvgRate(Integer count) {
        return new BigDecimal("1").divide(new BigDecimal(count), (int)KEEP_SCALE, RoundingMode.HALF_UP);
    }
}

