/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.utils;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileUtils {
    private static Logger logger = LoggerFactory.getLogger(FileUtils.class);

    public static File createFileDE(String filePathName) {
        File file = new File(filePathName);
        if (file.exists() && !file.delete()) {
            return null;
        }
        if (!FileUtils.makeDir((File)file.getParentFile())) {
            return null;
        }
        try {
            if (!file.createNewFile()) {
                return null;
            }
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        return file;
    }

    public static boolean makeDir(File dir) {
        if (!dir.exists()) {
            File parent = dir.getParentFile();
            if (parent != null) {
                FileUtils.makeDir((File)parent);
            }
            return dir.mkdir();
        }
        return true;
    }

    public static List<File> getDirectoryFiles(String dir, String fileEndsWith) {
        File[] files;
        ArrayList<File> scriptFiles = new ArrayList<File>();
        if (dir == null) {
            return null;
        }
        File fileDir = new File(dir);
        if (!fileDir.isDirectory()) {
            logger.warn("Expected a dir, but not: '{}'", (Object)fileDir.getPath());
        }
        if (!fileDir.isAbsolute()) {
            logger.warn("Expected a absolute path, bu not: '{}'", (Object)fileDir.getPath());
        }
        if ((files = fileDir.listFiles(file -> {
            if (fileEndsWith == null) {
                return true;
            }
            return file.getName().endsWith(fileEndsWith);
        })) == null || files.length == 0) {
            return null;
        }
        scriptFiles.addAll(Arrays.asList(files));
        return scriptFiles;
    }

    public static boolean deleteDir(File dir) {
        String[] children;
        if (dir.isDirectory() && (children = dir.list()) != null) {
            for (String child : children) {
                if (FileUtils.deleteDir((File)new File(child))) continue;
                return false;
            }
        }
        return dir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeTextFile(String content, String filePathName) {
        File file = FileUtils.createFileDE((String)filePathName);
        if (file == null) {
            return false;
        }
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file));
            writer.write(content);
            writer.flush();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean appendTextFile(String content, String filePathName) {
        File file = new File(filePathName);
        if (!file.exists()) {
            FileUtils.makeDir((File)file.getParentFile());
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                logger.error(e.getMessage());
            }
        }
        if (file == null) {
            return false;
        }
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file));
            writer.append(content);
            writer.flush();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFileContent(File file) {
        InputStreamReader reader = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int length;
            reader = new InputStreamReader(new FileInputStream(file));
            char[] buffer = new char[32];
            while ((length = reader.read(buffer)) > 0) {
                stringBuilder.append(buffer, 0, length);
            }
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appentContent2(String filePath, String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return;
        }
        OutputStreamWriter fw = null;
        PrintWriter pw = null;
        try {
            File newFile = new File(filePath);
            if (!newFile.exists()) {
                FileUtils.makeDir((File)newFile.getParentFile());
                try {
                    newFile.createNewFile();
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                }
            }
            fw = new FileWriter(newFile, true);
            pw = new PrintWriter(fw);
            pw.println(content);
            pw.flush();
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        finally {
            try {
                fw.flush();
                pw.close();
                fw.close();
            }
            catch (IOException e) {
                logger.error(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject readLine(String filePath, int index, int count) {
        JSONObject json = new JSONObject();
        ArrayList pins = Lists.newArrayList();
        long lineNumber = 0L;
        try {
            lineNumber = Files.lines(Paths.get(filePath, new String[0])).count();
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        File file = new File(filePath);
        BufferedReader reader = null;
        int readLine = 0;
        InputStreamReader inputStreamReader = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
            reader = new LineNumberReader(inputStreamReader);
            int lines = 0;
            while (true) {
                String pin = ((LineNumberReader)reader).readLine();
                ++readLine;
                if (lines >= index) {
                    pins.add(pin);
                }
                if (count == pins.size()) break;
                if ((long)readLine >= lineNumber) {
                    break;
                }
                ++lines;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        json.put("list", (Object)pins);
        json.put("lineNum", (Object)lineNumber);
        return json;
    }

    public static List<String> getFileNames(String path) {
        try {
            File file = new File(path);
            if (file == null) {
                return Lists.newArrayList();
            }
            String[] list = file.list();
            if (list == null) {
                return Lists.newArrayList();
            }
            return Arrays.asList(list);
        }
        catch (Exception e) {
            return Lists.newArrayList();
        }
    }

    public static boolean existFile(String path) {
        File file = new File(path);
        return null != file && file.exists();
    }

    public static void deleteFileByCreateTime(String filePath, Long deleteTime) throws IOException {
        File[] files;
        if (StringUtils.isBlank((CharSequence)filePath) || deleteTime == null || filePath.equals("/") || filePath.equals("/root")) {
            return;
        }
        File root = new File(filePath);
        for (File file : files = root.listFiles()) {
            if (file.isDirectory()) {
                FileUtils.deleteFileByCreateTime((String)file.getAbsolutePath(), (Long)deleteTime);
                continue;
            }
            Path path = Paths.get(file.getAbsolutePath(), new String[0]);
            BasicFileAttributeView basicview = Files.getFileAttributeView(path, BasicFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
            BasicFileAttributes attr = null;
            attr = basicview.readAttributes();
            long fileCreateTime = attr.creationTime().toMillis();
            if (fileCreateTime >= deleteTime) continue;
            file.delete();
        }
    }

    public static String getByteSize(long size) {
        if (size < 1024L) {
            return String.valueOf(size) + "B";
        }
        if ((size /= 1024L) < 1024L) {
            return String.valueOf(size) + "KB";
        }
        if ((size /= 1024L) < 1024L) {
            return String.valueOf((size *= 100L) / 100L) + "." + String.valueOf(size % 100L) + "MB";
        }
        size = size * 100L / 1024L;
        return String.valueOf(size / 100L) + "." + String.valueOf(size % 100L) + "GB";
    }
}

