/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pamirs.tro.entity.domain.annotation.ExcelTag;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFDataFormatter;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExcelUtil<T> {
    private static void setResponse(HttpServletResponse response, String fileName) {
        try {
            try {
                fileName = new String(fileName.getBytes(), "ISO8859-1");
                response.setContentType("application/octet-stream;charset=ISO8859-1");
                response.setHeader("Content-Disposition", "attachment;filename=" + fileName + ".xls");
                response.addHeader("Pargam", "no-cache");
                response.addHeader("Cache-Control", "no-cache");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static <T> Map<String, List<T>> readExcel(String path, Class<T> clazz) {
        Map map = ExcelUtil.readExcel((String)path);
        return map.keySet().stream().collect(Collectors.toMap(key -> key, key -> {
            ArrayList listBean = Lists.newArrayList();
            Field[] fields = clazz.getDeclaredFields();
            Object uBean = null;
            for (int i = 1; i < ((List)map.get(key)).size(); ++i) {
                try {
                    uBean = clazz.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
                List listStr = (List)((List)map.get(key)).get(i);
                for (int j = 0; j < listStr.size() && j < fields.length; ++j) {
                    Field field = fields[j];
                    String datastring = (String)listStr.get(j);
                    field.setAccessible(true);
                    ExcelUtil.setData(uBean, (Field)field, (String)datastring);
                }
                listBean.add(uBean);
            }
            return listBean;
        }, (k1, k2) -> k1));
    }

    private static <T> void setData(T uBean, Field field, String dataString) {
        if (dataString.length() > 0) {
            try {
                Class<?> type = field.getType();
                if (type == String.class) {
                    field.set(uBean, dataString);
                } else if (type == Integer.class || type == Integer.TYPE) {
                    field.set(uBean, Integer.parseInt(dataString));
                } else if (type == Double.class || type == Double.TYPE) {
                    field.set(uBean, Double.parseDouble(dataString));
                } else if (type == Float.class || type == Float.TYPE) {
                    field.set(uBean, Float.valueOf(Float.parseFloat(dataString)));
                } else if (type == Long.class || type == Long.TYPE) {
                    field.set(uBean, Long.parseLong(dataString));
                } else if (type == Boolean.class || type == Boolean.TYPE) {
                    field.set(uBean, Boolean.parseBoolean(dataString));
                } else if (type == Short.class || type == Short.TYPE) {
                    field.set(uBean, Short.parseShort(dataString));
                } else if (type == Byte.class || type == Byte.TYPE) {
                    field.set(uBean, Byte.parseByte(dataString));
                } else if (type == Character.class || type == Character.TYPE) {
                    field.set(uBean, Character.valueOf(dataString.charAt(0)));
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public static Map<String, List<List<String>>> readExcel(String path) {
        HashMap map = Maps.newHashMap();
        try {
            XSSFWorkbook workBook = null;
            try {
                workBook = new XSSFWorkbook(path);
            }
            catch (Exception ex) {
                workBook = new HSSFWorkbook((InputStream)new FileInputStream(path));
            }
            for (int numSheet = 0; numSheet < workBook.getNumberOfSheets(); ++numSheet) {
                Sheet sheet = workBook.getSheetAt(numSheet);
                if (sheet == null) continue;
                int totalRows = sheet.getPhysicalNumberOfRows();
                int totalCells = 0;
                if (totalRows >= 1 && sheet.getRow(0) != null) {
                    totalCells = sheet.getRow(0).getPhysicalNumberOfCells();
                }
                ArrayList dataLst = Lists.newArrayList();
                for (int r = 0; r < totalRows; ++r) {
                    Row row = sheet.getRow(r);
                    if (row == null) continue;
                    ArrayList rowLst = Lists.newArrayList();
                    for (int c = 0; c < totalCells; ++c) {
                        Cell cell = row.getCell(c);
                        String cellValue = "";
                        if (null != cell) {
                            HSSFDataFormatter hSSFDataFormatter = new HSSFDataFormatter();
                            cellValue = hSSFDataFormatter.formatCellValue(cell);
                        }
                        rowLst.add(cellValue);
                    }
                    dataLst.add(rowLst);
                }
                map.put(sheet.getSheetName(), dataLst);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return map;
    }

    public static Map<String, List<List<String>>> readExcel(InputStream in) {
        HashMap map = Maps.newHashMap();
        try {
            HSSFWorkbook workBook = new HSSFWorkbook(in);
            for (int numSheet = 0; numSheet < workBook.getNumberOfSheets(); ++numSheet) {
                Sheet sheet = workBook.getSheetAt(numSheet);
                if (sheet == null) continue;
                int totalRows = sheet.getPhysicalNumberOfRows();
                int totalCells = 0;
                if (totalRows >= 1 && sheet.getRow(0) != null) {
                    totalCells = sheet.getRow(0).getPhysicalNumberOfCells();
                }
                ArrayList dataLst = Lists.newArrayList();
                for (int r = 0; r < totalRows; ++r) {
                    Row row = sheet.getRow(r);
                    if (row == null) continue;
                    ArrayList rowLst = Lists.newArrayList();
                    for (int c = 0; c < totalCells; ++c) {
                        Cell cell = row.getCell(c);
                        String cellValue = "";
                        if (null != cell) {
                            HSSFDataFormatter hSSFDataFormatter = new HSSFDataFormatter();
                            cellValue = hSSFDataFormatter.formatCellValue(cell);
                        }
                        rowLst.add(cellValue);
                    }
                    dataLst.add(rowLst);
                }
                map.put(sheet.getSheetName(), dataLst);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return map;
    }

    public void export(HttpServletResponse response, List<T> data, List<String> titles, String fileName) throws Exception {
        int i;
        if (null == data || data.size() < 1) {
            throw new Exception("\u5bfc\u51fa\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet();
        titles = this.titles(data);
        HSSFCellStyle style = this.init(wb);
        HSSFRow row = sheet.createRow(0);
        HSSFCell cell = null;
        for (i = 0; i < titles.size(); ++i) {
            cell = row.createCell(i);
            cell.setCellStyle(style);
            cell.setCellValue((String)titles.get(i));
        }
        for (i = 0; i < data.size(); ++i) {
            HSSFRow irow = sheet.createRow(i + 1);
            HSSFCell icell = null;
            List values = this.values(data.get(i));
            for (int j = 0; j < values.size(); ++j) {
                icell = irow.createCell(j);
                icell.setCellStyle(style);
                icell.setCellValue((String)values.get(j));
            }
        }
        try {
            ExcelUtil.setResponse((HttpServletResponse)response, (String)fileName);
            ServletOutputStream out = response.getOutputStream();
            wb.write((OutputStream)out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<String> titles(List<T> data) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            Field[] fields;
            if (CollectionUtils.isEmpty(data)) {
                return null;
            }
            T t = data.get(0);
            for (Field field : fields = t.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                if (!field.isAnnotationPresent(ExcelTag.class)) continue;
                ExcelTag tag = field.getAnnotation(ExcelTag.class);
                result.add(tag.name());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private List<String> values(T t) {
        ArrayList<String> values = new ArrayList<String>();
        Field[] fields = t.getClass().getDeclaredFields();
        try {
            for (Field field : fields) {
                field.setAccessible(true);
                if (!field.isAnnotationPresent(ExcelTag.class)) continue;
                ExcelTag tag = field.getAnnotation(ExcelTag.class);
                Class tagValue = tag.type();
                if (tagValue == String.class) {
                    String split;
                    String[] splits;
                    String rule;
                    String[] ruleSplit;
                    Iterator<String> iterator;
                    boolean convert;
                    String originValue = String.valueOf(field.get(t));
                    if ("null".equalsIgnoreCase(originValue)) {
                        originValue = "";
                    }
                    if ((convert = tag.convert()) && (iterator = Arrays.asList(ruleSplit = (rule = tag.rule()).split(",")).iterator()).hasNext() && StringUtils.equalsIgnoreCase((CharSequence)(splits = (split = iterator.next()).split("="))[0], (CharSequence)originValue)) {
                        originValue = splits[1];
                    }
                    values.add(originValue);
                    continue;
                }
                if (tagValue.getName().equals("java.util.List")) {
                    List tagValueList = (List)field.get(t);
                    JSONArray jsonArray = new JSONArray();
                    for (int i = 0; i < tagValueList.size(); ++i) {
                        Object obj = tagValueList.get(i);
                        Field[] declaredFields = obj.getClass().getDeclaredFields();
                        JSONObject jsonObject = new JSONObject();
                        for (Field field1 : declaredFields) {
                            field1.setAccessible(true);
                            ExcelTag annotation = field1.getAnnotation(ExcelTag.class);
                            if (null == annotation) continue;
                            String s = String.valueOf(field1.get(obj));
                            jsonObject.put(annotation.name(), (Object)s);
                        }
                        jsonArray.add(i, (Object)jsonObject);
                    }
                    values.add(jsonArray.toJSONString());
                }
                if (tagValue != Date.class) continue;
                try {
                    values.add(this.formate((Date)field.get(t)));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return values;
    }

    private String formate(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat();
        return dateFormat.format(date);
    }

    private HSSFCellStyle init(HSSFWorkbook wb) {
        HSSFFont font1 = wb.createFont();
        HSSFFont font2 = wb.createFont();
        font1.setFontHeightInPoints((short)14);
        font1.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        font2.setFontHeightInPoints((short)12);
        font2.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        HSSFCellStyle css1 = wb.createCellStyle();
        HSSFCellStyle css2 = wb.createCellStyle();
        HSSFDataFormat df = wb.createDataFormat();
        css1.setFont(font1);
        css1.setDataFormat(df.getFormat("#,##0.0"));
        css2.setFont(font2);
        css1.setBorderBottom(BorderStyle.THIN);
        css1.setBorderTop(BorderStyle.THIN);
        css1.setBorderRight(BorderStyle.THIN);
        css1.setBorderLeft(BorderStyle.THIN);
        return css1;
    }

    public void verify(MultipartFile[] files) throws Exception {
        if (files == null) {
            throw new Exception("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a");
        }
        for (MultipartFile file : files) {
            String fileName = file.getOriginalFilename();
            if (fileName.endsWith(".xls") || fileName.endsWith(".xlsx")) continue;
            throw new Exception("\u4e0d\u652f\u6301\u7684\u4e0a\u4f20\u6587\u4ef6\u7c7b\u578b");
        }
    }
}

