/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.utils;

import com.pamirs.tro.common.enums.ds.DsTypeEnum;
import com.pamirs.tro.entity.domain.vo.dsmanage.Configurations;
import com.pamirs.tro.entity.domain.vo.dsmanage.DataSource;
import com.pamirs.tro.entity.domain.vo.dsmanage.DatasourceMediator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DsManageUtil {
    private static final Logger log = LoggerFactory.getLogger(DsManageUtil.class);

    public static boolean isEsServerType(Integer dsType) {
        return DsTypeEnum.SHADOW_ES_SERVER.getCode().equals(dsType);
    }

    public static boolean isHbaseServerType(Integer dsType) {
        return DsTypeEnum.SHADOW_HBASE_SERVER.getCode().equals(dsType);
    }

    public static boolean isServerDsType(Integer dsType) {
        return DsTypeEnum.SHADOW_REDIS_SERVER.getCode().equals(dsType);
    }

    public static boolean isTableDsType(Integer dsType) {
        return DsTypeEnum.SHADOW_TABLE.getCode().equals(dsType);
    }

    public static boolean isSchemaDsType(Integer dsType) {
        return DsTypeEnum.SHADOW_DB.getCode().equals(dsType);
    }

    public static boolean isNewVersionSchemaDsType(Integer dsType, boolean isNewVersion) {
        return DsTypeEnum.SHADOW_DB.getCode().equals(dsType) && isNewVersion;
    }

    public static String parseShadowTableUrl(String url) {
        if (url == null) {
            return null;
        }
        if (url.contains("?")) {
            return url.substring(0, url.indexOf("?"));
        }
        return url;
    }

    public static String getOriginPasswordFieldAboutJson(String password) {
        return String.format("\"password\":\"%s\"", password);
    }

    public static String getSafePasswordFieldAboutJson() {
        return String.format("\"password\":\"%s\"", "********");
    }

    public static String getSafePasswordElementAboutXml() {
        return String.format("<property name=\"password\" value=\"%s\"/>", "********");
    }

    public static String getOriginPasswordElementAboutXml(String password) {
        return String.format("<property name=\"password\" value=\"%s\"/>", password);
    }

    public static Configurations getConfigurationsByXml(String xml) {
        xml = DsManageUtil.replaceSpecialCharacters((String)xml);
        SAXReader reader = new SAXReader();
        try {
            Configurations configurations = new Configurations();
            Document document = reader.read((InputStream)new ByteArrayInputStream(xml.getBytes()));
            Element root = document.getRootElement();
            Element datasourceMediatorElement = root.element("datasourceMediator");
            List datasourceElementList = root.element("datasources").elements("datasource");
            DatasourceMediator datasourceMediator = DsManageUtil.parseDatasourceMediator((Element)datasourceMediatorElement);
            ArrayList<DataSource> dataSourceList = new ArrayList<DataSource>();
            for (Element element : datasourceElementList) {
                dataSourceList.add(DsManageUtil.parseDataSource((Element)element));
            }
            configurations.setDatasourceMediator(datasourceMediator);
            configurations.setDataSources(dataSourceList);
            return configurations;
        }
        catch (Exception e) {
            log.error("XML \u89e3\u6790\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private static String replaceSpecialCharacters(String xmlString) {
        return xmlString.replaceAll("&", "&amp;");
    }

    private static DatasourceMediator parseDatasourceMediator(Element element) {
        if (element == null) {
            return null;
        }
        DatasourceMediator mediator = new DatasourceMediator();
        List propertyList = element.elements("property");
        for (Element property : propertyList) {
            Attribute nameAttr = property.attribute("name");
            Attribute refAttr = property.attribute("ref");
            if (nameAttr == null || refAttr == null) continue;
            String name = nameAttr.getValue();
            String ref = refAttr.getValue();
            if ("dataSourceBusiness".equals(name)) {
                mediator.setDataSourceBusiness(ref);
            }
            if (!"dataSourcePerformanceTest".equals(name)) continue;
            mediator.setDataSourcePerformanceTest(ref);
        }
        return mediator;
    }

    private static DataSource parseDataSource(Element element) {
        if (element == null) {
            return null;
        }
        DataSource dataSource = new DataSource();
        Attribute idAttr = element.attribute("id");
        if (idAttr != null && idAttr.getValue() != null) {
            dataSource.setId(idAttr.getValue());
        }
        List propertyList = element.elements("property");
        for (Element property : propertyList) {
            Attribute nameAttr = property.attribute("name");
            Attribute valueAttr = property.attribute("value");
            if (nameAttr == null || valueAttr == null) continue;
            String name = nameAttr.getValue();
            String value = valueAttr.getValue();
            if ("driverClassName".equals(name)) {
                dataSource.setDriverClassName(value);
            }
            if ("url".equals(name)) {
                dataSource.setUrl(value);
            }
            if ("schema".equals(name)) {
                dataSource.setSchema(value);
            }
            if ("username".equals(name)) {
                dataSource.setUsername(value);
            }
            if ("password".equals(name)) {
                dataSource.setPassword(value);
            }
            if ("initialSize".equals(name)) {
                dataSource.setInitialSize(value);
            }
            if ("minIdle".equals(name)) {
                dataSource.setMinIdle(value);
            }
            if ("maxActive".equals(name)) {
                dataSource.setMaxActive(value);
            }
            if ("maxWait".equals(name)) {
                dataSource.setMaxWait(value);
            }
            if ("timeBetweenEvictionRunsMillis".equals(name)) {
                dataSource.setTimeBetweenEvictionRunsMillis(value);
            }
            if ("minEvictableIdleTimeMillis".equals(name)) {
                dataSource.setMinEvictableIdleTimeMillis(value);
            }
            if ("validationQuery".equals(name)) {
                dataSource.setValidationQuery(value);
            }
            if ("testWhileIdle".equals(name)) {
                dataSource.setTestWhileIdle(value);
            }
            if ("testOnBorrow".equals(name)) {
                dataSource.setTestOnBorrow(value);
            }
            if ("testOnReturn".equals(name)) {
                dataSource.setTestOnReturn(value);
            }
            if ("poolPreparedStatements".equals(name)) {
                dataSource.setPoolPreparedStatements(value);
            }
            if ("maxPoolPreparedStatementPerConnectionSize".equals(name)) {
                dataSource.setMaxPoolPreparedStatementPerConnectionSize(value);
            }
            if (!"connectionProperties".equals(name)) continue;
            dataSource.setConnectionProperties(value);
        }
        return dataSource;
    }
}

