/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.utils;

import com.opencsv.CSVWriter;
import com.opencsv.bean.ColumnPositionMappingStrategy;
import com.opencsv.bean.MappingStrategy;
import com.opencsv.bean.StatefulBeanToCsv;
import com.opencsv.bean.StatefulBeanToCsvBuilder;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import io.shulie.tro.web.app.response.user.UserCsvBean;
import io.shulie.tro.web.app.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVUtil {
    private static Logger log = LoggerFactory.getLogger(CSVUtil.class);

    public static void writeCsvFile(List<UserCsvBean> dataList, String finalPath) {
        File file = new File(finalPath);
        if (!file.exists()) {
            FileUtils.makeDir((File)file.getParentFile());
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
        }
        try {
            FileWriterWithEncoding writer = new FileWriterWithEncoding(finalPath, "GBK");
            ColumnPositionMappingStrategy mapper = new ColumnPositionMappingStrategy();
            mapper.setType(UserCsvBean.class);
            CSVWriter csvWriter = new CSVWriter((Writer)writer, ',', '\u0000', '\\', "\n");
            String[] header = new String[]{"\u90e8\u95e8\uff08\u591a\u4e2a\u90e8\u95e8\u4f7f\u7528/\u5206\u9694\uff09", "\u8d26\u53f7\u540d\u79f0", "\u8d26\u53f7\u5bc6\u7801", "\u9519\u8bef\u4fe1\u606f"};
            csvWriter.writeNext(header);
            StatefulBeanToCsv beanToCsv = new StatefulBeanToCsvBuilder((Writer)writer).withMappingStrategy((MappingStrategy)mapper).withQuotechar('\u0000').withSeparator(',').withEscapechar('\\').build();
            beanToCsv.write(dataList);
            csvWriter.close();
            writer.close();
        }
        catch (CsvDataTypeMismatchException | CsvRequiredFieldEmptyException | IOException e) {
            log.error("writeCsvFile filed:", e);
        }
    }
}

