/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.task;

import com.pamirs.tro.common.util.DateUtils;
import io.shulie.tro.common.beans.page.PagingList;
import io.shulie.tro.web.app.response.perfomanceanaly.PressureMachineResponse;
import io.shulie.tro.web.app.service.perfomanceanaly.PressureMachineLogService;
import io.shulie.tro.web.app.service.perfomanceanaly.PressureMachineService;
import io.shulie.tro.web.app.service.perfomanceanaly.PressureMachineStatisticsService;
import io.shulie.tro.web.data.param.machine.PressureMachineQueryParam;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class PressureMachineStasticsTask {
    private static final Logger log = LoggerFactory.getLogger(PressureMachineStasticsTask.class);
    @Autowired
    private PressureMachineStatisticsService pressureMachineStatisticsService;
    @Autowired
    private PressureMachineService pressureMachineService;
    @Value(value="${pressure.machine.upload.interval.time:180000}")
    private Long machineUploadIntervalTime;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private PressureMachineLogService machineLogService;

    @Scheduled(cron="0 */1 * * * ?")
    public void statisticsPressureMachine() {
        Boolean aBoolean = this.redisTemplate.opsForValue().setIfAbsent((Object)"pressure:machine:statistics:schedule:task:key", (Object)"1", 50L, TimeUnit.SECONDS);
        if (aBoolean instanceof Boolean && aBoolean.booleanValue()) {
            this.pressureMachineStatisticsService.statistics();
        }
    }

    @Scheduled(cron="0 */1 * * * ?")
    public void judgePressureMachineStatus() {
        Boolean aBoolean = this.redisTemplate.opsForValue().setIfAbsent((Object)"pressure:mcahine:offline:status:calculate:key", (Object)"1", 50L, TimeUnit.SECONDS);
        if (aBoolean instanceof Boolean && aBoolean.booleanValue()) {
            this.doJudgePressureMachineStatus();
        }
    }

    @Scheduled(cron="0 0 */3 * * ?")
    public void clearPressureMachineStatisticsData() {
        this.pressureMachineStatisticsService.clearRubbishData();
    }

    @Scheduled(cron="0 0 */2 * * ?")
    public void clearPressureMachineLogRubbishData() {
        this.machineLogService.clearRubbishData();
    }

    private void doJudgePressureMachineStatus() {
        PressureMachineQueryParam param = new PressureMachineQueryParam();
        param.setCurrent(0);
        param.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        PagingList pressureMachineResponsePagingList = this.pressureMachineService.queryByExample(param);
        List list = pressureMachineResponsePagingList.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        for (PressureMachineResponse machine : list) {
            Date updateTime;
            if (machine.getStatus() == -1 || (updateTime = DateUtils.strToDate((String)machine.getGmtUpdate(), null)) == null || System.currentTimeMillis() - updateTime.getTime() <= this.machineUploadIntervalTime) continue;
            this.pressureMachineService.updatePressureMachineStatus(machine.getId(), Integer.valueOf(-1));
        }
    }
}

