/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.task;

import io.shulie.tro.web.app.service.LinkBottleneckService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class LinkBottleneckTask
implements ApplicationListener<ContextRefreshedEvent> {
    private static Logger logger = LoggerFactory.getLogger(LinkBottleneckTask.class);
    @Autowired
    private LinkBottleneckService linkBottleneckService;
    @Value(value="${flag:true}")
    private boolean flag;
    private int initialDelay = 30;

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        try {
            if (this.flag) {
                ScheduledExecutorService service = Executors.newScheduledThreadPool(1);
                service.scheduleAtFixedRate(() -> this.linkBottleneckService.handleLinkBottleneck(), this.initialDelay, this.initialDelay, TimeUnit.SECONDS);
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new RuntimeException(e);
        }
    }
}

