/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.task;

import com.github.pagehelper.util.StringUtil;
import com.pamirs.tro.common.util.DateUtils;
import io.shulie.tro.web.app.constant.FastDebugLogPathFactory;
import io.shulie.tro.web.app.service.fastdebug.FastDebugMachinePerformanceService;
import io.shulie.tro.web.app.service.fastdebug.FastDebugStackInfoService;
import io.shulie.tro.web.app.utils.FileUtils;
import java.io.IOException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class FastDebugSchedulerTask {
    private static final Logger log = LoggerFactory.getLogger(FastDebugSchedulerTask.class);
    @Autowired
    private FastDebugLogPathFactory pathFactory;
    @Autowired
    private FastDebugMachinePerformanceService fastDebugMachinePerformanceService;
    @Autowired
    private FastDebugStackInfoService fastDebugStackInfoService;

    @Scheduled(cron="0 0 2 * * ?")
    public void clear() {
        log.info("\u6267\u884c\u5220\u9664\u62c9\u53d6\u7684\u5e94\u7528\u65e5\u5fd7\u5b9a\u65f6\u4efb\u52a1...");
        long start = System.currentTimeMillis();
        Date previousNDay = DateUtils.getPreviousNDay((int)15);
        try {
            this.clearAgentAndAPPlog(previousNDay);
        }
        catch (Exception e) {
            log.error("\u6267\u884c\u6e05\u7406agent\u4e0a\u62a5\u7684\u65e5\u5fd7\u4efb\u52a1\u5931\u8d25\uff1b ", (Throwable)e);
        }
        try {
            this.clearMachinePerformance(previousNDay);
        }
        catch (Exception e) {
            log.error("\u6267\u884c\u6e05\u7406\u8c03\u8bd5\u673a\u5668\u6027\u80fd\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
        try {
            this.clearHistoryStackInfoData(previousNDay);
        }
        catch (Exception e) {
            log.error("\u6267\u884c\u6e05\u7406\u8c03\u8bd5\u6808\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
        log.info("execute fastdebug scheduler task cost : {}", (Object)(System.currentTimeMillis() - start + "ms"));
    }

    public void clearAgentAndAPPlog(Date date) throws IOException {
        String logPathPre = this.pathFactory.getLogPathPre();
        if (StringUtil.isEmpty((String)logPathPre) || date == null) {
            return;
        }
        FileUtils.deleteFileByCreateTime((String)logPathPre, (Long)date.getTime());
    }

    public void clearMachinePerformance(Date beforeDate) {
        this.fastDebugMachinePerformanceService.clearHistoryData(beforeDate);
    }

    public void clearHistoryStackInfoData(Date beforeDate) {
        this.fastDebugStackInfoService.clearHistory(beforeDate);
    }
}

