/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.user;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.pamirs.tro.entity.domain.entity.user.User;
import com.pamirs.tro.entity.domain.vo.user.UserLoginParam;
import io.shulie.tro.exception.entity.ExceptionReadable;
import io.shulie.tro.web.app.common.Response;
import io.shulie.tro.web.app.common.RestContext;
import io.shulie.tro.web.app.exception.ExceptionCode;
import io.shulie.tro.web.app.exception.TroWebException;
import io.shulie.tro.web.app.license.TroClientValidator;
import io.shulie.tro.web.app.output.user.TroUserOutput;
import io.shulie.tro.web.app.response.user.UserLoginResponse;
import io.shulie.tro.web.app.response.user.UserLogoutResponse;
import io.shulie.tro.web.app.service.auth.TroAuthService;
import io.shulie.tro.web.app.utils.TroUserUtil;
import io.shulie.tro.web.auth.api.exception.TroAuthException;
import io.shulie.tro.web.auth.api.exception.TroLoginException;
import io.shulie.tro.web.common.constant.TroClientAuthConstant;
import io.shulie.tro.web.common.util.verificationcode.VerificationCodeUtil;
import io.shulie.tro.web.data.dao.user.LoginRecordDao;
import io.shulie.tro.web.data.mapper.mysql.TroUserMapper;
import io.shulie.tro.web.data.model.mysql.TroUserEntity;
import io.shulie.tro.web.data.param.user.LoginRecordParam;
import io.shulie.tro.web.data.param.user.UserDeptQueryParam;
import io.shulie.tro.web.data.result.user.UserDeptResult;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class TroUserService {
    private static final Logger log = LoggerFactory.getLogger(TroUserService.class);
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private TroAuthService troAuthService;
    @Resource
    private TroUserMapper troUserMapper;
    @Autowired
    private LoginRecordDao loginRecordDao;

    public Response login(UserLoginParam userLoginParam, HttpServletRequest request, HttpServletResponse response) {
        try {
            TroUserEntity admin;
            this.saveLoginRecord(userLoginParam, request);
            this.checkCode(request, userLoginParam.getCode());
            User user = this.troAuthService.login(request, userLoginParam);
            UserDeptQueryParam userDeptQueryParam = new UserDeptQueryParam();
            userDeptQueryParam.setUserIdList(Arrays.asList(String.valueOf(user.getId())));
            List userDeptResultList = this.troAuthService.selectList(userDeptQueryParam);
            List userDeptResults = Optional.ofNullable(userDeptResultList).orElse(Lists.newArrayList());
            if (CollectionUtils.isNotEmpty((Collection)userDeptResults)) {
                user.setDeptList(((UserDeptResult)userDeptResults.get(0)).getDeptList());
            }
            if ((admin = this.getAdminUser(user.getCustomerId())) != null) {
                user.setCustomerId(admin.getId());
                user.setCustomerKey(admin.getKey());
            }
            log.warn("Login User->Admin, userId={}, adminId={}, adminkey={}", new Object[]{user.getId(), user.getCustomerId(), user.getCustomerKey()});
            this.syncAuth(user);
            this.troAuthService.loginSuccess(user);
            UserLoginResponse userLoginResponse = new UserLoginResponse();
            userLoginResponse.setId(user.getId());
            userLoginResponse.setKey(user.getKey());
            userLoginResponse.setName(user.getName());
            userLoginResponse.setUserType(user.getUserType());
            userLoginResponse.setXToken(user.getXToken());
            userLoginResponse.setExpire(TroClientAuthConstant.isExpire);
            TroClientValidator.validate((String)user.getKey());
            return Response.success((Object)userLoginResponse);
        }
        catch (TroLoginException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Response.fail((String)"300", (String)e.getMessage(), null);
        }
    }

    private void saveLoginRecord(UserLoginParam userLoginParam, HttpServletRequest request) {
        String ipAddress = this.getIpAddr(request);
        LoginRecordParam param = new LoginRecordParam();
        param.setUserName(userLoginParam.getUsername());
        param.setIp(ipAddress);
        this.loginRecordDao.insert(param);
    }

    private String getIpAddr(HttpServletRequest request) {
        String ipAddress = null;
        try {
            ipAddress = request.getHeader("x-forwarded-for");
            if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
                ipAddress = request.getHeader("Proxy-Client-IP");
            }
            if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
                ipAddress = request.getHeader("WL-Proxy-Client-IP");
            }
            if ((ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) && (ipAddress = request.getRemoteAddr()).equals("127.0.0.1")) {
                InetAddress inet = null;
                try {
                    inet = InetAddress.getLocalHost();
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
                ipAddress = inet.getHostAddress();
            }
            if (ipAddress != null && ipAddress.length() > 15 && ipAddress.indexOf(",") > 0) {
                ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
            }
        }
        catch (Exception e) {
            ipAddress = "";
        }
        return ipAddress;
    }

    public Response loginNoCode(UserLoginParam userLoginParam, HttpServletRequest request, HttpServletResponse response) {
        try {
            TroUserEntity admin;
            User user = this.troAuthService.login(request, userLoginParam);
            UserDeptQueryParam userDeptQueryParam = new UserDeptQueryParam();
            userDeptQueryParam.setUserIdList(Arrays.asList(String.valueOf(user.getId())));
            List userDeptResultList = this.troAuthService.selectList(userDeptQueryParam);
            List userDeptResults = Optional.ofNullable(userDeptResultList).orElse(Lists.newArrayList());
            if (CollectionUtils.isNotEmpty((Collection)userDeptResults)) {
                user.setDeptList(((UserDeptResult)userDeptResults.get(0)).getDeptList());
            }
            if ((admin = this.getAdminUser(user.getCustomerId())) != null) {
                user.setCustomerId(admin.getId());
                user.setCustomerKey(admin.getKey());
            }
            log.warn("Login User->Admin, userId={}, adminId={}, adminkey={}", new Object[]{user.getId(), user.getCustomerId(), user.getCustomerKey()});
            this.syncAuth(user);
            this.troAuthService.loginSuccess(user);
            UserLoginResponse userLoginResponse = new UserLoginResponse();
            userLoginResponse.setId(user.getId());
            userLoginResponse.setKey(user.getKey());
            userLoginResponse.setName(user.getName());
            userLoginResponse.setUserType(user.getUserType());
            userLoginResponse.setXToken(user.getXToken());
            userLoginResponse.setExpire(TroClientAuthConstant.isExpire);
            TroClientValidator.validate((String)user.getKey());
            return Response.success((Object)userLoginResponse);
        }
        catch (TroLoginException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Response.fail((String)"300", (String)e.getMessage(), null);
        }
    }

    private void checkCode(HttpServletRequest request, String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.VERIFICATION_CODE_ERROR, (Object)"\u9a8c\u8bc1\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        String accessToken = request.getHeader("Access-Token");
        HttpSession httpSession = VerificationCodeUtil.getSession((String)accessToken);
        if (httpSession == null) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.VERIFICATION_CODE_ERROR, (Object)"\u56fe\u5f62\u9a8c\u8bc1\u7801\u9519\u8bef\u5df2\u8fc7\u671f");
        }
        Object sessionObject = httpSession.getAttribute("verification_code");
        if (null == sessionObject) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.VERIFICATION_CODE_ERROR, (Object)"\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        String sessionCode = sessionObject.toString();
        if (!code.equalsIgnoreCase(sessionCode)) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.VERIFICATION_CODE_ERROR, (Object)"\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        VerificationCodeUtil.delSession((String)accessToken);
    }

    public Response logout(HttpServletRequest request, HttpServletResponse response) {
        try {
            String indexUrl = this.troAuthService.logout(request, response);
            UserLogoutResponse userLogoutResponse = new UserLogoutResponse();
            userLogoutResponse.setIndexUrl(indexUrl);
            return Response.success((Object)userLogoutResponse);
        }
        catch (TroLoginException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Response.fail((String)"300", (String)e.getMessage(), null);
        }
    }

    public void redirect(String redirectUrl, HttpServletRequest request, HttpServletResponse response) {
        this.troAuthService.redirect(redirectUrl, request, response);
    }

    public Response logout(HttpServletRequest request) {
        String token = request.getHeader("x-token");
        this.redisTemplate.opsForValue().set((Object)token, null);
        return Response.success((Object)"\u6210\u529f\u9000\u51fa");
    }

    public void syncAuth(User user) {
        List urlList = this.troAuthService.getUserMenuResource(user);
        if (!TroUserUtil.validateSuperAdmin((User)user).booleanValue() && CollectionUtils.isEmpty((Collection)urlList)) {
            String msg = "\u7528\u6237\u6682\u672a\u5206\u914d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff1a" + user.getName();
            log.error(msg);
            throw new TroAuthException((ExceptionReadable)ExceptionCode.ALL_PERMISSION_DENY_ERROR, (Object)msg);
        }
        RestContext.setUser((User)user);
        Map menuMap = this.troAuthService.getUserMenu();
        Map actionMap = this.troAuthService.getUserAction();
        Map dataMap = this.troAuthService.getUserData();
        user.setPermissionUrl(urlList);
        user.setPermissionMenu(menuMap);
        user.setPermissionAction(actionMap);
        user.setPermissionData(dataMap);
    }

    private TroUserEntity getAdminUser(Long customerId) {
        return (TroUserEntity)this.troUserMapper.selectById((Serializable)customerId);
    }

    public TroUserOutput queryUserByKey(String userAppKey) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)lambdaQueryWrapper.eq(TroUserEntity::getKey, (Object)userAppKey)).eq(TroUserEntity::getIsDelete, (Object)0);
        List troUserEntities = this.troUserMapper.selectList((Wrapper)lambdaQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)troUserEntities)) {
            return null;
        }
        if (troUserEntities.size() > 1) {
            log.error("{}\u5bf9\u5e94\u7684\u7528\u6237\u5728\u6570\u636e\u5e93\u6709\u591a\u6761\u8bb0\u5f55", (Object)userAppKey);
        }
        TroUserOutput troUserOutput = new TroUserOutput();
        BeanUtils.copyProperties(troUserEntities.get(0), (Object)troUserOutput);
        return troUserOutput;
    }
}

