/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.user.Impl;

import com.pamirs.tro.entity.domain.dto.ApplicationSwitchStatusDTO;
import com.pamirs.tro.entity.domain.dto.linkmanage.SystemProcessViewListDto;
import com.pamirs.tro.entity.domain.query.ApplicationQueryParam;
import com.pamirs.tro.entity.domain.vo.ApplicationVo;
import com.pamirs.tro.entity.domain.vo.linkmanage.queryparam.TechQueryVo;
import com.pamirs.tro.entity.domain.vo.user.WorkBenchVo;
import io.shulie.tro.web.app.common.Response;
import io.shulie.tro.web.app.service.ApplicationService;
import io.shulie.tro.web.app.service.linkManage.LinkManageService;
import io.shulie.tro.web.app.service.user.WorkBenchService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkBenchServiceImpl
implements WorkBenchService {
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private LinkManageService linkManageService;

    public WorkBenchVo getUserWorkBench(Long uid) {
        WorkBenchVo workBenchVo = new WorkBenchVo();
        if (uid == null) {
            return workBenchVo;
        }
        Response response = this.applicationService.userAppSwitchInfo();
        if (response != null && response.getData() != null) {
            ApplicationSwitchStatusDTO statusDTO = (ApplicationSwitchStatusDTO)response.getData();
            workBenchVo.setSwitchStatus(statusDTO.getSwitchStatus());
        }
        ApplicationQueryParam queryParam = new ApplicationQueryParam();
        queryParam.setPageSize(Integer.valueOf(-1));
        Response appResponse = this.applicationService.getApplicationList(queryParam);
        if (appResponse != null && appResponse.getData() != null) {
            List applicationVoList = (List)appResponse.getData();
            int errorNum = 0;
            for (ApplicationVo vo : applicationVoList) {
                if (vo.getAccessStatus() == null || !vo.getAccessStatus().equals(3)) continue;
                ++errorNum;
            }
            workBenchVo.setApplicationNum(Integer.valueOf(applicationVoList == null ? 0 : applicationVoList.size()));
            workBenchVo.setAccessErrorNum(Integer.valueOf(errorNum));
        }
        TechQueryVo techQuery = new TechQueryVo();
        techQuery.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        Response listResponse = this.linkManageService.gettechLinksViwList(techQuery);
        if (listResponse != null && listResponse.getData() != null) {
            int changeNum = 0;
            for (SystemProcessViewListDto vo : (List)listResponse.getData()) {
                if (vo.getIsChange() == null || !"1".equals(vo.getIsChange())) continue;
                ++changeNum;
            }
            workBenchVo.setChangedProcessNum(Integer.valueOf(changeNum));
            workBenchVo.setSystemProcessNum(Integer.valueOf(((List)listResponse.getData()).size()));
        } else {
            workBenchVo.setSystemProcessNum(Integer.valueOf(0));
            workBenchVo.setChangedProcessNum(Integer.valueOf(0));
        }
        return workBenchVo;
    }
}

