/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.user.Impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.opencsv.bean.CsvToBeanBuilder;
import com.pamirs.tro.entity.dao.user.TUserMapper;
import com.pamirs.tro.entity.domain.entity.user.User;
import com.pamirs.tro.entity.domain.vo.user.UserQueryParam;
import io.shulie.tro.cloud.open.req.report.ReportAllocationUserReq;
import io.shulie.tro.cloud.open.req.scenemanage.SceneAllocationUserReq;
import io.shulie.tro.common.beans.response.ResponseResult;
import io.shulie.tro.exception.entity.ExceptionReadable;
import io.shulie.tro.web.app.cache.webimpl.AllUserCache;
import io.shulie.tro.web.app.common.Response;
import io.shulie.tro.web.app.common.RestContext;
import io.shulie.tro.web.app.exception.ExceptionCode;
import io.shulie.tro.web.app.exception.TroWebException;
import io.shulie.tro.web.app.input.user.UserAllocationUpdateInput;
import io.shulie.tro.web.app.request.application.ShadowConsumerUpdateUserRequest;
import io.shulie.tro.web.app.request.user.UserAllocationUpdateRequest;
import io.shulie.tro.web.app.request.user.UserCreateRequest;
import io.shulie.tro.web.app.request.user.UserDeleteRequest;
import io.shulie.tro.web.app.request.user.UserDetailQueryRequest;
import io.shulie.tro.web.app.request.user.UserPasswordUpdateRequest;
import io.shulie.tro.web.app.request.user.UserUpdateRequest;
import io.shulie.tro.web.app.response.user.UserCsvBean;
import io.shulie.tro.web.app.response.user.UserDetailResponse;
import io.shulie.tro.web.app.response.user.UserImportResponse;
import io.shulie.tro.web.app.service.ShadowConsumerService;
import io.shulie.tro.web.app.service.user.Impl.TroWebUserServiceImpl;
import io.shulie.tro.web.app.service.user.TroUserService;
import io.shulie.tro.web.app.service.user.TroWebUserService;
import io.shulie.tro.web.app.utils.BCrypt;
import io.shulie.tro.web.app.utils.CSVUtil;
import io.shulie.tro.web.app.utils.UnitConvertor;
import io.shulie.tro.web.auth.api.enums.MenuTypeEnum;
import io.shulie.tro.web.auth.api.enums.UserTypeEnum;
import io.shulie.tro.web.common.util.FileUtil;
import io.shulie.tro.web.data.dao.application.ApplicationApiDAO;
import io.shulie.tro.web.data.dao.application.ApplicationDAO;
import io.shulie.tro.web.data.dao.application.ApplicationDsDAO;
import io.shulie.tro.web.data.dao.application.ApplicationShadowJobDAO;
import io.shulie.tro.web.data.dao.application.ApplicationWhiteListDAO;
import io.shulie.tro.web.data.dao.application.LinkGuardDAO;
import io.shulie.tro.web.data.dao.linkmanage.BusinessLinkManageDAO;
import io.shulie.tro.web.data.dao.linkmanage.LinkManageDAO;
import io.shulie.tro.web.data.dao.linkmanage.SceneDAO;
import io.shulie.tro.web.data.dao.scriptmanage.ScriptManageDAO;
import io.shulie.tro.web.data.dao.user.TroDeptDAO;
import io.shulie.tro.web.data.dao.user.TroDeptUserRelationDAO;
import io.shulie.tro.web.data.dao.user.TroRoleUserRelationDAO;
import io.shulie.tro.web.data.dao.user.TroUserDAO;
import io.shulie.tro.web.data.model.mysql.TroUserDeptRelationEntity;
import io.shulie.tro.web.data.param.application.ApplicationApiUpdateUserParam;
import io.shulie.tro.web.data.param.application.ApplicationDsUpdateUserParam;
import io.shulie.tro.web.data.param.application.ApplicationUpdateParam;
import io.shulie.tro.web.data.param.application.ApplicationWhiteListUpdateParam;
import io.shulie.tro.web.data.param.application.LinkGuardUpdateUserParam;
import io.shulie.tro.web.data.param.application.ShadowJobUpdateUserParam;
import io.shulie.tro.web.data.param.linkmanage.BusinessLinkManageUpdateParam;
import io.shulie.tro.web.data.param.linkmanage.LinkManageUpdateParam;
import io.shulie.tro.web.data.param.linkmanage.SceneUpdateParam;
import io.shulie.tro.web.data.param.user.DeptCreateParam;
import io.shulie.tro.web.data.param.user.UserCreateParam;
import io.shulie.tro.web.data.param.user.UserDeptQueryParam;
import io.shulie.tro.web.data.param.user.UserDeptRelationBatchUserDeleteParam;
import io.shulie.tro.web.data.param.user.UserRoleRelationBatchDeleteParam;
import io.shulie.tro.web.data.result.user.DeptQueryResult;
import io.shulie.tro.web.data.result.user.UserDetailResult;
import io.shulie.tro.web.diff.api.scenemanage.SceneManageApi;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class TroWebUserServiceImpl
implements TroWebUserService {
    private static final Logger log = LoggerFactory.getLogger(TroWebUserServiceImpl.class);
    @Resource
    private TUserMapper TUserMapper;
    @Autowired
    private TroUserService troUserService;
    @Autowired
    private SceneDAO sceneDAO;
    @Autowired
    private ApplicationDAO applicationDAO;
    @Autowired
    private BusinessLinkManageDAO businessLinkManageDAO;
    @Autowired
    private LinkManageDAO linkManageDAO;
    @Autowired
    private ScriptManageDAO scriptManageDAO;
    @Autowired
    private SceneManageApi sceneManageApi;
    @Autowired
    private ApplicationWhiteListDAO whiteListDAO;
    @Autowired
    private ApplicationDsDAO applicationDsDAO;
    @Autowired
    private LinkGuardDAO linkGuardDAO;
    @Autowired
    private ApplicationShadowJobDAO shadowJobDAO;
    @Autowired
    private ShadowConsumerService shadowConsumerService;
    @Autowired
    private ApplicationApiDAO applicationApiDAO;
    @Autowired
    private TroDeptUserRelationDAO troDeptUserRelationDAO;
    @Autowired
    private TroRoleUserRelationDAO troRoleUserRelationDAO;
    private static final String deptNameSeparator = "/";
    @Autowired
    private AllUserCache allUserCache;
    @Autowired
    private TroDeptDAO troDeptDAO;
    @Autowired
    private TroUserDAO troUserDAO;
    @Value(value="${file.upload.user.data.dir}")
    private String fileDir;
    private ScheduledExecutorService service = Executors.newScheduledThreadPool(1);

    @Transactional(rollbackFor={Exception.class})
    public void createUser(UserCreateRequest createRequest) {
        UserQueryParam param = new UserQueryParam();
        param.setName(createRequest.getName());
        param.setCustomerId(RestContext.getCustomerId());
        User userExist = this.TUserMapper.queryByName(param);
        if (userExist != null) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.USER_MANAGE_ADD_ERROR, (Object)"\u7528\u6237\u5df2\u5b58\u5728");
        }
        int minLength = 8;
        int maxLength = 20;
        int passwordLength = createRequest.getPassword().length();
        if (passwordLength > maxLength || passwordLength < minLength) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.USER_MANAGE_ADD_ERROR, (Object)"\u5bc6\u7801\u4e0d\u5408\u6cd5\uff0c\u8bf7\u8f93\u51658~20\u4e2a\u5b57\u7b26");
        }
        int nameLength = createRequest.getName().length();
        if (nameLength > maxLength) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.USER_MANAGE_ADD_ERROR, (Object)"\u7528\u6237\u540d\u8d85\u957f\uff0c\u4e0d\u5f97\u8d85\u8fc720\u4e2a\u5b57\u7b26");
        }
        UserCreateParam user = new UserCreateParam();
        user.setName(createRequest.getName());
        user.setNick(createRequest.getName());
        user.setKey(UUID.randomUUID().toString());
        String salt = BCrypt.gensalt();
        String pwd = BCrypt.hashpw((String)createRequest.getPassword(), (String)salt);
        user.setSalt(salt);
        user.setPassword(pwd);
        user.setUserType(UserTypeEnum.NORMAL.getCode());
        user.setCustomerId(RestContext.getCustomerId());
        Long userId = this.troUserDAO.insert(user);
        List deptIdList = createRequest.getDeptIdList();
        List deptUserEntityList = deptIdList.stream().map(deptId -> {
            TroUserDeptRelationEntity entity = new TroUserDeptRelationEntity();
            entity.setDeptId(String.valueOf(deptId));
            entity.setUserId(String.valueOf(userId));
            return entity;
        }).collect(Collectors.toList());
        this.troDeptUserRelationDAO.batchInsert(deptUserEntityList);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateUser(UserUpdateRequest updateRequest) {
        String pwd;
        UserDetailResult userOld = this.troUserDAO.selectUserById(updateRequest.getId());
        if (userOld == null) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.USER_MANAGE_UPDATE_ERROR, (Object)"\u7528\u6237\u4e0d\u5b58\u5728");
        }
        User updateUser = new User();
        updateUser.setId(updateRequest.getId());
        updateUser.setName(updateRequest.getName());
        if (!updateRequest.getName().equals(userOld.getName())) {
            UserQueryParam param = new UserQueryParam();
            param.setName(updateRequest.getName());
            param.setCustomerId(RestContext.getCustomerId());
            User userExist = this.TUserMapper.queryByName(param);
            if (userExist != null) {
                throw new TroWebException((ExceptionReadable)ExceptionCode.USER_MANAGE_UPDATE_ERROR, (Object)"\u7528\u6237\u5df2\u5b58\u5728");
            }
        }
        if (!(pwd = BCrypt.hashpw((String)updateRequest.getPassword(), (String)userOld.getSalt())).equals(userOld.getPassword())) {
            String newSalt = BCrypt.gensalt();
            String newPwd = BCrypt.hashpw((String)updateRequest.getPassword(), (String)newSalt);
            updateUser.setSalt(newSalt);
            updateUser.setPassword(newPwd);
        }
        this.TUserMapper.updateByPrimaryKeySelective(updateUser);
        UserDeptRelationBatchUserDeleteParam deptRelationBatchUserDeleteParam = new UserDeptRelationBatchUserDeleteParam();
        deptRelationBatchUserDeleteParam.setUserIdList(Collections.singletonList(updateRequest.getId()));
        this.troDeptUserRelationDAO.deleteByUserIds(deptRelationBatchUserDeleteParam);
        List deptIdList = updateRequest.getDeptIdList();
        List deptUserEntityList = deptIdList.stream().map(deptId -> {
            TroUserDeptRelationEntity entity = new TroUserDeptRelationEntity();
            entity.setDeptId(String.valueOf(deptId));
            entity.setUserId(String.valueOf(updateRequest.getId()));
            return entity;
        }).collect(Collectors.toList());
        this.troDeptUserRelationDAO.batchInsert(deptUserEntityList);
    }

    public void updatePassword(UserPasswordUpdateRequest updateRequest) {
        UserDetailResult userOld = this.troUserDAO.selectUserById(updateRequest.getId());
        String oldPassword = BCrypt.hashpw((String)updateRequest.getOldPassword(), (String)userOld.getSalt());
        if (!userOld.getPassword().equals(oldPassword)) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.USER_MANAGE_UPDATE_ERROR, (Object)"\u539f\u5bc6\u7801\u9519\u8bef");
        }
        if (updateRequest.getOldPassword().equals(updateRequest.getNewPassword())) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.USER_MANAGE_UPDATE_ERROR, (Object)"\u65b0\u65e7\u5bc6\u7801\u4e0d\u8bb8\u91cd\u590d");
        }
        int minLength = 8;
        int maxLength = 20;
        int passwordLength = updateRequest.getNewPassword().length();
        if (passwordLength > maxLength || passwordLength < minLength) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.USER_MANAGE_UPDATE_ERROR, (Object)"\u65b0\u5bc6\u7801\u4e0d\u5408\u6cd5\uff0c\u8bf7\u8f93\u51658~20\u4e2a\u5b57\u7b26");
        }
        User updateUser = new User();
        updateUser.setId(updateRequest.getId());
        String newSalt = BCrypt.gensalt();
        String newPwd = BCrypt.hashpw((String)updateRequest.getNewPassword(), (String)newSalt);
        updateUser.setSalt(newSalt);
        updateUser.setPassword(newPwd);
        this.TUserMapper.updateByPrimaryKeySelective(updateUser);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteUser(UserDeleteRequest deleteRequest) {
        List userIdList = deleteRequest.getUserIdList();
        this.TUserMapper.deleteByIds(userIdList);
        UserDeptRelationBatchUserDeleteParam deptRelationBatchUserDeleteParam = new UserDeptRelationBatchUserDeleteParam();
        deptRelationBatchUserDeleteParam.setUserIdList(userIdList);
        this.troDeptUserRelationDAO.deleteByUserIds(deptRelationBatchUserDeleteParam);
        List userIdStringList = userIdList.stream().map(String::valueOf).collect(Collectors.toList());
        UserRoleRelationBatchDeleteParam deleteParam = new UserRoleRelationBatchDeleteParam();
        deleteParam.setUserId(userIdStringList);
        this.troRoleUserRelationDAO.deleteUserRoleRelationBatch(deleteParam);
    }

    private static boolean allFieldIsNotNull(Object o, List<String> ignoreField) {
        try {
            for (Field field : o.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                Object object = field.get(o);
                String fieldName = field.getName();
                if (CollectionUtils.isNotEmpty(ignoreField) && ignoreField.contains(fieldName)) {
                    return true;
                }
                if (!Objects.isNull(object)) continue;
                return false;
            }
        }
        catch (Exception e) {
            log.error("execute method allFieldIsNotNull error:", (Throwable)e);
            return false;
        }
        return true;
    }

    public UserDetailResponse queryUser(UserDetailQueryRequest queryRequest) {
        UserDetailResult user = this.troUserDAO.selectUserById(queryRequest.getId());
        if (Objects.isNull(user)) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.USER_MANAGE_QUERY_ERROR, (Object)"\u7528\u6237\u4e0d\u5b58\u5728");
        }
        UserDetailResponse detailResponse = new UserDetailResponse();
        detailResponse.setId(user.getId());
        detailResponse.setName(user.getName());
        UserDeptQueryParam queryParam = new UserDeptQueryParam();
        queryParam.setUserIdList(Collections.singletonList(String.valueOf(queryRequest.getId())));
        List deptIdList = this.troDeptUserRelationDAO.selectDeptIdList(queryParam);
        detailResponse.setDeptIdList(deptIdList);
        return detailResponse;
    }

    @Transactional(rollbackFor={Exception.class})
    public UserImportResponse importUser(MultipartFile file) {
        UserImportResponse importResponse = this.verifyFile(file);
        if (!Objects.isNull(importResponse)) {
            return importResponse;
        }
        importResponse = new UserImportResponse();
        importResponse.setSuccess(Boolean.FALSE);
        importResponse.setWriteBack(Boolean.FALSE);
        File commonFile = FileUtil.convertMultipartFile((MultipartFile)file);
        try {
            List beans = new CsvToBeanBuilder((Reader)new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(commonFile), "GBK"))).withType(UserCsvBean.class).build().parse();
            commonFile.delete();
            if (CollectionUtils.isEmpty((Collection)beans) || beans.size() <= 1) {
                return this.wrapImportResponse(importResponse, "\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
            }
            LinkedHashMap beanMap = Maps.newLinkedHashMap();
            for (UserCsvBean userCsvBean : beans) {
                if (!TroWebUserServiceImpl.allFieldIsNotNull((Object)userCsvBean, Collections.singletonList("errorMsg"))) continue;
                beanMap.putIfAbsent(userCsvBean.getUsername(), userCsvBean);
            }
            beanMap.remove("\u8d26\u53f7\u540d\u79f0");
            LinkedList writeBackUserCsvBeanList = this.verfiyUser((Map)beanMap);
            boolean writeBack = writeBackUserCsvBeanList.stream().anyMatch(w -> StringUtils.isNotBlank((String)w.getErrorMsg()));
            if (writeBack) {
                importResponse.setSuccess(Boolean.FALSE);
                importResponse.setWriteBack(Boolean.TRUE);
                importResponse.setErrorMsg("\u5bfc\u5165\u5931\u8d25\uff0c\u5931\u8d25\u660e\u7ec6\u5df2\u4e0b\u8f7d\u5230\u672c\u5730\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u5bfc\u5165");
                String[] fileNameArr = Objects.requireNonNull(file.getOriginalFilename()).split("\\.");
                String fileName = fileNameArr[0] + System.currentTimeMillis() + "." + fileNameArr[1];
                String basePath = this.fileDir + "/file/temp/" + fileName;
                importResponse.setFilePath(basePath);
                CSVUtil.writeCsvFile((List)writeBackUserCsvBeanList, (String)basePath);
                return importResponse;
            }
            this.batchImportDept(writeBackUserCsvBeanList);
            this.batchImportUser((Map)beanMap);
            importResponse.setSuccess(Boolean.TRUE);
        }
        catch (FileNotFoundException e) {
            log.error("\u5bfc\u5165\u7528\u6237\u5931\u8d25:{}", (Object)file.getOriginalFilename(), (Object)e);
            return this.wrapImportResponse(importResponse, "\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u7528\u6237\u5931\u8d25:{}", (Object)file.getOriginalFilename(), (Object)e);
            importResponse.setErrorMsg("\u5bfc\u5165\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406");
        }
        return importResponse;
    }

    private void batchImportDept(LinkedList<UserCsvBean> writeBackUserCsvBeanList) {
        LinkedHashSet deptNameSet = Sets.newLinkedHashSet();
        writeBackUserCsvBeanList.forEach(userCsvBean -> {
            String deptName = userCsvBean.getDeptNames();
            if (deptName.contains("/")) {
                String[] deptNameArr = deptName.split("/");
                deptNameSet.addAll(Arrays.asList(deptNameArr));
            } else {
                deptNameSet.add(deptName);
            }
        });
        if (!deptNameSet.isEmpty()) {
            deptNameSet.forEach(deptName -> {
                DeptQueryResult deptQueryResult = this.troDeptDAO.selectDetailByName(deptName);
                if (Objects.isNull(deptQueryResult)) {
                    DeptCreateParam createParam = new DeptCreateParam();
                    createParam.setName(deptName.trim());
                    createParam.setCode(RandomStringUtils.randomAlphanumeric((int)8));
                    this.troDeptDAO.insert(createParam);
                }
            });
        }
    }

    private UserImportResponse verifyFile(MultipartFile file) {
        String supportSuffix = "csv";
        if (!Objects.requireNonNull(file.getOriginalFilename()).endsWith(supportSuffix)) {
            UserImportResponse importResponse = new UserImportResponse();
            return this.wrapImportResponse(importResponse, "\u5b58\u5728\u4e0d\u652f\u6301\u7684\u4e0a\u4f20\u6587\u4ef6\u7c7b\u578b");
        }
        if (file.isEmpty()) {
            UserImportResponse importResponse = new UserImportResponse();
            return this.wrapImportResponse(importResponse, "\u6587\u4ef6\u5185\u5bb9\u4e0d\u8bb8\u4e3a\u7a7a");
        }
        BigDecimal fileSizeDecimal = UnitConvertor.byteToMb((BigDecimal)new BigDecimal(file.getSize()));
        if (fileSizeDecimal.compareTo(new BigDecimal(2)) > 0) {
            UserImportResponse importResponse = new UserImportResponse();
            return this.wrapImportResponse(importResponse, "\u6587\u4ef6\u5927\u5c0f\u4e0d\u8bb8\u8d85\u8fc72MB");
        }
        return null;
    }

    private void batchImportUser(Map<String, UserCsvBean> beanMap) {
        beanMap.forEach((name, userCsvBean) -> {
            UserCreateParam user = new UserCreateParam();
            user.setName(name.trim());
            user.setNick(name.trim());
            user.setKey(UUID.randomUUID().toString());
            String salt = BCrypt.gensalt();
            String pwd = BCrypt.hashpw((String)userCsvBean.getPassword().trim(), (String)salt);
            user.setSalt(salt);
            user.setPassword(pwd);
            user.setUserType(UserTypeEnum.NORMAL.getCode());
            user.setCustomerId(RestContext.getCustomerId());
            Long userId = this.troUserDAO.insert(user);
            String deptNames = userCsvBean.getDeptNames();
            List<Object> deptNameList = new ArrayList<String>();
            if (deptNames.contains("/")) {
                deptNameList = Arrays.asList(deptNames.split("/"));
            } else {
                deptNameList.add(deptNames);
            }
            ArrayList list = Lists.newArrayList();
            for (String string : deptNameList) {
                DeptQueryResult deptQueryResult = this.troDeptDAO.selectDetailByName(string);
                if (Objects.isNull(deptQueryResult)) continue;
                TroUserDeptRelationEntity entity = new TroUserDeptRelationEntity();
                entity.setUserId(String.valueOf(userId));
                entity.setDeptId(String.valueOf(deptQueryResult.getId()));
                list.add(entity);
            }
            this.troDeptUserRelationDAO.batchInsert((List)list);
        });
    }

    public void download(HttpServletResponse httpServletResponse, String path) {
        File fileF = new File(path);
        if (!fileF.exists()) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.USER_MANAGE_DOWNLOAD_ERROR, (Object)"\u6587\u4ef6\u4e0d\u5b58\u5728!");
        }
        FileInputStream fileInputStream = null;
        OutputStream outputStream = null;
        httpServletResponse.setHeader("Content-Type", "application/octet-stream");
        try {
            int length;
            httpServletResponse.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileF.getName(), "UTF-8"));
            fileInputStream = new FileInputStream(fileF);
            outputStream = httpServletResponse.getOutputStream();
            byte[] bytes = new byte[32];
            while ((length = fileInputStream.read(bytes)) > 0) {
                outputStream.write(bytes, 0, length);
            }
            outputStream.flush();
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new TroWebException((ExceptionReadable)ExceptionCode.USER_MANAGE_DOWNLOAD_ERROR, (Object)e.getMessage());
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
                this.service.schedule(fileF::delete, 10000L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
                throw new TroWebException((ExceptionReadable)ExceptionCode.USER_MANAGE_DOWNLOAD_ERROR, (Object)e.getMessage());
            }
        }
    }

    public void downloadExample(HttpServletResponse httpServletResponse) {
        String filePath = "/file/example/example.csv";
        String downloadPath = this.fileDir + filePath;
        File fileF = new File(downloadPath);
        if (!fileF.exists()) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.USER_MANAGE_DOWNLOAD_ERROR, (Object)"\u6a21\u677f\u4e0d\u5b58\u5728!");
        }
        FileInputStream fileInputStream = null;
        OutputStream outputStream = null;
        httpServletResponse.setHeader("Content-Type", "application/octet-stream");
        try {
            int length;
            httpServletResponse.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileF.getName(), "UTF-8"));
            fileInputStream = new FileInputStream(fileF);
            outputStream = httpServletResponse.getOutputStream();
            byte[] bytes = new byte[32];
            while ((length = fileInputStream.read(bytes)) > 0) {
                outputStream.write(bytes, 0, length);
            }
            outputStream.flush();
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new TroWebException((ExceptionReadable)ExceptionCode.USER_MANAGE_DOWNLOAD_ERROR, (Object)e.getMessage());
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
                throw new TroWebException((ExceptionReadable)ExceptionCode.USER_MANAGE_DOWNLOAD_ERROR, (Object)e.getMessage());
            }
        }
    }

    private UserImportResponse wrapImportResponse(UserImportResponse importResponse, String errorMsg) {
        importResponse.setSuccess(Boolean.FALSE);
        importResponse.setErrorMsg(errorMsg);
        importResponse.setWriteBack(Boolean.FALSE);
        return importResponse;
    }

    private LinkedList<UserCsvBean> verfiyUser(Map<String, UserCsvBean> beanMap) {
        LinkedList writeBackUserCsvBeanList = Lists.newLinkedList();
        beanMap.forEach((name, userCsvBean) -> {
            ArrayList<String> msgList = new ArrayList<String>();
            String username = userCsvBean.getUsername();
            String password = userCsvBean.getPassword();
            String deptNames = userCsvBean.getDeptNames();
            int minLength = 8;
            int maxLength = 20;
            if (StringUtils.isBlank((String)username)) {
                msgList.add("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            } else {
                UserDetailResult userDetailResult;
                int usernameLength = username.length();
                if (usernameLength > maxLength) {
                    msgList.add("\u7528\u6237\u540d\u8d85\u957f\uff0c\u4e0d\u5f97\u8d85\u8fc720\u4e2a\u5b57\u7b26");
                }
                if (null != (userDetailResult = this.troUserDAO.selectUserByName(username))) {
                    msgList.add("\u7528\u6237\u540d\u79f0\u5df2\u5b58\u5728");
                }
            }
            if (StringUtils.isBlank((String)password)) {
                msgList.add("\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            } else {
                int passwordLength = password.length();
                if (passwordLength > maxLength || passwordLength < minLength) {
                    msgList.add("\u5bc6\u7801\u4e0d\u5408\u6cd5\uff0c\u8bf7\u8f93\u51658~20\u4e2a\u5b57\u7b26");
                }
            }
            if (StringUtils.isBlank((String)deptNames)) {
                msgList.add("\u90e8\u95e8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            } else {
                String[] deptNameArr;
                for (String deptName : deptNameArr = deptNames.split("/")) {
                    int deptNameLength = deptName.length();
                    if (deptNameLength <= maxLength) continue;
                    msgList.add("\u90e8\u95e8\u540d\u79f0\u8d85\u957f\uff0c\u4e0d\u5f97\u8d85\u8fc720\u4e2a\u5b57\u7b26");
                }
            }
            if (!msgList.isEmpty()) {
                userCsvBean.setErrorMsg(Strings.join(msgList, (char)'\uff0c'));
            }
            writeBackUserCsvBeanList.add(userCsvBean);
        });
        return writeBackUserCsvBeanList;
    }

    public User queryUserByKey(String key) {
        if (StringUtils.isBlank((String)key)) {
            log.error("\u67e5\u8be2\u7528\u6237\u5931\u8d25\uff1akey\u4e3a\u7a7a");
            return null;
        }
        User user = this.TUserMapper.selectByKey(key);
        if (Objects.isNull(user)) {
            log.error("\u67e5\u8be2\u7528\u6237\u5931\u8d25\uff0c\u7528\u6237\u4e0d\u5b58\u5728\uff1a" + key);
            return null;
        }
        this.troUserService.syncAuth(user);
        return user;
    }

    @Transactional(rollbackFor={Exception.class})
    public Response allocationUser(UserAllocationUpdateRequest request) {
        UserAllocationUpdateInput input = new UserAllocationUpdateInput();
        BeanUtils.copyProperties((Object)request, (Object)input);
        if (null == input.getDataId() || null == input.getUserId() || StringUtils.isBlank((String)input.getMenuCode())) {
            return Response.fail((String)"0", (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        Long dataId = input.getDataId();
        Long userId = input.getUserId();
        boolean success = true;
        switch (1.$SwitchMap$io$shulie$tro$web$auth$api$enums$MenuTypeEnum[Objects.requireNonNull(MenuTypeEnum.getByCode((String)input.getMenuCode())).ordinal()]) {
            case 1: {
                this.linkManageDAO.allocationUser(new LinkManageUpdateParam(dataId, userId));
                break;
            }
            case 2: {
                this.businessLinkManageDAO.allocationUser(new BusinessLinkManageUpdateParam(dataId, userId));
                break;
            }
            case 3: {
                this.sceneDAO.allocationUser(new SceneUpdateParam(dataId, userId));
                break;
            }
            case 4: {
                this.applicationDAO.allocationUser(new ApplicationUpdateParam(dataId, userId));
                this.applicationDsDAO.allocationUser(new ApplicationDsUpdateUserParam(dataId, userId));
                this.linkGuardDAO.allocationUser(new LinkGuardUpdateUserParam(dataId, userId));
                this.shadowJobDAO.allocationUser(new ShadowJobUpdateUserParam(dataId, userId));
                this.whiteListDAO.allocationUser(new ApplicationWhiteListUpdateParam(String.valueOf(dataId), userId));
                this.shadowConsumerService.allocationUser(new ShadowConsumerUpdateUserRequest(dataId, userId));
                this.applicationApiDAO.allocationUser(new ApplicationApiUpdateUserParam(dataId, userId));
                break;
            }
            case 5: {
                SceneAllocationUserReq sceneReq = new SceneAllocationUserReq();
                sceneReq.setDataId(dataId);
                sceneReq.setUserId(userId);
                ResponseResult sceneResult = this.sceneManageApi.allocationSceneUser(sceneReq);
                success = sceneResult.getSuccess();
                break;
            }
            case 6: {
                ReportAllocationUserReq reportReq = new ReportAllocationUserReq();
                reportReq.setDataId(dataId);
                reportReq.setUserId(userId);
                ResponseResult reporeResult = this.sceneManageApi.allocationReportUser(reportReq);
                success = reporeResult.getSuccess();
                break;
            }
            case 7: {
                this.scriptManageDAO.allocationUser(dataId, userId);
                break;
            }
        }
        return success ? Response.success((Object)"success") : Response.fail((String)"\u64cd\u4f5c\u5931\u8d25", (Object[])new Object[0]);
    }
}

