/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.user.Impl;

import com.alibaba.excel.util.CollectionUtils;
import com.google.common.collect.Lists;
import io.shulie.tro.web.app.common.Response;
import io.shulie.tro.web.app.input.user.UserRoleRelationBatchDeleteInput;
import io.shulie.tro.web.app.input.user.UserRoleRelationCreateInput;
import io.shulie.tro.web.app.request.user.RoleCreateRequest;
import io.shulie.tro.web.app.request.user.RoleDeleteRequest;
import io.shulie.tro.web.app.request.user.RoleDetailQueryRequest;
import io.shulie.tro.web.app.request.user.RoleQueryRequest;
import io.shulie.tro.web.app.request.user.RoleUpdateRequest;
import io.shulie.tro.web.app.request.user.UserRoleRelationBatchDeleteRequest;
import io.shulie.tro.web.app.request.user.UserRoleRelationCreateRequest;
import io.shulie.tro.web.app.response.user.RoleQueryResponse;
import io.shulie.tro.web.app.service.user.TroRoleService;
import io.shulie.tro.web.auth.api.RoleService;
import io.shulie.tro.web.data.param.user.RoleCreateParam;
import io.shulie.tro.web.data.param.user.RoleDeleteParam;
import io.shulie.tro.web.data.param.user.RoleQueryParam;
import io.shulie.tro.web.data.param.user.RoleUpdateParam;
import io.shulie.tro.web.data.param.user.UserRoleRelationBatchDeleteParam;
import io.shulie.tro.web.data.param.user.UserRoleRelationCreateParam;
import io.shulie.tro.web.data.result.user.RoleQueryResult;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TroRoleServiceImpl
implements TroRoleService {
    private static final Logger log = LoggerFactory.getLogger(TroRoleServiceImpl.class);
    @Autowired
    private RoleService roleService;

    public List<RoleQueryResponse> listRole(RoleQueryRequest request) {
        List<Object> responseList = Lists.newArrayList();
        RoleQueryParam param = new RoleQueryParam();
        param.setName(request.getRoleName());
        List resultList = this.roleService.selectList(param);
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            return responseList;
        }
        resultList.sort(Comparator.comparing(RoleQueryResult::getCreateTime).reversed());
        responseList = resultList.stream().map(result -> {
            RoleQueryResponse response = new RoleQueryResponse();
            BeanUtils.copyProperties((Object)result, (Object)response);
            return response;
        }).collect(Collectors.toList());
        return responseList;
    }

    public Response queryDetail(RoleDetailQueryRequest request) {
        RoleQueryParam param = new RoleQueryParam();
        param.setId(request.getId());
        RoleQueryResult result = this.roleService.selectDetail(param);
        RoleQueryResponse queryResponse = new RoleQueryResponse();
        if (Objects.isNull(result.getId())) {
            return Response.fail((String)"0", (String)"\u8be5\u89d2\u8272\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        }
        BeanUtils.copyProperties((Object)result, (Object)queryResponse);
        return Response.success((Object)queryResponse);
    }

    public Response addRole(RoleCreateRequest request) {
        RoleQueryParam existNameQuery = new RoleQueryParam();
        existNameQuery.setName(request.getRoleName());
        RoleQueryResult result = this.roleService.selectDetail(existNameQuery);
        if (!Objects.isNull(result.getId())) {
            return Response.fail((String)"0", (String)"\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728", (Object[])new Object[0]);
        }
        RoleCreateParam param = new RoleCreateParam();
        param.setName(request.getRoleName());
        param.setDescription(request.getRoleDesc());
        int count = this.roleService.insert(param);
        return count > 0 ? Response.success((Object)"\u6dfb\u52a0\u6210\u529f") : Response.fail((String)"0", (String)"\u6dfb\u52a0\u5931\u8d25", (Object[])new Object[0]);
    }

    public Response updateRole(RoleUpdateRequest request) {
        RoleQueryParam existRoleQuery = new RoleQueryParam();
        existRoleQuery.setId(request.getId());
        RoleQueryResult existRoleResult = this.roleService.selectDetail(existRoleQuery);
        if (Objects.isNull(existRoleResult.getId())) {
            return Response.fail((String)"0", (String)"\u89d2\u8272\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        }
        if (!request.getRoleName().equals(existRoleResult.getName())) {
            RoleQueryParam existNameQuery = new RoleQueryParam();
            existNameQuery.setName(request.getRoleName());
            RoleQueryResult existNameResult = this.roleService.selectDetail(existNameQuery);
            if (!Objects.isNull(existNameResult.getId())) {
                return Response.fail((String)"0", (String)"\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728", (Object[])new Object[0]);
            }
        }
        RoleUpdateParam param = new RoleUpdateParam();
        param.setId(request.getId());
        param.setName(request.getRoleName());
        param.setDescription(request.getRoleDesc());
        int count = this.roleService.update(param);
        return count > 0 ? Response.success((Object)"\u66f4\u65b0\u6210\u529f") : Response.fail((String)"0", (String)"\u66f4\u65b0\u5931\u8d25", (Object[])new Object[0]);
    }

    public Response deleteRole(RoleDeleteRequest request) {
        RoleDeleteParam param = new RoleDeleteParam();
        BeanUtils.copyProperties((Object)request, (Object)param);
        int count = this.roleService.delete(param);
        return count > 0 ? Response.success((Object)"\u5220\u9664\u6210\u529f") : Response.fail((String)"0", (String)"\u5220\u9664\u5931\u8d25", (Object[])new Object[0]);
    }

    public Response insertRoleToUser(UserRoleRelationCreateRequest request) {
        UserRoleRelationCreateInput input = new UserRoleRelationCreateInput();
        input.setRoleId(request.getRoleIds());
        input.setUserId(request.getAccountIds());
        if (null == input || CollectionUtils.isEmpty((Collection)input.getUserId())) {
            return Response.fail((String)"0", (String)"\u7528\u6237\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        if (null != input.getRoleId() && input.getRoleId().size() > 10) {
            return Response.fail((String)"0", (String)"\u89d2\u8272\u6570\u91cf\u8d85\u8fc7\u9650\u5236", (Object[])new Object[0]);
        }
        UserRoleRelationCreateParam param = new UserRoleRelationCreateParam();
        BeanUtils.copyProperties((Object)input, (Object)param);
        int count = this.roleService.insertRoleToUser(param);
        return count > 0 ? Response.success((Object)"\u5206\u914d\u6210\u529f") : Response.fail((String)"0", (String)"\u5206\u914d\u5931\u8d25", (Object[])new Object[0]);
    }

    public Response deleteUserRoleRelationBatch(UserRoleRelationBatchDeleteRequest request) {
        UserRoleRelationBatchDeleteInput input = new UserRoleRelationBatchDeleteInput();
        input.setUserId(request.getAccountIds());
        UserRoleRelationBatchDeleteParam param = new UserRoleRelationBatchDeleteParam();
        BeanUtils.copyProperties((Object)input, (Object)param);
        this.roleService.deleteUserRoleRelationBatch(param);
        return Response.success((Object)"\u91cd\u7f6e\u6210\u529f");
    }
}

