/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.user.Impl;

import com.google.common.collect.Sets;
import com.pamirs.tro.entity.domain.entity.auth.TreeConvertUtil;
import io.shulie.tro.exception.entity.ExceptionReadable;
import io.shulie.tro.web.app.exception.ExceptionCode;
import io.shulie.tro.web.app.exception.TroWebException;
import io.shulie.tro.web.app.request.user.DeptCreateRequest;
import io.shulie.tro.web.app.request.user.DeptDeleteRequest;
import io.shulie.tro.web.app.request.user.DeptQueryRequest;
import io.shulie.tro.web.app.request.user.DeptUpdateRequest;
import io.shulie.tro.web.app.response.user.DeptQueryResponse;
import io.shulie.tro.web.app.service.user.TroDeptService;
import io.shulie.tro.web.auth.api.DeptService;
import io.shulie.tro.web.data.dao.user.TroDeptDAO;
import io.shulie.tro.web.data.dao.user.TroDeptUserRelationDAO;
import io.shulie.tro.web.data.param.user.DeptCreateParam;
import io.shulie.tro.web.data.param.user.DeptDeleteParam;
import io.shulie.tro.web.data.param.user.DeptUpdateParam;
import io.shulie.tro.web.data.param.user.UserDeptConditionQueryParam;
import io.shulie.tro.web.data.result.user.DeptQueryResult;
import io.shulie.tro.web.data.result.user.UserDeptConditionResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TroDeptServiceImpl
implements TroDeptService {
    private static final Logger log = LoggerFactory.getLogger(TroDeptServiceImpl.class);
    @Autowired
    private TroDeptDAO troDeptDAO;
    @Autowired
    private TroDeptUserRelationDAO troDeptUserRelationDAO;
    @Autowired
    private DeptService deptService;

    public void createDept(DeptCreateRequest createRequest) {
        int maxLength = 20;
        int nameLength = createRequest.getName().length();
        if (nameLength > maxLength) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.DEPT_MANAGE_ADD_ERROR, (Object)"\u90e8\u95e8\u540d\u79f0\u8d85\u957f\uff0c\u4e0d\u5f97\u8d85\u8fc720\u4e2a\u5b57\u7b26");
        }
        DeptQueryResult queryResult = this.troDeptDAO.selectDetailByName(createRequest.getName());
        if (queryResult != null) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.DEPT_MANAGE_ADD_ERROR, (Object)"\u90e8\u95e8\u540d\u79f0\u5df2\u5b58\u5728");
        }
        DeptCreateParam createParam = new DeptCreateParam();
        createParam.setName(createRequest.getName());
        createParam.setCode(RandomStringUtils.randomAlphanumeric((int)8));
        if (createRequest.getParentId() != -1L) {
            createParam.setParentId(createRequest.getParentId());
        }
        this.troDeptDAO.insert(createParam);
    }

    public void updateDept(DeptUpdateRequest updateRequest) {
        DeptQueryResult existDept;
        int maxLength = 20;
        int nameLength = updateRequest.getName().length();
        if (nameLength > maxLength) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.DEPT_MANAGE_UPDATE_ERROR, (Object)"\u90e8\u95e8\u540d\u79f0\u8d85\u957f\uff0c\u4e0d\u5f97\u8d85\u8fc720\u4e2a\u5b57\u7b26");
        }
        DeptQueryResult queryResult = this.troDeptDAO.selectDetailById(updateRequest.getId());
        if (!queryResult.getName().equals(updateRequest.getName()) && (existDept = this.troDeptDAO.selectDetailByName(updateRequest.getName())) != null) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.DEPT_MANAGE_UPDATE_ERROR, (Object)"\u90e8\u95e8\u540d\u79f0\u5df2\u5b58\u5728");
        }
        HashSet currentDeptIdSet = Sets.newHashSet();
        currentDeptIdSet.add(String.valueOf(updateRequest.getId()));
        HashSet lowerDeptIdSet = Sets.newHashSet();
        List deptTotalList = this.deptService.getAllDepts("");
        TreeConvertUtil.getLowerDeptByParentDeptIds((List)deptTotalList, (Set)currentDeptIdSet, (Set)lowerDeptIdSet);
        if (updateRequest.getId().equals(updateRequest.getParentId()) || lowerDeptIdSet.contains(String.valueOf(updateRequest.getParentId()))) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.DEPT_MANAGE_UPDATE_ERROR, (Object)"\u4e0a\u7ea7\u90e8\u95e8\u4e0d\u80fd\u4fee\u6539\u4e3a\u5f53\u524d\u90e8\u95e8\u6216\u5f53\u524d\u90e8\u95e8\u7684\u4e0b\u7ea7\u90e8\u95e8");
        }
        DeptUpdateParam updateParam = new DeptUpdateParam();
        updateParam.setId(updateRequest.getId());
        updateParam.setName(updateRequest.getName());
        if (updateRequest.getParentId() == -1L) {
            updateRequest.setParentId(null);
        } else {
            updateParam.setParentId(updateRequest.getParentId());
        }
        this.troDeptDAO.update(updateParam);
    }

    public void deleteDept(DeptDeleteRequest deleteRequest) {
        HashSet currentDeptIdSet = Sets.newHashSet();
        currentDeptIdSet.add(String.valueOf(deleteRequest.getId()));
        HashSet lowerDeptIdSet = Sets.newHashSet();
        List deptTotalList = this.deptService.getAllDepts("");
        TreeConvertUtil.getLowerDeptByParentDeptIds((List)deptTotalList, (Set)currentDeptIdSet, (Set)lowerDeptIdSet);
        ArrayList deptIdList = new ArrayList(lowerDeptIdSet);
        UserDeptConditionQueryParam queryParam = new UserDeptConditionQueryParam();
        queryParam.setDeptIds(deptIdList);
        List userDeptConditionResultList = this.troDeptUserRelationDAO.selectUserByDeptIds(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)userDeptConditionResultList)) {
            List deptNameList = userDeptConditionResultList.stream().map(UserDeptConditionResult::getDeptName).distinct().collect(Collectors.toList());
            String existUserDeptName = StringUtils.join((Object[])deptNameList.toArray(), (String)",");
            throw new TroWebException((ExceptionReadable)ExceptionCode.DEPT_MANAGE_DELETE_ERROR, (Object)("\u5220\u9664\u5931\u8d25\uff0c\u90e8\u95e8\u3010" + existUserDeptName + "\u3011\u4e0b\u5b58\u5728\u8d26\u53f7\uff0c\u8bf7\u79fb\u9664\u8d26\u53f7\u540e\u91cd\u8bd5"));
        }
        List deptIdLongList = deptIdList.stream().map(Long::parseLong).collect(Collectors.toList());
        DeptDeleteParam deleteParam = new DeptDeleteParam();
        deleteParam.setDeptIdList(deptIdLongList);
        this.troDeptDAO.delete(deleteParam);
    }

    public DeptQueryResponse queryDept(DeptQueryRequest queryRequest) {
        DeptQueryResult result = this.troDeptDAO.selectDetailById(queryRequest.getId());
        if (!Objects.isNull(queryRequest)) {
            DeptQueryResponse queryResponse = new DeptQueryResponse();
            queryResponse.setId(result.getId());
            queryResponse.setName(result.getName());
            queryResponse.setParentId(result.getParentId());
            return queryResponse;
        }
        return null;
    }
}

