/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.statistics;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pamirs.tro.common.constant.ScriptEnum;
import com.pamirs.tro.common.util.DateUtils;
import io.shulie.tro.cloud.open.req.statistics.PressureTotalReq;
import io.shulie.tro.cloud.open.resp.statistics.PressureListTotalResp;
import io.shulie.tro.cloud.open.resp.statistics.PressurePieTotalResp;
import io.shulie.tro.cloud.open.resp.statistics.ReportTotalResp;
import io.shulie.tro.web.app.convert.statistics.StatisticsConvert;
import io.shulie.tro.web.app.input.statistics.PressureTotalInput;
import io.shulie.tro.web.app.output.statistics.PressureListTotalOutput;
import io.shulie.tro.web.app.output.statistics.PressurePieTotalOutput;
import io.shulie.tro.web.app.output.statistics.ReportTotalOutput;
import io.shulie.tro.web.app.output.statistics.ScriptLabelListTotalOutput;
import io.shulie.tro.web.app.service.statistics.PressureStatisticsService;
import io.shulie.tro.web.data.dao.statistics.StatisticsManageDao;
import io.shulie.tro.web.data.dao.user.TroUserDAO;
import io.shulie.tro.web.data.result.statistics.PressureListTotalResult;
import io.shulie.tro.web.data.result.statistics.PressurePieTotalResult;
import io.shulie.tro.web.data.result.user.TroUserResult;
import io.shulie.tro.web.diff.api.statistics.PressureStatisticsApi;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PressureStatisticsServiceImpl
implements PressureStatisticsService {
    @Resource
    private PressureStatisticsApi pressureStatisticsApi;
    @Resource
    private StatisticsManageDao statisticsManageDao;
    @Autowired
    private TroUserDAO troUserDAO;

    public PressurePieTotalOutput getPressurePieTotal(PressureTotalInput input) {
        PressurePieTotalOutput output = new PressurePieTotalOutput();
        switch (input.getType()) {
            case "0": {
                PressureTotalReq req = new PressureTotalReq();
                BeanUtils.copyProperties((Object)input, (Object)req);
                PressurePieTotalResp resp = this.pressureStatisticsApi.getPressurePieTotal(req);
                output = StatisticsConvert.ofCloud((PressurePieTotalResp)resp);
                break;
            }
            case "1": {
                List list = this.statisticsManageDao.getPressureScenePieTotal(input.getStartTime(), input.getEndTime());
                HashMap totalMap = Maps.newHashMap();
                for (ScriptEnum scriptEnum : ScriptEnum.values()) {
                    totalMap.put(scriptEnum.getName(), 0);
                }
                list.forEach(data -> totalMap.put(ScriptEnum.getName((Integer)data.getType()), data.getCount()));
                List totals = totalMap.entrySet().stream().map(e -> new PressurePieTotalOutput.PressurePieTotal((String)e.getKey(), (Integer)e.getValue())).collect(Collectors.toList());
                Integer count = list.stream().mapToInt(PressurePieTotalResult::getCount).sum();
                output.setData(totals);
                output.setTotal(count);
                break;
            }
        }
        return output;
    }

    public ReportTotalOutput getReportTotal(PressureTotalInput input) {
        PressureTotalReq req = new PressureTotalReq();
        BeanUtils.copyProperties((Object)input, (Object)req);
        ReportTotalResp resp = this.pressureStatisticsApi.getReportTotal(req);
        return StatisticsConvert.ofCloud((ReportTotalResp)resp);
    }

    public List<PressureListTotalOutput> getPressureListTotal(PressureTotalInput input) {
        List<PressureListTotalOutput> outputs = Lists.newArrayList();
        PressureTotalReq req = new PressureTotalReq();
        BeanUtils.copyProperties((Object)input, (Object)req);
        switch (input.getType()) {
            case "0": {
                List resp = this.pressureStatisticsApi.getPressureListTotal(req);
                outputs = StatisticsConvert.ofListCloud((List)resp);
                List ids = outputs.stream().map(PressureListTotalOutput::getId).collect(Collectors.toList());
                List tags = Lists.newArrayList();
                if (ids != null && ids.size() > 0) {
                    tags = this.statisticsManageDao.getSceneTag(ids);
                }
                Map<Long, PressureListTotalResult> map = tags.stream().collect(Collectors.toMap(PressureListTotalResult::getId, totalResult -> totalResult));
                outputs.forEach(output -> {
                    TroUserResult userResult;
                    PressureListTotalResult result = (PressureListTotalResult)map.get(output.getId());
                    if (result != null) {
                        output.setLabel(result.getTags());
                    }
                    if (StringUtils.isNotBlank((CharSequence)output.getCreateName()) && (userResult = this.troUserDAO.selectById(Long.valueOf(output.getCreateName()))) != null) {
                        output.setCreateName(userResult.getName());
                    }
                });
                break;
            }
            case "1": {
                req.setScriptIds(this.statisticsManageDao.selectScriptManageDeployIds());
                List totalResps = this.pressureStatisticsApi.getPressureListTotal(req);
                outputs = StatisticsConvert.ofListCloud((List)totalResps);
                List scriptIds = totalResps.stream().map(PressureListTotalResp::getId).collect(Collectors.toList());
                List results = Lists.newArrayList();
                if (scriptIds == null || scriptIds.size() <= 0) {
                    return outputs;
                }
                results = this.statisticsManageDao.getScriptTag(scriptIds);
                Map<Long, PressureListTotalResult> totalResultMap = results.stream().collect(Collectors.toMap(PressureListTotalResult::getId, totalResult -> totalResult));
                outputs.sort(Comparator.comparing(sort -> ((PressureListTotalResult)totalResultMap.get(sort.getId())).getGmtCreate(), Comparator.reverseOrder()));
                outputs.sort(Comparator.comparing(PressureListTotalOutput::getCount, Comparator.reverseOrder()));
                outputs.forEach(output -> {
                    PressureListTotalResult result = (PressureListTotalResult)totalResultMap.get(output.getId());
                    if (result != null) {
                        output.setName(result.getName() + " \u7248\u672c" + result.getScriptVersion());
                        output.setLabel(result.getTags());
                        output.setGmtCreate(DateUtils.dateToString((Date)result.getGmtCreate(), (String)"yyyy-MM-dd HH:mm:ss"));
                        output.setCreateName(result.getCreateName());
                    }
                });
                break;
            }
        }
        return outputs;
    }

    public List<ScriptLabelListTotalOutput> getScriptLabelListTotal(PressureTotalInput input) {
        List results = this.statisticsManageDao.getScriptLabelListTotal(input.getStartTime(), input.getEndTime());
        return StatisticsConvert.ofListResult((List)results);
    }
}

