/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.simplify;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.github.pagehelper.PageInfo;
import com.pamirs.tro.common.constant.JobEnum;
import com.pamirs.tro.entity.dao.confcenter.TApplicationMntDao;
import com.pamirs.tro.entity.dao.simplify.TShadowJobConfigMapper;
import com.pamirs.tro.entity.dao.user.TUserMapper;
import com.pamirs.tro.entity.domain.entity.TApplicationMnt;
import com.pamirs.tro.entity.domain.entity.simplify.TShadowJobConfig;
import com.pamirs.tro.entity.domain.entity.user.User;
import com.pamirs.tro.entity.domain.query.ShadowJobConfigQuery;
import com.pamirs.tro.entity.domain.vo.ShadowJobConfigVo;
import io.shulie.tro.web.app.cache.AgentConfigCacheManager;
import io.shulie.tro.web.app.common.Response;
import io.shulie.tro.web.app.common.RestContext;
import io.shulie.tro.web.app.init.sync.ConfigSyncService;
import io.shulie.tro.web.app.service.auth.TroAuthService;
import io.shulie.tro.web.app.service.user.TroWebUserService;
import io.shulie.tro.web.app.utils.Estimate;
import io.shulie.tro.web.app.utils.XmlUtil;
import io.shulie.tro.web.data.dao.application.ApplicationDAO;
import io.shulie.tro.web.data.dao.application.ApplicationShadowJobDAO;
import io.shulie.tro.web.data.param.application.ShadowJobCreateParam;
import io.shulie.tro.web.data.result.application.ApplicationDetailResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShadowJobConfigService {
    private static final Logger log = LoggerFactory.getLogger(ShadowJobConfigService.class);
    @Autowired
    TroAuthService troAuthService;
    @Autowired
    TroWebUserService troWebUserService;
    @Resource
    private TShadowJobConfigMapper tShadowJobConfigMapper;
    @Resource
    private TApplicationMntDao tApplicationMntDao;
    @Resource
    private TUserMapper TUserMapper;
    @Autowired
    private ConfigSyncService configSyncService;
    @Autowired
    private ApplicationShadowJobDAO applicationShadowJobDAO;
    @Autowired
    private AgentConfigCacheManager agentConfigCacheManager;
    @Autowired
    private ApplicationDAO applicationDAO;

    public static void main(String[] args) throws DocumentException {
        String text = "<xml>\n    <className>com.pradar.xx.TestJob</className>\n    <cron>0 * * * * *</cron>\n    <jobType>elastic-job</jobType>\n    <jobDataType>simple</jobDataType>\n    <listener>com.pradar.listener.TestListener</listener>\n</xml>";
        Map stringStringMap = XmlUtil.readStringXml((String)text);
        System.out.println(stringStringMap);
    }

    public Response insert(TShadowJobConfig tShadowJobConfig) throws DocumentException {
        Map xmlMap = XmlUtil.readStringXml((String)tShadowJobConfig.getConfigCode());
        String className = (String)xmlMap.get("className");
        String jobType = (String)xmlMap.get("jobType");
        Estimate.notBlank((Object)className, (String)"className\u4e0d\u80fd\u4e3a\u7a7a");
        Estimate.notBlank((Object)jobType, (String)"job\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        tShadowJobConfig.setName(className);
        tShadowJobConfig.setType(Integer.valueOf(JobEnum.getJobByText((String)jobType).ordinal()));
        if (null != tShadowJobConfig.getId()) {
            return Response.fail((String)"ID\u5fc5\u987b\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        ShadowJobCreateParam shadowJobCreateParam = new ShadowJobCreateParam();
        BeanUtils.copyProperties((Object)tShadowJobConfig, (Object)shadowJobCreateParam);
        ApplicationDetailResult applicationDetailResult = this.applicationDAO.getApplicationById(tShadowJobConfig.getApplicationId());
        shadowJobCreateParam.setCustomerId(applicationDetailResult.getCustomerId());
        shadowJobCreateParam.setUserId(applicationDetailResult.getUserId());
        this.applicationShadowJobDAO.insert(shadowJobCreateParam);
        User user = RestContext.getUser();
        this.configSyncService.syncShadowJob(user.getKey(), tShadowJobConfig.getApplicationId().longValue(), null);
        TApplicationMnt tApplicationMnt = this.tApplicationMntDao.queryApplicationinfoById(tShadowJobConfig.getApplicationId().longValue());
        if (null == tApplicationMnt) {
            return Response.fail((String)"\u672a\u67e5\u8be2\u5230\u76f8\u5173\u5e94\u7528\u4fe1\u606f", (Object[])new Object[0]);
        }
        this.agentConfigCacheManager.evictShadowJobs(tApplicationMnt.getApplicationName());
        return Response.success();
    }

    public Response queryDetail(Long id) {
        TShadowJobConfig shadowJobConfig = this.tShadowJobConfigMapper.selectOneById(id);
        if (shadowJobConfig == null) {
            return Response.fail((String)"\u672a\u67e5\u8be2\u5230\u76f8\u5173\u6570\u636e", (Object[])new Object[0]);
        }
        TApplicationMnt tApplicationMnt = this.tApplicationMntDao.queryApplicationinfoById(shadowJobConfig.getApplicationId().longValue());
        if (null == tApplicationMnt) {
            return Response.fail((String)"\u672a\u67e5\u8be2\u5230\u76f8\u5173\u5e94\u7528\u4fe1\u606f", (Object[])new Object[0]);
        }
        return Response.success((Object)new ShadowJobConfigVo(shadowJobConfig, tApplicationMnt.getApplicationName()));
    }

    public Response update(ShadowJobConfigQuery query) throws DocumentException {
        TApplicationMnt tApplicationMnt;
        TShadowJobConfig updateShadowJobConfig = new TShadowJobConfig();
        TShadowJobConfig shadowJobConfig = this.tShadowJobConfigMapper.selectOneById(query.getId());
        if (null == shadowJobConfig) {
            return Response.success((Object)"\u6839\u636eID\u672a\u67e5\u8be2\u5230\u76f8\u5173\u6570\u636e");
        }
        if (StringUtils.isNotBlank((CharSequence)query.getConfigCode()) && null != query.getConfigCode() && !query.getConfigCode().equals(shadowJobConfig.getConfigCode())) {
            updateShadowJobConfig.setConfigCode(query.getConfigCode());
            Map xmlMap = XmlUtil.readStringXml((String)query.getConfigCode());
            String className = (String)xmlMap.get("className");
            String jobType = (String)xmlMap.get("jobType");
            JobEnum jobText = JobEnum.getJobByText((String)jobType);
            if (StringUtils.isNotBlank((CharSequence)className) && !className.equals(shadowJobConfig.getName())) {
                updateShadowJobConfig.setName(className);
            }
            if (null != jobText && !Integer.valueOf(jobText.ordinal()).equals(shadowJobConfig.getType())) {
                updateShadowJobConfig.setType(Integer.valueOf(jobText.ordinal()));
            }
        }
        updateShadowJobConfig.setId(query.getId());
        if (null != query.getStatus() && !query.getStatus().equals(shadowJobConfig.getStatus())) {
            updateShadowJobConfig.setStatus(query.getStatus());
        }
        if (null != query.getActive() && !query.getActive().equals(shadowJobConfig.getActive())) {
            updateShadowJobConfig.setActive(query.getActive());
        }
        if (StringUtils.isNotBlank((CharSequence)updateShadowJobConfig.getConfigCode()) || null != query.getStatus() || null != query.getActive()) {
            this.tShadowJobConfigMapper.update(updateShadowJobConfig);
        }
        if (query.getRemark() != null) {
            TShadowJobConfig updateRemark = new TShadowJobConfig();
            updateRemark.setId(query.getId());
            updateRemark.setRemark(query.getRemark());
            this.tShadowJobConfigMapper.update(updateRemark);
        }
        if (null == (tApplicationMnt = this.tApplicationMntDao.queryApplicationinfoById(shadowJobConfig.getApplicationId().longValue()))) {
            return Response.fail((String)"\u672a\u67e5\u8be2\u5230\u76f8\u5173\u5e94\u7528\u4fe1\u606f", (Object[])new Object[0]);
        }
        User user = RestContext.getUser();
        this.configSyncService.syncShadowJob(user.getKey(), shadowJobConfig.getApplicationId().longValue(), null);
        this.agentConfigCacheManager.evictShadowJobs(tApplicationMnt.getApplicationName());
        return Response.success();
    }

    public Response delete(Long id) {
        TShadowJobConfig shadowJobConfig = this.tShadowJobConfigMapper.selectOneById(id);
        if (null == shadowJobConfig) {
            return Response.fail((String)"\u6839\u636eID\u672a\u67e5\u8be2\u5230\u76f8\u5173\u4fe1\u606f", (Object[])new Object[0]);
        }
        TApplicationMnt tApplicationMnt = this.tApplicationMntDao.queryApplicationinfoById(shadowJobConfig.getApplicationId().longValue());
        if (null == tApplicationMnt) {
            return Response.fail((String)"\u672a\u67e5\u8be2\u5230\u76f8\u5173\u5e94\u7528\u4fe1\u606f", (Object[])new Object[0]);
        }
        this.tShadowJobConfigMapper.delete(id);
        User user = RestContext.getUser();
        this.configSyncService.syncShadowJob(user.getKey(), shadowJobConfig.getApplicationId().longValue(), null);
        this.agentConfigCacheManager.evictShadowJobs(tApplicationMnt.getApplicationName());
        return Response.success();
    }

    public Response queryByPage(ShadowJobConfigQuery query) {
        if (StringUtils.isBlank((CharSequence)query.getOrderBy())) {
            query.setOrderBy("id desc");
        }
        List tShadowJobConfigs = this.tShadowJobConfigMapper.selectList(query);
        PageInfo pageInfo = new PageInfo(tShadowJobConfigs);
        ArrayList configVos = new ArrayList();
        pageInfo.getList().forEach(tShadowJobConfig -> {
            List allowEnableDisableUserIdList;
            List allowDeleteUserIdList;
            ShadowJobConfigVo vo = new ShadowJobConfigVo();
            vo.setId(String.valueOf(tShadowJobConfig.getId()));
            vo.setApplicationId(String.valueOf(tShadowJobConfig.getApplicationId()));
            vo.setName(tShadowJobConfig.getName());
            vo.setType(tShadowJobConfig.getType());
            vo.setStatus(tShadowJobConfig.getStatus());
            vo.setConfigCode(tShadowJobConfig.getConfigCode());
            vo.setTypeName(JobEnum.getJobByIndex((int)tShadowJobConfig.getType()).getText());
            vo.setActive(tShadowJobConfig.getActive());
            vo.setActive(tShadowJobConfig.getActive());
            vo.setUpdateTime(tShadowJobConfig.getUpdateTime());
            vo.setRemark(tShadowJobConfig.getRemark());
            List allowUpdateUserIdList = RestContext.getUpdateAllowUserIdList();
            if (CollectionUtils.isNotEmpty((Collection)allowUpdateUserIdList)) {
                vo.setCanEdit(Boolean.valueOf(allowUpdateUserIdList.contains(tShadowJobConfig.getUserId())));
            }
            if (CollectionUtils.isNotEmpty((Collection)(allowDeleteUserIdList = RestContext.getDeleteAllowUserIdList()))) {
                vo.setCanRemove(Boolean.valueOf(allowDeleteUserIdList.contains(tShadowJobConfig.getUserId())));
            }
            if (CollectionUtils.isNotEmpty((Collection)(allowEnableDisableUserIdList = RestContext.getEnableDisableAllowUserIdList()))) {
                vo.setCanEnableDisable(Boolean.valueOf(allowEnableDisableUserIdList.contains(tShadowJobConfig.getUserId())));
            }
            configVos.add(vo);
        });
        return Response.success(configVos, (long)pageInfo.getTotal());
    }

    public List<TShadowJobConfig> queryByAppName(String appName) {
        TApplicationMnt tApplicationMnt;
        Estimate.notBlank((Object)appName, (String)"\u5e94\u7528\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        User user = RestContext.getUser();
        if (user == null) {
            String userAppKey = RestContext.getTenantUserKey();
            user = this.TUserMapper.selectByKey(userAppKey);
        }
        if (null == (tApplicationMnt = this.tApplicationMntDao.queryApplicationInfoByNameAndTenant(appName, user == null ? null : user.getId()))) {
            throw new RuntimeException("\u672a\u67e5\u8be2\u5230\u5e94\u7528\u76f8\u5173\u6570\u636e");
        }
        ShadowJobConfigQuery query = new ShadowJobConfigQuery();
        query.setApplicationId(Long.valueOf(tApplicationMnt.getApplicationId()));
        List tShadowJobConfigs = this.tShadowJobConfigMapper.selectList(query);
        try {
            for (TShadowJobConfig tShadowJobConfig : tShadowJobConfigs) {
                Map stringStringMap = XmlUtil.readStringXml((String)tShadowJobConfig.getConfigCode());
                tShadowJobConfig.setConfigCode(JSONObject.toJSONString((Object)stringStringMap));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("dom \u89e3\u6790\u53d1\u751f\u5f02\u5e38");
        }
        return tShadowJobConfigs;
    }

    public List<TShadowJobConfig> getAllEnableShadowJobs(long applicationId) {
        return this.tShadowJobConfigMapper.getAllEnableShadowJobs(applicationId);
    }
}

