/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.scriptmanage;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.pamirs.tro.entity.domain.entity.user.User;
import io.shulie.tro.cloud.common.redis.RedisClientUtils;
import io.shulie.tro.common.beans.page.PagingList;
import io.shulie.tro.exception.entity.ExceptionReadable;
import io.shulie.tro.utils.file.FileManagerHelper;
import io.shulie.tro.utils.json.JsonHelper;
import io.shulie.tro.web.app.common.RestContext;
import io.shulie.tro.web.app.context.OperationLogContextHolder;
import io.shulie.tro.web.app.exception.ExceptionCode;
import io.shulie.tro.web.app.exception.TroWebException;
import io.shulie.tro.web.app.input.scriptmanage.ShellExecuteInput;
import io.shulie.tro.web.app.input.scriptmanage.ShellScriptManageCreateInput;
import io.shulie.tro.web.app.input.scriptmanage.ShellScriptManagePageQueryInput;
import io.shulie.tro.web.app.input.scriptmanage.ShellScriptManageUpdateInput;
import io.shulie.tro.web.app.output.scriptmanage.shell.ScriptExecuteOutput;
import io.shulie.tro.web.app.output.scriptmanage.shell.ShellScriptManageContentOutput;
import io.shulie.tro.web.app.output.scriptmanage.shell.ShellScriptManageDetailOutput;
import io.shulie.tro.web.app.output.scriptmanage.shell.ShellScriptManageExecuteOutput;
import io.shulie.tro.web.app.output.scriptmanage.shell.ShellScriptManageOutput;
import io.shulie.tro.web.app.output.tagmanage.TagManageOutput;
import io.shulie.tro.web.app.service.scriptmanage.ShellScriptManageService;
import io.shulie.tro.web.app.utils.LinuxHelper;
import io.shulie.tro.web.auth.api.UserService;
import io.shulie.tro.web.data.dao.filemanage.FileManageDAO;
import io.shulie.tro.web.data.dao.scriptmanage.ScriptFileRefDAO;
import io.shulie.tro.web.data.dao.scriptmanage.ScriptManageDAO;
import io.shulie.tro.web.data.dao.scriptmanage.ScriptTagRefDAO;
import io.shulie.tro.web.data.dao.tagmanage.TagManageDAO;
import io.shulie.tro.web.data.param.filemanage.FileManageCreateParam;
import io.shulie.tro.web.data.param.scriptmanage.ScriptExecuteResultCreateParam;
import io.shulie.tro.web.data.param.scriptmanage.ScriptManageDeployCreateParam;
import io.shulie.tro.web.data.param.scriptmanage.ScriptManageDeployPageQueryParam;
import io.shulie.tro.web.data.param.scriptmanage.shell.ShellExecuteParam;
import io.shulie.tro.web.data.result.filemanage.FileManageResult;
import io.shulie.tro.web.data.result.scriptmanage.ScriptFileRefResult;
import io.shulie.tro.web.data.result.scriptmanage.ScriptManageDeployResult;
import io.shulie.tro.web.data.result.scriptmanage.ScriptManageResult;
import io.shulie.tro.web.data.result.scriptmanage.ScriptTagRefResult;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ShellScriptManageServiceImpl
implements ShellScriptManageService {
    private static final Logger log = LoggerFactory.getLogger(ShellScriptManageServiceImpl.class);
    private static ThreadFactory nameThreadFactory = new ThreadFactoryBuilder().setNameFormat("linux-run-thread-%d").build();
    private static ThreadPoolExecutor poolExecutor = new ThreadPoolExecutor(20, 20, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10), nameThreadFactory, new ThreadPoolExecutor.CallerRunsPolicy());
    @Value(value="${web.file.upload.script.path:/opt/tro/script}")
    private String fileScriptPath;
    @Value(value="${customer.id:0}")
    private String customerId;
    @Autowired
    private ScriptManageDAO scriptManageDAO;
    @Autowired
    private ScriptFileRefDAO scriptFileRefDAO;
    @Autowired
    private FileManageDAO fileManageDAO;
    @Autowired
    private ScriptTagRefDAO scriptTagRefDAO;
    @Autowired
    private UserService userService;
    @Autowired
    private TagManageDAO tagManageDAO;
    @Autowired
    private RedisClientUtils redisClientUtils;

    public Long createScriptManage(ShellScriptManageCreateInput input) {
        input.setType(Integer.valueOf(1));
        input.setFileType(Integer.valueOf(4));
        input.setName(input.getName().trim());
        List scriptManageResults = this.scriptManageDAO.selectScriptManageByName(input.getName());
        if (CollectionUtils.isNotEmpty((Collection)scriptManageResults)) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.SCRIPT_MANAGE_CREATE_VALID_ERROR, (Object)"\u811a\u672c\u540d\u79f0\u91cd\u590d\uff01");
        }
        ScriptManageDeployCreateParam param = new ScriptManageDeployCreateParam();
        BeanUtils.copyProperties((Object)input, (Object)param);
        param.setStatus(Integer.valueOf(0));
        param.setScriptVersion(Integer.valueOf(1));
        User user = RestContext.getUser();
        param.setCreateUserId(user.getId());
        param.setCreateUserName(user.getName());
        param.setCustomerId(user.getCustomerId());
        ScriptManageDeployResult scriptManageDeployResult = this.scriptManageDAO.createScriptManageDeploy(param);
        FileManageCreateParam fileManageCreateParam = this.getFileManageCreateParams(input, scriptManageDeployResult);
        FileManagerHelper.createFileByPathAndString((String)fileManageCreateParam.getUploadPath(), (String)input.getContent());
        ArrayList params = Lists.newArrayList();
        params.add(fileManageCreateParam);
        List fileIds = this.fileManageDAO.createFileManageList((List)params);
        this.scriptFileRefDAO.createScriptFileRefs(fileIds, scriptManageDeployResult.getId());
        return scriptManageDeployResult.getId();
    }

    private FileManageCreateParam getFileManageCreateParams(ShellScriptManageCreateInput input, ScriptManageDeployResult result) {
        FileManageCreateParam fileManageCreateParam = new FileManageCreateParam();
        UUID uuid = UUID.randomUUID();
        String fileName = uuid.toString() + ".sh";
        fileManageCreateParam.setFileName(fileName);
        try {
            fileManageCreateParam.setFileSize(input.getContent().getBytes("utf-8").length / 1024 / 1024 + "M");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        fileManageCreateParam.setFileType(input.getFileType());
        fileManageCreateParam.setCustomerId(Long.valueOf(Long.parseLong(this.customerId)));
        fileManageCreateParam.setUploadPath(this.fileScriptPath + "/shell/" + result.getScriptId() + "/" + result.getScriptVersion() + "/" + fileName);
        fileManageCreateParam.setUploadTime(new Date());
        return fileManageCreateParam;
    }

    public String updateScriptManage(ShellScriptManageUpdateInput input) {
        if (!this.isStop(input.getScriptDeployId()).booleanValue()) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.SCRIPT_MANAGE_UPDATE_VALID_ERROR, (Object)"\u811a\u672c\u6b63\u5728\u8fd0\u884c\u4e2d\uff01");
        }
        ScriptManageDeployResult oldDeployResult = this.scriptManageDAO.selectScriptManageDeployById(input.getScriptDeployId());
        Boolean updateFlag = this.isUpdate(input, oldDeployResult);
        if (updateFlag.booleanValue()) {
            input.setType(Integer.valueOf(1));
            input.setFileType(Integer.valueOf(4));
            ScriptManageDeployCreateParam createParam = new ScriptManageDeployCreateParam();
            BeanUtils.copyProperties((Object)input, (Object)createParam);
            createParam.setStatus(Integer.valueOf(0));
            List history = this.scriptManageDAO.selectScriptManageDeployByScriptId(oldDeployResult.getScriptId());
            Integer scriptVersion = history.stream().max(Comparator.comparing(ScriptManageDeployResult::getScriptVersion)).get().getScriptVersion();
            createParam.setScriptVersion(Integer.valueOf(scriptVersion + 1));
            this.scriptManageDAO.updateScriptVersion(oldDeployResult.getScriptId(), Integer.valueOf(scriptVersion + 1));
            User user = RestContext.getUser();
            createParam.setCreateUserId(user.getId());
            createParam.setCreateUserName(user.getName());
            createParam.setScriptId(oldDeployResult.getScriptId());
            ScriptManageDeployResult scriptManageDeployResult = this.scriptManageDAO.createScriptManageDeploy(createParam);
            ShellScriptManageCreateInput createInput = new ShellScriptManageCreateInput();
            BeanUtils.copyProperties((Object)input, (Object)createInput);
            FileManageCreateParam fileManageCreateParam = this.getFileManageCreateParams(createInput, scriptManageDeployResult);
            FileManagerHelper.createFileByPathAndString((String)fileManageCreateParam.getUploadPath(), (String)input.getContent());
            ArrayList params = Lists.newArrayList();
            params.add(fileManageCreateParam);
            List fileIds = this.fileManageDAO.createFileManageList((List)params);
            this.scriptFileRefDAO.createScriptFileRefs(fileIds, scriptManageDeployResult.getId());
            return "\u7248\u672c\u66f4\u65b0\u6210\u529f";
        }
        this.scriptManageDAO.switchScriptVersion(oldDeployResult.getScriptId(), input.getScriptVersion());
        return "\u7248\u672c\u5207\u6362\u6210\u529f";
    }

    private Boolean isUpdate(ShellScriptManageUpdateInput input, ScriptManageDeployResult oldDeployResult) {
        Boolean updateFlag = false;
        if (!StringUtils.equals((CharSequence)input.getDescription(), (CharSequence)oldDeployResult.getDescription())) {
            updateFlag = true;
        }
        String content = this.getContent(oldDeployResult);
        if (!StringUtils.equals((CharSequence)input.getContent(), (CharSequence)content)) {
            updateFlag = true;
        }
        return updateFlag;
    }

    private String getContent(ScriptManageDeployResult deployResult) {
        List scriptFileRefResults = this.scriptFileRefDAO.selectFileIdsByScriptDeployId(deployResult.getId());
        if (CollectionUtils.isEmpty((Collection)scriptFileRefResults)) {
            log.info("\u6ca1\u6709\u627e\u76f8\u5173\u6587\u4ef6");
            return "";
        }
        List fileIds = scriptFileRefResults.stream().map(ScriptFileRefResult::getFileId).collect(Collectors.toList());
        List fileManageResults = this.fileManageDAO.selectFileManageByIds(fileIds);
        if (CollectionUtils.isNotEmpty((Collection)fileManageResults)) {
            List paths = fileManageResults.stream().map(FileManageResult::getUploadPath).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(paths)) {
                return "";
            }
            FileManageResult fileManageResult = (FileManageResult)fileManageResults.get(0);
            try {
                if (new File(fileManageResult.getUploadPath()).exists()) {
                    return FileManagerHelper.readFileToString((File)new File(fileManageResult.getUploadPath()), (String)"UTF-8");
                }
            }
            catch (IOException e) {
                throw new TroWebException((ExceptionReadable)ExceptionCode.SCRIPT_MANAGE_ERROR, (Object)"\u811a\u672c\u5185\u5bb9\u83b7\u53d6\u9519\u8bef");
            }
        }
        return "";
    }

    public void deleteScriptManage(Long scriptId) {
        ScriptManageResult scriptManageResult = this.scriptManageDAO.selectScriptManageById(scriptId);
        ScriptManageDeployResult deployResult = this.scriptManageDAO.selectScriptManageDeployByVersion(scriptManageResult.getId(), scriptManageResult.getScriptVersion());
        if (!this.isStop(deployResult.getId()).booleanValue()) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.SCRIPT_MANAGE_DELETE_VALID_ERROR, (Object)"\u811a\u672c\u6b63\u5728\u8fd0\u884c\u4e2d\uff01");
        }
        OperationLogContextHolder.addVars((String)"scriptManageDeployName", (String)deployResult.getName());
        List existScriptManageDeployResults = this.scriptManageDAO.selectScriptManageDeployByScriptId(scriptId);
        this.scriptManageDAO.deleteScriptManageAndDeploy(scriptId);
        List existScriptManageDeployIds = existScriptManageDeployResults.stream().map(ScriptManageDeployResult::getId).collect(Collectors.toList());
        List scriptFileRefResults = this.scriptFileRefDAO.selectFileIdsByScriptDeployIds(existScriptManageDeployIds);
        if (CollectionUtils.isNotEmpty((Collection)scriptFileRefResults)) {
            List scriptFileRefIds = scriptFileRefResults.stream().map(ScriptFileRefResult::getId).collect(Collectors.toList());
            this.scriptFileRefDAO.deleteByIds(scriptFileRefIds);
            List fileIds = scriptFileRefResults.stream().map(ScriptFileRefResult::getFileId).collect(Collectors.toList());
            List fileManageResults = this.fileManageDAO.selectFileManageByIds(fileIds);
            List filePaths = fileManageResults.stream().map(FileManageResult::getUploadPath).collect(Collectors.toList());
            FileManagerHelper.deleteFiles(filePaths);
            this.fileManageDAO.deleteByIds(fileIds);
        }
        this.scriptTagRefDAO.deleteByScriptId(scriptId);
    }

    public ShellScriptManageDetailOutput getScriptManageDetail(Long scriptId) {
        ShellScriptManageDetailOutput output = new ShellScriptManageDetailOutput();
        ScriptManageResult scriptManageResult = this.scriptManageDAO.selectScriptManageById(scriptId);
        if (scriptManageResult == null) {
            return null;
        }
        BeanUtils.copyProperties((Object)scriptManageResult, (Object)output);
        ScriptManageDeployResult deployResult = this.scriptManageDAO.selectScriptManageDeployByVersion(scriptId, scriptManageResult.getScriptVersion());
        if (deployResult == null) {
            return output;
        }
        output.setDescription(deployResult.getDescription());
        output.setScriptDeployId(deployResult.getId());
        output.setType(deployResult.getType());
        output.setContent(this.getContent(deployResult));
        List list = this.scriptManageDAO.selectScriptManageDeployByScriptId(scriptId);
        List versions = list.stream().map(result -> {
            HashMap map = Maps.newHashMap();
            map.put("label", "\u7248\u672c" + result.getScriptVersion());
            map.put("value", result.getScriptVersion());
            return map;
        }).collect(Collectors.toList());
        output.setVersions(versions);
        return output;
    }

    public PagingList<ShellScriptManageOutput> pageQueryScriptManage(ShellScriptManagePageQueryInput input) {
        PagingList scriptManageDeployResults;
        ScriptManageDeployPageQueryParam queryParam = new ScriptManageDeployPageQueryParam();
        if (input != null) {
            BeanUtils.copyProperties((Object)input, (Object)queryParam);
            if (CollectionUtils.isNotEmpty((Collection)input.getTagIds())) {
                List scriptTagRefResults = this.scriptTagRefDAO.selectScriptTagRefByTagIds(input.getTagIds());
                if (CollectionUtils.isEmpty((Collection)scriptTagRefResults)) {
                    return PagingList.empty();
                }
                Map<Long, List<ScriptTagRefResult>> scriptTagRefMap = scriptTagRefResults.stream().collect(Collectors.groupingBy(ScriptTagRefResult::getScriptId));
                ArrayList<Long> scriptIds = new ArrayList<Long>();
                for (Map.Entry<Long, List<ScriptTagRefResult>> entry : scriptTagRefMap.entrySet()) {
                    if (entry.getValue().size() != input.getTagIds().size()) continue;
                    scriptIds.add(entry.getKey());
                }
                if (CollectionUtils.isEmpty(scriptIds)) {
                    return PagingList.empty();
                }
                queryParam.setScriptIds(scriptIds);
            }
        }
        queryParam.setCurrent(input.getCurrent());
        queryParam.setPageSize(Integer.valueOf(input.getPageSize()));
        queryParam.setScriptType(Integer.valueOf(1));
        List userIdList = RestContext.getQueryAllowUserIdList();
        if (CollectionUtils.isNotEmpty((Collection)userIdList)) {
            queryParam.setUserIdList(userIdList);
        }
        if ((scriptManageDeployResults = this.scriptManageDAO.pageQueryRecentScriptManageDeploy(queryParam)).isEmpty()) {
            return PagingList.empty();
        }
        List userIds = scriptManageDeployResults.getList().stream().filter(data -> null != data.getUserId()).map(ScriptManageDeployResult::getUserId).collect(Collectors.toList());
        Map userMap = this.userService.getUserMapByIds(userIds);
        List allowUpdateUserIdList = RestContext.getUpdateAllowUserIdList();
        List allowDeleteUserIdList = RestContext.getDeleteAllowUserIdList();
        List outputs = scriptManageDeployResults.getList().stream().map(scriptManageDeployResult -> {
            ShellScriptManageOutput shellScriptManageOutput = new ShellScriptManageOutput();
            BeanUtils.copyProperties((Object)scriptManageDeployResult, (Object)shellScriptManageOutput);
            shellScriptManageOutput.setScripDeployId(scriptManageDeployResult.getId());
            if (CollectionUtils.isNotEmpty((Collection)allowUpdateUserIdList)) {
                shellScriptManageOutput.setCanEdit(Boolean.valueOf(allowUpdateUserIdList.contains(scriptManageDeployResult.getUserId())));
            }
            if (CollectionUtils.isNotEmpty((Collection)allowDeleteUserIdList)) {
                shellScriptManageOutput.setCanRemove(Boolean.valueOf(allowDeleteUserIdList.contains(scriptManageDeployResult.getUserId())));
            }
            shellScriptManageOutput.setManagerId(scriptManageDeployResult.getUserId());
            String userName = Optional.ofNullable(userMap.get(scriptManageDeployResult.getUserId())).map(u -> u.getName()).orElse("");
            shellScriptManageOutput.setManagerName(userName);
            return shellScriptManageOutput;
        }).collect(Collectors.toList());
        this.setTagList(outputs);
        this.setExecuteState(outputs);
        return PagingList.of(outputs, (long)scriptManageDeployResults.getTotal());
    }

    private void setExecuteState(List<ShellScriptManageOutput> outputs) {
        if (outputs == null || CollectionUtils.isEmpty(outputs)) {
            return;
        }
        outputs.forEach(arg_0 -> this.setState(arg_0));
    }

    private void setState(ShellScriptManageOutput output) {
        if (!this.isStop(output.getScripDeployId()).booleanValue()) {
            output.setExecute(Boolean.valueOf(true));
        }
    }

    private void setTagList(List<ShellScriptManageOutput> outputs) {
        if (outputs == null || CollectionUtils.isEmpty(outputs)) {
            return;
        }
        List scriptIds = outputs.stream().map(ShellScriptManageOutput::getScriptId).collect(Collectors.toList());
        List scriptTagRefResults = this.scriptTagRefDAO.selectScriptTagRefByScriptIds(scriptIds);
        if (CollectionUtils.isEmpty((Collection)scriptTagRefResults)) {
            return;
        }
        List tagIds = scriptTagRefResults.stream().map(ScriptTagRefResult::getTagId).collect(Collectors.toList());
        List tagManageResults = this.tagManageDAO.selectScriptTagsByIds(tagIds);
        if (CollectionUtils.isEmpty((Collection)tagManageResults)) {
            return;
        }
        Map<Long, List<ScriptTagRefResult>> scriptTagRefMap = scriptTagRefResults.stream().collect(Collectors.groupingBy(ScriptTagRefResult::getScriptId));
        List tagManageOutputs = tagManageResults.stream().map(tagManageResult -> {
            TagManageOutput tagManageOutput = new TagManageOutput();
            tagManageOutput.setId(tagManageResult.getId());
            tagManageOutput.setTagName(tagManageResult.getTagName());
            return tagManageOutput;
        }).collect(Collectors.toList());
        Map<Long, TagManageOutput> tagManageResponseMap = tagManageOutputs.stream().collect(Collectors.toMap(TagManageOutput::getId, a -> a, (k1, k2) -> k1));
        outputs.forEach(output -> {
            List scriptTagRefList = (List)scriptTagRefMap.get(output.getScriptId());
            if (CollectionUtils.isEmpty((Collection)scriptTagRefList)) {
                return;
            }
            List resultTagManageOutputs = scriptTagRefList.stream().map(scriptTagRefResult -> (TagManageOutput)tagManageResponseMap.get(scriptTagRefResult.getTagId())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(resultTagManageOutputs)) {
                return;
            }
            output.setTagManageOutputs(resultTagManageOutputs);
        });
    }

    public ShellScriptManageExecuteOutput execute(Long scriptManageDeployId) {
        if (!this.isStop(scriptManageDeployId).booleanValue()) {
            log.info("\u6267\u884c\u7ed3\u679c\uff1a{}", (Object)JsonHelper.bean2Json((Object)this.redisClientUtils.hmget("shell_execute_key", String.valueOf(scriptManageDeployId))));
            return (ShellScriptManageExecuteOutput)this.redisClientUtils.hmget("shell_execute_key", String.valueOf(scriptManageDeployId));
        }
        ShellScriptManageExecuteOutput output = new ShellScriptManageExecuteOutput();
        List scriptFileRefResults = this.scriptFileRefDAO.selectFileIdsByScriptDeployId(scriptManageDeployId);
        ArrayList data = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)scriptFileRefResults)) {
            log.info("\u6ca1\u6709\u627e\u76f8\u5173\u6587\u4ef6");
            output.setSuccess(Boolean.valueOf(false));
            data.add("\u6ca1\u6709\u627e\u5230\u76f8\u5173\u811a\u672c\u6587\u4ef6\u4f9d\u8d56");
            output.setMessage((List)data);
            return output;
        }
        List fileIds = scriptFileRefResults.stream().map(ScriptFileRefResult::getFileId).collect(Collectors.toList());
        List fileManageResults = this.fileManageDAO.selectFileManageByIds(fileIds);
        if (CollectionUtils.isNotEmpty((Collection)fileManageResults)) {
            FileManageResult fileManageResult = (FileManageResult)fileManageResults.get(0);
            StringBuilder sb = new StringBuilder();
            sb.append("sh ");
            sb.append(fileManageResult.getUploadPath());
            poolExecutor.execute(() -> {
                HashMap map = Maps.newHashMap();
                ShellScriptManageExecuteOutput executeOutput = new ShellScriptManageExecuteOutput();
                data.add(sb.toString() + ":\u5f00\u59cb\u6267\u884c");
                executeOutput.setIsStop(Boolean.valueOf(false));
                executeOutput.setMessage(data);
                map.put(String.valueOf(scriptManageDeployId), executeOutput);
                this.redisClientUtils.hmset("shell_execute_key", (Map)map);
                AtomicReference shellProcess = new AtomicReference();
                int state = LinuxHelper.runShell((String)sb.toString(), (Long)60L, process -> shellProcess.set(process), message -> {
                    log.info("\u6267\u884c\u8fd4\u56de\u7ed3\u679c:{}", (Object)message);
                    ShellScriptManageExecuteOutput temp = (ShellScriptManageExecuteOutput)this.redisClientUtils.hmget("shell_execute_key", String.valueOf(scriptManageDeployId));
                    temp.getMessage().add(message);
                    map.put(String.valueOf(scriptManageDeployId), temp);
                    this.redisClientUtils.hmset("shell_execute_key", map);
                });
                ShellScriptManageExecuteOutput temp = (ShellScriptManageExecuteOutput)this.redisClientUtils.hmget("shell_execute_key", String.valueOf(scriptManageDeployId));
                temp.setIsStop(Boolean.valueOf(true));
                temp.setSuccess(Boolean.valueOf(state == 0));
                map.put(String.valueOf(scriptManageDeployId), temp);
                this.redisClientUtils.hmset("shell_execute_key", (Map)map, 259200L);
                ScriptExecuteResultCreateParam param = new ScriptExecuteResultCreateParam();
                ScriptManageDeployResult deployResult = this.scriptManageDAO.selectScriptManageDeployById(scriptManageDeployId);
                param.setScriptVersion(deployResult.getScriptVersion());
                param.setScriptId(deployResult.getScriptId());
                param.setSuccess(Boolean.valueOf(state == 0));
                param.setExecutor(RestContext.getUser().getName());
                param.setGmtCreate(new Date());
                param.setResult(JsonHelper.bean2Json((Object)temp.getMessage()));
                param.setScripDeployId(scriptManageDeployId);
                this.scriptManageDAO.createScriptExecuteResult(param);
            });
            ScriptManageDeployResult deployResult = this.scriptManageDAO.selectScriptManageDeployById(scriptManageDeployId);
            OperationLogContextHolder.addVars((String)"scriptManageDeployName", (String)deployResult.getName());
            return output;
        }
        output.setSuccess(Boolean.valueOf(false));
        data.add("\u6ca1\u6709\u627e\u5230\u6267\u884c\u6587\u4ef6");
        output.setMessage((List)data);
        return output;
    }

    private Boolean isStop(Long scriptManageDeployId) {
        if (this.redisClientUtils.hmget("shell_execute_key", String.valueOf(scriptManageDeployId)) != null) {
            ShellScriptManageExecuteOutput output = (ShellScriptManageExecuteOutput)this.redisClientUtils.hmget("shell_execute_key", String.valueOf(scriptManageDeployId));
            return output.getIsStop();
        }
        return true;
    }

    public ShellScriptManageContentOutput getShellScriptManageContent(Long scriptId, Integer version) {
        ShellScriptManageContentOutput output = new ShellScriptManageContentOutput();
        ScriptManageDeployResult deployResult = this.scriptManageDAO.selectScriptManageDeployByVersion(scriptId, version);
        if (deployResult == null) {
            return null;
        }
        output.setScriptManageDeployId(deployResult.getId());
        output.setScriptVersion(deployResult.getScriptVersion());
        output.setContent(this.getContent(deployResult));
        output.setDescription(deployResult.getDescription());
        return output;
    }

    public PagingList<ScriptExecuteOutput> getExecuteResult(ShellExecuteInput input) {
        if ("0".equals(input.getType())) {
            ShellScriptManageExecuteOutput output = (ShellScriptManageExecuteOutput)this.redisClientUtils.hmget("shell_execute_key", String.valueOf(input.getScriptDeployId()));
            ArrayList outputs = Lists.newArrayList();
            if (output != null) {
                ScriptExecuteOutput executeOutput = new ScriptExecuteOutput();
                executeOutput.setSuccess(output.getSuccess());
                executeOutput.setIsStop(output.getIsStop());
                executeOutput.setResult(output.getMessage() != null && output.getMessage().size() > 0 ? (String)output.getMessage().get(output.getMessage().size() - 1) : "");
                outputs.add(executeOutput);
            }
            return PagingList.of((List)outputs, (long)outputs.size());
        }
        ScriptManageDeployResult deployResult = this.scriptManageDAO.selectScriptManageDeployById(input.getScriptDeployId());
        ShellExecuteParam param = new ShellExecuteParam();
        BeanUtils.copyProperties((Object)input, (Object)param);
        param.setScriptId(deployResult.getScriptId());
        PagingList pagingList = this.scriptManageDAO.getExecuteResult(param);
        List results = pagingList.getList();
        List outputs = results.stream().map(result -> {
            ScriptExecuteOutput output = new ScriptExecuteOutput();
            BeanUtils.copyProperties((Object)result, (Object)output);
            return output;
        }).collect(Collectors.toList());
        return PagingList.of(outputs, (long)pagingList.getTotal());
    }
}

