/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.scriptmanage;

import cn.hutool.core.date.DateUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pamirs.tro.common.util.parse.UrlUtil;
import com.pamirs.tro.entity.dao.linkmanage.TBusinessLinkManageTableMapper;
import com.pamirs.tro.entity.dao.linkmanage.TSceneLinkRelateMapper;
import com.pamirs.tro.entity.dao.linkmanage.TSceneMapper;
import com.pamirs.tro.entity.domain.dto.scenemanage.ScriptCheckDTO;
import com.pamirs.tro.entity.domain.entity.linkmanage.BusinessLinkManageTable;
import com.pamirs.tro.entity.domain.entity.linkmanage.Scene;
import com.pamirs.tro.entity.domain.vo.scenemanage.ScriptUrlVO;
import io.shulie.tro.cloud.common.pojo.dto.scenemanage.UploadFileDTO;
import io.shulie.tro.cloud.open.req.engine.EnginePluginDetailsWrapperReq;
import io.shulie.tro.cloud.open.req.engine.EnginePluginFetchWrapperReq;
import io.shulie.tro.cloud.open.req.scenemanage.SceneParseReq;
import io.shulie.tro.cloud.open.req.scenemanage.UpdateSceneFileRequest;
import io.shulie.tro.cloud.open.resp.engine.EnginePluginDetailResp;
import io.shulie.tro.cloud.open.resp.scenemanage.SceneManageListResp;
import io.shulie.tro.common.beans.page.PagingList;
import io.shulie.tro.common.beans.response.ResponseResult;
import io.shulie.tro.exception.entity.ExceptionReadable;
import io.shulie.tro.utils.json.JsonHelper;
import io.shulie.tro.utils.linux.LinuxHelper;
import io.shulie.tro.utils.string.StringUtil;
import io.shulie.tro.utils.xml.XmlHelper;
import io.shulie.tro.web.app.common.RestContext;
import io.shulie.tro.web.app.convert.performace.TraceManageResponseConvertor;
import io.shulie.tro.web.app.exception.ExceptionCode;
import io.shulie.tro.web.app.exception.TroWebException;
import io.shulie.tro.web.app.request.filemanage.FileManageCreateRequest;
import io.shulie.tro.web.app.request.filemanage.FileManageUpdateRequest;
import io.shulie.tro.web.app.request.scriptmanage.ScriptManageDeployCreateRequest;
import io.shulie.tro.web.app.request.scriptmanage.ScriptManageDeployPageQueryRequest;
import io.shulie.tro.web.app.request.scriptmanage.ScriptManageDeployUpdateRequest;
import io.shulie.tro.web.app.request.scriptmanage.ScriptTagCreateRefRequest;
import io.shulie.tro.web.app.request.scriptmanage.SupportJmeterPluginNameRequest;
import io.shulie.tro.web.app.request.scriptmanage.SupportJmeterPluginVersionRequest;
import io.shulie.tro.web.app.response.filemanage.FileManageResponse;
import io.shulie.tro.web.app.response.scriptmanage.PluginConfigDetailResponse;
import io.shulie.tro.web.app.response.scriptmanage.ScriptManageActivityResponse;
import io.shulie.tro.web.app.response.scriptmanage.ScriptManageDeployActivityResponse;
import io.shulie.tro.web.app.response.scriptmanage.ScriptManageDeployDetailResponse;
import io.shulie.tro.web.app.response.scriptmanage.ScriptManageDeployResponse;
import io.shulie.tro.web.app.response.scriptmanage.ScriptManageSceneManageResponse;
import io.shulie.tro.web.app.response.scriptmanage.ScriptManageXmlContentResponse;
import io.shulie.tro.web.app.response.scriptmanage.SinglePluginRenderResponse;
import io.shulie.tro.web.app.response.scriptmanage.SupportJmeterPluginNameResponse;
import io.shulie.tro.web.app.response.scriptmanage.SupportJmeterPluginVersionResponse;
import io.shulie.tro.web.app.response.tagmanage.TagManageResponse;
import io.shulie.tro.web.app.service.linkManage.LinkManageService;
import io.shulie.tro.web.app.service.scriptmanage.ScriptManageService;
import io.shulie.tro.web.app.utils.exception.ScriptManageExceptionUtil;
import io.shulie.tro.web.auth.api.UserService;
import io.shulie.tro.web.common.constant.RemoteConstant;
import io.shulie.tro.web.common.enums.script.FileTypeEnum;
import io.shulie.tro.web.common.enums.script.ScriptManageDeployStatusEnum;
import io.shulie.tro.web.common.pojo.vo.file.FileExtendVO;
import io.shulie.tro.web.common.util.ActivityUtil;
import io.shulie.tro.web.common.util.FileUtil;
import io.shulie.tro.web.data.dao.filemanage.FileManageDAO;
import io.shulie.tro.web.data.dao.linkmanage.BusinessLinkManageDAO;
import io.shulie.tro.web.data.dao.linkmanage.LinkManageDAO;
import io.shulie.tro.web.data.dao.scriptmanage.ScriptFileRefDAO;
import io.shulie.tro.web.data.dao.scriptmanage.ScriptManageDAO;
import io.shulie.tro.web.data.dao.scriptmanage.ScriptTagRefDAO;
import io.shulie.tro.web.data.dao.tagmanage.TagManageDAO;
import io.shulie.tro.web.data.param.filemanage.FileManageCreateParam;
import io.shulie.tro.web.data.param.linkmanage.LinkManageQueryParam;
import io.shulie.tro.web.data.param.scriptmanage.ScriptManageDeployCreateParam;
import io.shulie.tro.web.data.param.scriptmanage.ScriptManageDeployPageQueryParam;
import io.shulie.tro.web.data.param.tagmanage.TagManageParam;
import io.shulie.tro.web.data.result.filemanage.FileManageResult;
import io.shulie.tro.web.data.result.linkmange.BusinessLinkResult;
import io.shulie.tro.web.data.result.linkmange.LinkManageResult;
import io.shulie.tro.web.data.result.scriptmanage.ScriptFileRefResult;
import io.shulie.tro.web.data.result.scriptmanage.ScriptManageDeployResult;
import io.shulie.tro.web.data.result.scriptmanage.ScriptManageResult;
import io.shulie.tro.web.data.result.scriptmanage.ScriptTagRefResult;
import io.shulie.tro.web.diff.api.DiffFileApi;
import io.shulie.tro.web.diff.api.scenemanage.SceneManageApi;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ScriptManageServiceImpl
implements ScriptManageService {
    private static final Logger log = LoggerFactory.getLogger(ScriptManageServiceImpl.class);
    @Value(value="${file.upload.url:''}")
    private String fileUploadUrl;
    @Value(value="${file.upload.tmp.path:'/tmp/tro/'}")
    private String tmpFilePath;
    @Value(value="${file.upload.script.path:'/nfs/tro/script/'}")
    private String scriptFilePath;
    @Value(value="${script.check:true}")
    private Boolean scriptCheck;
    @Value(value="${file.upload.user.data.dir:/data/tmp}")
    private String fileDir;
    @Autowired
    private DiffFileApi fileApi;
    @Autowired
    private ScriptManageDAO scriptManageDAO;
    @Autowired
    private ScriptFileRefDAO scriptFileRefDAO;
    @Autowired
    private FileManageDAO fileManageDAO;
    @Autowired
    private ScriptTagRefDAO scriptTagRefDAO;
    @Autowired
    private TagManageDAO tagManageDAO;
    @Autowired
    private TBusinessLinkManageTableMapper tBusinessLinkManageTableMapper;
    @Autowired
    private TSceneMapper tSceneMapper;
    @Autowired
    private LinkManageService linkManageService;
    @Autowired
    private SceneManageApi sceneManageApi;
    @Autowired
    private TSceneLinkRelateMapper tSceneLinkRelateMapper;
    @Autowired
    private UserService userService;
    @Autowired
    private BusinessLinkManageDAO businessLinkManageDAO;
    @Autowired
    private LinkManageDAO linkManageDAO;

    public String getZipFileUrl(Long scriptDeployId) {
        String fileName;
        ScriptManageDeployResult scriptManageDeployResult = this.scriptManageDAO.selectScriptManageDeployById(scriptDeployId);
        if (scriptManageDeployResult == null) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.SCRIPT_MANAGE_DOWNLOAD_VALID_ERROR, (Object)"\u811a\u672c\u4e0d\u5b58\u5728\uff01");
        }
        List scriptFileRefResults = this.scriptFileRefDAO.selectFileIdsByScriptDeployId(scriptDeployId);
        if (CollectionUtils.isEmpty((Collection)scriptFileRefResults)) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.SCRIPT_MANAGE_DOWNLOAD_VALID_ERROR, (Object)"\u6ca1\u6709\u5173\u8054\u7684\u6587\u4ef6\uff01");
        }
        List fileIds = scriptFileRefResults.stream().map(ScriptFileRefResult::getFileId).collect(Collectors.toList());
        List fileManageResults = this.fileManageDAO.selectFileManageByIds(fileIds);
        List uploadPaths = fileManageResults.stream().map(FileManageResult::getUploadPath).collect(Collectors.toList());
        String targetScriptPath = this.getTargetScriptPath(scriptManageDeployResult);
        Boolean result = this.fileApi.zipFile(targetScriptPath, uploadPaths, fileName = scriptManageDeployResult.getName() + ".zip");
        if (!result.booleanValue()) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.SCRIPT_MANAGE_DOWNLOAD_VALID_ERROR, (Object)"\u6587\u4ef6\u6253\u5305\u4e0b\u8f7d\u5931\u8d25\uff01");
        }
        String url = null;
        try {
            url = this.fileUploadUrl + "/api/file/downloadFileByPath?filePath=" + targetScriptPath + URLEncoder.encode(fileName, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String[] cmds = new String[]{"curl", "-o", this.fileDir + "/" + fileName, "-OL", "-H", "licenseKey:" + RemoteConstant.LICENSE_VALUE, url};
        LinuxHelper.execCurl((String[])cmds);
        return this.fileDir + "/" + fileName;
    }

    public Long createScriptManage(ScriptManageDeployCreateRequest scriptManageDeployCreateRequest) {
        this.checkCreateScriptManageParam(scriptManageDeployCreateRequest);
        scriptManageDeployCreateRequest.setName(scriptManageDeployCreateRequest.getName().trim());
        List scriptManageResults = this.scriptManageDAO.selectScriptManageByName(scriptManageDeployCreateRequest.getName());
        if (CollectionUtils.isNotEmpty((Collection)scriptManageResults)) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.SCRIPT_MANAGE_CREATE_VALID_ERROR, (Object)"\u811a\u672c\u540d\u79f0\u91cd\u590d\uff01");
        }
        this.uploadCreateScriptFile(scriptManageDeployCreateRequest.getFileManageCreateRequests());
        List scriptFile = scriptManageDeployCreateRequest.getFileManageCreateRequests().stream().filter(o -> o.getFileType() == 0).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(scriptFile) || scriptFile.size() != 1) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.SCRIPT_MANAGE_CREATE_VALID_ERROR, (Object)"\u811a\u672c\u6587\u4ef6\u4e0d\u552f\u4e00\uff01");
        }
        ScriptCheckDTO scriptCheckDTO = this.checkAndUpdateScript(scriptManageDeployCreateRequest.getRefType(), scriptManageDeployCreateRequest.getRefValue(), this.tmpFilePath + ((FileManageCreateRequest)scriptFile.get(0)).getUploadId() + "/" + ((FileManageCreateRequest)scriptFile.get(0)).getFileName());
        if (scriptCheckDTO != null && !StringUtil.isBlank((CharSequence)scriptCheckDTO.getErrmsg())) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.SCRIPT_MANAGE_CREATE_VALID_ERROR, (Object)scriptCheckDTO.getErrmsg());
        }
        if (scriptCheckDTO != null && scriptCheckDTO.getIsHttp() != null && !scriptCheckDTO.getIsHttp().booleanValue() && CollectionUtils.isEmpty((Collection)scriptManageDeployCreateRequest.getPluginConfigCreateRequests())) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.SCRIPT_MANAGE_CREATE_VALID_ERROR, (Object)"\u5b58\u5728\u4e0d\u662fhttp\u7684\u4e1a\u52a1\u6d3b\u52a8\uff0c\u4f46\u6ca1\u6709\u4f20\u63d2\u4ef6\uff01");
        }
        ScriptManageDeployCreateParam scriptManageDeployCreateParam = new ScriptManageDeployCreateParam();
        BeanUtils.copyProperties((Object)scriptManageDeployCreateRequest, (Object)scriptManageDeployCreateParam);
        scriptManageDeployCreateParam.setStatus(Integer.valueOf(0));
        scriptManageDeployCreateParam.setScriptVersion(Integer.valueOf(1));
        if (CollectionUtils.isNotEmpty((Collection)scriptManageDeployCreateRequest.getPluginConfigCreateRequests())) {
            HashMap features = Maps.newHashMap();
            features.put("pluginConfig", scriptManageDeployCreateRequest.getPluginConfigCreateRequests());
            scriptManageDeployCreateParam.setFeature(JSON.toJSONString((Object)features));
        }
        ScriptManageDeployResult scriptManageDeployResult = this.scriptManageDAO.createScriptManageDeploy(scriptManageDeployCreateParam);
        String targetScriptPath = this.getTargetScriptPath(scriptManageDeployResult);
        List tmpFilePaths = scriptManageDeployCreateRequest.getFileManageCreateRequests().stream().map(o -> this.tmpFilePath + o.getUploadId() + "/" + o.getFileName()).collect(Collectors.toList());
        this.fileApi.copyFile(targetScriptPath, tmpFilePaths);
        this.fileApi.deleteFile(tmpFilePaths);
        List fileManageCreateParams = this.getFileManageCreateParams(scriptManageDeployCreateRequest.getFileManageCreateRequests(), targetScriptPath);
        List fileIds = this.fileManageDAO.createFileManageList(fileManageCreateParams);
        this.scriptFileRefDAO.createScriptFileRefs(fileIds, scriptManageDeployResult.getId());
        return scriptManageDeployResult.getId();
    }

    private void uploadCreateScriptFile(List<FileManageCreateRequest> fileManageCreateRequests) {
        if (CollectionUtils.isNotEmpty(fileManageCreateRequests)) {
            for (FileManageCreateRequest fileManageCreateRequest : fileManageCreateRequests) {
                if (fileManageCreateRequest.getIsDeleted() != 0 || fileManageCreateRequest.getFileType() != 0 || StringUtil.isBlank((CharSequence)fileManageCreateRequest.getScriptContent())) continue;
                if (!StringUtil.isBlank((CharSequence)fileManageCreateRequest.getUploadId())) {
                    String tempFile = this.tmpFilePath + fileManageCreateRequest.getUploadId() + "/" + fileManageCreateRequest.getFileName();
                    this.fileApi.deleteFile(Collections.singletonList(tempFile));
                }
                UUID uuid = UUID.randomUUID();
                fileManageCreateRequest.setUploadId(uuid.toString());
                String tempFile = this.tmpFilePath + fileManageCreateRequest.getUploadId() + "/" + fileManageCreateRequest.getFileName();
                this.fileApi.createFileByPathAndString(tempFile, fileManageCreateRequest.getScriptContent());
            }
        }
    }

    private void uploadUpdateScriptFile(List<FileManageUpdateRequest> fileManageCreateRequests) {
        if (CollectionUtils.isEmpty(fileManageCreateRequests)) {
            return;
        }
        for (FileManageUpdateRequest fileManageUpdateRequest : fileManageCreateRequests) {
            if (!StringUtil.isNotBlank((CharSequence)fileManageUpdateRequest.getScriptContent())) continue;
            if (StringUtil.isNotBlank((CharSequence)fileManageUpdateRequest.getUploadId())) {
                String tempFile = this.tmpFilePath + fileManageUpdateRequest.getUploadId() + "/" + fileManageUpdateRequest.getFileName();
                this.fileApi.deleteFile(Collections.singletonList(tempFile));
            }
            UUID uuid = UUID.randomUUID();
            fileManageUpdateRequest.setUploadId(uuid.toString());
            fileManageUpdateRequest.setId(null);
            String tempFile = this.tmpFilePath + fileManageUpdateRequest.getUploadId() + "/" + fileManageUpdateRequest.getFileName();
            this.fileApi.createFileByPathAndString(tempFile, fileManageUpdateRequest.getScriptContent());
        }
    }

    public ScriptCheckDTO checkAndUpdateScript(String refType, String refValue, String scriptFileUploadPath) {
        ScriptCheckDTO dto = new ScriptCheckDTO();
        if (this.scriptCheck == null || !this.scriptCheck.booleanValue()) {
            return dto;
        }
        SceneParseReq sceneParseReq = new SceneParseReq();
        sceneParseReq.setUploadPath(scriptFileUploadPath);
        sceneParseReq.setAbsolutePath(true);
        sceneParseReq.setScriptId(Long.valueOf(1L));
        ResponseResult mapResponseResult = this.sceneManageApi.parseAndUpdateScript(sceneParseReq);
        if (mapResponseResult == null || mapResponseResult.getData() == null) {
            log.error("\u4ece\u63a7\u5236\u53f0\u62ff\u53bb\u6570\u636e\u62a5\u9519\uff1a{}", (Object)scriptFileUploadPath);
            dto.setErrmsg("\u4ece\u63a7\u5236\u53f0\u62ff\u53bb\u6570\u636e\u62a5\u9519\uff1a" + scriptFileUploadPath);
            return dto;
        }
        Map dataMap = (Map)mapResponseResult.getData();
        List voList = (List)dataMap.get("requestUrl");
        if (CollectionUtils.isEmpty((Collection)voList)) {
            dto.setErrmsg("\u811a\u672c\u4e2d\u6ca1\u6709\u83b7\u53d6\u5230\u8bf7\u6c42\u94fe\u63a5\uff01");
            return dto;
        }
        List businessActivityList = this.getBusinessActivity(refType, refValue);
        if (CollectionUtils.isEmpty((Collection)businessActivityList)) {
            dto.setErrmsg("\u627e\u4e0d\u5230\u5173\u8054\u7684\u4e1a\u52a1\u6d3b\u52a8\uff01");
            return dto;
        }
        HashSet errorSet = new HashSet();
        int unbindCount = 0;
        HashMap<String, Integer> urlMap = new HashMap<String, Integer>();
        for (BusinessLinkManageTable data : businessActivityList) {
            if (StringUtil.isBlank((CharSequence)data.getEntrace())) continue;
            HashSet<String> tempErrorSet = new HashSet<String>();
            ActivityUtil.EntranceJoinEntity entranceJoinEntity = ActivityUtil.covertEntrance((String)data.getEntrace());
            if (!entranceJoinEntity.getRpcType().equals("0")) {
                dto.setIsHttp(Boolean.valueOf(false));
            }
            Map map = UrlUtil.convertUrl((ActivityUtil.EntranceJoinEntity)entranceJoinEntity);
            for (Map temp : voList) {
                ScriptUrlVO urlVO = (ScriptUrlVO)JsonHelper.json2Bean((String)JsonHelper.bean2Json((Object)temp), ScriptUrlVO.class);
                if (UrlUtil.checkEqual((String)((String)map.get("url")), (String)urlVO.getPath()).booleanValue() && urlVO.getEnable().booleanValue()) {
                    ++unbindCount;
                    tempErrorSet.clear();
                    if (!urlMap.containsKey(urlVO.getName())) {
                        urlMap.put(urlVO.getName(), 1);
                        break;
                    }
                    urlMap.put(urlVO.getName(), (Integer)urlMap.get(urlVO.getName()) + 1);
                    break;
                }
                tempErrorSet.add(data.getLinkName());
            }
            errorSet.addAll(tempErrorSet);
        }
        HashSet urlErrorSet = new HashSet();
        urlMap.forEach((k, v) -> {
            if (v > 1) {
                urlErrorSet.add("\u811a\u672c\u4e2d[" + k + "]\u91cd\u590d" + v + "\u6b21");
            }
        });
        if (urlErrorSet.size() > 0) {
            dto.setMatchActivity(Boolean.valueOf(false));
            dto.setErrmsg("\u811a\u672c\u6587\u4ef6\u914d\u7f6e\u4e0d\u6b63\u786e:" + ((Object)urlErrorSet).toString());
        }
        if (businessActivityList.size() > unbindCount) {
            dto.setMatchActivity(Boolean.valueOf(false));
            dto.setErrmsg("\u4e1a\u52a1\u6d3b\u52a8\u4e0e\u811a\u672c\u6587\u4ef6\u4e0d\u5339\u914d:" + ((Object)errorSet).toString());
        }
        return dto;
    }

    private List<BusinessLinkManageTable> getBusinessActivity(String refType, String refValue) {
        List sceneLinkRelates;
        if ("1".equals(refType)) {
            return this.tBusinessLinkManageTableMapper.selectBussinessLinkByIdList(Collections.singletonList(Long.valueOf(refValue)));
        }
        if ("2".equals(refType) && CollectionUtils.isNotEmpty((Collection)(sceneLinkRelates = this.tSceneLinkRelateMapper.selectBySceneId(Long.valueOf(refValue))))) {
            List businessActivityIds = sceneLinkRelates.stream().map(o -> Long.valueOf(o.getBusinessLinkId())).collect(Collectors.toList());
            return this.tBusinessLinkManageTableMapper.selectBussinessLinkByIdList(businessActivityIds);
        }
        return null;
    }

    @Transactional(rollbackFor={Throwable.class})
    public void updateScriptManage(ScriptManageDeployUpdateRequest scriptManageDeployUpdateRequest) {
        String scriptFileUrl;
        this.checkUpdateScriptManageParam(scriptManageDeployUpdateRequest);
        scriptManageDeployUpdateRequest.setName(scriptManageDeployUpdateRequest.getName().trim());
        List scriptFile = scriptManageDeployUpdateRequest.getFileManageUpdateRequests().stream().filter(o -> o.getIsDeleted() == 0 && FileTypeEnum.SCRIPT.getCode().equals(o.getFileType())).collect(Collectors.toList());
        ScriptManageExceptionUtil.isUpdateValidError((CollectionUtils.isEmpty(scriptFile) || scriptFile.size() != 1 ? 1 : 0) != 0, (String)"\u811a\u672c\u6587\u4ef6\u4e0d\u552f\u4e00!");
        this.uploadUpdateScriptFile(scriptFile);
        ScriptManageExceptionUtil.isUpdateValidError((CollectionUtils.isEmpty(scriptFile) || scriptFile.size() != 1 ? 1 : 0) != 0, (String)"\u811a\u672c\u6587\u4ef6\u4e0d\u552f\u4e00!");
        if (((FileManageUpdateRequest)scriptFile.get(0)).getId() == null) {
            scriptFileUrl = this.tmpFilePath + ((FileManageUpdateRequest)scriptFile.get(0)).getUploadId() + "/" + ((FileManageUpdateRequest)scriptFile.get(0)).getFileName();
        } else {
            List fileManageResults = this.fileManageDAO.selectFileManageByIds(Collections.singletonList(((FileManageUpdateRequest)scriptFile.get(0)).getId()));
            if (CollectionUtils.isEmpty((Collection)fileManageResults)) {
                log.error("\u5df2\u7ecf\u5b58\u5728\u7684\u6587\u4ef6\u4e22\u5931\uff0cfileId:{}", (Object)((FileManageUpdateRequest)scriptFile.get(0)).getId());
                throw ScriptManageExceptionUtil.getUpdateValidError((String)"\u670d\u52a1\u5668\u5df2\u7ecf\u5b58\u5728\u7684\u6587\u4ef6\u4e22\u5931");
            }
            scriptFileUrl = ((FileManageResult)fileManageResults.get(0)).getUploadPath();
        }
        ScriptCheckDTO scriptCheckDTO = this.checkAndUpdateScript(scriptManageDeployUpdateRequest.getRefType(), scriptManageDeployUpdateRequest.getRefValue(), scriptFileUrl);
        if (scriptCheckDTO != null && !StringUtil.isBlank((CharSequence)scriptCheckDTO.getErrmsg())) {
            throw ScriptManageExceptionUtil.getUpdateValidError((String)scriptCheckDTO.getErrmsg());
        }
        if (scriptCheckDTO != null && scriptCheckDTO.getIsHttp() != null && !scriptCheckDTO.getIsHttp().booleanValue()) {
            ScriptManageExceptionUtil.isCreateValidError((boolean)CollectionUtils.isEmpty((Collection)scriptManageDeployUpdateRequest.getPluginConfigUpdateRequests()), (String)"\u5b58\u5728\u4e0d\u662fhttp\u7684\u4e1a\u52a1\u6d3b\u52a8\uff0c\u4f46\u6ca1\u6709\u4f20\u63d2\u4ef6!");
        }
        ScriptManageDeployResult scriptManageDeployResult = this.updateScriptAndCreateScriptDeployAndGet(scriptManageDeployUpdateRequest);
        String targetScriptPath = this.getTargetScriptPath(scriptManageDeployUpdateRequest, scriptManageDeployResult);
        List addFileManageUpdateRequests = scriptManageDeployUpdateRequest.getFileManageUpdateRequests().stream().filter(o -> o.getIsDeleted() == 0).collect(Collectors.toList());
        List fileManageCreateParams = this.getFileManageCreateParamsByUpdateReq(addFileManageUpdateRequests, targetScriptPath);
        List fileIds = this.fileManageDAO.createFileManageList(fileManageCreateParams);
        Long scriptId = scriptManageDeployUpdateRequest.getId();
        this.updateCloudFileByScriptId(scriptId, scriptManageDeployResult.getType(), fileManageCreateParams);
        this.scriptFileRefDAO.createScriptFileRefs(fileIds, scriptManageDeployResult.getId());
    }

    private void updateCloudFileByScriptId(Long scriptId, Integer scriptType, List<FileManageCreateParam> files) {
        if (scriptId == null || CollectionUtils.isEmpty(files)) {
            return;
        }
        UpdateSceneFileRequest request = new UpdateSceneFileRequest();
        request.setScriptId(scriptId);
        request.setScriptType(scriptType);
        List uploadFiles = files.stream().map(file -> {
            UploadFileDTO uploadFileDTO = new UploadFileDTO();
            BeanUtils.copyProperties((Object)file, (Object)uploadFileDTO);
            uploadFileDTO.setIsDeleted(Integer.valueOf(0));
            String fileExtend = file.getFileExtend();
            if (StringUtils.isNotBlank((CharSequence)fileExtend)) {
                FileExtendVO fileExtendVO = (FileExtendVO)JSONUtil.toBean((String)fileExtend, FileExtendVO.class);
                uploadFileDTO.setIsSplit(fileExtendVO.getIsSplit());
            }
            uploadFileDTO.setUploadedData(Long.valueOf(0L));
            uploadFileDTO.setUploadTime(DateUtil.format((Date)file.getUploadTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            return uploadFileDTO;
        }).collect(Collectors.toList());
        request.setUploadFiles(uploadFiles);
        ResponseResult response = this.sceneManageApi.updateSceneFileByScriptId(request);
        if (!response.getSuccess().booleanValue()) {
            log.error("\u811a\u672c\u66f4\u65b0 --> \u5bf9\u5e94\u7684 cloud \u573a\u666f, \u811a\u672c\u6587\u4ef6\u66f4\u65b0\u5931\u8d25, \u9519\u8bef\u4fe1\u606f: {}", (Object)JSONUtil.toJsonStr((Object)response));
            throw ScriptManageExceptionUtil.getUpdateValidError((String)String.format("\u5bf9\u5e94\u7684 cloud \u811a\u672c\u66f4\u65b0\u5931\u8d25, \u9519\u8bef\u4fe1\u606f: %s", response.getError().getSolution()));
        }
    }

    private String getTargetScriptPath(ScriptManageDeployUpdateRequest scriptManageDeployUpdateRequest, ScriptManageDeployResult scriptManageDeployResult) {
        ArrayList sourcePaths = new ArrayList();
        String targetScriptPath = this.getTargetScriptPath(scriptManageDeployResult);
        List tmpFilePaths = scriptManageDeployUpdateRequest.getFileManageUpdateRequests().stream().filter(o -> o.getIsDeleted() == 0 && !StringUtil.isBlank((CharSequence)o.getUploadId())).map(o -> this.tmpFilePath + o.getUploadId() + "/" + o.getFileName()).collect(Collectors.toList());
        List existFileIds = scriptManageDeployUpdateRequest.getFileManageUpdateRequests().stream().filter(o -> o.getIsDeleted() == 0 && StringUtil.isBlank((CharSequence)o.getUploadId()) && o.getId() != null).map(FileManageUpdateRequest::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(existFileIds)) {
            List fileManageResults = this.fileManageDAO.selectFileManageByIds(existFileIds);
            List uploadPaths = fileManageResults.stream().map(FileManageResult::getUploadPath).collect(Collectors.toList());
            sourcePaths.addAll(uploadPaths);
        }
        if (CollectionUtils.isNotEmpty(tmpFilePaths)) {
            sourcePaths.addAll(tmpFilePaths);
        }
        this.fileApi.copyFile(targetScriptPath, sourcePaths);
        if (CollectionUtils.isNotEmpty(tmpFilePaths)) {
            this.fileApi.deleteFile(tmpFilePaths);
        }
        return targetScriptPath;
    }

    private ScriptManageDeployResult updateScriptAndCreateScriptDeployAndGet(ScriptManageDeployUpdateRequest scriptManageDeployUpdateRequest) {
        Long scriptDeployId = scriptManageDeployUpdateRequest.getId();
        ScriptManageDeployResult oldScriptManageDeployResult = this.scriptManageDAO.selectScriptManageDeployById(scriptDeployId);
        ScriptManageExceptionUtil.isUpdateValidError((oldScriptManageDeployResult == null ? 1 : 0) != 0, (String)"\u66f4\u65b0\u7684\u811a\u672c\u5b9e\u4f8b\u4e0d\u5b58\u5728!");
        Long scriptId = oldScriptManageDeployResult.getScriptId();
        ScriptManageResult scriptManageResult = this.scriptManageDAO.selectScriptManageById(scriptId);
        ScriptManageExceptionUtil.isUpdateValidError((scriptManageResult == null ? 1 : 0) != 0, (String)"\u66f4\u65b0\u7684\u811a\u672c\u5b9e\u4f8b\u5bf9\u5e94\u7684\u811a\u672c\u4e0d\u5b58\u5728!");
        ScriptManageDeployCreateParam scriptManageDeployCreateParam = new ScriptManageDeployCreateParam();
        BeanUtils.copyProperties((Object)scriptManageDeployUpdateRequest, (Object)scriptManageDeployCreateParam);
        scriptManageDeployCreateParam.setScriptId(scriptId);
        scriptManageDeployCreateParam.setStatus(ScriptManageDeployStatusEnum.NEW.getCode());
        int scriptNewVersion = scriptManageResult.getScriptVersion() + 1;
        scriptManageDeployCreateParam.setScriptVersion(Integer.valueOf(scriptNewVersion));
        this.scriptManageDAO.updateScriptVersion(scriptId, Integer.valueOf(scriptNewVersion));
        HashMap features = Maps.newHashMap();
        features.put("pluginConfig", scriptManageDeployUpdateRequest.getPluginConfigUpdateRequests());
        scriptManageDeployCreateParam.setFeature(JSON.toJSONString((Object)features));
        return this.scriptManageDAO.createScriptManageDeploy(scriptManageDeployCreateParam);
    }

    public List<ScriptManageSceneManageResponse> getAllScenes(String businessFlowName) {
        List<Object> scriptManageSceneManageResponses = new ArrayList<ScriptManageSceneManageResponse>();
        try {
            List businessFlowIdAndNameDtos = this.linkManageService.businessFlowIdFuzzSearch(businessFlowName);
            if (CollectionUtils.isNotEmpty((Collection)businessFlowIdAndNameDtos)) {
                scriptManageSceneManageResponses = businessFlowIdAndNameDtos.stream().map(businessFlowIdAndNameDto -> {
                    ScriptManageSceneManageResponse scriptManageSceneManageResponse = new ScriptManageSceneManageResponse();
                    scriptManageSceneManageResponse.setId(businessFlowIdAndNameDto.getId());
                    scriptManageSceneManageResponse.setSceneName(businessFlowIdAndNameDto.getBusinessFlowName());
                    return scriptManageSceneManageResponse;
                }).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u4e1a\u52a1\u6d41\u7a0b\u5f02\u5e38");
        }
        if (CollectionUtils.isNotEmpty(scriptManageSceneManageResponses)) {
            List systemProcessIds = scriptManageSceneManageResponses.stream().map(ScriptManageSceneManageResponse::getId).collect(Collectors.toList());
            ArrayList<Integer> status = new ArrayList<Integer>();
            status.add(0);
            status.add(1);
            List scriptManageDeployResults = this.scriptManageDAO.selectByRefIdsAndType(systemProcessIds, "2", status);
            if (CollectionUtils.isNotEmpty((Collection)scriptManageDeployResults)) {
                Map<String, List<ScriptManageDeployResult>> systemProcessScriptMap = scriptManageDeployResults.stream().collect(Collectors.groupingBy(ScriptManageDeployResult::getRefValue));
                scriptManageSceneManageResponses.forEach(scriptManageSceneManageResponse -> {
                    List scriptManageDeploys = (List)systemProcessScriptMap.get(scriptManageSceneManageResponse.getId());
                    scriptManageSceneManageResponse.setScriptManageDeployResponses(this.getScriptManageDeployResponses(scriptManageDeploys));
                });
            }
        }
        return scriptManageSceneManageResponses;
    }

    private List<ScriptManageDeployActivityResponse> getScriptManageDeployResponses(List<ScriptManageDeployResult> scriptManageDeployResults) {
        if (CollectionUtils.isNotEmpty(scriptManageDeployResults)) {
            ArrayList<ScriptManageDeployActivityResponse> scriptManageDeployActivityResponses = new ArrayList<ScriptManageDeployActivityResponse>();
            Map<Long, List<ScriptManageDeployResult>> collect = scriptManageDeployResults.stream().collect(Collectors.groupingBy(ScriptManageDeployResult::getScriptId));
            collect.forEach((k, v) -> {
                ScriptManageDeployResult scriptManageDeploy = v.stream().max(Comparator.comparing(ScriptManageDeployResult::getScriptVersion)).get();
                ScriptManageDeployActivityResponse scriptManageDeployActivityResponse = new ScriptManageDeployActivityResponse();
                scriptManageDeployActivityResponse.setId(scriptManageDeploy.getId());
                scriptManageDeployActivityResponse.setName(scriptManageDeploy.getName() + " \u7248\u672c" + scriptManageDeploy.getScriptVersion());
                scriptManageDeployActivityResponses.add(scriptManageDeployActivityResponse);
            });
            return scriptManageDeployActivityResponses;
        }
        return null;
    }

    public List<ScriptManageActivityResponse> listAllActivities(String activityName) {
        List businessActiveIdAndNameList = this.linkManageService.businessActiveNameFuzzSearch(activityName);
        if (CollectionUtils.isEmpty((Collection)businessActiveIdAndNameList)) {
            return Collections.emptyList();
        }
        List<ScriptManageActivityResponse> scriptManageActivityResponses = businessActiveIdAndNameList.stream().map(businessActiveIdAndNameDto -> {
            ScriptManageActivityResponse scriptManageActivityResponse = new ScriptManageActivityResponse();
            scriptManageActivityResponse.setId(businessActiveIdAndNameDto.getId());
            scriptManageActivityResponse.setBusinessActiveName(businessActiveIdAndNameDto.getBusinessActiveName());
            return scriptManageActivityResponse;
        }).collect(Collectors.toList());
        List activityIds = scriptManageActivityResponses.stream().map(ScriptManageActivityResponse::getId).collect(Collectors.toList());
        if (activityIds.isEmpty()) {
            return scriptManageActivityResponses;
        }
        List<Integer> scriptManageDeployStatusList = Arrays.asList(ScriptManageDeployStatusEnum.NEW.getCode(), ScriptManageDeployStatusEnum.PASS.getCode());
        List scriptManageDeployResults = this.scriptManageDAO.selectByRefIdsAndType(activityIds, "1", scriptManageDeployStatusList);
        if (CollectionUtils.isEmpty((Collection)scriptManageDeployResults)) {
            return scriptManageActivityResponses;
        }
        Map<String, List<ScriptManageDeployResult>> activityScriptMap = scriptManageDeployResults.stream().filter(scriptManageDeploy -> StringUtils.isNotBlank((CharSequence)scriptManageDeploy.getRefValue())).collect(Collectors.groupingBy(ScriptManageDeployResult::getRefValue));
        scriptManageActivityResponses.forEach(scriptManageActivityResponse -> {
            List scriptManageDeploys = (List)activityScriptMap.get(scriptManageActivityResponse.getId());
            scriptManageActivityResponse.setScriptManageDeployResponses(this.getScriptManageDeployResponses(scriptManageDeploys));
        });
        return scriptManageActivityResponses;
    }

    public String explainScriptFile(String scriptFileUploadPath) {
        Map data;
        SceneParseReq sceneParseReq = new SceneParseReq();
        sceneParseReq.setUploadPath(scriptFileUploadPath);
        sceneParseReq.setScriptId(Long.valueOf(1L));
        sceneParseReq.setAbsolutePath(true);
        ResponseResult mapResponseResult = this.sceneManageApi.parseScript(sceneParseReq);
        if (mapResponseResult != null && mapResponseResult.getData() != null && (data = (Map)mapResponseResult.getData()).get("xmlContent") != null) {
            return XmlHelper.formatXml((String)data.get("xmlContent").toString());
        }
        return "";
    }

    public String getFileDownLoadUrl(String filePath) {
        if (StringUtils.isBlank((CharSequence)filePath)) {
            return "";
        }
        String[] file = filePath.split("/");
        String fileName = file[file.length - 1];
        String url = null;
        try {
            url = this.fileUploadUrl + "/api/file/downloadFileByPath?filePath=" + URLEncoder.encode(filePath, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String[] cmds = new String[]{"curl", "-o", this.fileDir + "/" + fileName, "-OL", "-H", "licenseKey:" + RemoteConstant.LICENSE_VALUE, url};
        LinuxHelper.execCurl((String[])cmds);
        return this.fileDir + "/" + fileName;
    }

    public List<ScriptManageDeployResponse> listScriptDeployByScriptId(Long scriptId) {
        return TraceManageResponseConvertor.INSTANCE.ofListScriptManageDeployResponse(this.scriptManageDAO.selectScriptManageDeployByScriptId(scriptId));
    }

    public String rollbackScriptDeploy(Long scriptDeployId) {
        ScriptManageDeployResult scriptManageDeployResult = this.scriptManageDAO.selectScriptManageDeployById(scriptDeployId);
        ScriptManageResult scriptManageResult = this.scriptManageDAO.selectScriptManageById(scriptManageDeployResult.getScriptId());
        if (scriptManageDeployResult.getScriptVersion().equals(scriptManageResult.getScriptVersion())) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.SCRIPT_MANAGE_ROLLBACK_VALID_ERROR, (Object)"\u5f53\u524d\u811a\u672c\u5b9e\u4f8b\u5df2\u662f\u6700\u65b0\u7248\u672c\uff01");
        }
        List scriptFileRefResults = this.scriptFileRefDAO.selectFileIdsByScriptDeployId(scriptManageDeployResult.getId());
        if (CollectionUtils.isEmpty((Collection)scriptFileRefResults)) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.SCRIPT_MANAGE_ROLLBACK_VALID_ERROR, (Object)"\u8be5\u811a\u672c\u5b9e\u4f8b\u6ca1\u6709\u5173\u8054\u6587\u4ef6\uff01");
        }
        List scriptFileIds = scriptFileRefResults.stream().map(ScriptFileRefResult::getFileId).collect(Collectors.toList());
        List fileManageResults = this.fileManageDAO.selectFileManageByIds(scriptFileIds);
        ScriptManageDeployUpdateRequest scriptManageDeployUpdateRequest = this.getScriptManageDeployUpdateRequest(scriptManageDeployResult, fileManageResults);
        this.updateScriptManage(scriptManageDeployUpdateRequest);
        return scriptManageResult.getName();
    }

    public List<ScriptManageXmlContentResponse> getScriptManageDeployXmlContent(List<Long> scriptManageDeployIds) {
        ArrayList<ScriptManageXmlContentResponse> results = new ArrayList<ScriptManageXmlContentResponse>();
        List scriptFileRefResults = this.scriptFileRefDAO.selectFileIdsByScriptDeployIds(scriptManageDeployIds);
        if (CollectionUtils.isNotEmpty((Collection)scriptFileRefResults)) {
            Map<Long, List<ScriptFileRefResult>> collect = scriptFileRefResults.stream().collect(Collectors.groupingBy(ScriptFileRefResult::getScriptDeployId));
            collect.forEach((k, v) -> {
                ScriptManageXmlContentResponse scriptManageXmlContentResponse = new ScriptManageXmlContentResponse();
                scriptManageXmlContentResponse.setScriptManageDeployId(k);
                List fileIds = v.stream().map(ScriptFileRefResult::getFileId).collect(Collectors.toList());
                List fileManageResults = this.fileManageDAO.selectFileManageByIds(fileIds);
                List scriptFiles = fileManageResults.stream().filter(o -> o.getFileType() == 0).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(scriptFiles)) {
                    scriptManageXmlContentResponse.setContent(this.explainScriptFile(((FileManageResult)scriptFiles.get(0)).getUploadPath()));
                }
                results.add(scriptManageXmlContentResponse);
            });
        }
        return results;
    }

    private ScriptManageDeployUpdateRequest getScriptManageDeployUpdateRequest(ScriptManageDeployResult scriptManageDeployResult, List<FileManageResult> fileManageResults) {
        ScriptManageDeployUpdateRequest scriptManageDeployUpdateRequest = new ScriptManageDeployUpdateRequest();
        scriptManageDeployUpdateRequest.setId(scriptManageDeployResult.getId());
        scriptManageDeployUpdateRequest.setName(scriptManageDeployResult.getName());
        scriptManageDeployUpdateRequest.setRefType(scriptManageDeployResult.getRefType());
        scriptManageDeployUpdateRequest.setRefValue(scriptManageDeployResult.getRefValue());
        scriptManageDeployUpdateRequest.setType(scriptManageDeployResult.getType());
        ArrayList fileManageUpdateRequests = new ArrayList();
        fileManageResults.forEach(fileManageResult -> {
            FileManageUpdateRequest fileManageUpdateRequest = new FileManageUpdateRequest();
            fileManageUpdateRequest.setId(fileManageResult.getId());
            fileManageUpdateRequest.setFileName(fileManageResult.getFileName());
            fileManageUpdateRequest.setFileSize(fileManageResult.getFileSize());
            fileManageUpdateRequest.setFileType(fileManageResult.getFileType());
            if (fileManageResult.getFileExtend() != null) {
                Map stringObjectMap = JsonHelper.json2Map((String)fileManageResult.getFileExtend(), String.class, Object.class);
                if (stringObjectMap != null && stringObjectMap.get("dataCount") != null && !StringUtils.isBlank((CharSequence)stringObjectMap.get("dataCount").toString())) {
                    fileManageUpdateRequest.setDataCount(Long.valueOf(stringObjectMap.get("dataCount").toString()));
                }
                if (stringObjectMap != null && stringObjectMap.get("isSplit") != null && !StringUtils.isBlank((CharSequence)stringObjectMap.get("isSplit").toString())) {
                    fileManageUpdateRequest.setIsSplit(Integer.valueOf(stringObjectMap.get("isSplit").toString()));
                }
            }
            fileManageUpdateRequest.setIsDeleted(fileManageResult.getIsDeleted());
            fileManageUpdateRequest.setUploadTime(fileManageResult.getUploadTime());
            fileManageUpdateRequests.add(fileManageUpdateRequest);
        });
        scriptManageDeployUpdateRequest.setFileManageUpdateRequests(fileManageUpdateRequests);
        return scriptManageDeployUpdateRequest;
    }

    public List<SupportJmeterPluginNameResponse> getSupportJmeterPluginNameList(SupportJmeterPluginNameRequest nameRequest) {
        String refValue;
        List<Object> nameResponseList = Lists.newArrayList();
        String refType = nameRequest.getRelatedType();
        List businessActivityList = this.getBusinessActivity(refType, refValue = nameRequest.getRelatedId());
        if (CollectionUtils.isEmpty((Collection)businessActivityList)) {
            log.error("\u672a\u67e5\u8be2\u5230\u4e1a\u52a1\u6d3b\u52a8\u4fe1\u606f:[refType:{},refValue:{}]", (Object)refType, (Object)refValue);
            return nameResponseList;
        }
        List businessLinkIdList = businessActivityList.stream().map(BusinessLinkManageTable::getLinkId).collect(Collectors.toList());
        List businessLinkResultList = this.businessLinkManageDAO.getListByIds(businessLinkIdList);
        List techLinkIdList = businessLinkResultList.stream().map(BusinessLinkResult::getRelatedTechLink).map(Long::parseLong).collect(Collectors.toList());
        LinkManageQueryParam queryParam = new LinkManageQueryParam();
        queryParam.setLinkIdList(techLinkIdList);
        List linkManageResultList = this.linkManageDAO.selectList(queryParam);
        if (CollectionUtils.isEmpty((Collection)linkManageResultList)) {
            log.error("\u672a\u67e5\u8be2\u5230\u670d\u52a1\u4fe1\u606f:[techLinkIdList:{}]", (Object)JSON.toJSONString(techLinkIdList));
            return nameResponseList;
        }
        List typeList = linkManageResultList.stream().map(LinkManageResult::getFeatures).map(features -> (Map)JSON.parseObject((String)features, Map.class)).map(featuresObj -> featuresObj.get("serverMiddlewareType")).map(String::valueOf).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(typeList)) {
            log.error("\u672a\u67e5\u8be2\u5230\u7c7b\u578b\u4fe1\u606f:[techLinkIdList:{}]", (Object)JSON.toJSONString(techLinkIdList));
            return nameResponseList;
        }
        EnginePluginFetchWrapperReq fetchWrapperReq = new EnginePluginFetchWrapperReq();
        fetchWrapperReq.setPluginTypes(typeList);
        ResponseResult responseResult = this.sceneManageApi.listEnginePlugins(fetchWrapperReq);
        Map dataMap = (Map)responseResult.getData();
        if (Objects.isNull(responseResult) || dataMap.isEmpty()) {
            log.error("\u672a\u67e5\u8be2\u5230\u63d2\u4ef6\u4fe1\u606f:[typeList:{}]", (Object)JSON.toJSONString(typeList));
            return nameResponseList;
        }
        nameResponseList = typeList.stream().map(type -> {
            List pluginSimpleInfoResps;
            SupportJmeterPluginNameResponse nameResponse = new SupportJmeterPluginNameResponse();
            nameResponse.setType(type);
            type = type.toLowerCase();
            if (dataMap.containsKey(type) && CollectionUtils.isNotEmpty((Collection)(pluginSimpleInfoResps = (List)dataMap.get(type)))) {
                List singlePluginRenderResponseList = pluginSimpleInfoResps.stream().map(enginePluginSimpleInfoResp -> {
                    SinglePluginRenderResponse renderResponse = new SinglePluginRenderResponse();
                    renderResponse.setLabel(enginePluginSimpleInfoResp.getPluginName());
                    renderResponse.setValue(enginePluginSimpleInfoResp.getPluginId());
                    return renderResponse;
                }).collect(Collectors.toList());
                nameResponse.setSinglePluginRenderResponseList(singlePluginRenderResponseList);
            }
            return nameResponse;
        }).collect(Collectors.toList());
        return nameResponseList;
    }

    public SupportJmeterPluginVersionResponse getSupportJmeterPluginVersionList(SupportJmeterPluginVersionRequest versionRequest) {
        Long pluginId = versionRequest.getPluginId();
        EnginePluginDetailsWrapperReq wrapperReq = new EnginePluginDetailsWrapperReq();
        wrapperReq.setPluginId(pluginId);
        ResponseResult responseResult = this.sceneManageApi.getEnginePluginDetails(wrapperReq);
        EnginePluginDetailResp detailResp = (EnginePluginDetailResp)responseResult.getData();
        if (!Objects.isNull(detailResp)) {
            SupportJmeterPluginVersionResponse versionResponse = new SupportJmeterPluginVersionResponse();
            versionResponse.setVersionList(detailResp.getSupportedVersions());
            return versionResponse;
        }
        return null;
    }

    private List<FileManageCreateParam> getFileManageCreateParamsByUpdateReq(List<FileManageUpdateRequest> fileManageUpdateRequests, String targetScriptPath) {
        return fileManageUpdateRequests.stream().map(fileManageUpdateRequest -> {
            FileManageCreateParam fileManageCreateParam = new FileManageCreateParam();
            fileManageCreateParam.setFileName(fileManageUpdateRequest.getFileName());
            fileManageCreateParam.setFileSize(fileManageUpdateRequest.getFileSize());
            fileManageCreateParam.setFileType(fileManageUpdateRequest.getFileType());
            HashMap<String, Number> fileExtend = new HashMap<String, Number>();
            fileExtend.put("dataCount", fileManageUpdateRequest.getDataCount());
            fileExtend.put("isSplit", fileManageUpdateRequest.getIsSplit());
            fileManageCreateParam.setCustomerId(RestContext.getUser().getCustomerId());
            fileManageCreateParam.setFileExtend(JsonHelper.bean2Json(fileExtend));
            fileManageCreateParam.setUploadPath(targetScriptPath + fileManageUpdateRequest.getFileName());
            fileManageCreateParam.setUploadTime(fileManageUpdateRequest.getUploadTime());
            return fileManageCreateParam;
        }).collect(Collectors.toList());
    }

    private List<FileManageCreateParam> getFileManageCreateParams(List<FileManageCreateRequest> fileManageCreateRequests, String targetScriptPath) {
        return fileManageCreateRequests.stream().map(fileManageCreateRequest -> {
            FileManageCreateParam fileManageCreateParam = new FileManageCreateParam();
            fileManageCreateParam.setFileName(fileManageCreateRequest.getFileName());
            fileManageCreateParam.setFileSize(fileManageCreateRequest.getFileSize());
            fileManageCreateParam.setFileType(fileManageCreateRequest.getFileType());
            HashMap<String, Number> fileExtend = new HashMap<String, Number>();
            fileExtend.put("dataCount", fileManageCreateRequest.getDataCount());
            fileExtend.put("isSplit", fileManageCreateRequest.getIsSplit());
            fileManageCreateParam.setFileExtend(JsonHelper.bean2Json(fileExtend));
            fileManageCreateParam.setCustomerId(RestContext.getUser().getCustomerId());
            fileManageCreateParam.setUploadPath(targetScriptPath + fileManageCreateRequest.getFileName());
            fileManageCreateParam.setUploadTime(fileManageCreateRequest.getUploadTime());
            return fileManageCreateParam;
        }).collect(Collectors.toList());
    }

    public PagingList<ScriptManageDeployResponse> pageQueryScriptManage(ScriptManageDeployPageQueryRequest scriptManageDeployPageQueryRequest) {
        PagingList scriptManageDeployResults;
        ScriptManageDeployPageQueryParam scriptManageDeployPageQueryParam = new ScriptManageDeployPageQueryParam();
        if (scriptManageDeployPageQueryRequest != null) {
            BeanUtils.copyProperties((Object)scriptManageDeployPageQueryRequest, (Object)scriptManageDeployPageQueryParam);
            if (!StringUtil.isBlank((CharSequence)scriptManageDeployPageQueryRequest.getBusinessActivityId())) {
                scriptManageDeployPageQueryParam.setRefType("1");
                scriptManageDeployPageQueryParam.setRefValue(scriptManageDeployPageQueryRequest.getBusinessActivityId());
            }
            if (!StringUtil.isBlank((CharSequence)scriptManageDeployPageQueryRequest.getBusinessFlowId())) {
                scriptManageDeployPageQueryParam.setRefType("2");
                scriptManageDeployPageQueryParam.setRefValue(scriptManageDeployPageQueryRequest.getBusinessFlowId());
            }
            if (!StringUtil.isBlank((CharSequence)scriptManageDeployPageQueryRequest.getBusinessActivityId()) && !StringUtil.isBlank((CharSequence)scriptManageDeployPageQueryRequest.getBusinessFlowId())) {
                return PagingList.empty();
            }
            if (!CollectionUtils.isEmpty((Collection)scriptManageDeployPageQueryRequest.getTagIds())) {
                List scriptTagRefResults = this.scriptTagRefDAO.selectScriptTagRefByTagIds(scriptManageDeployPageQueryRequest.getTagIds());
                if (CollectionUtils.isEmpty((Collection)scriptTagRefResults)) {
                    return PagingList.empty();
                }
                Map<Long, List<ScriptTagRefResult>> scriptTagRefMap = scriptTagRefResults.stream().collect(Collectors.groupingBy(ScriptTagRefResult::getScriptId));
                ArrayList<Long> scriptIds = new ArrayList<Long>();
                for (Map.Entry<Long, List<ScriptTagRefResult>> entry : scriptTagRefMap.entrySet()) {
                    if (entry.getValue().size() != scriptManageDeployPageQueryRequest.getTagIds().size()) continue;
                    scriptIds.add(entry.getKey());
                }
                if (CollectionUtils.isEmpty(scriptIds)) {
                    return PagingList.empty();
                }
                scriptManageDeployPageQueryParam.setScriptIds(scriptIds);
            }
        }
        scriptManageDeployPageQueryParam.setCurrent(scriptManageDeployPageQueryRequest.getCurrent());
        scriptManageDeployPageQueryParam.setPageSize(Integer.valueOf(scriptManageDeployPageQueryRequest.getPageSize()));
        scriptManageDeployPageQueryParam.setScriptType(Integer.valueOf(0));
        List userIdList = RestContext.getQueryAllowUserIdList();
        if (CollectionUtils.isNotEmpty((Collection)userIdList)) {
            scriptManageDeployPageQueryParam.setUserIdList(userIdList);
        }
        if ((scriptManageDeployResults = this.scriptManageDAO.pageQueryRecentScriptManageDeploy(scriptManageDeployPageQueryParam)).isEmpty()) {
            return PagingList.empty();
        }
        Map numMaps = this.scriptManageDAO.selectScriptDeployNumResult();
        List userIds = scriptManageDeployResults.getList().stream().filter(data -> null != data.getUserId()).map(ScriptManageDeployResult::getUserId).collect(Collectors.toList());
        Map userMap = this.userService.getUserMapByIds(userIds);
        List allowUpdateUserIdList = RestContext.getUpdateAllowUserIdList();
        List allowDeleteUserIdList = RestContext.getDeleteAllowUserIdList();
        List allowDownloadUserIdList = RestContext.getDownloadAllowUserIdList();
        List scriptManageDeployResponses = scriptManageDeployResults.getList().stream().map(scriptManageDeployResult -> {
            ScriptManageDeployResponse response = new ScriptManageDeployResponse();
            BeanUtils.copyProperties((Object)scriptManageDeployResult, (Object)response);
            if (numMaps.get(response.getScriptId()) != null && (Long)numMaps.get(response.getScriptId()) > 1L) {
                response.setOnlyOne(Boolean.valueOf(false));
            }
            if (CollectionUtils.isNotEmpty((Collection)allowUpdateUserIdList)) {
                response.setCanEdit(Boolean.valueOf(allowUpdateUserIdList.contains(scriptManageDeployResult.getUserId())));
            }
            if (CollectionUtils.isNotEmpty((Collection)allowDeleteUserIdList)) {
                response.setCanRemove(Boolean.valueOf(allowDeleteUserIdList.contains(scriptManageDeployResult.getUserId())));
            }
            if (CollectionUtils.isNotEmpty((Collection)allowDownloadUserIdList)) {
                response.setCanDownload(Boolean.valueOf(allowDownloadUserIdList.contains(scriptManageDeployResult.getUserId())));
            }
            response.setManagerId(scriptManageDeployResult.getUserId());
            String userName = Optional.ofNullable(userMap.get(scriptManageDeployResult.getUserId())).map(u -> u.getName()).orElse("");
            response.setManagerName(userName);
            return response;
        }).collect(Collectors.toList());
        this.setFileList(scriptManageDeployResponses);
        this.setTagList(scriptManageDeployResponses);
        this.setRefName(scriptManageDeployResponses, scriptManageDeployResults);
        return PagingList.of(scriptManageDeployResponses, (long)scriptManageDeployResults.getTotal());
    }

    private void setTagList(List<ScriptManageDeployResponse> scriptManageDeployResponses) {
        if (scriptManageDeployResponses == null || CollectionUtils.isEmpty(scriptManageDeployResponses)) {
            return;
        }
        List scriptIds = scriptManageDeployResponses.stream().map(ScriptManageDeployResponse::getScriptId).collect(Collectors.toList());
        List scriptTagRefResults = this.scriptTagRefDAO.selectScriptTagRefByScriptIds(scriptIds);
        if (CollectionUtils.isEmpty((Collection)scriptTagRefResults)) {
            return;
        }
        List tagIds = scriptTagRefResults.stream().map(ScriptTagRefResult::getTagId).collect(Collectors.toList());
        List tagManageResults = this.tagManageDAO.selectScriptTagsByIds(tagIds);
        if (CollectionUtils.isEmpty((Collection)tagManageResults)) {
            return;
        }
        Map<Long, List<ScriptTagRefResult>> scriptTagRefMap = scriptTagRefResults.stream().collect(Collectors.groupingBy(ScriptTagRefResult::getScriptId));
        List tagManageResponses = tagManageResults.stream().map(tagManageResult -> {
            TagManageResponse tagManageResponse = new TagManageResponse();
            tagManageResponse.setId(tagManageResult.getId());
            tagManageResponse.setTagName(tagManageResult.getTagName());
            return tagManageResponse;
        }).collect(Collectors.toList());
        Map<Long, TagManageResponse> tagManageResponseMap = tagManageResponses.stream().collect(Collectors.toMap(TagManageResponse::getId, a -> a, (k1, k2) -> k1));
        scriptManageDeployResponses.forEach(scriptManageDeployResponse -> {
            List scriptTagRefList = (List)scriptTagRefMap.get(scriptManageDeployResponse.getScriptId());
            if (CollectionUtils.isEmpty((Collection)scriptTagRefList)) {
                return;
            }
            List resultTagManageResponses = scriptTagRefList.stream().map(scriptTagRefResult -> (TagManageResponse)tagManageResponseMap.get(scriptTagRefResult.getTagId())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(resultTagManageResponses)) {
                return;
            }
            scriptManageDeployResponse.setTagManageResponses(resultTagManageResponses);
        });
    }

    private void setFileList(List<ScriptManageDeployResponse> scriptManageDeployResponses) {
        if (scriptManageDeployResponses == null || CollectionUtils.isEmpty(scriptManageDeployResponses)) {
            return;
        }
        List scriptDeployIds = scriptManageDeployResponses.stream().map(ScriptManageDeployResponse::getId).collect(Collectors.toList());
        List scriptFileRefResults = this.scriptFileRefDAO.selectFileIdsByScriptDeployIds(scriptDeployIds);
        if (CollectionUtils.isEmpty((Collection)scriptFileRefResults)) {
            return;
        }
        List fileIdList = scriptFileRefResults.stream().map(ScriptFileRefResult::getFileId).collect(Collectors.toList());
        List fileManageResponses = this.getFileManageResponseByFileIds(fileIdList);
        if (CollectionUtils.isEmpty((Collection)fileManageResponses)) {
            return;
        }
        Map<Long, List<ScriptFileRefResult>> scriptFileRefMap = scriptFileRefResults.stream().collect(Collectors.groupingBy(ScriptFileRefResult::getScriptDeployId));
        Map<Long, FileManageResponse> fileManageResultMap = fileManageResponses.stream().collect(Collectors.toMap(FileManageResponse::getId, a -> a, (k1, k2) -> k1));
        scriptManageDeployResponses.forEach(scriptManageDeployResponse -> {
            List scriptFileRefList = (List)scriptFileRefMap.get(scriptManageDeployResponse.getId());
            if (CollectionUtils.isEmpty((Collection)scriptFileRefList)) {
                return;
            }
            List resultFileManageResponses = scriptFileRefList.stream().map(scriptFileRefResult -> (FileManageResponse)fileManageResultMap.get(scriptFileRefResult.getFileId())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(resultFileManageResponses)) {
                return;
            }
            scriptManageDeployResponse.setFileManageResponseList(resultFileManageResponses);
        });
    }

    public void deleteScriptManage(Long scriptDeployId) {
        ScriptManageDeployResult scriptManageDeployResult = this.scriptManageDAO.selectScriptManageDeployById(scriptDeployId);
        if (scriptManageDeployResult == null) {
            return;
        }
        ResponseResult sceneManageList = this.sceneManageApi.getSceneManageList();
        if (sceneManageList == null || !sceneManageList.getSuccess().booleanValue()) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.SCRIPT_MANAGE_DELETE_VALID_ERROR, (Object)("\u67e5\u8be2\u573a\u666f\u5217\u8868\u5931\u8d25\uff01" + sceneManageList.getError().getMsg()));
        }
        List existScriptManageDeployResults = this.scriptManageDAO.selectScriptManageDeployByScriptId(scriptManageDeployResult.getScriptId());
        Map<Long, ScriptManageDeployResult> existScriptManageDeployResultMap = existScriptManageDeployResults.stream().collect(Collectors.toMap(ScriptManageDeployResult::getId, o -> o, (k1, k2) -> k1));
        StringBuilder sb = new StringBuilder();
        if (CollectionUtils.isNotEmpty((Collection)((Collection)sceneManageList.getData()))) {
            for (SceneManageListResp sceneManageListResp : (List)sceneManageList.getData()) {
                Map featuresMap;
                if (StringUtil.isBlank((CharSequence)sceneManageListResp.getFeatures()) || (featuresMap = JsonHelper.json2Map((String)sceneManageListResp.getFeatures(), String.class, Object.class)).get("scriptId") == null || existScriptManageDeployResultMap.get(Long.valueOf(featuresMap.get("scriptId").toString())) == null) continue;
                sb.append(sceneManageListResp.getSceneName()).append("\u3001");
            }
        }
        if (!StringUtil.isBlank((CharSequence)sb.toString())) {
            sb.deleteCharAt(sb.lastIndexOf("\u3001"));
            throw new TroWebException((ExceptionReadable)ExceptionCode.SCRIPT_MANAGE_DELETE_VALID_ERROR, (Object)("\u8be5\u811a\u672c\u88ab\u4ee5\u4e0b\u573a\u666f\u5f15\u7528\uff0c\u8bf7\u53d6\u6d88\u5f15\u7528\u540e\u518d\u5220\u9664:" + sb.toString()));
        }
        this.scriptManageDAO.deleteScriptManageAndDeploy(scriptManageDeployResult.getScriptId());
        List existScriptManageDeployIds = existScriptManageDeployResults.stream().map(ScriptManageDeployResult::getId).collect(Collectors.toList());
        List scriptFileRefResults = this.scriptFileRefDAO.selectFileIdsByScriptDeployIds(existScriptManageDeployIds);
        if (CollectionUtils.isNotEmpty((Collection)scriptFileRefResults)) {
            List scriptFileRefIds = scriptFileRefResults.stream().map(ScriptFileRefResult::getId).collect(Collectors.toList());
            this.scriptFileRefDAO.deleteByIds(scriptFileRefIds);
            List fileIds = scriptFileRefResults.stream().map(ScriptFileRefResult::getFileId).collect(Collectors.toList());
            List fileManageResults = this.fileManageDAO.selectFileManageByIds(fileIds);
            List filePaths = fileManageResults.stream().map(FileManageResult::getUploadPath).collect(Collectors.toList());
            this.fileApi.deleteFile(filePaths);
            this.fileManageDAO.deleteByIds(fileIds);
        }
        this.scriptTagRefDAO.deleteByScriptId(scriptManageDeployResult.getScriptId());
    }

    public void createScriptTagRef(ScriptTagCreateRefRequest scriptTagCreateRefRequest) {
        if (scriptTagCreateRefRequest == null || scriptTagCreateRefRequest.getScriptDeployId() == null) {
            return;
        }
        if (scriptTagCreateRefRequest.getTagNames().size() > 10) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.SCRIPT_MANAGE_TAG_ADD_VALID_ERROR, (Object)"\u6bcf\u4e2a\u811a\u672c\u5173\u8054\u6807\u7b7e\u6570\u4e0d\u80fd\u8d85\u8fc710");
        }
        List collect = scriptTagCreateRefRequest.getTagNames().stream().filter(o -> o.length() > 10).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect)) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.SCRIPT_MANAGE_TAG_ADD_VALID_ERROR, (Object)"\u5b58\u5728\u811a\u672c\u540d\u79f0\u957f\u5ea6\u8d85\u8fc710");
        }
        ScriptManageDeployResult scriptManageDeployResult = this.scriptManageDAO.selectScriptManageDeployById(scriptTagCreateRefRequest.getScriptDeployId());
        if (scriptManageDeployResult != null) {
            this.scriptTagRefDAO.deleteByScriptId(scriptManageDeployResult.getScriptId());
            if (CollectionUtils.isNotEmpty((Collection)scriptTagCreateRefRequest.getTagNames())) {
                List tagManageParams = scriptTagCreateRefRequest.getTagNames().stream().distinct().map(tagName -> {
                    TagManageParam tagManageParam = new TagManageParam();
                    tagManageParam.setTagName(tagName);
                    tagManageParam.setTagStatus(Integer.valueOf(0));
                    tagManageParam.setTagType(Integer.valueOf(0));
                    return tagManageParam;
                }).collect(Collectors.toList());
                List tagIds = this.tagManageDAO.addScriptTags(tagManageParams, Integer.valueOf(0));
                this.scriptTagRefDAO.addScriptTagRef(tagIds, scriptManageDeployResult.getScriptId());
            }
        }
    }

    public List<TagManageResponse> queryScriptTagList() {
        List tagManageResults = this.tagManageDAO.selectAllScript();
        if (CollectionUtils.isNotEmpty((Collection)tagManageResults)) {
            return tagManageResults.stream().map(tagManageResult -> {
                TagManageResponse tagManageResponse = new TagManageResponse();
                tagManageResponse.setId(tagManageResult.getId());
                tagManageResponse.setTagName(tagManageResult.getTagName());
                return tagManageResponse;
            }).collect(Collectors.toList());
        }
        return new ArrayList<TagManageResponse>();
    }

    public ScriptManageDeployDetailResponse getScriptManageDeployDetail(Long scriptDeployId) {
        ScriptManageDeployDetailResponse result = new ScriptManageDeployDetailResponse();
        ScriptManageDeployResult scriptManageDeployResult = this.scriptManageDAO.selectScriptManageDeployById(scriptDeployId);
        if (scriptManageDeployResult == null) {
            return null;
        }
        BeanUtils.copyProperties((Object)scriptManageDeployResult, (Object)result);
        this.setRefName(result, scriptManageDeployResult);
        this.setFileList(result);
        this.setFeatures(result, scriptManageDeployResult.getFeature());
        return result;
    }

    private void setRefName(List<ScriptManageDeployResponse> scriptManageDeployResponses, PagingList<ScriptManageDeployResult> scriptManageDeployResults) {
        if (scriptManageDeployResults == null || CollectionUtils.isEmpty((Collection)scriptManageDeployResults.getList()) || CollectionUtils.isEmpty(scriptManageDeployResponses)) {
            return;
        }
        Map<String, List<ScriptManageDeployResult>> refTypeMap = scriptManageDeployResults.getList().stream().filter(item -> item.getRefType() != null).collect(Collectors.groupingBy(ScriptManageDeployResult::getRefType));
        if (refTypeMap == null || refTypeMap.size() <= 0) {
            return;
        }
        Map<Long, ScriptManageDeployResult> longScriptManageDeployResultMap = scriptManageDeployResults.getList().stream().collect(Collectors.toMap(ScriptManageDeployResult::getId, a -> a, (k1, k2) -> k1));
        Map<Object, Object> businessFlowMap = new HashMap();
        Map<Object, Object> businessActivityMap = new HashMap();
        for (Map.Entry<String, List<ScriptManageDeployResult>> entry : refTypeMap.entrySet()) {
            List businessActivityIds;
            List businessLinkManageTables;
            List businessFlowIds;
            List scenes;
            if ("2".equals(entry.getKey()) && CollectionUtils.isNotEmpty((Collection)(scenes = this.tSceneMapper.selectBusinessFlowNameByIds(businessFlowIds = entry.getValue().stream().map(scriptManageDeployResult -> Long.parseLong(scriptManageDeployResult.getRefValue())).collect(Collectors.toList()))))) {
                businessFlowMap = scenes.stream().collect(Collectors.toMap(Scene::getId, a -> a, (k1, k2) -> k1));
            }
            if (!"1".equals(entry.getKey()) || !CollectionUtils.isNotEmpty((Collection)(businessLinkManageTables = this.tBusinessLinkManageTableMapper.selectBussinessLinkByIdList(businessActivityIds = entry.getValue().stream().map(scriptManageDeployResult -> Long.parseLong(scriptManageDeployResult.getRefValue())).collect(Collectors.toList()))))) continue;
            businessActivityMap = businessLinkManageTables.stream().collect(Collectors.toMap(BusinessLinkManageTable::getLinkId, a -> a, (k1, k2) -> k1));
        }
        HashMap finalBusinessFlowMap = businessFlowMap;
        HashMap finalBusinessActivityMap = businessActivityMap;
        scriptManageDeployResponses.forEach(scriptManageDeployResponse -> {
            BusinessLinkManageTable businessLinkManageTable;
            Scene scene;
            ScriptManageDeployResult scriptManageDeployResult = (ScriptManageDeployResult)longScriptManageDeployResultMap.get(scriptManageDeployResponse.getId());
            if ("2".equals(scriptManageDeployResponse.getRefType()) && (scene = (Scene)finalBusinessFlowMap.get(Long.parseLong(scriptManageDeployResult.getRefValue()))) != null) {
                scriptManageDeployResponse.setRefName(scene.getSceneName());
            }
            if ("1".equals(scriptManageDeployResponse.getRefType()) && (businessLinkManageTable = (BusinessLinkManageTable)finalBusinessActivityMap.get(Long.parseLong(scriptManageDeployResult.getRefValue()))) != null) {
                scriptManageDeployResponse.setRefName(businessLinkManageTable.getLinkName());
            }
        });
    }

    private void setFileList(ScriptManageDeployDetailResponse result) {
        if (result == null || result.getId() == null) {
            return;
        }
        List scriptFileRefResults = this.scriptFileRefDAO.selectFileIdsByScriptDeployId(result.getId());
        if (CollectionUtils.isEmpty((Collection)scriptFileRefResults)) {
            log.info("\u4e0d\u5b58\u5728\u5173\u8054\u7684\u6587\u4ef6id");
            return;
        }
        List fileIds = scriptFileRefResults.stream().map(ScriptFileRefResult::getFileId).collect(Collectors.toList());
        List totalFileList = this.getFileManageResponseByFileIds(fileIds);
        if (CollectionUtils.isNotEmpty((Collection)totalFileList)) {
            List fileManageResponseList = totalFileList.stream().filter(f -> f.getFileType().equals(FileTypeEnum.SCRIPT.getCode()) || f.getFileType().equals(FileTypeEnum.DATA.getCode())).collect(Collectors.toList());
            List attachmentManageResponseList = totalFileList.stream().filter(f -> f.getFileType().equals(FileTypeEnum.ATTACHMENT.getCode())).collect(Collectors.toList());
            result.setFileManageResponseList(fileManageResponseList);
            result.setAttachmentManageResponseList(attachmentManageResponseList);
        }
    }

    private void setFeatures(ScriptManageDeployDetailResponse result, String feature) {
        Map featureMap;
        if (StringUtils.isNotBlank((CharSequence)feature) && (featureMap = (Map)JSON.parseObject((String)feature, Map.class)).containsKey("pluginConfig")) {
            String pluginConfigContent = JSON.toJSONString(featureMap.get("pluginConfig"));
            List pluginConfigDetailResponseList = JSON.parseArray((String)pluginConfigContent, PluginConfigDetailResponse.class);
            result.setPluginConfigDetailResponseList(pluginConfigDetailResponseList);
        }
    }

    private List<FileManageResponse> getFileManageResponseByFileIds(List<Long> fileIds) {
        List fileManageResults = this.fileManageDAO.selectFileManageByIds(fileIds);
        ArrayList<FileManageResponse> fileManageResponses = new ArrayList<FileManageResponse>();
        if (CollectionUtils.isNotEmpty((Collection)fileManageResults)) {
            for (FileManageResult fileManageResult : fileManageResults) {
                FileManageResponse fileManageResponse = new FileManageResponse();
                BeanUtils.copyProperties((Object)fileManageResult, (Object)fileManageResponse);
                if (StringUtils.isNotEmpty((CharSequence)fileManageResult.getFileExtend())) {
                    Map stringObjectMap = JsonHelper.json2Map((String)fileManageResult.getFileExtend(), String.class, Object.class);
                    if (stringObjectMap != null && stringObjectMap.get("dataCount") != null && !StringUtil.isBlank((CharSequence)stringObjectMap.get("dataCount").toString())) {
                        fileManageResponse.setDataCount(Long.valueOf(stringObjectMap.get("dataCount").toString()));
                    }
                    if (stringObjectMap != null && stringObjectMap.get("isSplit") != null && !StringUtil.isBlank((CharSequence)stringObjectMap.get("isSplit").toString())) {
                        fileManageResponse.setIsSplit(Integer.valueOf(stringObjectMap.get("isSplit").toString()));
                    }
                }
                String uploadUrl = fileManageResult.getUploadPath();
                fileManageResponse.setUploadPath(uploadUrl);
                fileManageResponses.add(fileManageResponse);
            }
            return fileManageResponses;
        }
        return null;
    }

    private void setRefName(ScriptManageDeployDetailResponse result, ScriptManageDeployResult scriptManageDeployResult) {
        List businessLinkManageTables;
        long businessId;
        List scenes;
        if (StringUtils.isEmpty((CharSequence)scriptManageDeployResult.getRefValue())) {
            return;
        }
        if ("2".equals(scriptManageDeployResult.getRefType()) && CollectionUtils.isNotEmpty((Collection)(scenes = this.tSceneMapper.selectBusinessFlowNameByIds(Collections.singletonList(businessId = Long.parseLong(scriptManageDeployResult.getRefValue())))))) {
            result.setRefName(((Scene)scenes.get(0)).getSceneName());
        }
        if ("1".equals(scriptManageDeployResult.getRefType()) && CollectionUtils.isNotEmpty((Collection)(businessLinkManageTables = this.tBusinessLinkManageTableMapper.selectBussinessLinkByIdList(Collections.singletonList(businessId = Long.parseLong(scriptManageDeployResult.getRefValue())))))) {
            result.setRefName(((BusinessLinkManageTable)businessLinkManageTables.get(0)).getLinkName());
        }
    }

    private void checkCreateScriptManageParam(ScriptManageDeployCreateRequest scriptManageDeployCreateRequest) {
        if (scriptManageDeployCreateRequest == null) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.SCRIPT_MANAGE_CREATE_PARAM_VALID_ERROR, (Object)"\u5165\u53c2\u4e3a\u7a7a\uff01");
        }
        if (StringUtil.isBlank((CharSequence)scriptManageDeployCreateRequest.getName())) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.SCRIPT_MANAGE_CREATE_PARAM_VALID_ERROR, (Object)"\u811a\u672c\u540d\u79f0\u4e3a\u7a7a\uff01");
        }
        if (StringUtil.isBlank((CharSequence)scriptManageDeployCreateRequest.getRefType())) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.SCRIPT_MANAGE_CREATE_PARAM_VALID_ERROR, (Object)"\u811a\u672c\u5173\u8054\u7c7b\u578b\u4e3a\u7a7a\uff01");
        }
        if (StringUtil.isBlank((CharSequence)scriptManageDeployCreateRequest.getRefValue())) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.SCRIPT_MANAGE_CREATE_PARAM_VALID_ERROR, (Object)"\u811a\u672c\u5173\u8054\u503c\u4e3a\u7a7a\uff01");
        }
        if (scriptManageDeployCreateRequest.getType() == null) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.SCRIPT_MANAGE_CREATE_PARAM_VALID_ERROR, (Object)"\u811a\u672c\u7c7b\u578b\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)scriptManageDeployCreateRequest.getFileManageCreateRequests())) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.SCRIPT_MANAGE_CREATE_PARAM_VALID_ERROR, (Object)"\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\uff01");
        }
        boolean existJmx = false;
        for (FileManageCreateRequest fileManageCreateRequest : scriptManageDeployCreateRequest.getFileManageCreateRequests()) {
            if (StringUtil.isBlank((CharSequence)fileManageCreateRequest.getFileName())) {
                throw new TroWebException((ExceptionReadable)ExceptionCode.SCRIPT_MANAGE_CREATE_PARAM_VALID_ERROR, (Object)"\u6587\u4ef6\u5217\u8868\u4e2d\u5b58\u5728\u6587\u4ef6\u540d\u4e3a\u7a7a\uff01");
            }
            if (fileManageCreateRequest.getFileName().length() > 64) {
                throw new TroWebException((ExceptionReadable)ExceptionCode.SCRIPT_MANAGE_CREATE_PARAM_VALID_ERROR, (Object)"\u6587\u4ef6\u5217\u8868\u4e2d\u5b58\u5728\u6587\u4ef6\u540d\u957f\u5ea6\u5927\u4e8e64\uff01");
            }
            if (fileManageCreateRequest.getFileType() == null) {
                throw new TroWebException((ExceptionReadable)ExceptionCode.SCRIPT_MANAGE_CREATE_PARAM_VALID_ERROR, (Object)("\u6587\u4ef6\u5217\u8868\u4e2d\u5b58\u5728\u6587\u4ef6\u7c7b\u578b\u4e3a\u7a7a\uff01fileName=" + fileManageCreateRequest.getFileName()));
            }
            if (fileManageCreateRequest.getFileName().contains(" ")) {
                throw new TroWebException((ExceptionReadable)ExceptionCode.SCRIPT_MANAGE_CREATE_PARAM_VALID_ERROR, (Object)"\u6587\u4ef6\u540d\u5305\u542b\u7a7a\u683c\uff01");
            }
            if (fileManageCreateRequest.getFileType() == 0 && fileManageCreateRequest.getIsDeleted() == 0) {
                existJmx = true;
            }
            fileManageCreateRequest.setFileName(FileUtil.replaceFileName((String)fileManageCreateRequest.getFileName()));
        }
        if (!existJmx) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.SCRIPT_MANAGE_CREATE_PARAM_VALID_ERROR, (Object)"\u6587\u4ef6\u5217\u8868\u4e2d\u4e0d\u5b58\u5728\u811a\u672c\u6587\u4ef6\uff01");
        }
    }

    private void checkUpdateScriptManageParam(ScriptManageDeployUpdateRequest scriptManageDeployUpdateRequest) {
        ScriptManageExceptionUtil.isUpdateValidError((scriptManageDeployUpdateRequest == null ? 1 : 0) != 0, (String)"\u5165\u53c2\u4e3a\u7a7a!");
        ScriptManageExceptionUtil.isUpdateValidError((scriptManageDeployUpdateRequest.getId() == null ? 1 : 0) != 0, (String)"\u811a\u672cid\u4e3a\u7a7a!");
        ScriptManageExceptionUtil.isUpdateValidError((boolean)StringUtil.isBlank((CharSequence)scriptManageDeployUpdateRequest.getName()), (String)"\u811a\u672c\u540d\u79f0\u4e3a\u7a7a!");
        ScriptManageExceptionUtil.isUpdateValidError((boolean)StringUtil.isBlank((CharSequence)scriptManageDeployUpdateRequest.getRefType()), (String)"\u811a\u672c\u5173\u8054\u7c7b\u578b\u4e3a\u7a7a!");
        ScriptManageExceptionUtil.isUpdateValidError((boolean)StringUtil.isBlank((CharSequence)scriptManageDeployUpdateRequest.getRefValue()), (String)"\u811a\u672c\u5173\u8054\u503c\u4e3a\u7a7a!");
        ScriptManageExceptionUtil.isUpdateValidError((scriptManageDeployUpdateRequest.getType() == null ? 1 : 0) != 0, (String)"\u811a\u672c\u7c7b\u578b\u4e3a\u7a7a!");
        ScriptManageExceptionUtil.isUpdateValidError((boolean)CollectionUtils.isEmpty((Collection)scriptManageDeployUpdateRequest.getFileManageUpdateRequests()), (String)"\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a!");
        boolean existJmx = false;
        for (FileManageUpdateRequest fileManageUpdateRequest : scriptManageDeployUpdateRequest.getFileManageUpdateRequests()) {
            ScriptManageExceptionUtil.isUpdateValidError((boolean)StringUtil.isBlank((CharSequence)fileManageUpdateRequest.getFileName()), (String)"\u6587\u4ef6\u5217\u8868\u4e2d\u5b58\u5728\u6587\u4ef6\u540d\u4e3a\u7a7a!");
            ScriptManageExceptionUtil.isUpdateValidError((fileManageUpdateRequest.getFileName().length() > 64 ? 1 : 0) != 0, (String)"\u6587\u4ef6\u5217\u8868\u4e2d\u5b58\u5728\u6587\u4ef6\u540d\u957f\u5ea6\u5927\u4e8e64!");
            ScriptManageExceptionUtil.isUpdateValidError((boolean)fileManageUpdateRequest.getFileName().contains(" "), (String)"\u6587\u4ef6\u540d\u5305\u542b\u7a7a\u683c!");
            ScriptManageExceptionUtil.isUpdateValidError((fileManageUpdateRequest.getFileType() == null ? 1 : 0) != 0, (String)("\u6587\u4ef6\u5217\u8868\u4e2d\u5b58\u5728\u6587\u4ef6\u7c7b\u578b\u4e3a\u7a7a\uff01fileName=" + fileManageUpdateRequest.getFileName()));
            if (fileManageUpdateRequest.getFileType() == 0 && fileManageUpdateRequest.getIsDeleted() == 0) {
                existJmx = true;
            }
            fileManageUpdateRequest.setFileName(FileUtil.replaceFileName((String)fileManageUpdateRequest.getFileName()));
        }
        ScriptManageExceptionUtil.isUpdateValidError((!existJmx ? 1 : 0) != 0, (String)"\u6587\u4ef6\u5217\u8868\u4e2d\u4e0d\u5b58\u5728\u811a\u672c\u6587\u4ef6!");
    }

    private String getTargetScriptPath(ScriptManageDeployResult scriptManageDeployResult) {
        return this.scriptFilePath + "/" + scriptManageDeployResult.getScriptId() + "/" + scriptManageDeployResult.getScriptVersion() + "/";
    }
}

