/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.scenemanage.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pamirs.tro.common.constant.AppAccessTypeEnum;
import com.pamirs.tro.common.constant.AppSwitchEnum;
import com.pamirs.tro.common.exception.ApiException;
import com.pamirs.tro.entity.dao.confcenter.TApplicationMntDao;
import com.pamirs.tro.entity.domain.dto.scenemanage.ScriptCheckDTO;
import com.pamirs.tro.entity.domain.entity.TApplicationMnt;
import com.pamirs.tro.entity.domain.query.ApplicationQueryParam;
import com.pamirs.tro.entity.domain.vo.report.SceneActionParam;
import io.shulie.tro.cloud.common.redis.RedisClientUtils;
import io.shulie.tro.cloud.open.api.scenetask.CloudTaskApi;
import io.shulie.tro.cloud.open.req.scenemanage.SceneManageIdReq;
import io.shulie.tro.cloud.open.req.scenetask.SceneTaskQueryTpsReq;
import io.shulie.tro.cloud.open.req.scenetask.SceneTaskUpdateTpsReq;
import io.shulie.tro.cloud.open.resp.scenemanage.SceneManageWrapperResp;
import io.shulie.tro.cloud.open.resp.scenetask.SceneActionResp;
import io.shulie.tro.cloud.open.resp.scenetask.SceneTaskAdjustTpsResp;
import io.shulie.tro.common.beans.response.ResponseResult;
import io.shulie.tro.exception.entity.ExceptionReadable;
import io.shulie.tro.web.app.common.RestContext;
import io.shulie.tro.web.app.exception.ExceptionCode;
import io.shulie.tro.web.app.exception.TroWebException;
import io.shulie.tro.web.app.request.scriptmanage.UpdateTpsRequest;
import io.shulie.tro.web.app.response.scriptmanage.ScriptManageDeployDetailResponse;
import io.shulie.tro.web.app.service.ApplicationService;
import io.shulie.tro.web.app.service.async.AsyncService;
import io.shulie.tro.web.app.service.report.impl.ReportApplicationService;
import io.shulie.tro.web.app.service.scenemanage.SceneManageService;
import io.shulie.tro.web.app.service.scenemanage.SceneTaskService;
import io.shulie.tro.web.app.service.scriptmanage.ScriptManageService;
import io.shulie.tro.web.common.constant.RemoteConstant;
import io.shulie.tro.web.common.domain.WebRequest;
import io.shulie.tro.web.common.domain.WebResponse;
import io.shulie.tro.web.common.http.HttpWebClient;
import io.shulie.tro.web.diff.api.scenemanage.SceneManageApi;
import io.shulie.tro.web.diff.api.scenetask.SceneTaskApi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;

@Service
public class SceneTaskServiceImpl
implements SceneTaskService {
    private static final Logger log = LoggerFactory.getLogger(SceneTaskServiceImpl.class);
    @Autowired
    private HttpWebClient httpWebClient;
    @Autowired
    private SceneManageService sceneManageService;
    @Autowired
    private TApplicationMntDao applicationMntDao;
    @Value(value="${start.task.check.application: true}")
    private Boolean checkApplication;
    @Autowired
    private SceneTaskApi sceneTaskApi;
    @Autowired
    private SceneManageApi sceneManageApi;
    @Autowired
    private ReportApplicationService reportApplicationService;
    @Autowired
    private AsyncService asyncService;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private CloudTaskApi cloudTaskApi;
    @Autowired
    private ScriptManageService scriptManageService;
    @Autowired
    private RedisClientUtils redisClientUtils;

    public WebResponse startTask(SceneActionParam param) {
        ScriptManageDeployDetailResponse scriptManageDeployDetail;
        List pluginConfigDetailResponseList;
        Integer status;
        SceneManageIdReq req = new SceneManageIdReq();
        req.setId(param.getSceneId());
        ResponseResult resp = this.sceneManageApi.getSceneDetail(req);
        if (!resp.getSuccess().booleanValue()) {
            throw ApiException.create((int)500, (String)("\u573a\u666f\u4fe1\u606f\u67e5\u8be2\u9519\u8bef\uff0cid=" + param.getSceneId()));
        }
        SceneManageWrapperResp wrapperResp = (SceneManageWrapperResp)resp.getData();
        Long operateId = param.getUid();
        if (operateId == null) {
            operateId = RestContext.getUser().getId();
        }
        if ((status = wrapperResp.getStatus()) != null && status != 0) {
            throw ApiException.create((int)500, (String)("\u573a\u666f\u5904\u4e8e\u538b\u6d4b\u4e2d\uff0c\u7981\u6b62\u5e76\u884c\u538b\u6d4b\uff0csceneId=" + param.getSceneId()));
        }
        param.setUid(operateId);
        this.preCheckStart(wrapperResp, operateId);
        if (wrapperResp != null && wrapperResp.getScriptId() != null && CollectionUtils.isNotEmpty((Collection)(pluginConfigDetailResponseList = (scriptManageDeployDetail = this.scriptManageService.getScriptManageDeployDetail(wrapperResp.getScriptId())).getPluginConfigDetailResponseList()))) {
            List pluginIds = pluginConfigDetailResponseList.stream().map(o -> Long.parseLong(o.getName())).collect(Collectors.toList());
            param.setEnginePluginIds(pluginIds);
        }
        param.setRequestUrl("/api/scene/task/start");
        param.setHttpMethod(HttpMethod.POST);
        return this.httpWebClient.request((WebRequest)param);
    }

    public ResponseResult stopTask(SceneActionParam param) {
        SceneManageIdReq req = new SceneManageIdReq();
        req.setId(param.getSceneId());
        ResponseResult response = this.sceneTaskApi.checkTask(req);
        if (!response.getSuccess().booleanValue()) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.SCENE_STOP_ERROR, (Object)response.getError());
        }
        SceneActionResp resp = (SceneActionResp)response.getData();
        this.redisClientUtils.hmdelete("pting.application:hmset", String.valueOf(resp.getReportId()));
        return this.sceneTaskApi.stopTask(req);
    }

    public ResponseResult<SceneActionResp> checkStatus(Long sceneId) {
        List appNames;
        Map slaMap;
        SceneManageIdReq req = new SceneManageIdReq();
        req.setId(sceneId);
        ResponseResult response = this.sceneTaskApi.checkTask(req);
        if (!response.getSuccess().booleanValue()) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.SCENE_CHECK_ERROR, (Object)response.getError());
        }
        SceneActionResp resp = (SceneActionResp)response.getData();
        if (response.getData() == null || resp.getData() != 2L) {
            return response;
        }
        Long reportId = resp.getReportId();
        ResponseResult detailResp = this.sceneManageApi.getSceneDetail(req);
        if (!detailResp.getSuccess().booleanValue()) {
            return response;
        }
        SceneManageWrapperResp wrapperResp = (SceneManageWrapperResp)JSONObject.parseObject((String)JSON.toJSONString((Object)detailResp.getData()), SceneManageWrapperResp.class);
        List sceneBusinessActivityRefList = wrapperResp.getBusinessActivityConfig();
        List applicationIds = sceneBusinessActivityRefList.stream().filter(data -> StringUtils.isNotEmpty((CharSequence)data.getApplicationIds())).map(SceneManageWrapperResp.SceneBusinessActivityRefResp::getApplicationIds).flatMap(appIds -> Arrays.stream(appIds.split(",")).map(Long::parseLong)).filter(data -> data > 0L).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(applicationIds)) {
            List applicationMntList = this.applicationMntDao.queryApplicationMntListByIds(applicationIds);
            List applicationNames = applicationMntList.stream().map(TApplicationMnt::getApplicationName).collect(Collectors.toList());
            HashMap map = Maps.newHashMap();
            map.put(String.valueOf(reportId), applicationNames);
            this.redisClientUtils.hmset("pting.application:hmset", (Map)map);
        }
        if (MapUtils.isNotEmpty((Map)(slaMap = this.getSceneSla(wrapperResp))) && CollectionUtils.isNotEmpty((Collection)(appNames = this.reportApplicationService.getReportApplication(reportId).getApplicationNames()))) {
            this.asyncService.monitorCpuMemory(sceneId, reportId, appNames, (List)slaMap.get("stop"), (List)slaMap.get("warn"));
        }
        return response;
    }

    public void updateTaskTps(UpdateTpsRequest request) {
        SceneTaskUpdateTpsReq req = new SceneTaskUpdateTpsReq();
        req.setSceneId(request.getSceneId());
        req.setReportId(request.getReportId());
        req.setTpsNum(request.getTargetTps());
        req.setLicense(RemoteConstant.LICENSE_VALUE);
        ResponseResult responseResult = this.cloudTaskApi.updateSceneTaskTps(req);
        if (responseResult == null || !responseResult.getSuccess().booleanValue()) {
            throw new RuntimeException("\u4fee\u6539TPS\u5931\u8d25");
        }
    }

    public Long queryTaskTps(Long reportId, Long sceneId) {
        SceneTaskQueryTpsReq req = new SceneTaskQueryTpsReq();
        req.setSceneId(sceneId);
        req.setReportId(reportId);
        req.setLicense(RemoteConstant.LICENSE_VALUE);
        ResponseResult respResponseResult = this.cloudTaskApi.queryAdjustTaskTps(req);
        if (respResponseResult != null && respResponseResult.getData() != null) {
            return ((SceneTaskAdjustTpsResp)respResponseResult.getData()).getTotalTps();
        }
        return null;
    }

    private void preCheckStart(SceneManageWrapperResp sceneData, Long uid) {
        ScriptCheckDTO scriptCheck;
        String userSwitchStatusForVo = this.applicationService.getUserSwitchStatusForVo(uid);
        if (StringUtils.isBlank((CharSequence)userSwitchStatusForVo) || !userSwitchStatusForVo.equals(AppSwitchEnum.OPENED.getCode())) {
            throw ApiException.create((int)500, (String)"\u538b\u6d4b\u5f00\u5173\u5904\u4e8e\u5173\u95ed\u72b6\u6001\uff0c\u7981\u6b62\u538b\u6d4b");
        }
        List sceneBusinessActivityRefList = sceneData.getBusinessActivityConfig();
        if (CollectionUtils.isEmpty((Collection)sceneBusinessActivityRefList)) {
            log.error("[{}]\u573a\u666f\u6ca1\u6709\u914d\u7f6e\u4e1a\u52a1\u6d3b\u52a8", (Object)sceneData.getId());
            throw ApiException.create((int)500, (String)"\u542f\u52a8\u538b\u6d4b\u5931\u8d25\uff0c\u6ca1\u6709\u914d\u7f6e\u4e1a\u52a1\u6d3b\u52a8");
        }
        StringBuffer errorMsg = new StringBuffer();
        List applicationIds = sceneBusinessActivityRefList.stream().map(SceneManageWrapperResp.SceneBusinessActivityRefResp::getApplicationIds).filter(StringUtils::isNotEmpty).flatMap(appIds -> Arrays.stream(appIds.split(",")).map(Long::parseLong)).filter(data -> data > 0L).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(applicationIds) && this.checkApplication.booleanValue()) {
            ApplicationQueryParam param = new ApplicationQueryParam();
            param.setApplicationIds(applicationIds);
            param.setCurrentPage(Integer.valueOf(0));
            param.setPageSize(Integer.valueOf(applicationIds.size() + 1));
            List applicationList = this.applicationService.getApplicationListVo(param);
            if (applicationList == null || applicationList.size() != applicationIds.size()) {
                log.error("\u542f\u52a8\u538b\u6d4b\u5931\u8d25, \u6ca1\u6709\u627e\u5230\u5173\u8054\u7684\u5e94\u7528\u4fe1\u606f\uff0c\u573a\u666fID\uff1a{}", (Object)sceneData.getId());
                throw ApiException.create((int)500, (String)"\u542f\u52a8\u538b\u6d4b\u5931\u8d25, \u6ca1\u6709\u627e\u5230\u5173\u8054\u7684\u5e94\u7528\u4fe1\u606f");
            }
            ArrayList errorApplicationStatus = Lists.newArrayList();
            applicationList.forEach(application -> {
                boolean statusError = false;
                if (!application.getSwitchStutus().equals(AppSwitchEnum.OPENED.getCode())) {
                    log.error("\u5e94\u7528[{}]\u672a\u5f00\u542f", (Object)application.getApplicationName());
                    statusError = true;
                }
                if (application.getAccessStatus().intValue() != AppAccessTypeEnum.NORMAL.getValue().intValue()) {
                    log.error("\u5e94\u7528[{}]\u63a5\u5165\u72b6\u6001\u4e0d\u662f\u5f00\u542f\u72b6\u6001\uff0c\u5f53\u524d\u72b6\u6001[{}]", (Object)application.getApplicationName(), (Object)application.getAccessStatus());
                    statusError = true;
                }
                if (statusError) {
                    errorApplicationStatus.add(application.getApplicationName());
                }
            });
            if (errorApplicationStatus.size() > 0) {
                String errorApplication = String.format(" %d\u4e2a\u5e94\u7528\u72b6\u6001\u4e0d\u6b63\u5e38\uff1a%s", errorApplicationStatus.size(), StringUtils.join((Object[])errorApplicationStatus.toArray(), (String)","));
                errorMsg.append(errorApplication).append("|");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(scriptCheck = this.sceneManageService.checkBusinessActivityAndScript(sceneData)).getErrmsg())) {
            log.error(scriptCheck.getErrmsg());
            errorMsg.append(scriptCheck.getErrmsg()).append("|");
        }
        if (!scriptCheck.getPtTag().booleanValue()) {
            log.error("\u538b\u6d4b\u811a\u672c\u672a\u8bc6\u522b\u5230\u538b\u6d4b\u6807\u8bb0");
            errorMsg.append("\u538b\u6d4b\u811a\u672c\u672a\u8bc6\u522b\u5230\u538b\u6d4b\u6807\u8bb0").append("|");
        }
        if (!scriptCheck.getMatchActivity().booleanValue()) {
            log.error("\u538b\u6d4b\u811a\u672c\u548c\u4e1a\u52a1\u6d3b\u52a8\u4e0d\u5339\u914d");
            errorMsg.append("\u538b\u6d4b\u811a\u672c\u548c\u4e1a\u52a1\u6d3b\u52a8\u4e0d\u5339\u914d");
        }
        if (errorMsg.length() > 0 && errorMsg.toString().endsWith("|")) {
            String msg = StringUtils.substring((String)errorMsg.toString(), (int)0, (int)(errorMsg.toString().length() - 1));
            throw ApiException.create((int)500, (String)msg);
        }
    }

    private Map<String, List<SceneManageWrapperResp.SceneSlaRefResp>> getSceneSla(SceneManageWrapperResp detailResp) {
        HashMap dataMap = Maps.newHashMap();
        List stopList = Optional.ofNullable(detailResp.getStopCondition()).orElse(Lists.newArrayList());
        if (CollectionUtils.isNotEmpty(stopList = stopList.stream().filter(data -> data.getRule().getIndexInfo() >= 4).collect(Collectors.toList()))) {
            dataMap.put("stop", stopList);
        }
        List warnList = Optional.ofNullable(detailResp.getWarningCondition()).orElse(Lists.newArrayList());
        if (CollectionUtils.isNotEmpty(warnList = warnList.stream().filter(data -> data.getRule().getIndexInfo() >= 4).collect(Collectors.toList()))) {
            dataMap.put("warn", warnList);
        }
        return dataMap;
    }
}

