/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.scenemanage.impl;

import com.google.common.collect.Lists;
import io.shulie.tro.exception.entity.ExceptionReadable;
import io.shulie.tro.web.app.exception.ExceptionCode;
import io.shulie.tro.web.app.exception.TroWebException;
import io.shulie.tro.web.app.request.scenemanage.SceneTagCreateRequest;
import io.shulie.tro.web.app.request.scenemanage.SceneTagRefCreateRequest;
import io.shulie.tro.web.app.response.scenemanage.SceneTagRefResponse;
import io.shulie.tro.web.app.response.tagmanage.TagManageResponse;
import io.shulie.tro.web.app.service.scenemanage.SceneTagService;
import io.shulie.tro.web.data.dao.scenemanage.SceneTagRefDAO;
import io.shulie.tro.web.data.dao.tagmanage.TagManageDAO;
import io.shulie.tro.web.data.param.sceneManage.SceneTagRefQueryParam;
import io.shulie.tro.web.data.param.tagmanage.TagManageParam;
import io.shulie.tro.web.data.result.scenemanage.SceneTagRefResult;
import io.shulie.tro.web.data.result.tagmanage.TagManageResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SceneTagServiceImpl
implements SceneTagService {
    @Autowired
    private TagManageDAO tagManageDAO;
    @Autowired
    private SceneTagRefDAO sceneTagRefDAO;

    public void createSceneTag(SceneTagCreateRequest request) {
        ArrayList<TagManageParam> paramList = new ArrayList<TagManageParam>();
        TagManageParam param = new TagManageParam();
        param.setTagName(request.getTagName());
        param.setTagType(Integer.valueOf(1));
        paramList.add(param);
        this.tagManageDAO.addScriptTags(paramList, Integer.valueOf(1));
    }

    public List<TagManageResponse> getAllSceneTags() {
        List tagManageResults = this.tagManageDAO.selectTagByType(Integer.valueOf(1));
        return this.tagResult2TagResp(tagManageResults);
    }

    public void createSceneTagRef(SceneTagRefCreateRequest sceneTagCreateRefRequest) {
        if (sceneTagCreateRefRequest == null || sceneTagCreateRefRequest.getSceneId() == null) {
            return;
        }
        if (sceneTagCreateRefRequest.getTagNames().size() > 10) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.SCRIPT_MANAGE_TAG_ADD_VALID_ERROR, (Object)"\u6bcf\u4e2a\u573a\u666f\u5173\u8054\u6807\u7b7e\u6570\u4e0d\u80fd\u8d85\u8fc710");
        }
        List collect = sceneTagCreateRefRequest.getTagNames().stream().filter(o -> o.length() > 10).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect)) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.SCRIPT_MANAGE_TAG_ADD_VALID_ERROR, (Object)"\u5b58\u5728\u811a\u672c\u540d\u79f0\u957f\u5ea6\u8d85\u8fc710");
        }
        if (sceneTagCreateRefRequest.getSceneId() != null) {
            this.sceneTagRefDAO.deleteBySceneId(sceneTagCreateRefRequest.getSceneId());
            if (CollectionUtils.isNotEmpty((Collection)sceneTagCreateRefRequest.getTagNames())) {
                List tagManageParams = sceneTagCreateRefRequest.getTagNames().stream().distinct().map(tagName -> {
                    TagManageParam tagManageParam = new TagManageParam();
                    tagManageParam.setTagName(tagName);
                    tagManageParam.setTagStatus(Integer.valueOf(0));
                    tagManageParam.setTagType(Integer.valueOf(1));
                    return tagManageParam;
                }).collect(Collectors.toList());
                List tagIds = this.tagManageDAO.addScriptTags(tagManageParams, Integer.valueOf(1));
                this.sceneTagRefDAO.addSceneTagRef(tagIds, sceneTagCreateRefRequest.getSceneId());
            }
        }
    }

    public List<SceneTagRefResponse> getSceneTagRefBySceneIds(List<Long> sceneIds) {
        if (CollectionUtils.isEmpty(sceneIds)) {
            return Lists.newArrayList();
        }
        List refResultList = this.sceneTagRefDAO.selectBySceneIds(sceneIds);
        return this.refResult2RefResp(refResultList);
    }

    public List<SceneTagRefResponse> getTagRefByTagIds(List<Long> tagIds) {
        if (CollectionUtils.isEmpty(tagIds)) {
            return Lists.newArrayList();
        }
        SceneTagRefQueryParam param = new SceneTagRefQueryParam();
        param.setTagIds(tagIds);
        List refResultList = this.sceneTagRefDAO.selectByExample(param);
        return this.refResult2RefResp(refResultList);
    }

    List<TagManageResponse> tagResult2TagResp(List<TagManageResult> tagManageResults) {
        if (CollectionUtils.isEmpty(tagManageResults)) {
            return Lists.newArrayList();
        }
        return tagManageResults.stream().map(tagManageResult -> {
            TagManageResponse tagManageResponse = new TagManageResponse();
            tagManageResponse.setId(tagManageResult.getId());
            tagManageResponse.setTagName(tagManageResult.getTagName());
            return tagManageResponse;
        }).collect(Collectors.toList());
    }

    List<SceneTagRefResponse> refResult2RefResp(List<SceneTagRefResult> sceneTagRefResults) {
        if (CollectionUtils.isEmpty(sceneTagRefResults)) {
            return Lists.newArrayList();
        }
        ArrayList<SceneTagRefResponse> responseList = new ArrayList<SceneTagRefResponse>();
        sceneTagRefResults.stream().forEach(sceneTagRefResult -> {
            SceneTagRefResponse response = new SceneTagRefResponse();
            BeanUtils.copyProperties((Object)sceneTagRefResult, (Object)response);
            responseList.add(response);
        });
        return responseList;
    }
}

