/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.scenemanage;

import com.google.common.collect.Lists;
import com.pamirs.tro.common.util.DateUtils;
import com.pamirs.tro.entity.domain.vo.report.SceneActionParam;
import io.shulie.tro.exception.entity.ExceptionReadable;
import io.shulie.tro.web.app.exception.ExceptionCode;
import io.shulie.tro.web.app.exception.TroWebException;
import io.shulie.tro.web.app.request.scenemanage.SceneSchedulerTaskCreateRequest;
import io.shulie.tro.web.app.request.scenemanage.SceneSchedulerTaskQueryRequest;
import io.shulie.tro.web.app.request.scenemanage.SceneSchedulerTaskUpdateRequest;
import io.shulie.tro.web.app.response.scenemanage.SceneSchedulerTaskResponse;
import io.shulie.tro.web.app.service.scenemanage.SceneSchedulerTaskService;
import io.shulie.tro.web.app.service.scenemanage.SceneTaskService;
import io.shulie.tro.web.data.dao.scenemanage.SceneSchedulerTaskDao;
import io.shulie.tro.web.data.param.sceneManage.SceneSchedulerTaskInsertParam;
import io.shulie.tro.web.data.param.sceneManage.SceneSchedulerTaskQueryParam;
import io.shulie.tro.web.data.param.sceneManage.SceneSchedulerTaskUpdateParam;
import io.shulie.tro.web.data.result.scenemanage.SceneSchedulerTaskResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SceneSchedulerTaskServiceImpl
implements SceneSchedulerTaskService {
    private static final Logger log = LoggerFactory.getLogger(SceneSchedulerTaskServiceImpl.class);
    @Autowired
    private SceneSchedulerTaskDao sceneSchedulerTaskDao;
    @Autowired
    private SceneTaskService sceneTaskService;

    public Long insert(SceneSchedulerTaskCreateRequest request) {
        if (request == null) {
            return null;
        }
        if (request.getSceneId() == null) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.SCENE_SCHEDULER_TASK_SCENE_ID_VALID_ERROR, (Object)"sceneId can not be null");
        }
        this.verificationScheduleTime(request.getExecuteTime());
        SceneSchedulerTaskResult result = this.sceneSchedulerTaskDao.selectBySceneId(request.getSceneId());
        if (result != null) {
            return result.getId();
        }
        SceneSchedulerTaskInsertParam insertParam = new SceneSchedulerTaskInsertParam();
        BeanUtils.copyProperties((Object)request, (Object)insertParam);
        return this.sceneSchedulerTaskDao.create(insertParam);
    }

    public void verificationScheduleTime(Date time) {
        if (time == null) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.SCENE_SCHEDULER_TASK_EXECUTE_TIME_VALID_ERROR, (Object)"executeTime can not be null");
        }
        if (time.getTime() - System.currentTimeMillis() < 60000L) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.SCENE_SCHEDULER_TASK_EXECUTE_TIME_VALID_ERROR, (Object)"\u5b9a\u65f6\u6267\u884c\u65f6\u95f4\u9700\u8981\u5927\u4e8e\u5f53\u524d\u65f6\u95f41\u5206\u949f");
        }
    }

    public void delete(Long id) {
        this.sceneSchedulerTaskDao.delete(id);
    }

    public void update(SceneSchedulerTaskUpdateRequest updateRequest, Boolean needVerify) {
        if (needVerify != null && needVerify.booleanValue()) {
            this.verificationScheduleTime(updateRequest.getExecuteTime());
        }
        SceneSchedulerTaskUpdateParam updateParam = new SceneSchedulerTaskUpdateParam();
        BeanUtils.copyProperties((Object)updateRequest, (Object)updateParam);
        this.sceneSchedulerTaskDao.update(updateParam);
    }

    public SceneSchedulerTaskResponse selectBySceneId(Long sceneId) {
        SceneSchedulerTaskResult result = this.sceneSchedulerTaskDao.selectBySceneId(sceneId);
        if (result == null) {
            return null;
        }
        SceneSchedulerTaskResponse response = new SceneSchedulerTaskResponse();
        BeanUtils.copyProperties((Object)result, (Object)response);
        return response;
    }

    public void deleteBySceneId(Long sceneId) {
        if (sceneId == null) {
            return;
        }
        this.sceneSchedulerTaskDao.deleteBySceneId(sceneId);
    }

    public List<SceneSchedulerTaskResponse> selectBySceneIds(List<Long> sceneIds) {
        if (CollectionUtils.isEmpty(sceneIds)) {
            return Lists.newArrayList();
        }
        List resultList = this.sceneSchedulerTaskDao.selectBySceneIds(sceneIds);
        return this.result2RespList(resultList);
    }

    public List<SceneSchedulerTaskResponse> selectByExample(SceneSchedulerTaskQueryRequest request) {
        if (request == null) {
            return Lists.newArrayList();
        }
        SceneSchedulerTaskQueryParam queryParam = new SceneSchedulerTaskQueryParam();
        BeanUtils.copyProperties((Object)request, (Object)queryParam);
        List resultList = this.sceneSchedulerTaskDao.selectByExample(queryParam);
        return this.result2RespList(resultList);
    }

    public void executeSchedulerPressureTask() {
        SceneSchedulerTaskQueryRequest request = new SceneSchedulerTaskQueryRequest();
        Date previousNSecond = DateUtils.getPreviousNSecond((int)-67);
        String time = DateUtils.dateToString((Date)previousNSecond, (String)"yyyy-MM-dd HH:mm");
        request.setEndTime(time);
        List responseList = this.selectByExample(request);
        if (CollectionUtils.isEmpty((Collection)responseList)) {
            return;
        }
        for (SceneSchedulerTaskResponse scheduler : responseList) {
            Date now;
            Date dbDate;
            if (scheduler.getExecuteTime() == null || scheduler.getIsExecuted() == null || scheduler.getIsExecuted() != 0 || !(dbDate = scheduler.getExecuteTime()).before(now = new Date())) continue;
            SceneActionParam startParam = new SceneActionParam();
            startParam.setSceneId(scheduler.getSceneId());
            startParam.setUid(scheduler.getUserId());
            new Thread(() -> {
                try {
                    this.sceneTaskService.startTask(startParam);
                }
                catch (Exception e) {
                    log.error("\u6267\u884c\u5b9a\u65f6\u538b\u6d4b\u4efb\u52a1\u5931\u8d25...", (Throwable)e);
                }
                finally {
                    SceneSchedulerTaskUpdateRequest updateRequest = new SceneSchedulerTaskUpdateRequest();
                    updateRequest.setId(scheduler.getId());
                    updateRequest.setIsExecuted(Integer.valueOf(2));
                    updateRequest.setIsDeleted(Boolean.valueOf(true));
                    this.update(updateRequest, Boolean.valueOf(false));
                }
            }).start();
        }
    }

    List<SceneSchedulerTaskResponse> result2RespList(List<SceneSchedulerTaskResult> resultList) {
        if (CollectionUtils.isEmpty(resultList)) {
            Lists.newArrayList();
        }
        ArrayList<SceneSchedulerTaskResponse> responseList = new ArrayList<SceneSchedulerTaskResponse>();
        resultList.stream().forEach(result -> {
            SceneSchedulerTaskResponse response = new SceneSchedulerTaskResponse();
            BeanUtils.copyProperties((Object)result, (Object)response);
            responseList.add(response);
        });
        return responseList;
    }
}

