/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.scene.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pamirs.tro.common.constant.TimeUnitEnum;
import com.pamirs.tro.common.exception.ApiException;
import com.pamirs.tro.common.util.DateUtils;
import com.pamirs.tro.common.util.ListHelper;
import com.pamirs.tro.common.util.parse.UrlUtil;
import com.pamirs.tro.entity.dao.confcenter.TApplicationMntDao;
import com.pamirs.tro.entity.dao.linkmanage.TBusinessLinkManageTableMapper;
import com.pamirs.tro.entity.dao.linkmanage.TLinkManageTableMapper;
import com.pamirs.tro.entity.domain.dto.scenemanage.ScriptCheckDTO;
import com.pamirs.tro.entity.domain.entity.linkmanage.BusinessLinkManageTable;
import com.pamirs.tro.entity.domain.entity.scenemanage.SceneBusinessActivityRef;
import com.pamirs.tro.entity.domain.entity.user.User;
import com.pamirs.tro.entity.domain.vo.scenemanage.FlowVO;
import com.pamirs.tro.entity.domain.vo.scenemanage.SceneBusinessActivityRefVO;
import com.pamirs.tro.entity.domain.vo.scenemanage.SceneManageIdVO;
import com.pamirs.tro.entity.domain.vo.scenemanage.SceneManageQueryVO;
import com.pamirs.tro.entity.domain.vo.scenemanage.SceneManageWrapperVO;
import com.pamirs.tro.entity.domain.vo.scenemanage.SceneParseVO;
import com.pamirs.tro.entity.domain.vo.scenemanage.SceneScriptRefVO;
import com.pamirs.tro.entity.domain.vo.scenemanage.ScriptUrlVO;
import com.pamirs.tro.entity.domain.vo.scenemanage.TimeVO;
import io.shulie.tro.cloud.common.bean.TimeBean;
import io.shulie.tro.cloud.open.req.scenemanage.SceneIpNumReq;
import io.shulie.tro.cloud.open.req.scenemanage.SceneManageIdReq;
import io.shulie.tro.cloud.open.req.scenemanage.SceneManageQueryByIdsReq;
import io.shulie.tro.cloud.open.req.scenemanage.SceneManageQueryReq;
import io.shulie.tro.cloud.open.req.scenemanage.SceneManageWrapperReq;
import io.shulie.tro.cloud.open.req.scenemanage.SceneScriptRefOpen;
import io.shulie.tro.cloud.open.resp.scenemanage.SceneManageListResp;
import io.shulie.tro.cloud.open.resp.scenemanage.SceneManageWrapperResp;
import io.shulie.tro.cloud.open.resp.strategy.StrategyResp;
import io.shulie.tro.common.beans.response.ResponseResult;
import io.shulie.tro.web.app.common.RestContext;
import io.shulie.tro.web.app.request.scenemanage.SceneSchedulerTaskCreateRequest;
import io.shulie.tro.web.app.request.scenemanage.SceneSchedulerTaskUpdateRequest;
import io.shulie.tro.web.app.response.scenemanage.SceneListResponse;
import io.shulie.tro.web.app.response.scenemanage.SceneSchedulerTaskResponse;
import io.shulie.tro.web.app.response.scenemanage.SceneTagRefResponse;
import io.shulie.tro.web.app.response.scriptmanage.ScriptManageDeployDetailResponse;
import io.shulie.tro.web.app.service.scene.ApplicationBusinessActivityService;
import io.shulie.tro.web.app.service.scenemanage.SceneManageService;
import io.shulie.tro.web.app.service.scenemanage.SceneSchedulerTaskService;
import io.shulie.tro.web.app.service.scenemanage.SceneTagService;
import io.shulie.tro.web.app.service.scriptmanage.ScriptManageService;
import io.shulie.tro.web.auth.api.UserService;
import io.shulie.tro.web.common.domain.ErrorInfo;
import io.shulie.tro.web.common.domain.WebRequest;
import io.shulie.tro.web.common.domain.WebResponse;
import io.shulie.tro.web.common.enums.script.FileTypeEnum;
import io.shulie.tro.web.common.enums.script.ScriptTypeEnum;
import io.shulie.tro.web.common.http.HttpWebClient;
import io.shulie.tro.web.common.util.ActivityUtil;
import io.shulie.tro.web.common.util.JsonUtil;
import io.shulie.tro.web.diff.api.scenemanage.SceneManageApi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;

@Service
public class SceneManageServiceImpl
implements SceneManageService {
    private static final Logger log = LoggerFactory.getLogger(SceneManageServiceImpl.class);
    @Autowired
    private HttpWebClient httpWebClient;
    @Resource
    private TBusinessLinkManageTableMapper TBusinessLinkManageTableMapper;
    @Value(value="${script.check:true}")
    private Boolean scriptCheck;
    @Value(value="${script.check.perfomancetype:false}")
    private Boolean scriptPTCheck;
    @Resource
    private TLinkManageTableMapper TLinkManageTableMapper;
    @Resource
    private TApplicationMntDao tApplicationMntDao;
    @Autowired
    private ApplicationBusinessActivityService applicationBusinessActivityService;
    @Autowired
    private ScriptManageService scriptManageService;
    @Autowired
    private SceneManageApi sceneManageApi;
    @Autowired
    private UserService userService;
    @Autowired
    private SceneSchedulerTaskService sceneSchedulerTaskService;
    @Autowired
    private SceneTagService sceneTagService;

    public ResponseResult<List<SceneManageWrapperResp>> getByIds(SceneManageQueryByIdsReq req) {
        return this.sceneManageApi.getByIds(req);
    }

    public WebResponse addScene(SceneManageWrapperVO vo, Long userId) {
        if (!Objects.isNull(vo.getScheduleInterval())) {
            Long scheduleInterval = this.convertTime(Long.valueOf(Long.parseLong(String.valueOf(vo.getScheduleInterval()))), TimeUnitEnum.MINUTE.getValue());
            TimeVO timeVo = vo.getPressureTestTime();
            Long pressureTestSecond = this.convertTime(timeVo.getTime(), timeVo.getUnit());
            if (scheduleInterval > pressureTestSecond) {
                return WebResponse.fail((String)"500", (String)"\u6f0f\u6570\u9a8c\u8bc1\u65f6\u95f4\u95f4\u9694\u4e0d\u80fd\u5927\u4e8e\u538b\u6d4b\u65f6\u957f", (Object[])new Object[0]);
            }
        }
        SceneManageWrapperReq req = new SceneManageWrapperReq();
        WebResponse webResponse = null;
        webResponse = this.sceneManageVo2Req(vo, req, userId);
        if (webResponse == null) {
            webResponse = new WebResponse();
        }
        try {
            ResponseResult result = this.sceneManageApi.saveScene(req);
            if (vo.getIsScheduler() != null && vo.getIsScheduler().booleanValue() && result != null && result.getSuccess().booleanValue() && vo.getExecuteTime() != null) {
                Long sceneId = (Long)JSON.parseObject((String)JSON.toJSONString((Object)result.getData()), Long.class);
                SceneSchedulerTaskCreateRequest createRequest = new SceneSchedulerTaskCreateRequest();
                createRequest.setSceneId(sceneId);
                createRequest.setExecuteTime(vo.getExecuteTime());
                createRequest.setUserId(RestContext.getUser().getId());
                this.sceneSchedulerTaskService.insert(createRequest);
            }
            webResponse.setSuccess(Boolean.valueOf(true));
        }
        catch (Exception e) {
            webResponse.setSuccess(Boolean.valueOf(false));
            log.error(e.getMessage(), (Throwable)e);
        }
        return webResponse;
    }

    public WebResponse sceneManageVo2Req(SceneManageWrapperVO vo, SceneManageWrapperReq req, Long userId) {
        WebResponse webResponse = this.buildSceneManageRef(vo, userId);
        Object data = webResponse.getData();
        if (!webResponse.getSuccess().booleanValue()) {
            return webResponse;
        }
        BeanUtils.copyProperties((Object)vo, (Object)req);
        if (data != null) {
            req.setUploadFile((List)data);
        }
        if (vo.getPressureTestTime() != null) {
            TimeBean presTime = new TimeBean();
            presTime.setUnit(vo.getPressureTestTime().getUnit());
            presTime.setTime(vo.getPressureTestTime().getTime());
            req.setPressureTestTime(presTime);
        }
        if (vo.getIncreasingTime() != null) {
            TimeBean incresTime = new TimeBean();
            incresTime.setTime(vo.getIncreasingTime().getTime());
            incresTime.setUnit(vo.getIncreasingTime().getUnit());
            req.setIncreasingTime(incresTime);
            req.setIncreasingTime(incresTime);
        }
        this.assembleFeatures(vo, req);
        return webResponse;
    }

    public void assembleFeatures(SceneManageWrapperVO vo, SceneManageWrapperReq req) {
        HashMap<String, Number> map = new HashMap<String, Number>();
        map.put("businessFlowId", vo.getBusinessFlowId());
        Integer configType = vo.getConfigType();
        map.put("configType", configType);
        if (configType != null && configType == 1) {
            if (CollectionUtils.isNotEmpty((Collection)vo.getBusinessActivityConfig())) {
                map.put("scriptId", ((SceneBusinessActivityRefVO)vo.getBusinessActivityConfig().get(0)).getScriptId());
            }
        } else {
            map.put("scriptId", vo.getScriptId());
        }
        map.put("scheduleInterval", vo.getScheduleInterval());
        req.setFeatures(JSON.toJSONString(map));
    }

    public WebResponse getPageList(SceneManageQueryVO vo) {
        WebResponse webResponse = new WebResponse();
        webResponse.setData((Object)Lists.newArrayList());
        webResponse.setSuccess(Boolean.valueOf(true));
        webResponse.setTotal(Long.valueOf(0L));
        SceneManageQueryReq req = new SceneManageQueryReq();
        BeanUtils.copyProperties((Object)vo, (Object)req);
        if (vo.getTagId() != null) {
            List<Long> tagIds = Arrays.asList(vo.getTagId());
            List sceneTagRefBySceneIds = this.sceneTagService.getTagRefByTagIds(tagIds);
            if (CollectionUtils.isNotEmpty((Collection)sceneTagRefBySceneIds)) {
                List sceneIds = sceneTagRefBySceneIds.stream().map(SceneTagRefResponse::getSceneId).distinct().collect(Collectors.toList());
                String sceneIdStr = StringUtils.join(sceneIds, (String)",");
                req.setSceneIds(sceneIdStr);
            } else {
                return webResponse;
            }
        }
        req.setLastPtStartTime(vo.getLastPtStartTime());
        req.setLastPtEndTime(vo.getLastPtEndTime());
        ResponseResult sceneList = this.sceneManageApi.getSceneList(req);
        List listData = (List)sceneList.getData();
        List userIds = listData.stream().map(SceneManageListResp::getUserId).filter(Objects::nonNull).collect(Collectors.toList());
        Map userMap = this.userService.getUserMapByIds(userIds);
        listData.stream().filter(data -> null != data.getUserId()).forEach(data -> {
            List allowStartStopUserIdList;
            List allowDeleteUserIdList;
            data.setManagerId(data.getUserId());
            String userName = Optional.ofNullable(userMap.get(data.getUserId())).map(User::getName).orElse("");
            data.setManagerName(userName);
            List allowUpdateUserIdList = RestContext.getUpdateAllowUserIdList();
            if (CollectionUtils.isNotEmpty((Collection)allowUpdateUserIdList)) {
                data.setCanEdit(Boolean.valueOf(allowUpdateUserIdList.contains(data.getUserId())));
            }
            if (CollectionUtils.isNotEmpty((Collection)(allowDeleteUserIdList = RestContext.getDeleteAllowUserIdList()))) {
                data.setCanRemove(Boolean.valueOf(allowDeleteUserIdList.contains(data.getUserId())));
            }
            if (CollectionUtils.isNotEmpty((Collection)(allowStartStopUserIdList = RestContext.getStartStopAllowUserIdList()))) {
                data.setCanStartStop(Boolean.valueOf(allowStartStopUserIdList.contains(data.getUserId())));
            }
        });
        webResponse.setTotal(sceneList.getTotalNum());
        if (null != sceneList) {
            webResponse.setTotal(sceneList.getTotalNum());
        } else {
            webResponse.setTotal(Long.valueOf(0L));
        }
        webResponse.setSuccess(Boolean.valueOf(true));
        List sceneListResponses = this.adjustSchedulerScene(listData);
        webResponse.setData((Object)sceneListResponses);
        return webResponse;
    }

    List<SceneListResponse> adjustSchedulerScene(List<SceneManageListResp> sceneRespList) {
        if (CollectionUtils.isEmpty(sceneRespList)) {
            return Lists.newArrayList();
        }
        List sceneIds = sceneRespList.stream().map(SceneManageListResp::getId).collect(Collectors.toList());
        List responseList = this.sceneSchedulerTaskService.selectBySceneIds(sceneIds);
        HashMap schedulerMap = new HashMap();
        responseList.stream().forEach(response -> schedulerMap.put(response.getSceneId(), response.getExecuteTime()));
        List allSceneTags = this.sceneTagService.getAllSceneTags();
        HashMap tagMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)allSceneTags)) {
            allSceneTags.stream().forEach(tagManageResponse -> tagMap.put(tagManageResponse.getId(), tagManageResponse));
        }
        List sceneTagRefList = this.sceneTagService.getSceneTagRefBySceneIds(sceneIds);
        Map<Long, List<SceneTagRefResponse>> sceneMap = sceneTagRefList.stream().collect(Collectors.groupingBy(SceneTagRefResponse::getSceneId));
        ArrayList<SceneListResponse> voList = new ArrayList<SceneListResponse>();
        for (SceneManageListResp resp : sceneRespList) {
            SceneListResponse sceneVo = new SceneListResponse();
            BeanUtils.copyProperties((Object)resp, (Object)sceneVo);
            Date executeTime = (Date)schedulerMap.get(sceneVo.getId());
            if (executeTime != null) {
                sceneVo.setIsScheduler(Boolean.valueOf(true));
                sceneVo.setScheduleExecuteTime(DateUtils.dateToString((Date)executeTime, (String)"yyyy-MM-dd HH:mm:ss"));
            } else {
                sceneVo.setIsScheduler(Boolean.valueOf(false));
            }
            ArrayList tags = new ArrayList();
            if (sceneMap.containsKey(sceneVo.getId())) {
                List<SceneTagRefResponse> refTagList = sceneMap.get(sceneVo.getId());
                for (SceneTagRefResponse response2 : refTagList) {
                    Long tagId = response2.getTagId();
                    if (!tagMap.containsKey(tagId)) continue;
                    tags.add(tagMap.get(tagId));
                }
            }
            sceneVo.setTag(tags);
            voList.add(sceneVo);
        }
        return voList;
    }

    public WebResponse calcFlow(FlowVO vo) {
        vo.setRequestUrl("/api/scenemanage/flow/calc");
        vo.setHttpMethod(HttpMethod.POST);
        return this.httpWebClient.request((WebRequest)vo);
    }

    public ResponseResult<StrategyResp> getIpNum(Integer concurrenceNum, Integer tpsNum) {
        SceneIpNumReq req = new SceneIpNumReq();
        req.setConcurrenceNum(concurrenceNum);
        req.setTpsNum(tpsNum);
        return this.sceneManageApi.getIpNum(req);
    }

    private WebResponse buildSceneManageRef(SceneManageWrapperVO wrapperVO, Long userId) {
        ScriptCheckDTO checkDTO;
        ScriptManageDeployDetailResponse scriptManageDeployDetail;
        Long scriptId = 0L;
        boolean hasScriptId = false;
        if (wrapperVO.getConfigType() != null && wrapperVO.getConfigType() == 2) {
            scriptId = wrapperVO.getScriptId();
            hasScriptId = true;
        } else {
            List list = wrapperVO.getBusinessActivityConfig();
            if (CollectionUtils.isNotEmpty((Collection)list) && list.size() == 1) {
                scriptId = ((SceneBusinessActivityRefVO)list.get(0)).getScriptId();
                hasScriptId = true;
            }
        }
        if (!hasScriptId) {
            WebResponse.fail((String)"scriptId can not be null !", (Object[])new Object[0]);
        }
        if ((scriptManageDeployDetail = this.scriptManageService.getScriptManageDeployDetail(scriptId)) == null) {
            return WebResponse.fail((String)"500", (String)"\u811a\u672c\u5b9e\u4f8b\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        }
        wrapperVO.setScriptType(scriptManageDeployDetail.getType());
        List scriptList = this.buildScriptRef(scriptManageDeployDetail);
        WebResponse response = this.checkScript(scriptManageDeployDetail.getType(), scriptList);
        if (!response.getSuccess().booleanValue()) {
            return response;
        }
        List execList = (List)response.getData();
        List businessActivityList = this.buildSceneBusinessActivityRef(wrapperVO.getBusinessActivityConfig());
        if (ScriptTypeEnum.JMETER.getCode().equals(wrapperVO.getScriptType()) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{(checkDTO = this.checkScriptAndActivity(wrapperVO.getScriptType(), true, businessActivityList, execList)).getErrmsg()})) {
            return WebResponse.fail((String)"500", (String)checkDTO.getErrmsg(), (Object[])new Object[0]);
        }
        Map dataMap = ListHelper.transferToMap((List)businessActivityList, SceneBusinessActivityRef::getBusinessActivityId, data -> data);
        wrapperVO.getBusinessActivityConfig().forEach(vo -> {
            SceneBusinessActivityRef ref = (SceneBusinessActivityRef)dataMap.get(vo.getBusinessActivityId());
            if (ref != null) {
                vo.setBindRef(ref.getBindRef());
                vo.setApplicationIds(ref.getApplicationIds());
            }
        });
        WebResponse webResponse = new WebResponse();
        webResponse.setSuccess(Boolean.valueOf(true));
        webResponse.setData((Object)scriptList);
        return webResponse;
    }

    public WebResponse updateScene(SceneManageWrapperVO vo, Long uid) {
        SceneSchedulerTaskResponse dbData = this.sceneSchedulerTaskService.selectBySceneId(vo.getId());
        if (vo.getIsScheduler() != null && vo.getIsScheduler().booleanValue() && vo.getExecuteTime() != null) {
            if (dbData != null) {
                Date executeTime = dbData.getExecuteTime();
                if (executeTime.compareTo(vo.getExecuteTime()) != 0) {
                    SceneSchedulerTaskUpdateRequest updateParam = new SceneSchedulerTaskUpdateRequest();
                    updateParam.setId(dbData.getId());
                    updateParam.setExecuteTime(vo.getExecuteTime());
                    updateParam.setUserId(RestContext.getUser().getId());
                    this.sceneSchedulerTaskService.update(updateParam, Boolean.valueOf(true));
                }
            } else {
                SceneSchedulerTaskCreateRequest insertParam = new SceneSchedulerTaskCreateRequest();
                insertParam.setSceneId(vo.getId());
                insertParam.setExecuteTime(vo.getExecuteTime());
                insertParam.setUserId(RestContext.getUser().getId());
                this.sceneSchedulerTaskService.insert(insertParam);
            }
        } else if (dbData != null) {
            this.sceneSchedulerTaskService.deleteBySceneId(dbData.getSceneId());
        }
        if (!Objects.isNull(vo.getScheduleInterval())) {
            Long scheduleInterval = this.convertTime(Long.valueOf(Long.parseLong(String.valueOf(vo.getScheduleInterval()))), TimeUnitEnum.MINUTE.getValue());
            TimeVO timeVo = vo.getPressureTestTime();
            Long pressureTestSecond = this.convertTime(timeVo.getTime(), timeVo.getUnit());
            if (scheduleInterval > pressureTestSecond) {
                return WebResponse.fail((String)"500", (String)"\u6f0f\u6570\u9a8c\u8bc1\u65f6\u95f4\u95f4\u9694\u4e0d\u80fd\u5927\u4e8e\u538b\u6d4b\u65f6\u957f", (Object[])new Object[0]);
            }
        }
        SceneManageWrapperReq req = new SceneManageWrapperReq();
        WebResponse webResponse = this.sceneManageVo2Req(vo, req, uid);
        vo.setUploadFile(this.sceneScriptRefOpenToVoList(req.getUploadFile()));
        ResponseResult cloudResult = this.sceneManageApi.updateScene(req);
        webResponse.setData(cloudResult.getData());
        webResponse.setSuccess(cloudResult.getSuccess());
        ErrorInfo errorInfo = new ErrorInfo();
        if (cloudResult.getError() != null) {
            errorInfo.setMsg(cloudResult.getError().getMsg());
            webResponse.setError(errorInfo);
        }
        webResponse.setTotal(cloudResult.getTotalNum());
        return webResponse;
    }

    public SceneScriptRefVO sceneScriptRefOpenToVo(SceneScriptRefOpen open) {
        SceneScriptRefVO vo = new SceneScriptRefVO();
        BeanUtils.copyProperties((Object)open, (Object)vo);
        return vo;
    }

    public List<SceneScriptRefVO> sceneScriptRefOpenToVoList(List<SceneScriptRefOpen> source) {
        ArrayList<SceneScriptRefVO> list = new ArrayList<SceneScriptRefVO>();
        if (CollectionUtils.isNotEmpty(source)) {
            source.forEach(open -> list.add(this.sceneScriptRefOpenToVo(open)));
        }
        return list;
    }

    public WebResponse deleteScene(SceneManageIdVO vo) {
        vo.setRequestUrl("/api/scenemanage");
        vo.setHttpMethod(HttpMethod.DELETE);
        return this.httpWebClient.request((WebRequest)vo);
    }

    public ResponseResult<SceneManageWrapperResp> detailScene(Long id) {
        SceneManageIdReq req = new SceneManageIdReq();
        req.setId(id);
        ResponseResult sceneDetail = this.sceneManageApi.getSceneDetail(req);
        if (sceneDetail != null && sceneDetail.getSuccess().booleanValue()) {
            SceneManageWrapperResp data = (SceneManageWrapperResp)sceneDetail.getData();
            SceneSchedulerTaskResponse sceneScheduler = this.sceneSchedulerTaskService.selectBySceneId(id);
            if (sceneScheduler != null && !sceneScheduler.getIsDeleted().booleanValue()) {
                Date executeTime = sceneScheduler.getExecuteTime();
                if (executeTime != null) {
                    data.setIsScheduler(Boolean.valueOf(true));
                    data.setExecuteTime(DateUtils.dateToString((Date)executeTime, (String)"yyyy-MM-dd HH:mm:ss"));
                }
            } else {
                data.setIsScheduler(Boolean.valueOf(false));
            }
            sceneDetail.setData((Object)data);
        }
        return sceneDetail;
    }

    public ScriptCheckDTO checkBusinessActivityAndScript(SceneManageWrapperResp sceneData) {
        int scriptType = sceneData.getScriptType();
        ArrayList scriptList = Lists.newArrayList();
        sceneData.getUploadFile().forEach(data -> scriptList.add(this.buildSceneScriptRef(data)));
        ScriptCheckDTO dto = new ScriptCheckDTO();
        try {
            WebResponse response = this.checkScript(Integer.valueOf(scriptType), (List)scriptList);
            if (!response.getSuccess().booleanValue()) {
                dto.setErrmsg(response.getError().getMsg());
                return dto;
            }
            List execList = (List)response.getData();
            ArrayList businessActivityList = Lists.newArrayList();
            sceneData.getBusinessActivityConfig().forEach(data -> businessActivityList.add(this.buildSceneBusinessActivityRef(data)));
            if (0 == scriptType) {
                dto = this.checkScriptAndActivity(Integer.valueOf(scriptType), false, (List)businessActivityList, execList);
            }
        }
        catch (ApiException apiException) {
            dto.setMatchActivity(Boolean.valueOf(false));
            dto.setPtTag(Boolean.valueOf(false));
        }
        return dto;
    }

    private SceneBusinessActivityRef buildSceneBusinessActivityRef(SceneManageWrapperResp.SceneBusinessActivityRefResp refResp) {
        SceneBusinessActivityRef activityRef = new SceneBusinessActivityRef();
        activityRef.setBusinessActivityId(refResp.getBusinessActivityId());
        activityRef.setBusinessActivityName(refResp.getBusinessActivityName());
        return activityRef;
    }

    private SceneScriptRefOpen buildSceneScriptRef(SceneManageWrapperResp.SceneScriptRefResp scriptRefResp) {
        SceneScriptRefOpen scriptRef = new SceneScriptRefOpen();
        scriptRef.setFileType(scriptRefResp.getFileType());
        scriptRef.setIsDeleted(scriptRefResp.getIsDeleted());
        scriptRef.setId(scriptRefResp.getId());
        scriptRef.setUploadPath(scriptRefResp.getUploadPath());
        return scriptRef;
    }

    private List<SceneBusinessActivityRef> buildSceneBusinessActivityRef(List<SceneBusinessActivityRefVO> voList) {
        ArrayList businessActivityList = Lists.newArrayList();
        voList.forEach(data -> {
            SceneBusinessActivityRef ref = new SceneBusinessActivityRef();
            ref.setBusinessActivityId(data.getBusinessActivityId());
            ref.setBusinessActivityName(data.getBusinessActivityName());
            List ids = this.getAppIdsByNameAndUser(this.getAppsbyId(data.getBusinessActivityId()), null);
            ref.setApplicationIds(this.convertListToString(ids));
            ref.setGoalValue(this.buildGoalValue(data));
            businessActivityList.add(ref);
        });
        return businessActivityList;
    }

    private String buildGoalValue(SceneBusinessActivityRefVO vo) {
        HashMap map = Maps.newHashMap();
        map.put("TPS", vo.getTargetTPS());
        map.put("RT", vo.getTargetRT());
        map.put("successRate", vo.getTargetSuccessRate());
        map.put("SA", vo.getTargetSA());
        return JSON.toJSONString((Object)map);
    }

    private List<SceneScriptRefOpen> buildScriptRef(ScriptManageDeployDetailResponse scriptManageDeployDetail) {
        List fileManageResponseList = scriptManageDeployDetail.getFileManageResponseList();
        if (CollectionUtils.isNotEmpty((Collection)scriptManageDeployDetail.getAttachmentManageResponseList())) {
            fileManageResponseList.addAll(scriptManageDeployDetail.getAttachmentManageResponseList());
        }
        if (CollectionUtils.isEmpty((Collection)fileManageResponseList)) {
            return Collections.emptyList();
        }
        return fileManageResponseList.stream().map(file -> {
            SceneScriptRefOpen ref = new SceneScriptRefOpen();
            ref.setId(file.getId());
            ref.setFileType(scriptManageDeployDetail.getType());
            ref.setFileName(file.getFileName());
            ref.setFileType(file.getFileType());
            ref.setFileSize(file.getFileSize());
            ref.setUploadPath(file.getUploadPath());
            ref.setUploadedData(file.getDataCount());
            ref.setIsSplit(file.getIsSplit());
            HashMap<String, Number> extend = new HashMap<String, Number>(4);
            extend.put("dataCount", file.getDataCount());
            extend.put("isSplit", file.getIsSplit());
            ref.setFileExtend(JsonUtil.bean2Json(extend));
            ref.setIsDeleted(file.getIsDeleted());
            ref.setUploadTime(DateUtils.transferDateToString((Object)file.getUploadTime()));
            return ref;
        }).collect(Collectors.toList());
    }

    private ScriptCheckDTO checkScriptAndActivity(Integer scriptType, boolean absolutePath, List<SceneBusinessActivityRef> businessActivityList, List<SceneScriptRefOpen> scriptList) {
        ScriptCheckDTO dto = new ScriptCheckDTO();
        if (scriptType == null) {
            return new ScriptCheckDTO(Boolean.valueOf(false), Boolean.valueOf(false), "\u65e0\u811a\u672c\u6587\u4ef6");
        }
        if (scriptType == 1) {
            return new ScriptCheckDTO();
        }
        if (this.scriptCheck == null || !this.scriptCheck.booleanValue()) {
            return new ScriptCheckDTO();
        }
        SceneScriptRefOpen sceneScriptRef = scriptList.get(0);
        SceneParseVO vo = new SceneParseVO();
        vo.setScriptId(sceneScriptRef.getId());
        vo.setUploadPath(sceneScriptRef.getUploadPath());
        vo.setRequestUrl("/api/scenemanage/parse/script");
        vo.setHttpMethod(HttpMethod.GET);
        vo.setAbsolutePath(absolutePath);
        WebResponse response = this.httpWebClient.request((WebRequest)vo);
        Map dataMap = (Map)response.getData();
        List voList = dataMap.getOrDefault("requestUrl", new ArrayList());
        log.info("\u4ece\u63a7\u5236\u53f0\u62ff\u53bb\u6570\u636eScriptRefID\uff1a{}", (Object)sceneScriptRef.getId());
        int ptSize = 0;
        if (dataMap.containsKey("ptSize")) {
            ptSize = (Integer)dataMap.get("ptSize");
        }
        List businessActivityIds = businessActivityList.stream().map(SceneBusinessActivityRef::getBusinessActivityId).distinct().collect(Collectors.toList());
        Map urlMap = ListHelper.transferToMap((List)this.TBusinessLinkManageTableMapper.selectByPrimaryKeys(businessActivityIds), BusinessLinkManageTable::getLinkId, BusinessLinkManageTable::getEntrace);
        StringBuffer sb = new StringBuffer();
        businessActivityList.forEach(data -> {
            String url = (String)urlMap.get(data.getBusinessActivityId());
            if (url == null) {
                return;
            }
            ActivityUtil.EntranceJoinEntity entranceJoinEntity = ActivityUtil.covertEntrance((String)url);
            Map map = UrlUtil.convertUrl((ActivityUtil.EntranceJoinEntity)entranceJoinEntity);
            if (CollectionUtils.isEmpty((Collection)voList)) {
                log.error("tro-cloud\u89e3\u6790\u811a\u672c\u6587\u4ef6\u4e2d\u7684url\u5931\u8d25\uff0c\u8fd4\u56de0\u6761,\u53ef\u80fd\u662f\u6ca1\u6709\u627e\u5230\u811a\u672c\u6587\u4ef6\uff0cscriptRefId:{},uploadPath:{}", (Object)sceneScriptRef.getId(), (Object)sceneScriptRef.getUploadPath());
                throw new RuntimeException("\u5bf9\u5e94\u811a\u672c\u6587\u4ef6\u89e3\u6790\u5931\u8d25\uff0c\u67e5\u770b\u811a\u672c\u6587\u4ef6\u662f\u5426\u5b58\u5728\uff01");
            }
            for (Map temp : voList) {
                ScriptUrlVO urlVO = (ScriptUrlVO)JSON.parseObject((String)JSON.toJSONString((Object)temp), ScriptUrlVO.class);
                if (!UrlUtil.checkEqual((String)((String)map.get("url")), (String)urlVO.getPath()).booleanValue() || !urlVO.getEnable().booleanValue()) continue;
                data.setBindRef(urlVO.getName());
                break;
            }
            if (StringUtils.isBlank((CharSequence)data.getBindRef())) {
                sb.append(data.getBusinessActivityName());
                sb.append(",");
            }
        });
        long unbindCount = businessActivityList.stream().filter(data -> data.getBindRef() == null).count();
        if (this.scriptPTCheck.booleanValue() && voList.size() != ptSize) {
            dto.setPtTag(Boolean.valueOf(false));
            dto.setErrmsg("\u7f3a\u5c11\u538b\u6d4b\u6807\u8bc6");
        }
        if (unbindCount > 0L) {
            dto.setMatchActivity(Boolean.valueOf(false));
            if (sb.length() != 0) {
                sb.deleteCharAt(sb.lastIndexOf(","));
                dto.setErrmsg("\u4e1a\u52a1\u6d3b\u52a8\u4e0e\u811a\u672c\u6587\u4ef6\u4e0d\u5339\u914d:" + sb.toString());
            } else {
                dto.setErrmsg("\u4e1a\u52a1\u6d3b\u52a8\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u4e0b\u4e1a\u52a1\u6d3b\u52a8~");
            }
        }
        return dto;
    }

    private WebResponse<List<SceneScriptRefOpen>> checkScript(Integer scriptType, List<SceneScriptRefOpen> scriptList) {
        if (CollectionUtils.isEmpty(scriptList)) {
            return WebResponse.fail((String)"500", (String)"\u627e\u4e0d\u5230\u811a\u672c\u6587\u4ef6", (Object[])new Object[0]);
        }
        List execList = scriptList.stream().filter(data -> data.getFileType() != null && FileTypeEnum.SCRIPT.getCode().equals(data.getFileType()) && data.getIsDeleted() != null && data.getIsDeleted() == 0).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(execList)) {
            return WebResponse.fail((String)"500", (String)"\u627e\u4e0d\u5230\u811a\u672c\u6587\u4ef6", (Object[])new Object[0]);
        }
        if (0 == scriptType && execList.size() > 1) {
            return WebResponse.fail((String)"500", (String)"JMeter\u7c7b\u578b\u7684\u811a\u672c\u6587\u4ef6\u53ea\u5141\u8bb8\u6709\u4e00\u4e2a", (Object[])new Object[0]);
        }
        return WebResponse.success(execList);
    }

    private List<String> getAppIdsByNameAndUser(List<String> nameList, Long userId) {
        if (CollectionUtils.isEmpty(nameList)) {
            return Collections.EMPTY_LIST;
        }
        return this.tApplicationMntDao.queryIdsByNameAndTenant(nameList, userId);
    }

    private List<String> getAppsbyId(Long id) {
        return this.applicationBusinessActivityService.processAppNameByBusinessActiveId(id);
    }

    private String convertListToString(List<String> dataList) {
        if (CollectionUtils.isEmpty(dataList)) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (String data : dataList) {
            sb.append(data);
            sb.append(",");
        }
        sb.deleteCharAt(sb.lastIndexOf(","));
        return sb.toString();
    }

    private Long convertTime(Long time, String unit) {
        if (time == null) {
            return 0L;
        }
        long t = TimeUnitEnum.HOUR.getValue().equals(unit) ? time * 60L * 60L : (TimeUnitEnum.MINUTE.getValue().equals(unit) ? time * 60L : time);
        return t;
    }

    public WebResponse checkParam(SceneManageWrapperVO sceneVO) {
        List activityRefVOList = sceneVO.getBusinessActivityConfig();
        if (CollectionUtils.isEmpty((Collection)activityRefVOList)) {
            return WebResponse.fail((String)"500", (String)"\u4e1a\u52a1\u6d3b\u52a8\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        for (SceneBusinessActivityRefVO sceneBusinessActivityRefVO : activityRefVOList) {
            if (Objects.isNull(sceneBusinessActivityRefVO.getTargetTPS())) {
                return WebResponse.fail((String)"500", (String)"\u76ee\u6807TPS\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            if (Objects.isNull(sceneBusinessActivityRefVO.getTargetRT())) {
                return WebResponse.fail((String)"500", (String)"\u76ee\u6807RT\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            if (Objects.isNull(sceneBusinessActivityRefVO.getTargetSuccessRate())) {
                return WebResponse.fail((String)"500", (String)"\u76ee\u6807\u6210\u529f\u7387\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            if (Objects.isNull(sceneBusinessActivityRefVO.getTargetSA())) {
                return WebResponse.fail((String)"500", (String)"\u76ee\u6807SA\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            if (!sceneVO.getPressureType().equals(0) || sceneVO.getConcurrenceNum() >= sceneVO.getIpNum()) continue;
            return WebResponse.fail((String)"500", (String)"\u6700\u5927\u5e76\u53d1\u6570\u4e0d\u80fd\u5c0f\u4e8eIP\u6570", (Object[])new Object[0]);
        }
        return WebResponse.success();
    }

    public WebResponse buildSceneForFlowVerify(SceneManageWrapperVO vo, SceneManageWrapperReq req, Long userId) {
        return this.sceneManageVo2Req(vo, req, userId);
    }
}

