/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.scene.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.shulie.amdb.common.dto.link.topology.LinkNodeDTO;
import io.shulie.amdb.common.dto.link.topology.LinkTopologyDTO;
import io.shulie.amdb.common.enums.NodeTypeEnum;
import io.shulie.tro.web.amdb.api.ApplicationEntranceClient;
import io.shulie.tro.web.app.service.scene.ApplicationBusinessActivityService;
import io.shulie.tro.web.data.mapper.mysql.BusinessLinkManageTableMapper;
import io.shulie.tro.web.data.mapper.mysql.LinkManageTableMapper;
import io.shulie.tro.web.data.model.mysql.BusinessLinkManageTableEntity;
import io.shulie.tro.web.data.model.mysql.LinkManageTableEntity;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApplicationBusinessActivityServiceImpl
implements ApplicationBusinessActivityService {
    private static final Logger log = LoggerFactory.getLogger(ApplicationBusinessActivityServiceImpl.class);
    @Autowired
    private ApplicationEntranceClient applicationEntranceClient;
    @Resource
    private BusinessLinkManageTableMapper businessLinkManageTableMapper;
    @Resource
    private LinkManageTableMapper linkManageTableMapper;

    public List<String> processAppNameByBusinessActiveId(Long businessActivityId) {
        BusinessLinkManageTableEntity businessLinkManageTableEntity = (BusinessLinkManageTableEntity)this.businessLinkManageTableMapper.selectById((Serializable)businessActivityId);
        if (businessLinkManageTableEntity == null) {
            return Lists.newArrayList();
        }
        LinkManageTableEntity linkManageTableEntity = (LinkManageTableEntity)this.linkManageTableMapper.selectById((Serializable)((Object)businessLinkManageTableEntity.getRelatedTechLink()));
        if (linkManageTableEntity == null) {
            return Lists.newArrayList();
        }
        String features = linkManageTableEntity.getFeatures();
        Map map = Maps.newHashMap();
        if (StringUtils.isNotBlank((String)features)) {
            map = (Map)JSON.parseObject((String)features, Map.class);
        }
        String serviceName = (String)map.get("serviceName");
        String methodName = (String)map.get("method");
        String rpcType = (String)map.get("rpcType");
        String extend = (String)map.get("extend");
        LinkTopologyDTO applicationEntrancesTopology = this.applicationEntranceClient.getApplicationEntrancesTopology(linkManageTableEntity.getApplicationName(), null, serviceName, methodName, rpcType, extend);
        if (applicationEntrancesTopology == null) {
            return Lists.newArrayList();
        }
        List nodes = applicationEntrancesTopology.getNodes();
        if (CollectionUtils.isEmpty((Collection)nodes)) {
            return Lists.newArrayList();
        }
        return nodes.stream().filter(node -> node.getNodeType().equals(NodeTypeEnum.APP.getType())).map(LinkNodeDTO::getNodeName).collect(Collectors.toList());
    }
}

