/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.risk.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.pamirs.tro.common.zk.FormatUtils;
import com.pamirs.tro.entity.dao.report.TReportBottleneckInterfaceMapper;
import com.pamirs.tro.entity.dao.report.TReportMachineMapper;
import com.pamirs.tro.entity.domain.dto.report.ReportDetailDTO;
import com.pamirs.tro.entity.domain.entity.linkmanage.structure.Category;
import com.pamirs.tro.entity.domain.entity.report.ReportBottleneckInterface;
import com.pamirs.tro.entity.domain.entity.report.ReportMachine;
import com.pamirs.tro.entity.domain.risk.BaseAppVo;
import com.pamirs.tro.entity.domain.risk.LinkCount;
import com.pamirs.tro.entity.domain.risk.Metrices;
import com.pamirs.tro.entity.domain.risk.ReportLinkDetail;
import io.shulie.tro.web.app.response.linkmanage.BusinessLinkResponse;
import io.shulie.tro.web.app.service.linkManage.LinkManageService;
import io.shulie.tro.web.app.service.report.impl.ReportDataCache;
import io.shulie.tro.web.app.service.risk.ProblemAnalysisService;
import io.shulie.tro.web.app.service.risk.util.DateUtil;
import io.shulie.tro.web.app.service.scene.ApplicationBusinessActivityService;
import io.shulie.tro.web.app.utils.LinkDataCalcUtil;
import io.shulie.tro.web.app.utils.VolumnUtil;
import io.shulie.tro.web.data.common.InfluxDBManager;
import io.shulie.tro.web.data.dao.baseserver.BaseServerDao;
import io.shulie.tro.web.data.param.baseserver.BaseServerParam;
import io.shulie.tro.web.data.param.baseserver.InfluxAvgParam;
import io.shulie.tro.web.data.param.baseserver.ProcessBaseRiskParam;
import io.shulie.tro.web.data.param.baseserver.TimeMetricsDetailParam;
import io.shulie.tro.web.data.param.baseserver.TimeMetricsParam;
import io.shulie.tro.web.data.result.baseserver.BaseServerResult;
import io.shulie.tro.web.data.result.baseserver.InfluxAvgResult;
import io.shulie.tro.web.data.result.baseserver.LinkDetailResult;
import io.shulie.tro.web.data.result.risk.BaseRiskResult;
import io.shulie.tro.web.data.result.risk.LinkDataResult;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="problemAnalysisService")
public class ProblemAnalysisServiceImpl
implements ProblemAnalysisService {
    public static final String UNKNOW_HTTP = "\u672a\u77e5(HTTP)";
    public static final String UNKNOW_RPC = "\u672a\u77e5(RPC)";
    private static Logger logger = LoggerFactory.getLogger(ProblemAnalysisServiceImpl.class);
    private static String real_time_database = "pradar";
    @Value(value="${risk.max.norm.scale:80D}")
    private Double scale;
    @Value(value="${risk.max.norm.maxLoad:2}")
    private Integer maxLoad;
    @Autowired
    private BaseServerDao baseServerDao;
    @Autowired
    private LinkManageService linkManageService;
    @Autowired
    private ApplicationBusinessActivityService applicationBusinessActivityService;
    @Autowired
    private ReportDataCache reportDataCache;
    @Autowired
    private LinkDataCalcUtil linkDataCalcUtil;
    private ThreadLocal<Integer> totalCountLocal = new ThreadLocal();
    private ThreadLocal<Double> firstRt = new ThreadLocal();
    @Autowired
    private TReportMachineMapper reportMachineMapper;
    @Autowired
    private TReportBottleneckInterfaceMapper reportBottleneckInterfaceMapper;
    @Autowired
    private InfluxDBManager influxDBManager;

    public void syncMachineData(Long reportId) {
        long startTime = System.currentTimeMillis();
        long endTime = System.currentTimeMillis();
        ReportDetailDTO dto = this.reportDataCache.getReportDetail();
        if (StringUtils.isNotBlank((String)dto.getStartTime())) {
            startTime = DateUtil.parseSecondFormatter((String)dto.getStartTime()).getTime();
        }
        if (dto.getEndTime() != null) {
            endTime = dto.getEndTime().getTime();
        }
        long sTime = this.formatTimestamp(startTime);
        long eTime = this.formatTimestamp(endTime);
        ArrayList baseAppVoList = Lists.newArrayList();
        List appNameList = this.reportDataCache.getApplications();
        appNameList.forEach(appName -> {
            Collection baseList = this.baseServerDao.queryBaseServer(new BaseServerParam(sTime, eTime, appName));
            if (CollectionUtils.isNotEmpty((Collection)baseList)) {
                logger.info("\u62a5\u544a{}\u5bf9\u5e94\u7684\u5e94\u7528{},\u67e5\u8be2\u65f6\u95f4\u6bb5\u4e3a\uff1a{}-{},\u5728influx\u4e2d\u5bf9\u5e94\u7684\u6570\u636e\u957f\u5ea6\u4e3a:{}", new Object[]{this.reportDataCache.getReportDetail().getId(), appName, sTime, eTime, baseList.size()});
                List tmpList = baseList.stream().map(base -> {
                    BaseAppVo vo = new BaseAppVo();
                    vo.setCore(Integer.valueOf(this.formatDouble(base.getCpuCores()).intValue()));
                    vo.setDisk(this.formatDouble(base.getDisk()));
                    vo.setMbps(this.formatDouble(base.getNetBandwidth()));
                    vo.setMemory(this.formatDouble(base.getMemory()));
                    vo.setAppIp(base.getTagAppIp());
                    vo.setAppName(appName);
                    vo.setReportId(reportId);
                    vo.setAgentIp(base.getTagAgentId());
                    return vo;
                }).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(tmpList)) {
                    baseAppVoList.addAll(tmpList);
                }
            } else {
                logger.error("\u62a5\u544a{}\u5bf9\u5e94\u7684\u5e94\u7528{},\u67e5\u8be2\u65f6\u95f4\u6bb5\u4e3a\uff1a{}-{},\u5728influx\u4e2d\u5bf9\u5e94\u7684\u6570\u636e\u957f\u5ea6\u4e3a\u7a7a", new Object[]{this.reportDataCache.getReportDetail().getId(), appName, sTime, eTime});
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)baseAppVoList)) {
            Map<String, List<BaseAppVo>> appMap = baseAppVoList.stream().collect(Collectors.groupingBy(arg_0 -> this.fetchApp(arg_0)));
            ArrayList insertList = Lists.newArrayList();
            appMap.values().forEach(value -> {
                BaseAppVo baseAppVo = (BaseAppVo)value.get(0);
                if (baseAppVo != null) {
                    ReportMachine tmp = new ReportMachine();
                    tmp.setReportId(baseAppVo.getReportId());
                    tmp.setMachineIp(baseAppVo.getAppIp());
                    tmp.setApplicationName(baseAppVo.getAppName());
                    tmp.setRiskFlag(Integer.valueOf(0));
                    tmp.setAgentId(baseAppVo.getAgentIp());
                    baseAppVo.setDisk(VolumnUtil.convertByte2Gb((BigDecimal)baseAppVo.getDisk()));
                    baseAppVo.setMemory(VolumnUtil.convertByte2Gb((BigDecimal)baseAppVo.getMemory()));
                    baseAppVo.setAppIp(null);
                    baseAppVo.setAppName(null);
                    baseAppVo.setReportId(null);
                    baseAppVo.setAgentIp(null);
                    tmp.setMachineBaseConfig(JSON.toJSONString((Object)baseAppVo));
                    insertList.add(tmp);
                }
            });
            if (CollectionUtils.isNotEmpty((Collection)insertList)) {
                insertList.forEach(arg_0 -> ((TReportMachineMapper)this.reportMachineMapper).insertOrUpdate(arg_0));
            }
        }
    }

    public void checkRisk(Long reportId) {
        List riskVoList = this.processRisk(reportId);
        if (CollectionUtils.isEmpty((Collection)riskVoList)) {
            logger.error("\u65e0\u98ce\u9669\u673a\u5668{}", (Object)reportId);
            return;
        }
        riskVoList.forEach(vo -> {
            ReportMachine reportMachine = new ReportMachine();
            reportMachine.setReportId(vo.getReportId());
            reportMachine.setApplicationName(vo.getAppName());
            reportMachine.setMachineIp(vo.getAppIp());
            reportMachine.setRiskFlag(Integer.valueOf(1));
            reportMachine.setRiskContent(vo.getContent());
            this.reportMachineMapper.updateRiskContent(reportMachine);
        });
    }

    public List<BaseRiskResult> processRisk(Long reportId) {
        ArrayList results = Lists.newArrayList();
        long startTime = System.currentTimeMillis();
        long endTime = System.currentTimeMillis();
        ReportDetailDTO dto = this.reportDataCache.getReportDetail();
        if (StringUtils.isNotBlank((String)dto.getStartTime())) {
            startTime = DateUtil.parseSecondFormatter((String)dto.getStartTime()).getTime();
        }
        if (dto.getEndTime() != null) {
            endTime = dto.getEndTime().getTime();
        }
        if (CollectionUtils.isEmpty((Collection)dto.getBusinessActivity())) {
            return results;
        }
        long sTime = this.formatTimestamp(startTime);
        long eTime = this.formatTimestamp(endTime);
        dto.getBusinessActivity().stream().forEach(ba -> {
            Long businessActivityId = ba.getBusinessActivityId();
            BigDecimal maxTps = ba.getMaxTps() != null ? ba.getMaxTps() : new BigDecimal("0");
            BigDecimal destTps = BigDecimal.valueOf(Double.parseDouble(ObjectUtils.toString((Object)ba.getTps().getValue(), (String)"0")));
            List appNameList = this.applicationBusinessActivityService.processAppNameByBusinessActiveId(businessActivityId);
            List tmpList = maxTps.compareTo(destTps) > 0 ? this.processOverRisk(appNameList, dto.getSceneId(), reportId, destTps) : this.processBaseRisk(appNameList, sTime, eTime, reportId);
            if (CollectionUtils.isNotEmpty((Collection)tmpList)) {
                results.addAll(tmpList);
            }
        });
        return results;
    }

    public void processBottleneck(Long reportId) {
        long startTime = System.currentTimeMillis();
        long endTime = System.currentTimeMillis();
        ReportDetailDTO dto = this.reportDataCache.getReportDetail();
        if (CollectionUtils.isEmpty((Collection)dto.getBusinessActivity())) {
            return;
        }
        if (StringUtils.isNotBlank((String)dto.getStartTime())) {
            startTime = DateUtil.parseSecondFormatter((String)dto.getStartTime()).getTime();
        }
        if (dto.getEndTime() != null) {
            endTime = dto.getEndTime().getTime();
        }
        long sTime = this.formatTimestamp(startTime);
        long eTime = this.formatTimestamp(endTime);
        ArrayList bottleneckList = Lists.newArrayList();
        dto.getBusinessActivity().stream().forEach(ba -> {
            List linkDataResultList = this.processLinkDataById(ba.getBusinessActivityId(), sTime, eTime);
            if (CollectionUtils.isNotEmpty((Collection)linkDataResultList)) {
                LinkCount linkCount = new LinkCount();
                this.linkDataCalcUtil.calcLinkWeight(linkCount, null, linkDataResultList);
                BigDecimal avg = this.linkDataCalcUtil.calcAvgRate(linkCount.getCount());
                this.linkDataCalcUtil.getBottleneckInterfaces(linkDataResultList, linkCount.getCount(), avg, bottleneckList);
            }
        });
        if (CollectionUtils.isEmpty((Collection)bottleneckList)) {
            return;
        }
        bottleneckList.sort((o1, o2) -> {
            if (o1.getRealWeight().compareTo(o2.getRealWeight()) > 0) {
                return -1;
            }
            if (o1.getRealWeight().compareTo(o2.getRealWeight()) < 0) {
                return 1;
            }
            return 0;
        });
        ArrayList recordList = Lists.newArrayList();
        HashSet sets = Sets.newHashSet();
        int sortNo = 1;
        for (int i = 0; i < bottleneckList.size(); ++i) {
            LinkDataResult data = (LinkDataResult)bottleneckList.get(i);
            String value = data.getAppName() + "|" + data.getEvent();
            if (sets.contains(value)) {
                return;
            }
            sets.add(value);
            ReportBottleneckInterface record = new ReportBottleneckInterface();
            record.setReportId(reportId);
            record.setSortNo(Integer.valueOf(sortNo));
            record.setApplicationName(data.getAppName());
            record.setInterfaceType(data.getEventType());
            record.setInterfaceName(data.getEvent());
            record.setTps(BigDecimal.valueOf(data.getTps()));
            record.setRt(BigDecimal.valueOf(data.getRt()));
            record.setErrorReqs(data.getErrorCount());
            record.setNodeCount(data.getNodeCount());
            record.setBottleneckWeight(data.getRealWeight());
            recordList.add(record);
            ++sortNo;
        }
        this.reportBottleneckInterfaceMapper.insertBatch((List)recordList);
    }

    public ReportLinkDetail queryLinkDetail(Long businessActivityId, Long startTime, Long endTime) {
        ReportLinkDetail detail = new ReportLinkDetail();
        BusinessLinkResponse businessLinkResponse = this.linkManageService.getBussisnessLinkDetail(String.valueOf(businessActivityId));
        if (businessLinkResponse == null || StringUtils.isBlank((String)businessLinkResponse.getLinkName())) {
            return detail;
        }
        String node = businessLinkResponse.getTechLinkResponse().getBody_after();
        if (StringUtils.isBlank((String)node) && StringUtils.isBlank((String)(node = businessLinkResponse.getTechLinkResponse().getBody_before()))) {
            return detail;
        }
        Category category = (Category)JSON.parseObject((String)node, Category.class);
        if (category == null || StringUtils.isBlank((String)category.getApplicationName())) {
            return detail;
        }
        this.removeUnknownNode(category);
        ArrayList parent = Lists.newArrayList();
        long sTime = this.formatTimestamp(startTime.longValue());
        long eTime = this.formatTimestamp(endTime.longValue());
        String traceId = this.queryTraceId(category.getApplicationName(), Long.valueOf(sTime), Long.valueOf(eTime), category.getEvent());
        HashMap aggMap = Maps.newHashMap();
        this.buildLinkDetail(true, category.getApplicationName(), (List)parent, Arrays.asList(category), sTime, eTime, traceId, (Map)aggMap);
        if (CollectionUtils.isNotEmpty((Collection)parent)) {
            detail = (ReportLinkDetail)parent.get(0);
        }
        return detail;
    }

    private Category removeUnknownNode(Category category) {
        if (null == category) {
            return category;
        }
        String appName = category.getApplicationName();
        if (UNKNOW_HTTP.equals(appName) || UNKNOW_RPC.equals(appName)) {
            category = null;
            return category;
        }
        if (null == category.getChildren() || category.getChildren().isEmpty()) {
            return category;
        }
        Iterator iterator = category.getChildren().iterator();
        while (iterator.hasNext()) {
            Category child = this.removeUnknownNode((Category)iterator.next());
            if (null != child) continue;
            iterator.remove();
        }
        return category;
    }

    private String queryTraceId(String appName, Long sTime, Long eTime, String event) {
        String traceId = "";
        InfluxAvgParam influxAvgParam = new InfluxAvgParam();
        influxAvgParam.setSTime(sTime);
        influxAvgParam.setETime(eTime);
        influxAvgParam.setAppName(appName);
        influxAvgParam.setEvent(event);
        Collection influxAvgVOS = this.baseServerDao.queryTraceId(influxAvgParam);
        if (CollectionUtils.isEmpty((Collection)influxAvgVOS)) {
            return traceId;
        }
        Collection sortedList = influxAvgVOS.stream().sorted(Comparator.comparingDouble(InfluxAvgResult::getRt)).collect(Collectors.toList());
        return ((InfluxAvgResult)sortedList.stream().findFirst().get()).getTraceId();
    }

    private void buildLinkDetail(boolean isParent, String invokeName, List<ReportLinkDetail> parent, List<Category> subList, long stime, long eTime, String traceId, Map<String, String> aggMap) {
        if (CollectionUtils.isEmpty(subList)) {
            return;
        }
        for (int i = 0; i < subList.size(); ++i) {
            Category tmp = subList.get(i);
            ReportLinkDetail data = new ReportLinkDetail();
            data.setAppName(tmp.getApplicationName());
            data.setEvent(tmp.getEvent());
            if (aggMap.containsKey(invokeName + tmp.getEvent())) continue;
            aggMap.put(invokeName + tmp.getEvent(), "");
            data.setServiceName(tmp.getServiceDetail());
            data.setEvent(tmp.getEvent());
            LinkDetailResult tmpDetail = this.queryTimeMetricsDetail(invokeName, tmp.getEvent(), tmp.getServiceType(), tmp.getApplicationName(), stime, eTime);
            data.setEventType(tmp.getServiceType());
            data.setMinRt(tmpDetail.getMinRt() == null || tmpDetail.getMinRt() == 0.0 ? "< 1ms" : FormatUtils.humanReadableTimeSpan((long)tmpDetail.getMinRt().longValue()));
            data.setMaxRt(tmpDetail.getMaxRt() == null || tmpDetail.getMaxRt() == 0.0 ? "< 1ms" : FormatUtils.humanReadableTimeSpan((long)tmpDetail.getMaxRt().longValue()));
            data.setAvgRt(Double.valueOf(tmpDetail.getAvgRt() == null ? 0.0 : tmpDetail.getAvgRt()));
            data.setTotalCount(tmpDetail.getTotalCount());
            data.setUuid(UUID.randomUUID().toString());
            data.setTps(tmpDetail.getTps());
            if (isParent) {
                data.setRequestRate(Double.valueOf(1.0));
                this.totalCountLocal.set(data.getTotalCount());
                this.firstRt.set(tmpDetail.getAvgRt());
            } else {
                Integer totalCount = (Integer)this.totalCountLocal.get();
                Integer totalDetail = tmpDetail.getTotalCount();
                if (totalCount == 0) {
                    data.setRequestRate(Double.valueOf(0.0));
                } else {
                    data.setRequestRate(Double.valueOf(this.formatDouble(Double.valueOf(totalDetail.doubleValue() / (double)totalCount.intValue())).doubleValue()));
                }
                if (tmpDetail.getAvgRt() > (Double)this.firstRt.get()) {
                    data.setAvgRt((Double)this.firstRt.get());
                }
            }
            data.setTraceId(traceId);
            if (StringUtils.isNotBlank((String)tmpDetail.getAppName())) {
                data.setAppName(tmpDetail.getAppName());
            }
            parent.add(data);
            List sub = tmp.getChildren();
            if (!CollectionUtils.isNotEmpty((Collection)sub)) continue;
            data.setChildren((List)Lists.newArrayList());
            this.buildLinkDetail(false, data.getAppName(), data.getChildren(), sub, stime, eTime, traceId, aggMap);
        }
    }

    private List<LinkDataResult> processLinkDataById(Long businessActivityId, long sTime, long eTime) {
        ArrayList linkDataResultList = Lists.newArrayList();
        BusinessLinkResponse businessLinkResponse = this.linkManageService.getBussisnessLinkDetail(String.valueOf(businessActivityId));
        if (businessLinkResponse == null || StringUtils.isBlank((String)businessLinkResponse.getLinkName())) {
            return linkDataResultList;
        }
        String node = businessLinkResponse.getTechLinkResponse().getBody_after();
        if (StringUtils.isBlank((String)node) && StringUtils.isBlank((String)(node = businessLinkResponse.getTechLinkResponse().getBody_before()))) {
            return linkDataResultList;
        }
        Category category = (Category)JSON.parseObject((String)node, Category.class);
        if (category == null || StringUtils.isBlank((String)category.getApplicationName())) {
            return linkDataResultList;
        }
        this.buildLink(category.getApplicationName(), (List)linkDataResultList, category.getChildren(), sTime, eTime);
        return linkDataResultList;
    }

    private void buildLink(String invokeName, List<LinkDataResult> parent, List<Category> subList, long stime, long eTime) {
        if (CollectionUtils.isEmpty(subList)) {
            return;
        }
        for (int i = 0; i < subList.size(); ++i) {
            Category tmp = subList.get(i);
            LinkDataResult data = new LinkDataResult();
            data.setAppName(tmp.getApplicationName());
            data.setEvent(tmp.getEvent());
            data.setServiceName(tmp.getServiceDetail());
            LinkDataResult tmpData = this.queryTimeMetrics(invokeName, tmp.getEvent(), tmp.getServiceType(), tmp.getApplicationName(), stime, eTime);
            data.setEventType(tmp.getServiceType());
            data.setRt(tmpData.getRt());
            data.setTps(tmpData.getTps());
            data.setErrorCount(tmpData.getErrorCount());
            if (StringUtils.isNotBlank((String)tmpData.getAppName())) {
                data.setAppName(tmpData.getAppName());
            }
            parent.add(data);
            List sub = tmp.getChildren();
            if (!CollectionUtils.isNotEmpty((Collection)sub)) continue;
            this.buildLink(data.getAppName(), data.getSubLink(), sub, stime, eTime);
        }
    }

    private LinkDetailResult queryTimeMetricsDetail(String invokeApp, String event, String rpcType, String appName, long sTime, long eTime) {
        TimeMetricsDetailParam param = new TimeMetricsDetailParam();
        param.setAppName(appName);
        param.setETime(eTime);
        param.setSTime(sTime);
        param.setInvokeApp(invokeApp);
        param.setEvent(event);
        param.setRpcType(rpcType);
        return this.baseServerDao.queryTimeMetricsDetail(param);
    }

    private LinkDataResult queryTimeMetrics(String invokeApp, String event, String rpcType, String appName, long sTime, long eTime) {
        TimeMetricsParam param = new TimeMetricsParam();
        param.setAppName(appName);
        param.setETime(eTime);
        param.setSTime(sTime);
        param.setInvokeApp(invokeApp);
        param.setEvent(event);
        param.setRpcType(rpcType);
        return this.baseServerDao.queryTimeMetrics(param);
    }

    private List<BaseRiskResult> processBaseRisk(List<String> appNames, long startTime, long endTime, Long reportId) {
        ProcessBaseRiskParam param = new ProcessBaseRiskParam();
        param.setAppNames(appNames);
        param.setEndTime(endTime);
        param.setReportId(reportId);
        param.setStartTime(startTime);
        return this.baseServerDao.queryProcessBaseRisk(param);
    }

    private List<BaseRiskResult> processOverRisk(List<String> appNames, Long sceneId, Long reportId, BigDecimal destTps) {
        ArrayList results = Lists.newArrayList();
        if (CollectionUtils.isEmpty(appNames)) {
            return results;
        }
        List metrices = this.reportDataCache.getAllMetricsData();
        if (CollectionUtils.isEmpty((Collection)metrices)) {
            logger.error("metrices is null,{}", (Object)reportId);
            return results;
        }
        List sortMetrics = metrices.stream().sorted(Comparator.comparing(Metrices::getExtTime)).collect(Collectors.toList());
        Metrices firstMetrices = (Metrices)sortMetrics.get(0);
        Metrices lastMetrices = (Metrices)sortMetrics.get(sortMetrics.size() - 1);
        long firstTime = this.formatTimestamp(firstMetrices.getExtTime() - 60000L);
        long lastTime = this.formatTimestamp(lastMetrices.getExtTime() + 60000L);
        List metricesList = metrices;
        appNames.forEach(appName -> {
            String ipSql = "select distinct(app_ip) as app_ip from app_base_data where app_name = '" + appName + "' and time > " + firstTime + " and time <= " + lastTime;
            Collection ipList = this.influxDBManager.query(BaseServerResult.class, ipSql);
            if (CollectionUtils.isNotEmpty((Collection)ipList)) {
                ArrayList calMetricesList = Lists.newArrayList();
                ipList.forEach(ip -> {
                    String tmpSql = "select mean(cpu_rate) as cpu_rate,mean(cpu_load) as cpu_load,mean(mem_rate) as mem_rate,mean(iowait) as iowait,mean(net_bandwidth_rate) as net_bandwidth_rate from app_base_data where tag_app_name = '" + appName + "' and tag_app_ip = '" + ip.getAppIp() + "' and time > " + firstTime + " and time <= " + lastTime + " group by time(5s) order by time";
                    Collection voList = this.influxDBManager.query(BaseServerResult.class, tmpSql);
                    if (CollectionUtils.isNotEmpty((Collection)voList)) {
                        Map<Long, List<BaseServerResult>> voMap = voList.stream().collect(Collectors.groupingBy(BaseServerResult::getExtTime));
                        metricesList.forEach(metricesTmp -> {
                            BaseServerResult tmpVo = new BaseServerResult();
                            Long time = metricesTmp.getExtTime() - 5000L;
                            List tmpBaseVoList = (List)voMap.get(time);
                            if (CollectionUtils.isNotEmpty((Collection)tmpBaseVoList)) {
                                tmpVo = (BaseServerResult)tmpBaseVoList.stream().findFirst().get();
                                tmpVo.setTps(metricesTmp.getAvgTps());
                                tmpVo.setTime(Instant.ofEpochMilli(metricesTmp.getExtTime()));
                                tmpVo.setAppIp(ip.getAppIp());
                                tmpVo.setAppName(appName);
                                calMetricesList.add(tmpVo);
                            }
                        });
                        List tmpRiskList = this.matchRisk((Collection)calMetricesList, destTps, reportId);
                        if (CollectionUtils.isNotEmpty((Collection)tmpRiskList)) {
                            results.addAll(tmpRiskList);
                        }
                    }
                });
            }
        });
        return results;
    }

    private List<BaseRiskResult> matchRisk(Collection<BaseServerResult> voList, BigDecimal destTps, Long reportId) {
        List moreList;
        ArrayList riskVoList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(voList)) {
            return riskVoList;
        }
        BaseServerResult tmpVo = voList.stream().findFirst().orElse(new BaseServerResult());
        String appIp = tmpVo.getAppIp();
        String appName = tmpVo.getAppName();
        Collection sortedList = voList.stream().filter(sort -> sort.getTps() != null).sorted(Comparator.comparingDouble(BaseServerResult::getTps)).collect(Collectors.toList());
        List lessList = sortedList.stream().filter(sort -> sort.getTps() != null).filter(sort -> sort.getTps().compareTo(destTps.doubleValue()) < 0).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(lessList)) {
            String content;
            BaseServerResult netBandWidthRate;
            BaseServerResult ioWait;
            BaseServerResult memRate;
            BaseServerResult cpuLoad;
            BaseRiskResult risk = new BaseRiskResult();
            risk.setAppIp(appIp);
            risk.setAppName(appName);
            risk.setReportId(reportId);
            BaseServerResult cpuRate = lessList.stream().filter(less -> less.getCpuRate() != null).max(Comparator.comparing(BaseServerResult::getCpuRate)).orElse(new BaseServerResult());
            StringBuilder stringBuilder = new StringBuilder();
            if (cpuRate.getCpuRate() != null && cpuRate.getCpuRate() >= this.scale) {
                stringBuilder.append("cpu\u4f7f\u7528\u7387\u8d85\u8fc7").append(this.formatDouble(cpuRate.getCpuRate())).append("%;");
            }
            if ((cpuLoad = lessList.stream().filter(less -> less.getCpuLoad() != null).max(Comparator.comparing(BaseServerResult::getCpuLoad)).orElse(new BaseServerResult())).getCpuLoad() != null && cpuLoad.getCpuLoad() >= (double)this.maxLoad.intValue()) {
                stringBuilder.append("cpuLoad\u8d85\u8fc7").append(this.formatDouble(cpuLoad.getCpuLoad())).append("; ");
            }
            if ((memRate = lessList.stream().filter(less -> less.getMemRate() != null).max(Comparator.comparing(BaseServerResult::getMemRate)).orElse(new BaseServerResult())).getMemRate() != null && memRate.getMemRate() >= this.scale) {
                stringBuilder.append("\u6700\u5927\u5185\u5b58\u4f7f\u7528\u7387\u8d85\u8fc7").append(this.formatDouble(memRate.getMemRate())).append("%;");
            }
            if ((ioWait = lessList.stream().filter(less -> less.getIoWait() != null).max(Comparator.comparing(BaseServerResult::getIoWait)).orElse(new BaseServerResult())).getIoWait() != null && ioWait.getIoWait() >= this.scale) {
                stringBuilder.append("\u6700\u5927IoWait").append(this.formatDouble(ioWait.getIoWait())).append("%;");
            }
            if ((netBandWidthRate = lessList.stream().filter(less -> less.getNetBandWidthRate() != null).max(Comparator.comparing(BaseServerResult::getNetBandWidthRate)).orElse(new BaseServerResult())).getNetBandWidthRate() != null && netBandWidthRate.getNetBandWidthRate() >= this.scale) {
                stringBuilder.append("\u7f51\u7edc\u5e26\u5bbd\u4f7f\u7528\u7387\u8d85\u8fc7").append(this.formatDouble(netBandWidthRate.getNetBandWidthRate())).append("%;");
            }
            if (StringUtils.isNotBlank((String)(content = stringBuilder.toString()))) {
                risk.setContent(content.substring(0, content.lastIndexOf(";")));
                riskVoList.add(risk);
            }
        }
        if (CollectionUtils.isNotEmpty(moreList = sortedList.stream().filter(sort -> sort.getTps() != null).filter(sort -> sort.getTps().compareTo(destTps.doubleValue()) > 0).collect(Collectors.toList()))) {
            BigDecimal mid = destTps.multiply(BigDecimal.valueOf(0.05));
            BigDecimal max = this.formatDouble(Double.valueOf(mid.add(destTps).doubleValue()));
            BigDecimal min = this.formatDouble(Double.valueOf(destTps.subtract(mid).doubleValue()));
            List midList = sortedList.stream().filter(sort -> sort.getTps() != null).filter(sort -> BigDecimal.valueOf(sort.getTps()).compareTo(min) >= 0 && BigDecimal.valueOf(sort.getTps()).compareTo(max) <= 0).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(midList)) {
                String content;
                BaseRiskResult risk = new BaseRiskResult();
                risk.setAppIp(appIp);
                risk.setAppName(appName);
                StringBuilder stringBuilder = new StringBuilder();
                Double cpuRate = midList.stream().filter(Objects::nonNull).mapToDouble(BaseServerResult::getCpuRate).average().orElse(0.0);
                Double cpuLoad = midList.stream().filter(Objects::nonNull).mapToDouble(BaseServerResult::getCpuLoad).average().orElse(0.0);
                Double cpuMemRate = midList.stream().filter(Objects::nonNull).mapToDouble(BaseServerResult::getMemRate).average().orElse(0.0);
                Double ioWait = midList.stream().filter(Objects::nonNull).mapToDouble(BaseServerResult::getIoWait).average().orElse(0.0);
                Double netBandWidthRate = midList.stream().filter(Objects::nonNull).mapToDouble(BaseServerResult::getNetBandWidthRate).average().orElse(0.0);
                if (cpuRate >= this.scale) {
                    stringBuilder.append("cpu\u4f7f\u7528\u7387\u8d85\u8fc7").append(this.formatDouble(cpuRate)).append("%;");
                }
                if (cpuLoad >= (double)this.maxLoad.intValue()) {
                    stringBuilder.append("cpuLoad\u8d85\u8fc7").append(this.formatDouble(cpuLoad)).append("; ");
                }
                if (cpuMemRate >= this.scale) {
                    stringBuilder.append("\u6700\u5927\u5185\u5b58\u4f7f\u7528\u7387\u8d85\u8fc7").append(this.formatDouble(cpuMemRate)).append("%;");
                }
                if (ioWait >= this.scale) {
                    stringBuilder.append("\u6700\u5927IoWait").append(this.formatDouble(ioWait)).append("%;");
                }
                if (netBandWidthRate >= this.scale) {
                    stringBuilder.append("\u7f51\u7edc\u5e26\u5bbd\u4f7f\u7528\u7387\u8d85\u8fc7").append(this.formatDouble(netBandWidthRate)).append("%;");
                }
                if (StringUtils.isNotBlank((String)(content = stringBuilder.toString()))) {
                    risk.setContent(content.substring(0, content.lastIndexOf(";")));
                    riskVoList.add(risk);
                }
            }
        }
        return riskVoList;
    }

    private long formatTimestamp(long timestamp) {
        String temp = timestamp + "000000";
        return Long.parseLong(temp);
    }

    private BigDecimal formatDouble(Double data) {
        if (data == null) {
            return new BigDecimal("0");
        }
        BigDecimal b = BigDecimal.valueOf(data);
        return b.setScale(2, 4);
    }

    private String fetchApp(BaseAppVo vo) {
        return vo.getReportId() + vo.getAppIp() + vo.getAppName();
    }

    private String fetchRisk(BaseRiskResult vo) {
        return vo.getReportId() + vo.getAppIp() + vo.getAppName();
    }

    private String fetchMachine(ReportMachine vo) {
        return vo.getReportId() + vo.getMachineIp() + vo.getApplicationName();
    }
}

