/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.report.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.pamirs.tro.common.util.DateUtils;
import com.pamirs.tro.entity.dao.report.TReportApplicationSummaryMapper;
import com.pamirs.tro.entity.dao.report.TReportBottleneckInterfaceMapper;
import com.pamirs.tro.entity.dao.report.TReportMachineMapper;
import com.pamirs.tro.entity.dao.report.TReportSummaryMapper;
import com.pamirs.tro.entity.domain.entity.report.ReportApplicationSummary;
import com.pamirs.tro.entity.domain.entity.report.ReportMachine;
import com.pamirs.tro.entity.domain.entity.report.ReportSummary;
import com.pamirs.tro.entity.domain.entity.report.TpsTarget;
import com.pamirs.tro.entity.domain.entity.report.TpsTargetArray;
import com.pamirs.tro.entity.domain.risk.Metrices;
import io.shulie.tro.web.app.service.report.ReportService;
import io.shulie.tro.web.app.service.report.impl.ReportDataCache;
import io.shulie.tro.web.common.domain.WebResponse;
import io.shulie.tro.web.data.common.InfluxDBManager;
import io.shulie.tro.web.data.result.baseserver.BaseServerResult;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SummaryService {
    private static final Logger log = LoggerFactory.getLogger(SummaryService.class);
    @Resource
    private TReportBottleneckInterfaceMapper TReportBottleneckInterfaceMapper;
    @Resource
    private TReportApplicationSummaryMapper TReportApplicationSummaryMapper;
    @Autowired
    private ReportService reportService;
    @Resource
    private TReportSummaryMapper TReportSummaryMapper;
    @Resource
    private TReportMachineMapper TReportMachineMapper;
    @Autowired
    private ReportDataCache reportDataCache;
    @Autowired
    private InfluxDBManager influxDBManager;

    public void calcApplicationSummary(Long reportId) {
        List dataList = this.TReportMachineMapper.selectCountByReport(reportId);
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return;
        }
        ArrayList applications = Lists.newArrayList();
        for (Map dataMap : dataList) {
            String applicationName = (String)dataMap.get("application_name");
            if (StringUtils.isBlank((CharSequence)applicationName)) continue;
            Integer totalCount = this.convertLong((Long)dataMap.get("count"));
            Integer riskCount = this.convertBigDecimal((BigDecimal)dataMap.get("riskSum"));
            ReportApplicationSummary application = new ReportApplicationSummary();
            application.setReportId(reportId);
            application.setApplicationName(applicationName);
            application.setMachineTotalCount(totalCount);
            application.setMachineRiskCount(riskCount);
            applications.add(application);
        }
        if (CollectionUtils.isEmpty((Collection)applications)) {
            return;
        }
        applications.forEach(arg_0 -> ((TReportApplicationSummaryMapper)this.TReportApplicationSummaryMapper).insertOrUpdate(arg_0));
    }

    public void calcReportSummay(Long reportId) {
        Map cloudMap;
        Integer bottleneckInterfaceCount = this.convertLong(this.TReportBottleneckInterfaceMapper.selectCountByReportId(reportId));
        Integer appCount = 0;
        Integer totalCount = 0;
        Integer riskCount = 0;
        Map countMap = this.TReportApplicationSummaryMapper.selectCountByReportId(reportId);
        if (MapUtils.isNotEmpty((Map)countMap)) {
            appCount = this.convertLong((Long)countMap.get("count"));
            totalCount = this.convertBigDecimal((BigDecimal)countMap.get("totalSum"));
            riskCount = this.convertBigDecimal((BigDecimal)countMap.get("riskSum"));
        }
        Integer warnCount = 0;
        Integer businessCount = 0;
        Integer passBusinessCount = 0;
        WebResponse response = this.reportService.queryReportCount(reportId);
        if (response != null && response.getData() != null && MapUtils.isNotEmpty((Map)(cloudMap = (Map)response.getData()))) {
            warnCount = (Integer)cloudMap.get("warnCount");
            businessCount = (Integer)cloudMap.get("count");
            passBusinessCount = (Integer)cloudMap.get("passSum");
        }
        warnCount = warnCount != null ? warnCount : 0;
        businessCount = businessCount != null ? businessCount : 0;
        passBusinessCount = passBusinessCount != null ? passBusinessCount : 0;
        ReportSummary reportSummary = new ReportSummary();
        reportSummary.setReportId(reportId);
        reportSummary.setBottleneckInterfaceCount(bottleneckInterfaceCount);
        reportSummary.setRiskMachineCount(riskCount);
        reportSummary.setBusinessActivityCount(businessCount);
        reportSummary.setUnachieveBusinessActivityCount(Integer.valueOf(businessCount - passBusinessCount));
        reportSummary.setApplicationCount(appCount);
        reportSummary.setMachineCount(totalCount);
        reportSummary.setWarnCount(warnCount);
        ReportSummary summary = this.TReportSummaryMapper.selectOneByReportId(reportId);
        if (summary == null) {
            this.TReportSummaryMapper.insert(reportSummary);
        }
        log.info("Build ReportSummary Success, reportId={}", (Object)reportId);
    }

    public void calcTpsTarget(Long reportId) {
        List metrics = this.reportDataCache.getAllMetricsData();
        if (CollectionUtils.isEmpty((Collection)metrics)) {
            return;
        }
        List applications = this.reportDataCache.getApplications();
        if (CollectionUtils.isEmpty((Collection)applications)) {
            return;
        }
        Long minTime = metrics.stream().map(data -> data.getExtTime()).min(Long::compareTo).get();
        Long maxTime = metrics.stream().map(data -> data.getExtTime()).max(Long::compareTo).get();
        minTime = minTime - 5000L;
        maxTime = maxTime + 15000L;
        for (String applicationName : applications) {
            Collection appIds = this.influxDBManager.query(BaseServerResult.class, "select distinct(app_ip) as app_ip from app_base_data where time>=" + minTime + "ms and time <= " + maxTime + "ms and app_name = '" + applicationName + "'");
            if (CollectionUtils.isEmpty((Collection)appIds)) continue;
            List hosts = appIds.stream().map(data -> data.getAppIp()).collect(Collectors.toList());
            for (String host : hosts) {
                Collection bases = this.influxDBManager.query(BaseServerResult.class, "select time, app_ip, cpu_rate, cpu_load, mem_rate, iowait, net_bandwidth_rate from app_base_data where time>=" + minTime + "ms and time <= " + maxTime + "ms and app_name = '" + applicationName + "' and app_ip = '" + host + "'");
                TpsTargetArray array = this.calcTpsTarget(metrics, bases);
                if (array == null) continue;
                ReportMachine reportMachine = new ReportMachine();
                reportMachine.setReportId(reportId);
                reportMachine.setApplicationName(applicationName);
                reportMachine.setMachineIp(host);
                reportMachine.setMachineTpsTargetConfig(JSON.toJSONString((Object)array));
                this.TReportMachineMapper.updateTpsTargetConfig(reportMachine);
            }
        }
    }

    private TpsTargetArray calcTpsTarget(List<Metrices> metrics, Collection<BaseServerResult> vos) {
        if (CollectionUtils.isEmpty(vos)) {
            return null;
        }
        ArrayList bases = Lists.newArrayList(vos);
        int currentIndex = 0;
        ArrayList targets = Lists.newArrayList();
        for (int i = 0; i < metrics.size(); ++i) {
            TpsTarget target = new TpsTarget();
            target.setTime(this.convertLongToTime(Long.valueOf(metrics.get(i).getExtTime())));
            target.setTps(Integer.valueOf(metrics.get(i).getAvgTps().intValue()));
            for (int j = currentIndex; j < bases.size(); ++j) {
                if (((BaseServerResult)bases.get(j)).getExtTime() <= metrics.get(i).getExtTime()) continue;
                if (currentIndex < j) {
                    Double cpu = bases.subList(currentIndex, j).stream().filter(data -> data.getCpuRate() != null).mapToDouble(data -> data.getCpuRate()).average().orElse(0.0);
                    Double loading = bases.subList(currentIndex, j).stream().filter(data -> data.getCpuLoad() != null).mapToDouble(data -> data.getCpuLoad()).average().orElse(0.0);
                    Double memory = bases.subList(currentIndex, j).stream().filter(data -> data.getMemRate() != null).mapToDouble(data -> data.getMemRate()).average().orElse(0.0);
                    Double io = bases.subList(currentIndex, j).stream().filter(data -> data.getIoWait() != null).mapToDouble(data -> data.getIoWait()).average().orElse(0.0);
                    Double mbps = bases.subList(currentIndex, j).stream().filter(data -> data.getNetBandWidthRate() != null).mapToDouble(data -> data.getNetBandWidthRate()).average().orElse(0.0);
                    target.setCpu(new BigDecimal(cpu.intValue()));
                    target.setLoading(new BigDecimal(loading).setScale(2, RoundingMode.HALF_UP));
                    target.setMemory(new BigDecimal(memory).setScale(2, RoundingMode.HALF_UP));
                    target.setIo(new BigDecimal(io).setScale(2, RoundingMode.HALF_UP));
                    target.setNetwork(new BigDecimal(mbps).setScale(2, RoundingMode.HALF_UP));
                }
                currentIndex = j;
                break;
            }
            if (target.getCpu() == null) continue;
            targets.add(target);
        }
        if (CollectionUtils.isEmpty((Collection)targets)) {
            return null;
        }
        return this.convert2TpsTargetArray((List)targets);
    }

    private Integer convertLong(Long param) {
        if (param == null) {
            return 0;
        }
        return param.intValue();
    }

    private Integer convertBigDecimal(BigDecimal param) {
        if (param == null) {
            return 0;
        }
        return param.intValue();
    }

    private TpsTargetArray convert2TpsTargetArray(List<TpsTarget> tpsList) {
        if (CollectionUtils.isEmpty(tpsList)) {
            return null;
        }
        String[] time = new String[tpsList.size()];
        Integer[] tps = new Integer[tpsList.size()];
        BigDecimal[] cpu = new BigDecimal[tpsList.size()];
        BigDecimal[] loading = new BigDecimal[tpsList.size()];
        BigDecimal[] memory = new BigDecimal[tpsList.size()];
        BigDecimal[] io = new BigDecimal[tpsList.size()];
        BigDecimal[] network = new BigDecimal[tpsList.size()];
        for (int i = 0; i < tpsList.size(); ++i) {
            time[i] = tpsList.get(i).getTime();
            tps[i] = tpsList.get(i).getTps();
            cpu[i] = tpsList.get(i).getCpu();
            loading[i] = tpsList.get(i).getLoading();
            memory[i] = tpsList.get(i).getMemory();
            io[i] = tpsList.get(i).getIo();
            network[i] = tpsList.get(i).getNetwork();
        }
        TpsTargetArray array = new TpsTargetArray();
        array.setTime(time);
        array.setTps(tps);
        array.setCpu(cpu);
        array.setLoading(loading);
        array.setMemory(memory);
        array.setIo(io);
        array.setNetwork(network);
        return array;
    }

    private String convertLongToTime(Long time) {
        if (time == null) {
            return null;
        }
        String date = DateUtils.transferDate((Object)time);
        if (StringUtils.length((CharSequence)date) == 19) {
            return date.substring(11);
        }
        return date;
    }
}

