/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.report.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import io.shulie.tro.cloud.common.redis.RedisClientUtils;
import io.shulie.tro.cloud.open.req.report.UpdateReportConclusionReq;
import io.shulie.tro.common.beans.response.ResponseResult;
import io.shulie.tro.web.app.service.report.ReportService;
import io.shulie.tro.web.app.service.report.ReportTaskService;
import io.shulie.tro.web.app.service.report.impl.ReportClearService;
import io.shulie.tro.web.app.service.report.impl.ReportDataCache;
import io.shulie.tro.web.app.service.report.impl.SummaryService;
import io.shulie.tro.web.app.service.risk.ProblemAnalysisService;
import io.shulie.tro.web.common.domain.WebResponse;
import io.shulie.tro.web.data.dao.leakverify.LeakVerifyResultDAO;
import io.shulie.tro.web.diff.api.scenetask.SceneTaskApi;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportTaskServiceImpl
implements ReportTaskService {
    private static final Logger log = LoggerFactory.getLogger(ReportTaskServiceImpl.class);
    private static final String MYSQL_UNIQUE_ERROR = "MySQLIntegrityConstraintViolationException: Duplicate entry";
    private static AtomicBoolean RUNNINT = new AtomicBoolean(false);
    @Autowired
    private ReportDataCache reportDataCache;
    @Autowired
    private ReportService reportService;
    @Autowired
    private ProblemAnalysisService problemAnalysisService;
    @Autowired
    private SummaryService summaryService;
    @Autowired
    private ReportClearService reportClearService;
    @Autowired
    private RedisClientUtils redisClientUtils;
    @Autowired
    private LeakVerifyResultDAO leakVerifyResultDAO;
    @Autowired
    private SceneTaskApi sceneTaskApi;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryReport() {
        try {
            if (RUNNINT.get()) {
                return;
            }
            if (!RUNNINT.compareAndSet(false, true)) {
                return;
            }
            ArrayList reportIds = Lists.newArrayList();
            WebResponse runningResponse = this.reportService.queryListRunningReport();
            if (runningResponse.getSuccess().booleanValue() && runningResponse.getData() != null) {
                reportIds.addAll((List)runningResponse.getData());
            }
            for (int i = 0; i < reportIds.size(); ++i) {
                Long reportId = Long.valueOf(reportIds.get(i).toString());
                this.reportDataCache.readyCloudReportData(reportId);
                Date endTime = null;
                if (this.reportDataCache.getReportDetail() != null) {
                    endTime = this.reportDataCache.getReportDetail().getEndTime();
                }
                try {
                    Boolean isLeaked;
                    if (endTime != null) {
                        WebResponse lockResponse = this.reportService.lockReport(reportId);
                        if (!lockResponse.getSuccess().booleanValue() || lockResponse.getData() == null || !((Boolean)lockResponse.getData()).booleanValue()) {
                            log.info("Lock Running Report Data Failure, reportId={}...", (Object)reportId);
                        }
                        log.info("\u538b\u6d4b\u7ed3\u675f\uff0clock Running Report success :{}", (Object)reportId);
                        log.info("\u538b\u6d4b\u7ed3\u675f\uff0c\u6570\u636e\u6c47\u603b Running Report :{}", (Object)reportId);
                    }
                    Long startTime = System.currentTimeMillis();
                    log.info("\u6536\u96c6 Running Report \u6570\u636e:{}", (Object)reportId);
                    this.problemAnalysisService.syncMachineData(reportId);
                    if (endTime != null) {
                        this.problemAnalysisService.checkRisk(reportId);
                        this.problemAnalysisService.processBottleneck(reportId);
                    }
                    this.summaryService.calcTpsTarget(reportId);
                    this.summaryService.calcApplicationSummary(reportId);
                    if (endTime == null) continue;
                    this.summaryService.calcReportSummay(reportId);
                    WebResponse webResponse = this.reportService.finishReport(reportId);
                    if (!webResponse.getSuccess().booleanValue() || !((Boolean)webResponse.getData()).booleanValue()) {
                        log.info("\u538b\u6d4b\u7ed3\u675f\u5931\u8d25 Report :{}\uff0ccloud\u66f4\u65b0\u5931\u8d25", (Object)reportId);
                    }
                    if ((isLeaked = this.leakVerifyResultDAO.querySceneIsLeaked(reportId)).booleanValue()) {
                        log.info("\u5b58\u5728\u6f0f\u6570\uff0c\u538b\u6d4b\u5931\u8d25\uff0c\u4fee\u6539\u538b\u6d4b\u62a5\u544a\u72b6\u6001:[{}]", (Object)reportId);
                        UpdateReportConclusionReq conclusionReq = new UpdateReportConclusionReq();
                        conclusionReq.setId(reportId);
                        conclusionReq.setConclusion(Integer.valueOf(0));
                        conclusionReq.setErrorMessage("\u5b58\u5728\u6f0f\u6570");
                        ResponseResult responseResult = this.sceneTaskApi.updateReportStatus(conclusionReq);
                        log.info("\u4fee\u6539\u538b\u6d4b\u62a5\u544a\u7684\u7ed3\u679c:[{}]", (Object)JSON.toJSONString((Object)responseResult));
                    }
                    this.redisClientUtils.del(new String[]{"report:warn:" + reportId});
                    this.redisClientUtils.hmdelete("pting.application:hmset", String.valueOf(reportId));
                    log.warn("\u62a5\u544aid={}\u6c47\u603b\u6210\u529f\uff0c\u82b1\u8d39\u65f6\u95f4={}s", (Object)reportId, (Object)((System.currentTimeMillis() - startTime) / 1000L));
                    continue;
                }
                catch (Exception e) {
                    log.error("\u5ba2\u6237\u7aef\u751f\u6210\u62a5\u544aid={}\u6570\u636e\u5f02\u5e38:{}", new Object[]{reportId, e.getMessage(), e});
                    this.reportClearService.clearReportData(reportId);
                    if (endTime == null) continue;
                    this.reportService.unLockReport(reportId);
                    log.warn("Unlock Report Success, reportId={}...", (Object)reportId);
                    continue;
                }
                finally {
                    this.reportDataCache.clearDataCache();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("QueryRunningReport Error :{}", (Throwable)e);
        }
        finally {
            RUNNINT.compareAndSet(true, false);
        }
    }
}

