/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.report.impl;

import com.google.common.collect.Lists;
import com.pamirs.tro.common.constant.VerifyResultStatusEnum;
import com.pamirs.tro.entity.domain.dto.report.LeakVerifyResult;
import com.pamirs.tro.entity.domain.vo.report.ReportIdVO;
import com.pamirs.tro.entity.domain.vo.report.ReportQueryParam;
import com.pamirs.tro.entity.domain.vo.report.ReportTrendQueryParam;
import com.pamirs.tro.entity.domain.vo.report.SceneIdVO;
import com.pamirs.tro.entity.domain.vo.sla.WarnQueryParam;
import io.shulie.tro.cloud.open.req.report.ReportDetailByIdReq;
import io.shulie.tro.cloud.open.req.report.ReportDetailBySceneIdReq;
import io.shulie.tro.cloud.open.resp.report.ReportDetailResp;
import io.shulie.tro.common.beans.response.ResponseResult;
import io.shulie.tro.utils.linux.LinuxHelper;
import io.shulie.tro.web.app.common.RestContext;
import io.shulie.tro.web.app.output.report.ReportDetailOutput;
import io.shulie.tro.web.app.output.report.ReportDetailTempOutput;
import io.shulie.tro.web.app.output.report.ReportJtlDownloadOutput;
import io.shulie.tro.web.app.request.leakverify.LeakVerifyTaskReportQueryRequest;
import io.shulie.tro.web.app.response.leakverify.LeakVerifyTaskResultResponse;
import io.shulie.tro.web.app.service.VerifyTaskReportService;
import io.shulie.tro.web.app.service.report.ReportService;
import io.shulie.tro.web.common.constant.RemoteConstant;
import io.shulie.tro.web.common.domain.WebRequest;
import io.shulie.tro.web.common.domain.WebResponse;
import io.shulie.tro.web.common.http.HttpWebClient;
import io.shulie.tro.web.data.dao.user.TroUserDAO;
import io.shulie.tro.web.data.result.user.TroUserResult;
import io.shulie.tro.web.data.result.user.UserCommonResult;
import io.shulie.tro.web.diff.api.report.ReportApi;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;

@Service
public class ReportServiceImpl
implements ReportService {
    private static final Logger log = LoggerFactory.getLogger(ReportServiceImpl.class);
    @Autowired
    private HttpWebClient httpWebClient;
    @Autowired
    private TroUserDAO troUserDAO;
    @Autowired
    private ReportApi reportApi;
    @Value(value="${file.upload.url:''}")
    private String fileUploadUrl;
    @Autowired
    private VerifyTaskReportService verifyTaskReportService;
    @Value(value="${file.upload.user.data.dir:/data/tmp}")
    private String fileDir;

    public WebResponse listReport(ReportQueryParam param) {
        WebResponse webResponse;
        List webRespData;
        param.setRequestUrl("/api/report/listReport");
        param.setHttpMethod(HttpMethod.GET);
        if (StringUtils.isNotBlank((String)param.getManagerName())) {
            List userList = this.troUserDAO.selectByName(param.getManagerName());
            if (CollectionUtils.isNotEmpty((Collection)userList)) {
                List uids = userList.stream().map(UserCommonResult::getUserId).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(uids)) {
                    param.setUserIdStr(null);
                } else {
                    param.setUserIdStr(StringUtils.join(uids, (String)","));
                }
            } else {
                return WebResponse.success((Object)Lists.newArrayList());
            }
        }
        if (CollectionUtils.isEmpty((Collection)(webRespData = (List)(webResponse = this.httpWebClient.request((WebRequest)param)).getData()))) {
            return webResponse;
        }
        List userIds = webRespData.stream().filter(data -> null != data.get("userId")).map(data -> Long.valueOf(data.get("userId").toString())).collect(Collectors.toList());
        Map userMap = this.troUserDAO.selectUserMapByIds(userIds);
        webRespData.forEach(data -> {
            Long userId = data.get("userId") == null ? null : Long.valueOf(data.get("userId").toString());
            String userName = Optional.ofNullable(userMap.get(userId)).map(UserCommonResult::getUserName).orElse("");
            data.put("managerName", userName);
            data.put("managerId", userId);
        });
        return webResponse;
    }

    public WebResponse getReportByReportId(Long reportId) {
        ReportDetailByIdReq req = new ReportDetailByIdReq();
        req.setReportId(reportId);
        ResponseResult result = this.reportApi.getReportByReportId(req);
        if (result == null) {
            return WebResponse.fail((String)"\u5b9e\u51b5\u62a5\u544a\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        }
        if (result.getSuccess().booleanValue()) {
            ReportDetailOutput output = new ReportDetailOutput();
            BeanUtils.copyProperties((Object)result.getData(), (Object)output);
            this.assembleVerifyResult(output);
            this.fillExecuteMan(output);
            return WebResponse.success((Object)output);
        }
        return WebResponse.fail((String)result.getError().getCode(), (String)result.getError().getMsg(), (Object[])new Object[0]);
    }

    private void fillExecuteMan(ReportDetailOutput output) {
        if (output == null || output.getUserId() == null) {
            return;
        }
        TroUserResult troUserResult = this.troUserDAO.selectById(output.getUserId());
        if (troUserResult != null) {
            output.setOperateName(troUserResult.getName());
            output.setManagerId(troUserResult.getId());
        }
    }

    private void assembleVerifyResult(ReportDetailOutput output) {
        LeakVerifyTaskReportQueryRequest queryRequest = new LeakVerifyTaskReportQueryRequest();
        queryRequest.setReportId(output.getId());
        LeakVerifyTaskResultResponse verifyTaskResultResponse = this.verifyTaskReportService.getVerifyTaskReport(queryRequest);
        if (Objects.isNull(verifyTaskResultResponse)) {
            return;
        }
        LeakVerifyResult leakVerifyResult = new LeakVerifyResult();
        leakVerifyResult.setCode(verifyTaskResultResponse.getStatus());
        leakVerifyResult.setLabel(VerifyResultStatusEnum.getLabelByCode((Integer)verifyTaskResultResponse.getStatus()));
        output.setLeakVerifyResult(leakVerifyResult);
    }

    public WebResponse queryReportTrend(ReportTrendQueryParam param) {
        param.setRequestUrl("/api/report/queryReportTrend");
        param.setHttpMethod(HttpMethod.GET);
        return this.httpWebClient.request((WebRequest)param);
    }

    public WebResponse tempReportDetail(Long sceneId) {
        ReportDetailBySceneIdReq req = new ReportDetailBySceneIdReq();
        req.setSceneId(sceneId);
        ResponseResult result = this.reportApi.tempReportDetail(req);
        if (!result.getSuccess().booleanValue()) {
            return WebResponse.fail((String)result.getError().getCode(), (String)result.getError().getMsg(), (Object[])new Object[0]);
        }
        ReportDetailResp resp = (ReportDetailResp)result.getData();
        ReportDetailTempOutput output = new ReportDetailTempOutput();
        BeanUtils.copyProperties((Object)resp, (Object)output);
        List allowStartStopUserIdList = RestContext.getStartStopAllowUserIdList();
        if (CollectionUtils.isNotEmpty((Collection)allowStartStopUserIdList)) {
            String managerId = "";
            if (output.getManagerId() != null) {
                managerId = String.valueOf(resp.getManagerId());
            }
            if (StringUtils.isBlank((String)managerId) || !allowStartStopUserIdList.contains(Long.parseLong(managerId))) {
                output.setCanStartStop(Boolean.FALSE);
            } else {
                output.setCanStartStop(Boolean.TRUE);
            }
        } else {
            output.setCanStartStop(Boolean.TRUE);
        }
        this.fillExecuteMan((ReportDetailOutput)output);
        return WebResponse.success((Object)output);
    }

    public WebResponse queryTempReportTrend(ReportTrendQueryParam param) {
        param.setRequestUrl("/api/report/queryTempReportTrend");
        param.setHttpMethod(HttpMethod.GET);
        return this.httpWebClient.request((WebRequest)param);
    }

    public WebResponse listWarn(WarnQueryParam param) {
        param.setRequestUrl("/api/report/listWarn");
        param.setHttpMethod(HttpMethod.GET);
        return this.httpWebClient.request((WebRequest)param);
    }

    public WebResponse queryReportActivityByReportId(Long reportId) {
        ReportIdVO vo = new ReportIdVO();
        vo.setReportId(reportId);
        vo.setRequestUrl("/api/report/queryReportActivityByReportId");
        vo.setHttpMethod(HttpMethod.GET);
        return this.httpWebClient.request((WebRequest)vo);
    }

    public WebResponse queryReportActivityBySceneId(Long sceneId) {
        SceneIdVO vo = new SceneIdVO();
        vo.setSceneId(sceneId);
        vo.setRequestUrl("/api/report/queryReportActivityBySceneId");
        vo.setHttpMethod(HttpMethod.GET);
        return this.httpWebClient.request((WebRequest)vo);
    }

    public WebResponse querySummaryList(Long reportId) {
        ReportIdVO vo = new ReportIdVO();
        vo.setReportId(reportId);
        vo.setRequestUrl("/api/report/businessActivity/summary/list");
        vo.setHttpMethod(HttpMethod.GET);
        return this.httpWebClient.request((WebRequest)vo);
    }

    public WebResponse queryMetrices(Long reportId, Long sceneId, Long customId) {
        ReportIdVO vo = new ReportIdVO();
        vo.setReportId(reportId);
        vo.setSceneId(sceneId);
        vo.setCustomerId(customId);
        vo.setRequestUrl("/api/report/metrices");
        vo.setHttpMethod(HttpMethod.GET);
        return this.httpWebClient.request((WebRequest)vo);
    }

    public WebResponse queryReportCount(Long reportId) {
        ReportIdVO vo = new ReportIdVO();
        vo.setReportId(reportId);
        vo.setRequestUrl("/api/report/count");
        vo.setHttpMethod(HttpMethod.GET);
        return this.httpWebClient.request((WebRequest)vo);
    }

    public WebResponse queryRunningReport() {
        WebRequest request = new WebRequest();
        request.setRequestUrl("/api/report/running");
        request.setHttpMethod(HttpMethod.GET);
        return this.httpWebClient.request(request);
    }

    public WebResponse queryListRunningReport() {
        WebRequest request = new WebRequest();
        request.setRequestUrl("/api/report/running/list");
        request.setHttpMethod(HttpMethod.GET);
        return this.httpWebClient.request(request);
    }

    public WebResponse lockReport(Long reportId) {
        ReportIdVO vo = new ReportIdVO();
        vo.setReportId(reportId);
        vo.setRequestUrl("/api/report/lock");
        vo.setHttpMethod(HttpMethod.PUT);
        return this.httpWebClient.request((WebRequest)vo);
    }

    public WebResponse unLockReport(Long reportId) {
        ReportIdVO vo = new ReportIdVO();
        vo.setReportId(reportId);
        vo.setRequestUrl("/api/report/unlock");
        vo.setHttpMethod(HttpMethod.PUT);
        return this.httpWebClient.request((WebRequest)vo);
    }

    public WebResponse finishReport(Long reportId) {
        ReportIdVO vo = new ReportIdVO();
        vo.setReportId(reportId);
        vo.setRequestUrl("/api/report/finish");
        vo.setHttpMethod(HttpMethod.PUT);
        return this.httpWebClient.request((WebRequest)vo);
    }

    public ReportJtlDownloadOutput getJtlDownLoadUrl(Long reportId) {
        ResponseResult result = this.reportApi.getJtlDownLoadUrl(reportId);
        if (result.getSuccess().booleanValue()) {
            String url = null;
            try {
                url = this.fileUploadUrl + "/api/file/downloadFileByPath?filePath=" + URLEncoder.encode((String)result.getData(), "UTF-8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String fileName = reportId + "_jtl.zip";
            String[] cmds = new String[]{"curl", "-o", this.fileDir + "/" + fileName, "-OL", "-H", "licenseKey:" + RemoteConstant.LICENSE_VALUE, url};
            LinuxHelper.execCurl((String[])cmds);
            return new ReportJtlDownloadOutput(this.fileDir + "/" + fileName, Boolean.valueOf(true));
        }
        return new ReportJtlDownloadOutput((String)result.getData(), Boolean.valueOf(false));
    }
}

