/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.report.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pamirs.pradar.log.parser.trace.RpcEntry;
import com.pamirs.pradar.log.parser.trace.RpcStack;
import com.pamirs.tro.entity.dao.linkmanage.TBusinessLinkManageTableMapper;
import com.pamirs.tro.entity.domain.dto.report.ReportDetailDTO;
import com.pamirs.tro.entity.domain.dto.report.ReportTraceDTO;
import com.pamirs.tro.entity.domain.dto.report.ReportTraceDetailDTO;
import com.pamirs.tro.entity.domain.entity.linkmanage.BusinessLinkManageTable;
import com.pamirs.tro.entity.domain.entity.linkmanage.figure.RpcType;
import com.pamirs.tro.entity.domain.vo.scenemanage.SceneManageIdVO;
import io.shulie.tro.common.beans.page.PagingList;
import io.shulie.tro.web.amdb.api.TraceClient;
import io.shulie.tro.web.amdb.bean.query.trace.TraceInfoQueryDTO;
import io.shulie.tro.web.amdb.bean.result.trace.EntryTraceInfoDTO;
import io.shulie.tro.web.app.service.report.ReportRealTimeService;
import io.shulie.tro.web.app.service.report.ReportService;
import io.shulie.tro.web.app.service.risk.util.DateUtil;
import io.shulie.tro.web.common.domain.PradarWebRequest;
import io.shulie.tro.web.common.domain.WebRequest;
import io.shulie.tro.web.common.domain.WebResponse;
import io.shulie.tro.web.common.http.HttpWebClient;
import io.shulie.tro.web.common.util.ResultCode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;

@Service
public class ReportRealTimeServiceImpl
implements ReportRealTimeService {
    private static final Logger log = LoggerFactory.getLogger(ReportRealTimeServiceImpl.class);
    @Resource
    TBusinessLinkManageTableMapper tBusinessLinkManageTableMapper;
    @Autowired
    private ReportService reportService;
    @Autowired
    private HttpWebClient httpWebClient;
    @Autowired
    private TraceClient traceClient;

    public PageInfo<ReportTraceDTO> getReportLinkList(Long sceneId, Long startTime, Integer type, int current, int pageSize) {
        if (startTime == null) {
            return new PageInfo((List)Lists.newArrayList());
        }
        return this.getReportTraceDTOS(sceneId, startTime.longValue(), System.currentTimeMillis(), type, current, pageSize);
    }

    public PageInfo<ReportTraceDTO> getReportLinkListByReportId(Long reportId, Integer type, int current, int pageSize) {
        ReportDetailDTO reportDetail = null;
        WebResponse response = this.reportService.getReportByReportId(reportId);
        if (response != null && response.getData() != null) {
            reportDetail = (ReportDetailDTO)JSON.parseObject((String)JSON.toJSONString((Object)response.getData()), ReportDetailDTO.class);
            log.info("Report Id={}, Status={}", (Object)reportId, (Object)reportDetail.getTaskStatus());
        }
        if (reportDetail == null || reportDetail.getStartTime() == null) {
            return new PageInfo((List)Lists.newArrayList());
        }
        long startTime = DateUtil.parseSecondFormatter((String)reportDetail.getStartTime()).getTime();
        long endTime = reportDetail.getEndTime() != null ? reportDetail.getEndTime().getTime() : startTime + 300L;
        return this.getReportTraceDTOS(reportDetail.getSceneId(), startTime, endTime, type, current, pageSize);
    }

    public Map<String, Object> getLinkDetail(String traceId, Integer id) {
        PradarWebRequest vo = new PradarWebRequest();
        vo.setHttpMethod(HttpMethod.GET);
        vo.setTraceId(traceId);
        RpcStack rpcStack = this.traceClient.getTraceDetailById(traceId);
        boolean isTest = !CollectionUtils.isEmpty((Collection)rpcStack.getRpcEntries()) && ((RpcEntry)rpcStack.getRpcEntries().get(0)).isClusterTest();
        HashMap map = Maps.newHashMap();
        map.put("startTime", rpcStack.getStartTime());
        map.put("entryHostIp", rpcStack.getRootIp());
        ArrayList vos = Lists.newArrayList();
        HashBiMap node = HashBiMap.create();
        AtomicInteger integer = new AtomicInteger(0);
        List dto = this.coverEntriesList(0L, (List)Lists.newArrayList(), rpcStack.getRpcEntries(), (List)vos, (BiMap)node, Integer.valueOf(-1), integer);
        ArrayList result = Lists.newArrayList();
        this.coverResult(dto, id, (List)result);
        map.put("traces", result);
        map.put("clusterTest", isTest);
        map.put("totalCost", rpcStack.getTotalCost());
        return map;
    }

    private void coverResult(List<ReportTraceDetailDTO> dtoList, Integer id, List<ReportTraceDetailDTO> result) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        if (id == 0) {
            if (dtoList.get(0).getNextNodes() != null) {
                dtoList.get(0).getNextNodes().forEach(dto -> dto.setNextNodes(dto.getNextNodes() != null && dto.getNextNodes().size() > 0 ? Lists.newArrayList() : null));
            }
            result.addAll(dtoList);
            return;
        }
        for (ReportTraceDetailDTO dto2 : dtoList) {
            if (CollectionUtils.isEmpty((Collection)dto2.getNextNodes())) continue;
            if (dto2.getId().equals(id) && dto2.getNextNodes() != null) {
                result.addAll(dto2.getNextNodes());
            }
            this.coverResult(dto2.getNextNodes(), id, result);
        }
    }

    private List<ReportTraceDetailDTO> coverEntriesList(long startTime, List<String> convertedEntriesList, List<RpcEntry> rpcEntries, List<ReportTraceDetailDTO> vos, BiMap<Integer, Integer> node, Integer id, AtomicInteger integer) {
        if (CollectionUtils.isEmpty(rpcEntries)) {
            return null;
        }
        return rpcEntries.stream().map(rpcEntry -> {
            RpcEntry entry;
            String tempKey;
            String convertedEntriesKey = rpcEntry.getAppName() + "|" + rpcEntry.getServiceName() + "|" + rpcEntry.getMethodName() + "|" + rpcEntry.getRpcType() + "|" + rpcEntry.getMiddlewareName() + "|" + rpcEntry.getRpcId();
            if (convertedEntriesList.contains(convertedEntriesKey)) {
                return null;
            }
            convertedEntriesList.add(convertedEntriesKey);
            ReportTraceDetailDTO reportTraceDetailDTO = new ReportTraceDetailDTO();
            reportTraceDetailDTO.setId(Integer.valueOf(integer.getAndIncrement()));
            node.forcePut((Object)id, (Object)reportTraceDetailDTO.getId());
            reportTraceDetailDTO.setCostTime(Long.valueOf(rpcEntry.getCost()));
            reportTraceDetailDTO.setApplicationName(rpcEntry.getAppName());
            reportTraceDetailDTO.setInterfaceName(rpcEntry.getServiceName());
            long offset = 0L;
            Iterator iterator = rpcEntries.iterator();
            while (iterator.hasNext() && !(tempKey = (entry = (RpcEntry)iterator.next()).getAppName() + "|" + entry.getServiceName() + "|" + entry.getMethodName() + "|" + entry.getRpcType() + "|" + entry.getMiddlewareName() + "|" + entry.getRpcId()).equals(convertedEntriesKey)) {
                offset += entry.getCost();
            }
            if ("0".equals(rpcEntry.getRpcId())) {
                reportTraceDetailDTO.setOffsetStartTime(Long.valueOf(0L));
            } else {
                reportTraceDetailDTO.setOffsetStartTime(Long.valueOf(startTime + offset));
            }
            reportTraceDetailDTO.setParams(this.buildParams(rpcEntry));
            reportTraceDetailDTO.setSucceeded(Boolean.valueOf(ResultCode.isOk((String)rpcEntry.getResultCode())));
            reportTraceDetailDTO.setRpcId(rpcEntry.getRpcId());
            reportTraceDetailDTO.setAgentId(rpcEntry.getClientAgentId());
            reportTraceDetailDTO.setEntryHostIp(rpcEntry.getClientIp());
            reportTraceDetailDTO.setClusterTest(Boolean.valueOf(rpcEntry.isClusterTest()));
            if (StringUtils.isNotBlank((CharSequence)rpcEntry.getClientIp()) && StringUtils.isNotBlank((CharSequence)rpcEntry.getServerIp())) {
                reportTraceDetailDTO.setNodeIp(rpcEntry.getServerIp());
            } else if (StringUtils.isNotBlank((CharSequence)rpcEntry.getClientIp())) {
                reportTraceDetailDTO.setNodeIp(rpcEntry.getClientIp());
            } else if (StringUtils.isNotBlank((CharSequence)rpcEntry.getServerIp())) {
                reportTraceDetailDTO.setNodeIp(rpcEntry.getServerIp());
            }
            reportTraceDetailDTO.setResponse(rpcEntry.getResponse());
            reportTraceDetailDTO.setNodeSuccess(Boolean.valueOf(true));
            if (!reportTraceDetailDTO.getSucceeded().booleanValue()) {
                this.setParentNode(vos, node, reportTraceDetailDTO.getId());
            }
            vos.add(reportTraceDetailDTO);
            reportTraceDetailDTO.setNextNodes(this.coverEntriesList(reportTraceDetailDTO.getOffsetStartTime().longValue(), convertedEntriesList, rpcEntry.getRpcEntries(), vos, node, reportTraceDetailDTO.getId(), integer));
            return reportTraceDetailDTO;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private void setParentNode(List<ReportTraceDetailDTO> vos, BiMap<Integer, Integer> node, Integer id) {
        ArrayList nodes = Lists.newArrayList();
        while (node.containsValue((Object)id)) {
            id = (Integer)node.inverse().get((Object)id);
            nodes.add(id);
        }
        if (vos != null && vos.size() > 0) {
            vos.forEach(vo -> {
                if (nodes.contains(vo.getId())) {
                    vo.setNodeSuccess(Boolean.valueOf(false));
                }
            });
        }
    }

    private String buildParams(RpcEntry item) {
        if (item.getRpcType() == RpcType.DB.getValue()) {
            if (StringUtils.isNotBlank((CharSequence)item.getServerCallbackMsg())) {
                return item.getServerCallbackMsg() + "\n" + item.getRequest();
            }
            if (StringUtils.isNotBlank((CharSequence)item.getClientCallbackMsg())) {
                return item.getClientCallbackMsg() + "\n" + item.getRequest();
            }
        }
        return item.getRequest();
    }

    private PageInfo<ReportTraceDTO> getReportTraceDTOS(Long sceneId, long startTime, long endTime, Integer type, int current, int pageSize) {
        SceneManageIdVO vo = new SceneManageIdVO();
        vo.setId(sceneId);
        vo.setRequestUrl("/api/scenemanage/detail");
        vo.setHttpMethod(HttpMethod.GET);
        WebResponse response = this.httpWebClient.request((WebRequest)vo);
        Map dataMap = (Map)response.getData();
        List mapList = (List)dataMap.get("businessActivityConfig");
        ArrayList businessActivityIdList = Lists.newArrayList();
        for (Map map : mapList) {
            businessActivityIdList.add(Long.parseLong(String.valueOf(map.get("businessActivityId"))));
        }
        List businessLinkManageTableList = this.tBusinessLinkManageTableMapper.selectBussinessLinkByIdList((List)businessActivityIdList);
        ArrayList entranceList = Lists.newArrayList();
        for (BusinessLinkManageTable businessLinkManageTable : businessLinkManageTableList) {
            String entrance = businessLinkManageTable.getEntrace();
            if (entrance.contains("http")) {
                entrance = entrance.substring(entrance.indexOf("http"));
            }
            entranceList.add(entrance);
        }
        TraceInfoQueryDTO traceInfoQueryDTO = new TraceInfoQueryDTO();
        traceInfoQueryDTO.setStartTime(Long.valueOf(startTime));
        traceInfoQueryDTO.setEndTime(Long.valueOf(endTime));
        traceInfoQueryDTO.setType(String.valueOf(type));
        traceInfoQueryDTO.setEntranceList((List)entranceList);
        traceInfoQueryDTO.setPageNum(Integer.valueOf(current));
        traceInfoQueryDTO.setPageSize(Integer.valueOf(pageSize));
        PagingList entryTraceInfoDTOPagingList = this.traceClient.listEntryTraceInfo(traceInfoQueryDTO);
        if (entryTraceInfoDTOPagingList.isEmpty()) {
            return new PageInfo();
        }
        List collect = entryTraceInfoDTOPagingList.getList().stream().map(traceInfo -> {
            ReportTraceDTO traceDTO = new ReportTraceDTO();
            traceDTO.setInterfaceName(traceInfo.getEntry());
            traceDTO.setApplicationName(this.buildAppName(traceInfo));
            traceDTO.setSucceeded(Boolean.valueOf(ResultCode.isOk((String)traceInfo.getStatus())));
            traceDTO.setTotalRt(traceInfo.getProcessTime());
            traceDTO.setStartTime(new Date(traceInfo.getStartTime()));
            traceDTO.setTraceId(traceInfo.getTraceId());
            return traceDTO;
        }).collect(Collectors.toList());
        PageInfo reportTraceDTOPageInfo = new PageInfo(collect);
        reportTraceDTOPageInfo.setTotal(entryTraceInfoDTOPagingList.getTotal());
        return reportTraceDTOPageInfo;
    }

    private String buildAppName(EntryTraceInfoDTO tro) {
        StringBuilder builder = new StringBuilder();
        builder.append(tro.getAppName());
        String entry = tro.getEntry();
        if (StringUtils.isNotBlank((CharSequence)entry) && entry.contains("http")) {
            entry = entry.replace("http://", "");
            if ((entry = entry.replace("https://", "")).contains("/")) {
                entry = entry.substring(0, entry.indexOf("/"));
            }
            if (entry.contains(":")) {
                entry = entry.substring(0, entry.indexOf(":"));
            }
            builder.append("(").append(entry).append(")");
        }
        return builder.toString();
    }
}

