/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.report.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.pamirs.tro.entity.dao.report.TReportApplicationSummaryMapper;
import com.pamirs.tro.entity.dao.report.TReportBottleneckInterfaceMapper;
import com.pamirs.tro.entity.dao.report.TReportMachineMapper;
import com.pamirs.tro.entity.dao.report.TReportSummaryMapper;
import com.pamirs.tro.entity.domain.dto.report.ApplicationDTO;
import com.pamirs.tro.entity.domain.dto.report.BottleneckInterfaceDTO;
import com.pamirs.tro.entity.domain.dto.report.MachineDetailDTO;
import com.pamirs.tro.entity.domain.dto.report.ReportCountDTO;
import com.pamirs.tro.entity.domain.dto.report.RiskApplicationCountDTO;
import com.pamirs.tro.entity.domain.dto.report.RiskMacheineDTO;
import com.pamirs.tro.entity.domain.entity.report.ReportApplicationSummary;
import com.pamirs.tro.entity.domain.entity.report.ReportBottleneckInterface;
import com.pamirs.tro.entity.domain.entity.report.ReportMachine;
import com.pamirs.tro.entity.domain.entity.report.ReportSummary;
import com.pamirs.tro.entity.domain.entity.report.TpsTargetArray;
import com.pamirs.tro.entity.domain.vo.report.ReportLocalQueryParam;
import io.shulie.tro.web.app.service.report.ReportLocalService;
import io.shulie.tro.web.app.service.report.ReportRealTimeService;
import io.shulie.tro.web.app.service.report.ReportService;
import io.shulie.tro.web.data.dao.application.ApplicationNodeDAO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportLocalServiceImpl
implements ReportLocalService {
    private static final Logger log = LoggerFactory.getLogger(ReportLocalServiceImpl.class);
    public static final BigDecimal ZERO = new BigDecimal("0");
    @Resource
    private TReportSummaryMapper TReportSummaryMapper;
    @Resource
    private TReportBottleneckInterfaceMapper TReportBottleneckInterfaceMapper;
    @Resource
    private TReportApplicationSummaryMapper TReportApplicationSummaryMapper;
    @Resource
    private TReportMachineMapper TReportMachineMapper;
    @Resource
    private ReportService reportService;
    @Autowired
    private ApplicationNodeDAO applicationNodeDAO;
    @Autowired
    private ReportRealTimeService reportRealTimeService;

    public static void main(String[] args) {
        String data1 = "{\"cpu\":[10,11,12],\"io\":[40,30,35],\"loading\":[75,55,70],\"memory\":[40,43,45],\"network\":[20,40,24],\"tps\":[100,110,120]}";
        String data2 = "{\"cpu\":[30,31,32],\"io\":[42,32,37],\"loading\":[77,57,72],\"memory\":[42,45,47],\"network\":[22,42,26],\"tps\":[110,120,130]}";
        MachineDetailDTO dto = new MachineDetailDTO();
        ReportLocalServiceImpl reportLocal = new ReportLocalServiceImpl();
        reportLocal.parseTpsConfig(dto, Arrays.asList(data1, data2));
        System.out.println(dto);
    }

    public ReportCountDTO getReportCount(Long reportId) {
        ReportSummary data = this.TReportSummaryMapper.selectOneByReportId(reportId);
        if (data == null) {
            return new ReportCountDTO();
        }
        return this.convert2ReportCountDTO(data);
    }

    public PageInfo<BottleneckInterfaceDTO> listBottleneckInterface(ReportLocalQueryParam queryParam) {
        Page page = PageHelper.startPage((int)(queryParam.getCurrentPage() + 1), (int)queryParam.getPageSize());
        List dataList = this.TReportBottleneckInterfaceMapper.selectByExample(queryParam);
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return new PageInfo((List)Lists.newArrayList());
        }
        List resultList = this.convert2BottleneckInterfaceDTO(dataList);
        PageInfo pageInfo = new PageInfo(resultList);
        pageInfo.setTotal(page.getTotal());
        return pageInfo;
    }

    public RiskApplicationCountDTO listRiskApplication(Long reportId) {
        ReportApplicationSummary param = new ReportApplicationSummary();
        param.setReportId(reportId);
        List dataList = this.TReportApplicationSummaryMapper.selectByParam(param);
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return new RiskApplicationCountDTO();
        }
        List resultList = dataList.stream().filter(data -> data.getMachineRiskCount() != null && data.getMachineRiskCount() > 0).sorted((o1, o2) -> {
            if (o1.getMachineRiskCount() > o2.getMachineRiskCount()) {
                return -1;
            }
            if (o1.getMachineRiskCount() < o2.getMachineRiskCount()) {
                return 1;
            }
            return 0;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(resultList)) {
            return new RiskApplicationCountDTO();
        }
        int riskMachineCount = 0;
        ReportSummary data2 = this.TReportSummaryMapper.selectOneByReportId(reportId);
        if (data2 != null) {
            riskMachineCount = data2.getRiskMachineCount();
        }
        return this.convert2RiskApplicationCountDTO(resultList, riskMachineCount);
    }

    public PageInfo<RiskMacheineDTO> listRiskMachine(ReportLocalQueryParam queryParam) {
        Page page = PageHelper.startPage((int)(queryParam.getCurrentPage() + 1), (int)queryParam.getPageSize());
        queryParam.setRiskFlag(Integer.valueOf(1));
        List dataList = this.TReportMachineMapper.selectSimpleByExample(queryParam);
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return new PageInfo((List)Lists.newArrayList());
        }
        List resultList = this.convert2RiskMacheineDTO(dataList);
        PageInfo pageInfo = new PageInfo(resultList);
        pageInfo.setTotal(page.getTotal());
        return pageInfo;
    }

    public MachineDetailDTO getMachineDetail(Long reportId, String applicationName, String machineIp) {
        ReportLocalQueryParam queryParam = new ReportLocalQueryParam();
        queryParam.setReportId(reportId);
        queryParam.setApplicationName(applicationName);
        queryParam.setMachineIp(machineIp);
        if ("\u5168\u90e8".equals(machineIp) || "0".equals(machineIp) || "all".equalsIgnoreCase(machineIp)) {
            queryParam.setMachineIp(null);
            List dataList = this.TReportMachineMapper.selectListByParam(queryParam);
            if (CollectionUtils.isEmpty((Collection)dataList)) {
                return new MachineDetailDTO();
            }
            MachineDetailDTO dto = new MachineDetailDTO();
            this.parseTpsConfig(dto, dataList.stream().filter(data -> data.getMachineTpsTargetConfig() != null).map(ReportMachine::getMachineTpsTargetConfig).collect(Collectors.toList()));
            return dto;
        }
        ReportMachine data2 = this.TReportMachineMapper.selectOneByParam(queryParam);
        if (data2 == null) {
            return new MachineDetailDTO();
        }
        return this.convert2MachineDetailDTO(data2);
    }

    public List<ApplicationDTO> listApplication(Long reportId, String applicationName) {
        ReportApplicationSummary param = new ReportApplicationSummary();
        param.setReportId(reportId);
        param.setApplicationName(applicationName);
        List dataList = this.TReportApplicationSummaryMapper.selectByParam(param);
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return Lists.newArrayList();
        }
        return this.convert2ApplicationDTO(dataList);
    }

    public PageInfo<MachineDetailDTO> listMachineDetail(ReportLocalQueryParam queryParam) {
        Page page = PageHelper.startPage((int)(queryParam.getCurrentPage() + 1), (int)queryParam.getPageSize());
        List dataList = this.TReportMachineMapper.selectSimpleByExample(queryParam);
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return new PageInfo((List)Lists.newArrayList());
        }
        List resultList = this.convert2MachineDetailDTO(dataList);
        PageInfo pageInfo = new PageInfo(resultList);
        pageInfo.setTotal(page.getTotal());
        return pageInfo;
    }

    public Long getTraceFailedCount(Long reportId) {
        PageInfo pageInfo = this.reportRealTimeService.getReportLinkListByReportId(reportId, Integer.valueOf(0), 0, 1);
        return pageInfo != null ? pageInfo.getTotal() : 0L;
    }

    private ReportCountDTO convert2ReportCountDTO(ReportSummary param) {
        ReportCountDTO dto = new ReportCountDTO();
        dto.setBottleneckInterfaceCount(param.getBottleneckInterfaceCount());
        dto.setRiskMachineCount(param.getRiskMachineCount());
        dto.setBusinessActivityCount(param.getBusinessActivityCount());
        dto.setNotpassBusinessActivityCount(param.getUnachieveBusinessActivityCount());
        dto.setApplicationCount(param.getApplicationCount());
        dto.setMachineCount(param.getMachineCount());
        dto.setWarnCount(param.getWarnCount());
        return dto;
    }

    private List<BottleneckInterfaceDTO> convert2BottleneckInterfaceDTO(List<ReportBottleneckInterface> paramList) {
        ArrayList dataList = Lists.newArrayList();
        paramList.forEach(data -> {
            BottleneckInterfaceDTO dto = new BottleneckInterfaceDTO();
            dto.setRank(data.getSortNo());
            dto.setApplicationName(data.getApplicationName());
            dto.setInterfaceName(data.getInterfaceName());
            dto.setTps(data.getTps());
            dto.setRt(data.getRt());
            dto.setSuccessRate(new BigDecimal("100"));
            dataList.add(dto);
        });
        return dataList;
    }

    private RiskApplicationCountDTO convert2RiskApplicationCountDTO(List<ReportApplicationSummary> paramList, int riskMachineCount) {
        RiskApplicationCountDTO dto = new RiskApplicationCountDTO();
        ArrayList apps = Lists.newArrayList();
        for (ReportApplicationSummary param : paramList) {
            ApplicationDTO app = new ApplicationDTO();
            app.setApplicationName(param.getApplicationName());
            app.setRiskCount(param.getMachineRiskCount());
            app.setTotalCount(param.getMachineTotalCount());
            apps.add(app);
        }
        dto.setApplicationCount(Integer.valueOf(paramList.size()));
        dto.setMachineCount(Integer.valueOf(riskMachineCount));
        dto.setApplicationList((List)apps);
        return dto;
    }

    private List<RiskMacheineDTO> convert2RiskMacheineDTO(List<ReportMachine> paramList) {
        ArrayList dataList = Lists.newArrayList();
        paramList.forEach(data -> {
            RiskMacheineDTO dto = new RiskMacheineDTO();
            dto.setId(data.getId());
            dto.setMachineIp(data.getMachineIp());
            dto.setRiskContent(data.getRiskContent());
            dto.setAgentId(data.getAgentId());
            dataList.add(dto);
        });
        return dataList;
    }

    private MachineDetailDTO convert2MachineDetailDTO(ReportMachine param) {
        MachineDetailDTO dto = new MachineDetailDTO();
        dto.setId(param.getId());
        dto.setMachineIp(param.getMachineIp());
        dto.setApplicationName(param.getApplicationName());
        dto.setAgentId(param.getAgentId());
        dto.setRiskFlag(this.checkRisk(param.getRiskFlag()));
        this.parseBaseConfig(dto, param.getMachineBaseConfig());
        this.parseTpsConfig(dto, Arrays.asList(param.getMachineTpsTargetConfig()));
        return dto;
    }

    private List<ApplicationDTO> convert2ApplicationDTO(List<ReportApplicationSummary> paramList) {
        ArrayList dataList = Lists.newArrayList();
        paramList.forEach(data -> {
            ApplicationDTO dto = new ApplicationDTO();
            dto.setApplicationName(data.getApplicationName());
            dto.setRiskCount(data.getMachineRiskCount());
            dto.setTotalCount(data.getMachineTotalCount());
            dataList.add(dto);
        });
        return dataList;
    }

    private List<MachineDetailDTO> convert2MachineDetailDTO(List<ReportMachine> paramList) {
        ArrayList dataList = Lists.newArrayList();
        paramList.forEach(data -> {
            MachineDetailDTO dto = new MachineDetailDTO();
            dto.setId(data.getId());
            dto.setMachineIp(data.getMachineIp());
            dto.setRiskFlag(this.checkRisk(data.getRiskFlag()));
            dto.setAgentId(data.getAgentId());
            dto.setApplicationName(data.getApplicationName());
            dto.setProcessName(dto.getMachineIp() + "|" + dto.getAgentId());
            dataList.add(dto);
        });
        return dataList;
    }

    private Boolean checkRisk(Integer riskFlag) {
        return riskFlag != null && riskFlag == 1;
    }

    private void parseBaseConfig(MachineDetailDTO dto, String baseConfig) {
        try {
            if (StringUtils.isBlank((CharSequence)baseConfig)) {
                return;
            }
            JSONObject jsonObject = JSON.parseObject((String)baseConfig);
            dto.setCpuNum(jsonObject.getInteger("core"));
            dto.setMemorySize(jsonObject.getBigDecimal("memory"));
            dto.setDiskSize(jsonObject.getBigDecimal("disk"));
            dto.setMbps(this.convertByte2Mb(jsonObject.getBigDecimal("mbps")));
        }
        catch (Exception e) {
            log.error("Parse BaseConfig Error: config={}, error={}", (Object)baseConfig, (Object)e.getMessage());
        }
    }

    private void parseTpsConfig(MachineDetailDTO dto, List<String> configs) {
        try {
            if (CollectionUtils.isEmpty(configs)) {
                return;
            }
            String[] time = this.getTpsConfigLength(configs);
            if (time == null || time.length == 0) {
                return;
            }
            int count = 0;
            Integer[] tps = new Integer[time.length];
            BigDecimal[] cpu = new BigDecimal[time.length];
            BigDecimal[] loading = new BigDecimal[time.length];
            BigDecimal[] memory = new BigDecimal[time.length];
            BigDecimal[] io = new BigDecimal[time.length];
            BigDecimal[] network = new BigDecimal[time.length];
            for (String config : configs) {
                TpsTargetArray array;
                if (StringUtils.isBlank((CharSequence)config) || (array = (TpsTargetArray)JSON.parseObject((String)config, TpsTargetArray.class)) == null) continue;
                for (int i = 0; i < time.length; ++i) {
                    tps[i] = (tps[i] != null ? tps[i] : 0) + array.getTps()[i];
                    cpu[i] = (cpu[i] != null ? cpu[i] : ZERO).add(array.getCpu()[i]);
                    loading[i] = (loading[i] != null ? loading[i] : ZERO).add(array.getLoading()[i]);
                    memory[i] = (memory[i] != null ? memory[i] : ZERO).add(array.getMemory()[i]);
                    io[i] = (io[i] != null ? io[i] : ZERO).add(array.getIo()[i]);
                    network[i] = (network[i] != null ? network[i] : ZERO).add(array.getNetwork()[i]);
                }
                ++count;
            }
            for (int i = 0; i < time.length; ++i) {
                cpu[i] = this.avg(cpu[i], Integer.valueOf(count));
                loading[i] = this.avg(loading[i], Integer.valueOf(count));
                memory[i] = this.avg(memory[i], Integer.valueOf(count));
                io[i] = this.avg(io[i], Integer.valueOf(count));
                network[i] = this.avg(network[i], Integer.valueOf(count));
            }
            MachineDetailDTO.MachineTPSTargetDTO tpsTargetDTO = new MachineDetailDTO.MachineTPSTargetDTO(new MachineDetailDTO());
            tpsTargetDTO.setTime(time);
            tpsTargetDTO.setTps(tps);
            tpsTargetDTO.setCpu(cpu);
            tpsTargetDTO.setLoad(loading);
            tpsTargetDTO.setMemory(memory);
            tpsTargetDTO.setIo(io);
            tpsTargetDTO.setMbps(network);
            dto.setTpsTarget(tpsTargetDTO);
        }
        catch (Exception e) {
            log.error("Parse PtsConfig Error:, error={}", (Object)e.getMessage());
        }
    }

    private String[] getTpsConfigLength(List<String> configs) {
        for (String config : configs) {
            TpsTargetArray array;
            if (StringUtils.isBlank((CharSequence)config) || (array = (TpsTargetArray)JSON.parseObject((String)config, TpsTargetArray.class)) == null) continue;
            return array.getTime();
        }
        return null;
    }

    private BigDecimal avg(BigDecimal num1, Integer count) {
        return num1.divide(new BigDecimal(count), 2, RoundingMode.HALF_UP);
    }

    private BigDecimal convertByte2Mb(BigDecimal num) {
        if (num == null) {
            return ZERO;
        }
        return num.divide(new BigDecimal(0x100000), 0, RoundingMode.HALF_UP);
    }
}

