/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.report.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.pamirs.tro.entity.dao.confcenter.TApplicationMntDao;
import com.pamirs.tro.entity.domain.dto.report.ReportApplicationDTO;
import com.pamirs.tro.entity.domain.dto.report.ReportDetailDTO;
import com.pamirs.tro.entity.domain.entity.TApplicationMnt;
import com.pamirs.tro.entity.domain.risk.Metrices;
import io.shulie.tro.web.app.service.report.ReportService;
import io.shulie.tro.web.app.service.report.impl.ReportApplicationService;
import io.shulie.tro.web.common.domain.WebResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReportDataCache {
    private static final Logger log = LoggerFactory.getLogger(ReportDataCache.class);
    private static List<Metrices> allMetrics = Lists.newArrayList();
    private static ReportDetailDTO reportDetail = null;
    private static List<String> applications = Lists.newArrayList();
    @Autowired
    private TApplicationMntDao tApplicationMntDao;
    @Autowired
    private ReportService reportService;
    @Autowired
    private ReportApplicationService reportApplicationService;

    public void readyCloudReportData(Long reportId) {
        this.queryReportDetail(reportId);
        this.queryAllMetricsData(reportId);
        this.fetchApplications();
    }

    private void queryReportDetail(Long reportId) {
        ReportApplicationDTO reportApplication = this.reportApplicationService.getReportApplication(reportId);
        reportDetail = reportApplication.getReportDetail();
        log.info("Report Id={}, Status={}", (Object)reportId, (Object)reportDetail.getTaskStatus());
        applications = reportApplication.getApplicationNames();
        log.info("Report Id={}, applicationName={}", (Object)reportId, (Object)JSON.toJSONString((Object)applications));
    }

    private void queryAllMetricsData(Long reportId) {
        if (reportDetail == null) {
            return;
        }
        WebResponse response = this.reportService.queryMetrices(reportId, reportDetail.getSceneId(), reportDetail.getCustomId());
        if (response == null || CollectionUtils.isEmpty((Collection)((Collection)response.getData()))) {
            log.error("ReportDataCache Cache Jmeter Metric is null");
            return;
        }
        log.info("ReportDataCache Cache Jmeter Metrices Data Size={}, One Sample: {}", (Object)((List)response.getData()).size(), (Object)JSONObject.toJSONString(((List)response.getData()).get(0)));
        ArrayList metrices = Lists.newArrayList();
        ((List)response.getData()).forEach(data -> {
            Metrices metric = new Metrices();
            metric.setTime((Long)data.get("time"));
            metric.setAvgTps((Double)data.get("avgTps"));
            metrices.add(metric);
        });
        allMetrics.addAll(metrices);
    }

    private void fetchApplications() {
        if (reportDetail == null || CollectionUtils.isEmpty((Collection)reportDetail.getBusinessActivity())) {
            log.error("\u62a5\u544a\u4e2d\u5173\u8054\u7684\u4e1a\u52a1\u6d3b\u52a8\u4e3a\u7a7a");
            return;
        }
        HashSet appSet = Sets.newHashSet();
        reportDetail.getBusinessActivity().forEach(data -> appSet.addAll(this.splitApplicationIds(data.getApplicationIds())));
        if (appSet.size() == 0) {
            log.error("\u62a5\u544a\u4e2d\u5173\u8054\u7684\u5e94\u7528\u4e3a\u7a7a");
            return;
        }
        List appsList = this.tApplicationMntDao.queryApplicationMntListByIds((List)Lists.newArrayList((Iterable)appSet));
        if (CollectionUtils.isEmpty((Collection)appsList)) {
            log.error("\u62a5\u544a\u4e2d\u5173\u8054\u7684\u5e94\u7528\u4e3a\u7a7a");
            return;
        }
        applications = appsList.stream().map(TApplicationMnt::getApplicationName).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).distinct().collect(Collectors.toList());
        log.info("\u62a5\u544a\u4e2d\u5173\u8054\u7684\u5e94\u7528\u6709\uff1a{}", (Object)JSON.toJSONString((Object)applications));
    }

    public ReportDetailDTO getReportDetail() {
        return reportDetail;
    }

    public List<Metrices> getAllMetricsData() {
        return allMetrics;
    }

    public List<String> getApplications() {
        return applications;
    }

    public void clearDataCache() {
        allMetrics.clear();
        reportDetail = null;
        applications.clear();
    }

    private List<Long> splitApplicationIds(String applicationIds) {
        if (StringUtils.isBlank((CharSequence)applicationIds)) {
            return Collections.EMPTY_LIST;
        }
        String[] args = applicationIds.split(",");
        ArrayList dataList = Lists.newArrayList();
        for (String arg : args) {
            dataList.add(Long.parseLong(arg));
        }
        return dataList;
    }
}

