/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.report.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.pamirs.tro.entity.dao.confcenter.TApplicationMntDao;
import com.pamirs.tro.entity.domain.dto.report.ReportApplicationDTO;
import com.pamirs.tro.entity.domain.dto.report.ReportDetailDTO;
import io.shulie.tro.web.app.service.report.ReportService;
import io.shulie.tro.web.common.domain.WebResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReportApplicationService {
    private static final Logger log = LoggerFactory.getLogger(ReportApplicationService.class);
    @Autowired
    private ReportService reportService;
    @Resource
    private TApplicationMntDao tApplicationMntDao;

    public ReportDetailDTO getDetail(Long reportId) {
        WebResponse response = this.reportService.getReportByReportId(reportId);
        if (response != null && response.getData() != null) {
            return (ReportDetailDTO)JSON.parseObject((String)JSON.toJSONString((Object)response.getData()), ReportDetailDTO.class);
        }
        return new ReportDetailDTO();
    }

    public ReportApplicationDTO getReportApplication(Long reportId) {
        ReportApplicationDTO reportApplication = new ReportApplicationDTO();
        ReportDetailDTO reportDetail = this.getDetail(reportId);
        reportApplication.setReportDetail(reportDetail);
        if (reportDetail == null || CollectionUtils.isEmpty((Collection)reportDetail.getBusinessActivity())) {
            return reportApplication;
        }
        HashSet appSet = Sets.newHashSet();
        reportDetail.getBusinessActivity().forEach(data -> appSet.addAll(this.splitApplicationIds(data.getApplicationIds())));
        if (appSet.size() == 0) {
            return reportApplication;
        }
        List appsList = this.tApplicationMntDao.queryApplicationMntListByIds((List)Lists.newArrayList((Iterable)appSet));
        if (CollectionUtils.isEmpty((Collection)appsList)) {
            return reportApplication;
        }
        reportApplication.setApplicationNames(appsList.stream().filter(data -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{data.getApplicationName()})).map(data -> data.getApplicationName()).distinct().collect(Collectors.toList()));
        return reportApplication;
    }

    private List<Long> splitApplicationIds(String applicationIds) {
        if (StringUtils.isBlank((CharSequence)applicationIds)) {
            return Collections.EMPTY_LIST;
        }
        String[] args = applicationIds.split(",");
        ArrayList dataList = Lists.newArrayList();
        for (String arg : args) {
            dataList.add(Long.parseLong(arg));
        }
        return dataList;
    }
}

