/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.pradar.impl;

import io.shulie.tro.web.app.response.pradar.PradarZKConfigResponse;
import io.shulie.tro.web.app.service.pradar.PradarConfigService;
import io.shulie.tro.web.app.service.pradar.impl.PradarConfigServiceImpl;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.WatchPathable;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class PradarConfigServiceImpl
implements PradarConfigService {
    private static final Logger log = LoggerFactory.getLogger(PradarConfigServiceImpl.class);
    List<PradarZKConfig> pradarZKConfigList = Arrays.asList(new PradarZKConfig(1, "/pradar/config/rt/hdfsDisable", PradarZKDataType.Boolean, "false", "hdfs\u5f00\u5173\u914d\u7f6e\uff0c\u63a7\u5236\u6570\u636e\u662f\u5426\u4e0d\u5199\u5165hdfs"), new PradarZKConfig(2, "/pradar/config/rt/hdfsSampling", PradarZKDataType.Int, "1", "\u65e5\u5fd7\u539f\u6587\u5199\u5165hdfs\u91c7\u6837\u7387\u914d\u7f6e\uff0c\u4ee3\u8868\u6bcf\u591a\u5c11\u6761\u6570\u636e\u91c7\u68371\u6761"), new PradarZKConfig(3, "/pradar/config/rt/monitroDisable", PradarZKDataType.Boolean, "false", "\u57fa\u7840\u4fe1\u606f\u5904\u7406\u5f00\u5173\uff0c\u63a7\u5236\u538b\u6d4b\u6307\u6807\u4fe1\u606f\u662f\u5426\u4e0d\u5904\u7406"), new PradarZKConfig(4, "/pradar/config/rt/clickhouseDisable", PradarZKDataType.Boolean, "false", "\u65e5\u5fd7\u539f\u6587\u5199\u5165clickhouse\u5f00\u5173\uff0c\u63a7\u5236\u65e5\u5fd7\u539f\u6587\u662f\u5426\u4e0d\u5199\u5165clickhouse"), new PradarZKConfig(5, "/pradar/config/rt/clickhouseSampling", PradarZKDataType.Int, "1", "\u65e5\u5fd7\u539f\u6587\u5199\u5165clickhouse\u91c7\u6837\u7387\uff0c\u4ee3\u8868\u6bcf\u591a\u5c11\u6761\u6570\u636e\u91c7\u68371\u6761"), new PradarZKConfig(6, "/config/log/trace/simpling", PradarZKDataType.Int, "1", "\u5168\u5c40\u65e5\u5fd7\u91c7\u6837\u7387"));
    @Autowired
    private Environment environment;
    private CuratorFramework client;

    @PostConstruct
    public void init() {
        String zkAddr = this.environment.getProperty("tro.config.zk.addr");
        if (StringUtils.isEmpty((Object)zkAddr)) {
            throw new RuntimeException("\u914d\u7f6e\u4e2d\u5fc3zk\u5730\u5740\u6ca1\u6709\u586b\u5199\uff0c\u8bf7\u6838\u5bf9\u6821\u9a8c`tro.config.zk.addr`");
        }
        int timeout = 3000;
        try {
            String timeoutString = this.environment.getProperty("tro.config.zk.timeout");
            if (timeoutString != null) {
                timeout = Integer.parseInt(timeoutString);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.client = CuratorFrameworkFactory.builder().connectString(zkAddr).sessionTimeoutMs(timeout).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(1000, 3)).build();
        this.client.start();
    }

    public List<PradarZKConfigResponse> getConfigList() {
        Stat stat = new Stat();
        return this.pradarZKConfigList.stream().map(pradarZKConfig -> new PradarZKConfigResponse(pradarZKConfig.getId(), pradarZKConfig.getZkPath(), pradarZKConfig.getType().type, this.getNode(stat, pradarZKConfig.getZkPath()), pradarZKConfig.getRemark(), stat.getCtime(), stat.getMtime())).collect(Collectors.toList());
    }

    public void initZKData() {
        this.pradarZKConfigList.forEach(pradarZKConfig -> {
            if (!this.checkNodeExists(pradarZKConfig.zkPath)) {
                this.addNode(pradarZKConfig.zkPath, pradarZKConfig.defaultValue);
            }
        });
    }

    public boolean updateConfig(int id, String value) {
        try {
            this.pradarZKConfigList.stream().filter(pradarZKConfig -> id == pradarZKConfig.id).forEach(pradarZKConfig -> this.updateNode(pradarZKConfig.zkPath, value));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void addNode(String path, String data) {
        try {
            ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentContainersIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(path, data.getBytes());
        }
        catch (Exception e) {
            log.error("\u521b\u5efazk\u6570\u636e\u8282\u70b9\u5931\u8d25;path={},data={}", new Object[]{path, data, e});
        }
    }

    private String getNode(Stat stat, String path) {
        if (!this.checkNodeExists(path)) {
            return null;
        }
        byte[] bytes = new byte[]{};
        try {
            bytes = (byte[])((WatchPathable)this.client.getData().storingStatIn(stat)).forPath(path);
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6zk\u6570\u636e\u8282\u70b9\u5931\u8d25;path={}", (Object)path, (Object)e);
        }
        return new String(bytes);
    }

    private boolean checkNodeExists(String path) {
        try {
            return this.client.checkExists().forPath(path) != null;
        }
        catch (Exception e) {
            log.error("\u5224\u65ad\u6570\u636e\u8282\u70b9\u662f\u5426\u5b58\u5728\u5931\u8d25;path={}", (Object)path, (Object)e);
            return false;
        }
    }

    private void updateNode(String path, String data) {
        try {
            this.client.setData().forPath(path, data.getBytes());
        }
        catch (Exception e) {
            log.error("\u521b\u5efazk\u6570\u636e\u8282\u70b9\u5931\u8d25;path={},data={}", new Object[]{path, data, e});
        }
    }
}

