/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.perfomanceanaly.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pamirs.tro.entity.domain.dto.report.ReportDetailDTO;
import io.shulie.tro.channel.bean.CommandCommon;
import io.shulie.tro.channel.bean.CommandPacket;
import io.shulie.tro.channel.bean.CommandStatus;
import io.shulie.tro.exception.entity.ExceptionReadable;
import io.shulie.tro.utils.json.JsonHelper;
import io.shulie.tro.web.app.agent.AgentCommandEnum;
import io.shulie.tro.web.app.agent.AgentCommandFactory;
import io.shulie.tro.web.app.convert.performace.TraceManageResponseConvertor;
import io.shulie.tro.web.app.exception.ExceptionCode;
import io.shulie.tro.web.app.exception.TroWebException;
import io.shulie.tro.web.app.request.perfomanceanaly.TraceManageCreateRequest;
import io.shulie.tro.web.app.request.perfomanceanaly.TraceManageDeployQueryRequest;
import io.shulie.tro.web.app.request.perfomanceanaly.TraceManageQueryListRequest;
import io.shulie.tro.web.app.response.perfomanceanaly.TraceManageCreateResponse;
import io.shulie.tro.web.app.response.perfomanceanaly.TraceManageResponse;
import io.shulie.tro.web.app.service.perfomanceanaly.TraceManageService;
import io.shulie.tro.web.app.service.report.ReportService;
import io.shulie.tro.web.common.domain.WebResponse;
import io.shulie.tro.web.common.enums.TraceManageStatusEnum;
import io.shulie.tro.web.common.vo.agent.TraceVO;
import io.shulie.tro.web.config.sync.api.TraceManageSyncService;
import io.shulie.tro.web.data.dao.perfomanceanaly.TraceManageDAO;
import io.shulie.tro.web.data.param.tracemanage.TraceManageCreateParam;
import io.shulie.tro.web.data.param.tracemanage.TraceManageDeployCreateParam;
import io.shulie.tro.web.data.param.tracemanage.TraceManageDeployUpdateParam;
import io.shulie.tro.web.data.param.tracemanage.TraceManageQueryParam;
import io.shulie.tro.web.data.result.tracemanage.TraceManageDeployResult;
import io.shulie.tro.web.data.result.tracemanage.TraceManageResult;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TraceManageServiceImpl
implements TraceManageService {
    private static final Logger log = LoggerFactory.getLogger(TraceManageServiceImpl.class);
    private static final int MAX_LEVEL = 5;
    @Autowired
    private TraceManageDAO traceManageDAO;
    @Autowired
    private TraceManageSyncService traceManageSyncService;
    @Autowired
    private ReportService reportService;
    @Autowired
    private AgentCommandFactory agentCommandFactory;

    public TraceManageCreateResponse createTraceManage(TraceManageCreateRequest traceManageCreateRequest) throws Exception {
        TraceManageCreateResponse traceManageCreateResponse = new TraceManageCreateResponse();
        String processName = traceManageCreateRequest.getProcessName();
        if (StringUtils.isBlank((CharSequence)processName)) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.TRACE_MANAGE_PARAM_VALID_ERROR, (Object)"\u8fdb\u7a0b\u540d\u79f0\u4e3a\u7a7a\uff01");
        }
        String[] split = StringUtils.split((String)processName, (String)"|");
        String agentId = split[1];
        String serverIp = split[0];
        int num = this.traceManageDAO.countTraceIngManageDeployByAgentId(agentId);
        if (num > 0) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.TRACE_MANAGE_VALID_ERROR, (Object)"\u5f53\u524d\u5e94\u7528\u5df2\u6709\u8ffd\u8e2a\u4efb\u52a1\u6267\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        if (traceManageCreateRequest.getReportId() == null) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.TRACE_MANAGE_PARAM_VALID_ERROR, (Object)"\u62a5\u544aid\u4e3a\u7a7a\uff01");
        }
        WebResponse reportDetail = this.reportService.getReportByReportId(traceManageCreateRequest.getReportId());
        if (reportDetail == null || !reportDetail.getSuccess().booleanValue() || reportDetail.getData() == null) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.TRACE_MANAGE_VALID_ERROR, (Object)"\u627e\u4e0d\u5230\u5f53\u524d\u5bf9\u5e94\u7684\u62a5\u544a\uff01");
        }
        String bean2Json = JsonHelper.bean2Json((Object)reportDetail.getData());
        ReportDetailDTO reportDetailDTO = (ReportDetailDTO)JsonHelper.json2Bean((String)bean2Json, ReportDetailDTO.class);
        if (reportDetailDTO.getTaskStatus() != 1) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.TRACE_MANAGE_VALID_ERROR, (Object)"\u5f53\u524d\u62a5\u544a\u4e0d\u5728\u538b\u6d4b\u4e2d\uff0c\u4e0d\u80fd\u8ffd\u8e2a\u8be5\u62a5\u544a\uff01");
        }
        if (traceManageCreateRequest.getTraceManageDeployId() != null) {
            TraceManageDeployResult traceManageDeployResult = this.traceManageDAO.queryTraceManageDeployById(traceManageCreateRequest.getTraceManageDeployId());
            if (traceManageDeployResult == null) {
                throw new TroWebException((ExceptionReadable)ExceptionCode.TRACE_MANAGE_VALID_ERROR, (Object)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8ffd\u8e2a\u65b9\u6cd5\u5b9e\u4f8b\uff01");
            }
            if (traceManageDeployResult.getLevel() >= 5) {
                throw new TroWebException((ExceptionReadable)ExceptionCode.TRACE_MANAGE_VALID_ERROR, (Object)"\u5f53\u524d\u8ffd\u8e2a\u5b9e\u4f8b\u5df2\u8fbe\u52305\u5c42\uff0c\u8bf7\u91cd\u65b0\u5f00\u59cb\u8ffd\u8e2a\uff01");
            }
            if (StringUtils.isBlank((CharSequence)traceManageDeployResult.getSampleId())) {
                String sampleId = this.createSampleId(traceManageDeployResult.toString());
                traceManageDeployResult.setSampleId(sampleId);
                TraceManageDeployUpdateParam updateParam = new TraceManageDeployUpdateParam();
                BeanUtils.copyProperties((Object)traceManageDeployResult, (Object)updateParam);
                updateParam.setStatus(TraceManageStatusEnum.TRACE_RUNNING.getCode());
                this.traceManageDAO.updateTraceManageDeploy(updateParam);
                this.createZkTraceManage(agentId, traceManageDeployResult.getSampleId(), traceManageDeployResult.getTraceDeployObject());
                traceManageCreateResponse.setSampleId(sampleId);
            }
        } else {
            TraceManageCreateParam traceManageCreateParam = new TraceManageCreateParam();
            traceManageCreateParam.setTraceObject(traceManageCreateRequest.getTraceObject());
            traceManageCreateParam.setReportId(traceManageCreateRequest.getReportId());
            traceManageCreateParam.setAgentId(agentId);
            traceManageCreateParam.setServerIp(serverIp);
            BeanUtils.copyProperties((Object)traceManageCreateRequest, (Object)traceManageCreateParam);
            String sampleId = this.createSampleId(traceManageCreateParam.toString());
            this.traceManageDAO.createTraceManageAndDeploy(traceManageCreateParam, sampleId);
            this.createZkTraceManage(agentId, sampleId, traceManageCreateParam.getTraceObject());
            traceManageCreateResponse.setSampleId(sampleId);
        }
        return traceManageCreateResponse;
    }

    private void createZkTraceManage(String agentId, String sampleId, String traceDeployObject) throws Exception {
        HashMap param = Maps.newHashMap();
        param.put("sampleId", sampleId);
        String[] split = StringUtils.split((String)traceDeployObject, (String)"#");
        param.put("class", split[0]);
        param.put("method", split[1]);
        param.put("limits", 100);
        param.put("wait", 3000);
        this.agentCommandFactory.send(AgentCommandEnum.PULL_AGENT_INFO_TRACE_COMMAND, agentId, (Map)param);
    }

    private String createSampleId(String param) {
        return UUID.randomUUID().toString();
    }

    public TraceManageResponse queryTraceManageDeploy(TraceManageDeployQueryRequest traceManageDeployQueryRequest) {
        Boolean traceStatus;
        if (traceManageDeployQueryRequest == null) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.TRACE_MANAGE_PARAM_VALID_ERROR, (Object)"\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (traceManageDeployQueryRequest.getId() == null && StringUtils.isBlank((CharSequence)traceManageDeployQueryRequest.getSampleId())) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.TRACE_MANAGE_PARAM_VALID_ERROR, (Object)"\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u90fd\u4e3a\u7a7a\uff01");
        }
        if (!StringUtils.isBlank((CharSequence)traceManageDeployQueryRequest.getSampleId())) {
            TraceManageDeployResult traceManageDeployResult = this.traceManageDAO.queryTraceManageDeployBySampleId(traceManageDeployQueryRequest.getSampleId());
            if (traceManageDeployResult == null) {
                throw new TroWebException((ExceptionReadable)ExceptionCode.TRACE_MANAGE_VALID_ERROR, (Object)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8ffd\u8e2a\u65b9\u6cd5\u5b9e\u4f8b\uff01");
            }
            traceManageDeployQueryRequest.setId(traceManageDeployResult.getTraceManageId());
            traceStatus = !TraceManageStatusEnum.isRunning((Integer)traceManageDeployResult.getStatus());
            if (TraceManageStatusEnum.TRACE_TIMEOUT.getCode().equals(traceManageDeployResult.getStatus())) {
                throw new TroWebException((ExceptionReadable)ExceptionCode.TRACE_MANAGE_TIMEOUT, (Object)"\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
            }
            if (TraceManageStatusEnum.AGENT_TRACE_ERROR.getCode().equals(traceManageDeployResult.getStatus())) {
                String errorMessage = TraceManageStatusEnum.AGENT_TRACE_ERROR.getName();
                if (StringUtils.isNotBlank((CharSequence)traceManageDeployResult.getFeature())) {
                    Map error = (Map)JsonHelper.string2Obj((String)traceManageDeployResult.getFeature(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                    errorMessage = (String)error.get("agentError");
                }
                throw new TroWebException((ExceptionReadable)ExceptionCode.TRACE_MANAGE_ERROR, (Object)errorMessage);
            }
        } else {
            traceStatus = true;
        }
        if (traceManageDeployQueryRequest.getId() != null) {
            TraceManageResponse result = this.getTraceManageResponseByTraceManageResult(this.traceManageDAO.queryTraceManageById(traceManageDeployQueryRequest.getId()));
            result.setTraceStatus(traceStatus.booleanValue());
            return result;
        }
        return null;
    }

    public void uploadTraceInfo(CommandPacket commandPacket) {
        if (commandPacket == null) {
            log.error("\u4e0a\u4f20trace\u4fe1\u606f\uff0c\u53c2\u6570\u4e3a\u7a7a");
            throw new TroWebException((ExceptionReadable)ExceptionCode.TRACE_MANAGE_PARAM_VALID_ERROR, (Object)"\u4e0a\u4f20\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String sampleId = Optional.ofNullable(commandPacket.getSend()).map(CommandCommon::getParam).map(map -> map.get("sampleId").toString()).orElseThrow(() -> new TroWebException((ExceptionReadable)ExceptionCode.TRACE_MANAGE_PARAM_VALID_ERROR, (Object)"\u4e0a\u4f20\u53c2\u6570\u552f\u4e00id\u4e3a\u7a7a\uff01"));
        TraceManageDeployResult deployResult = this.traceManageDAO.queryTraceManageDeployBySampleId(sampleId);
        if (deployResult == null) {
            log.error("\u4e0a\u4f20trace\u4fe1\u606f,\u6839\u636esampleId\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a,sampleId:{}", (Object)sampleId);
            throw new TroWebException((ExceptionReadable)ExceptionCode.TRACE_MANAGE_PARAM_VALID_ERROR, (Object)"\u6839\u636esampleId\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u503c!");
        }
        TraceManageDeployUpdateParam traceManageDeployUpdateParam = new TraceManageDeployUpdateParam();
        BeanUtils.copyProperties((Object)deployResult, (Object)traceManageDeployUpdateParam);
        CommandStatus commandStatus = commandPacket.getStatus();
        HashMap error = Maps.newHashMap();
        if (!CommandStatus.COMMAND_COMPLETED_SUCCESS.equals((Object)commandStatus)) {
            error.put("agentError", "agent\u6267\u884c\u5931\u8d25\uff0c\u547d\u4ee4\u72b6\u6001" + commandStatus.getStatus());
            this.updateTraceError((Map)error, traceManageDeployUpdateParam);
            return;
        }
        if (commandPacket.getResponse() == null) {
            error.put("agentError", "agent\u6267\u884c\u5931\u8d25\uff0c\u54cd\u5e94\u7ed3\u679c\u4e3a\u7a7a");
            this.updateTraceError((Map)error, traceManageDeployUpdateParam);
            return;
        }
        if (!commandPacket.getResponse().isSuccess()) {
            error.put("agentError", "agent\u6267\u884c\u5931\u8d25\uff0c\u547d\u4ee4\u7ed3\u679c:" + commandPacket.getResponse().getMessage());
            this.updateTraceError((Map)error, traceManageDeployUpdateParam);
            return;
        }
        List result = (List)commandPacket.getResponse().getResult();
        if (result.size() == 0) {
            error.put("agentError", "agent\u6267\u884c\u5931\u8d25\uff0c\u547d\u4ee4\u7ed3\u679c:agent\u65e0trace\u65e5\u5fd7\u8fd4\u56de");
            this.updateTraceError((Map)error, traceManageDeployUpdateParam);
            return;
        }
        HashMap costMap = Maps.newHashMap();
        TraceVO traceVO = this.convertTraceVo((Map)costMap, result, traceManageDeployUpdateParam);
        if (traceManageDeployUpdateParam.getLineNum() == null) {
            BeanUtils.copyProperties((Object)traceVO, (Object)traceManageDeployUpdateParam);
        }
        traceManageDeployUpdateParam.setStatus(TraceManageStatusEnum.TRACE_CLOSE.getCode());
        traceManageDeployUpdateParam.setHasChildren(Integer.valueOf(CollectionUtils.isNotEmpty((Collection)traceVO.getChildren()) ? 1 : 0));
        this.traceManageDAO.updateTraceManageDeploy(traceManageDeployUpdateParam);
        if (CollectionUtils.isNotEmpty((Collection)traceVO.getChildren())) {
            ArrayList createParams = Lists.newArrayList();
            this.getCreateParams((List)createParams, traceVO.getChildren(), deployResult);
            this.traceManageDAO.createTraceManageDeploy((List)createParams);
        }
    }

    private TraceVO convertTraceVo(Map<String, List<Long>> costMap, List<LinkedHashMap<String, Object>> result, TraceManageDeployUpdateParam param) {
        Map deepestLevel = this.convertCostMap(costMap, result);
        TraceVO traceVO = new TraceVO();
        for (Integer key : deepestLevel.keySet()) {
            LinkedHashMap<String, Object> linkedHashMap = result.get(key);
            LinkedHashMap root = (LinkedHashMap)linkedHashMap.get("root");
            this.costMapToTraceVO(costMap, root, traceVO, "root", param);
            if (null == root.get("children")) {
                return traceVO;
            }
            List children = (List)root.get("children");
            this.forEachChildrenToTraceVO(costMap, children, traceVO, param);
        }
        return traceVO;
    }

    private void forEachChildrenToTraceVO(Map<String, List<Long>> costMap, List<LinkedHashMap<String, Object>> children, TraceVO traceVO, TraceManageDeployUpdateParam param) {
        if (children == null || children.size() == 0) {
            return;
        }
        for (LinkedHashMap<String, Object> childrenMap : children) {
            if (!childrenMap.containsKey("className")) continue;
            this.costMapToTraceVO(costMap, childrenMap, traceVO, "children", param);
            if (null == childrenMap.get("children")) continue;
            this.forEachChildrenToTraceVO(costMap, (List)childrenMap.get("children"), traceVO, param);
        }
    }

    private void costMapToTraceVO(Map<String, List<Long>> costMap, LinkedHashMap<String, Object> map, TraceVO traceVO, String type, TraceManageDeployUpdateParam param) {
        if ("root".equals(type)) {
            TraceVO temp = this.getTraceVO(map, costMap, param, null);
            if (temp != null) {
                BeanUtils.copyProperties((Object)temp, (Object)traceVO);
            }
            return;
        }
        TraceVO children = this.getTraceVO(map, costMap, param, traceVO);
        if (traceVO.getChildren() == null) {
            traceVO.setChildren((List)Lists.newArrayList());
        }
        traceVO.getChildren().add(children);
    }

    private TraceVO getTraceVO(LinkedHashMap<String, Object> map, Map<String, List<Long>> costMap, TraceManageDeployUpdateParam param, TraceVO targetVO) {
        String key = this.getKey(map);
        if (costMap.get(key) == null || costMap.get(key).size() == 0) {
            return null;
        }
        String className = String.valueOf(map.get("className"));
        String methodName = String.valueOf(map.get("methodName"));
        Integer line = Integer.valueOf(String.valueOf(map.get("line")));
        TraceVO traceVO = new TraceVO();
        traceVO.setTraceDeployObject(className + "#" + methodName);
        traceVO.setLineNum(line);
        BigDecimal source = param.getAvgCost();
        BigDecimal scale = source == null || targetVO == null || targetVO.getAvgCost() == null ? BigDecimal.valueOf(1L) : source.divide(targetVO.getAvgCost(), 6, RoundingMode.HALF_UP);
        traceVO.setCosts(costMap.get(key));
        traceVO.setAvgCost(this.getAvgCost(costMap.get(key)).multiply(scale).setScale(6, RoundingMode.HALF_UP));
        traceVO.setP50(this.getPercentile(costMap.get(key), 0.5).multiply(scale).setScale(6, RoundingMode.HALF_UP));
        traceVO.setP90(this.getPercentile(costMap.get(key), 0.9).multiply(scale).setScale(6, RoundingMode.HALF_UP));
        traceVO.setP95(this.getPercentile(costMap.get(key), 0.95).multiply(scale).setScale(6, RoundingMode.HALF_UP));
        traceVO.setP99(this.getPercentile(costMap.get(key), 0.99).multiply(scale).setScale(6, RoundingMode.HALF_UP));
        traceVO.setMax(this.getMaxMinCost(costMap.get(key), "max").multiply(scale).setScale(6, RoundingMode.HALF_UP));
        traceVO.setMin(this.getMaxMinCost(costMap.get(key), "min").multiply(scale).setScale(6, RoundingMode.HALF_UP));
        return traceVO;
    }

    public BigDecimal getPercentile(List<Long> costs, double p) {
        int n = costs.size();
        List sortCosts = costs.stream().sorted().collect(Collectors.toList());
        double px = p * (double)(n - 1);
        int i = (int)Math.floor(px);
        double g = px - (double)i;
        if (g == 0.0) {
            return BigDecimal.valueOf((double)((Long)sortCosts.get(i + 1)).longValue() / 1000000.0).setScale(6, RoundingMode.HALF_UP);
        }
        return BigDecimal.valueOf(((1.0 - g) * (double)((Long)sortCosts.get(i)).longValue() + g * (double)((Long)sortCosts.get(i + 1)).longValue()) / 1000000.0).setScale(6, RoundingMode.HALF_UP);
    }

    public BigDecimal getMaxMinCost(List<Long> costs, String type) {
        OptionalDouble optionalDouble = "max".equals(type) ? costs.stream().mapToDouble(Long::longValue).max() : costs.stream().mapToDouble(Long::longValue).min();
        if (optionalDouble.isPresent()) {
            return BigDecimal.valueOf(optionalDouble.getAsDouble() / 1000000.0).setScale(6, RoundingMode.HALF_UP);
        }
        return BigDecimal.valueOf(0L);
    }

    public BigDecimal getAvgCost(List<Long> costs) {
        OptionalDouble optionalDouble = costs.stream().mapToDouble(Long::longValue).average();
        if (optionalDouble.isPresent()) {
            return BigDecimal.valueOf(optionalDouble.getAsDouble() / 1000000.0).setScale(6, RoundingMode.HALF_UP);
        }
        return BigDecimal.valueOf(0L);
    }

    private Map<Integer, Integer> convertCostMap(Map<String, List<Long>> costMap, List<LinkedHashMap<String, Object>> result) {
        Integer level = 0;
        Integer i = 0;
        Integer deepest = 0;
        for (LinkedHashMap<String, Object> map : result) {
            LinkedHashMap root = (LinkedHashMap)map.get("root");
            if (!root.containsKey("className")) continue;
            this.getCostMap(costMap, root);
            if (null == root.get("children")) continue;
            List children = (List)root.get("children");
            Integer temp = this.forEachChildren(costMap, children, Integer.valueOf(0));
            if (temp > level) {
                level = temp;
                deepest = i;
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        HashMap deepestLevel = Maps.newHashMap();
        deepestLevel.put(deepest, level);
        return deepestLevel;
    }

    private Integer forEachChildren(Map<String, List<Long>> costMap, List<LinkedHashMap<String, Object>> children, Integer temp) {
        if (children == null || children.size() == 0) {
            return temp;
        }
        temp = temp + 1;
        for (LinkedHashMap<String, Object> childrenMap : children) {
            if (!childrenMap.containsKey("className")) continue;
            this.getCostMap(costMap, childrenMap);
            if (null == childrenMap.get("children")) continue;
            temp = this.forEachChildren(costMap, (List)childrenMap.get("children"), temp);
        }
        return temp;
    }

    private String getKey(LinkedHashMap<String, Object> map) {
        String className = String.valueOf(map.get("className"));
        String methodName = String.valueOf(map.get("methodName"));
        int line = Integer.parseInt(String.valueOf(map.get("line")));
        return className + "#" + methodName + "#" + line;
    }

    private void getCostMap(Map<String, List<Long>> costMap, LinkedHashMap<String, Object> map) {
        Long cost = map.get("cost") == null ? 0L : Long.parseLong(map.get("cost").toString());
        costMap.compute(this.getKey(map), (k, v) -> {
            List<Long> longs = v == null ? Lists.newArrayList() : v;
            longs.add(cost);
            return longs;
        });
    }

    private void updateTraceError(Map<String, String> error, TraceManageDeployUpdateParam updateParam) {
        updateParam.setStatus(TraceManageStatusEnum.AGENT_TRACE_ERROR.getCode());
        updateParam.setFeature(JsonHelper.bean2Json(error));
        this.traceManageDAO.updateTraceManageDeploy(updateParam);
    }

    public List<TraceManageResponse> queryTraceManageList(TraceManageQueryListRequest traceManageQueryListRequest) {
        TraceManageQueryParam traceManageQueryParam = new TraceManageQueryParam();
        BeanUtils.copyProperties((Object)traceManageQueryListRequest, (Object)traceManageQueryParam);
        List traceManageResults = this.traceManageDAO.queryTraceManageList(traceManageQueryParam);
        if (CollectionUtils.isNotEmpty((Collection)traceManageResults)) {
            return traceManageResults.stream().map(arg_0 -> ((TraceManageResponseConvertor)TraceManageResponseConvertor.INSTANCE).ofTraceManageResponse(arg_0)).collect(Collectors.toList());
        }
        return new ArrayList<TraceManageResponse>();
    }

    private void getCreateParams(List<TraceManageDeployCreateParam> createParams, List<TraceVO> children, TraceManageDeployResult result) {
        if (CollectionUtils.isNotEmpty(children)) {
            for (TraceVO vo : children) {
                TraceManageDeployCreateParam createParam = new TraceManageDeployCreateParam();
                BeanUtils.copyProperties((Object)vo, (Object)createParam);
                createParam.setTraceManageId(result.getTraceManageId());
                createParam.setLevel(Integer.valueOf(result.getLevel() + 1));
                createParam.setParentId(result.getId());
                createParam.setTraceDeployObject(vo.getTraceDeployObject());
                createParam.setStatus(TraceManageStatusEnum.TRACE_WAIT.getCode());
                createParam.setHasChildren(Integer.valueOf(2));
                createParams.add(createParam);
            }
        }
    }

    private TraceManageResponse getTraceManageResponseByTraceManageResult(TraceManageResult traceManageResult) {
        if (traceManageResult == null) {
            return null;
        }
        TraceManageResponse traceManageResponse = TraceManageResponseConvertor.INSTANCE.ofTraceManageResponse(traceManageResult);
        if (traceManageResult.getTraceManageDeployResult() != null) {
            traceManageResponse.setTraceManageDeployResponse(TraceManageResponseConvertor.INSTANCE.ofTraceManageDeployResponse(traceManageResult.getTraceManageDeployResult()));
        }
        return traceManageResponse;
    }
}

