/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.perfomanceanaly.impl;

import com.google.common.collect.Lists;
import com.pamirs.tro.common.util.DateUtils;
import io.shulie.tro.cloud.common.utils.DateUtil;
import io.shulie.tro.web.app.request.perfomanceanaly.PerformanceAnalyzeRequest;
import io.shulie.tro.web.app.request.perfomanceanaly.PerformanceCommonRequest;
import io.shulie.tro.web.app.request.perfomanceanaly.ThreadCpuUseRateRequest;
import io.shulie.tro.web.app.request.perfomanceanaly.ThreadListRequest;
import io.shulie.tro.web.app.response.perfomanceanaly.ProcessBaseDataResponse;
import io.shulie.tro.web.app.response.perfomanceanaly.ReportTimeResponse;
import io.shulie.tro.web.app.response.perfomanceanaly.ThreadCpuChartResponse;
import io.shulie.tro.web.app.response.perfomanceanaly.ThreadCpuUseRateChartResponse;
import io.shulie.tro.web.app.response.perfomanceanaly.ThreadDetailResponse;
import io.shulie.tro.web.app.response.perfomanceanaly.ThreadListResponse;
import io.shulie.tro.web.app.response.perfomanceanaly.ThreadStatusResponse;
import io.shulie.tro.web.app.service.perfomanceanaly.ReportDetailService;
import io.shulie.tro.web.app.service.perfomanceanaly.ThreadAnalyService;
import io.shulie.tro.web.data.dao.baseserver.BaseServerDao;
import io.shulie.tro.web.data.dao.perfomanceanaly.PerformanceBaseDataDAO;
import io.shulie.tro.web.data.dao.perfomanceanaly.PerformanceThreadDataDAO;
import io.shulie.tro.web.data.param.baseserver.BaseServerParam;
import io.shulie.tro.web.data.param.perfomanceanaly.PerformanceBaseQueryParam;
import io.shulie.tro.web.data.param.perfomanceanaly.PerformanceThreadQueryParam;
import io.shulie.tro.web.data.result.baseserver.BaseServerResult;
import io.shulie.tro.web.data.result.perfomanceanaly.PerformanceBaseDataResult;
import io.shulie.tro.web.data.result.perfomanceanaly.PerformanceThreadCountResult;
import io.shulie.tro.web.data.result.perfomanceanaly.PerformanceThreadDataResult;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ThreadAnalyServiceImpl
implements ThreadAnalyService {
    private static final Logger log = LoggerFactory.getLogger(ThreadAnalyServiceImpl.class);
    @Autowired
    private ReportDetailService reportDetailService;
    @Autowired
    private PerformanceBaseDataDAO performanceBaseDataDAO;
    @Autowired
    private PerformanceThreadDataDAO performanceThreadDataDAO;
    @Autowired
    private BaseServerDao baseServerDao;

    public ProcessBaseDataResponse getBaseData(PerformanceAnalyzeRequest request) {
        PerformanceBaseQueryParam baseParam = this.buildBaseQueryParam(request.getReportId(), (PerformanceCommonRequest)request);
        PerformanceBaseDataResult baseData = this.performanceBaseDataDAO.getOnePerformanceBaseData(baseParam);
        ProcessBaseDataResponse baseResponse = new ProcessBaseDataResponse();
        BeanUtils.copyProperties((Object)baseData, (Object)baseResponse);
        baseResponse.setProcessName(baseData.getAppName());
        return baseResponse;
    }

    public List<ThreadCpuChartResponse> getThreadAnalyze(PerformanceAnalyzeRequest request) {
        PerformanceBaseQueryParam baseParam = this.buildBaseQueryParam(request.getReportId(), (PerformanceCommonRequest)request);
        List baseList = this.performanceBaseDataDAO.getPerformanceBaseDataList(baseParam);
        if (CollectionUtils.isEmpty((Collection)baseList)) {
            return Lists.newArrayList();
        }
        List<ThreadCpuChartResponse> responses = baseList.stream().map(base -> {
            ThreadCpuChartResponse response = new ThreadCpuChartResponse();
            response.setTime(DateUtils.dateToString((Date)new Date(base.getTimestamp()), (String)"yyyy-MM-dd HH:mm:ss").substring(11, 19));
            response.setThreadCount(base.getThreadCount());
            response.setBaseId(base.getBaseId());
            response.setCpuRate(new BigDecimal(base.getCpuUseRate()).setScale(2, RoundingMode.HALF_UP));
            return response;
        }).collect(Collectors.toList());
        return responses;
    }

    private void buildBaseServerParam(PerformanceBaseQueryParam param, List<PerformanceThreadCountResult> resultList, BaseServerParam baseParam) {
        if (CollectionUtils.isEmpty(resultList)) {
            return;
        }
        baseParam.setApplicationName(param.getAppName());
        baseParam.setAppIp(param.getAppIp());
        baseParam.setAgentId(param.getAgentId());
        baseParam.setStartTime(this.formatTimestamp(param.getStartTime()));
        baseParam.setEndTime(this.formatTimestamp(param.getEndTime()));
    }

    public ThreadListResponse getThreadList(ThreadListRequest request) {
        PerformanceThreadQueryParam param = new PerformanceThreadQueryParam();
        param.setBaseId(request.getBaseId());
        List allTempList = this.performanceThreadDataDAO.getPerformanceThreadDataList(param);
        List<PerformanceThreadDataResult> allList = allTempList.stream().distinct().collect(Collectors.toList());
        ThreadListResponse response = new ThreadListResponse();
        Map<String, Long> statusMap = allList.stream().collect(Collectors.groupingBy(PerformanceThreadDataResult::getThreadStatus, Collectors.counting()));
        ArrayList statusList = Lists.newArrayList();
        statusMap.forEach((key, value) -> {
            ThreadStatusResponse temp = new ThreadStatusResponse();
            temp.setStatus(key);
            temp.setCount(Integer.valueOf(value.intValue()));
            statusList.add(temp);
        });
        Collections.sort(statusList);
        ThreadStatusResponse total = new ThreadStatusResponse();
        total.setStatus("");
        total.setCount(Integer.valueOf(statusList.stream().mapToInt(ThreadStatusResponse::getCount).sum()));
        statusList.add(0, total);
        response.setStatus((List)statusList);
        ArrayList responseList = Lists.newArrayList();
        allList.forEach(data -> {
            ThreadDetailResponse temp = new ThreadDetailResponse();
            temp.setThreadName(data.getThreadName());
            temp.setThreadCpuUseRate(new BigDecimal(String.valueOf(data.getThreadCpuUseRate())).setScale(2, RoundingMode.HALF_UP));
            temp.setThreadStackLink(data.getThreadStackLink());
            temp.setThreadStatus(data.getThreadStatus());
            responseList.add(temp);
        });
        response.setDetails((List)responseList);
        return response;
    }

    public List<ThreadCpuUseRateChartResponse> getThreadCpuUseRate(ThreadCpuUseRateRequest request) {
        PerformanceBaseQueryParam baseParam = this.buildBaseQueryParam(request.getReportId(), (PerformanceCommonRequest)request);
        List baseList = this.performanceBaseDataDAO.getPerformanceBaseDataList(baseParam);
        List baseIds = baseList.stream().map(data -> data.getBaseId()).collect(Collectors.toList());
        PerformanceThreadQueryParam param = new PerformanceThreadQueryParam();
        param.setBaseIds(baseIds);
        List dataList = this.performanceThreadDataDAO.getPerformanceThreadDataList(param);
        List threadList = null;
        threadList = request.getThreadName() != null ? dataList.stream().filter(e -> e.getThreadName().equals(request.getThreadName())).collect(Collectors.toList()) : dataList;
        ArrayList response = Lists.newArrayList();
        threadList.stream().forEach(data -> {
            ThreadCpuUseRateChartResponse temp = new ThreadCpuUseRateChartResponse();
            temp.setThreadCpuUseRate(data.getThreadCpuUseRate());
            if (StringUtils.isNotBlank((CharSequence)data.getTimestamp()) && data.getTimestamp().length() > 18) {
                temp.setTime(data.getTimestamp().substring(11, 19));
                response.add(temp);
            }
        });
        return response;
    }

    private PerformanceBaseQueryParam buildBaseQueryParam(Long reportId, PerformanceCommonRequest request) {
        ReportTimeResponse timeResponse = this.reportDetailService.getReportTime(reportId);
        PerformanceBaseQueryParam baseParam = new PerformanceBaseQueryParam();
        baseParam.setStartTime(timeResponse.getStartTime());
        baseParam.setEndTime(timeResponse.getEndTime() != null ? timeResponse.getEndTime() : DateUtil.formatTime((long)System.currentTimeMillis()));
        String[] splits = StringUtils.split((String)request.getProcessName(), (String)"|");
        baseParam.setAppIp(splits[0]);
        baseParam.setAgentId(splits[1]);
        baseParam.setAppName(request.getAppName());
        return baseParam;
    }

    private List<ThreadCpuChartResponse> buildThreadCpuChartResponse(List<PerformanceThreadCountResult> threadList, Collection<BaseServerResult> baseResults) {
        ArrayList responses = Lists.newArrayList();
        int cpuSize = baseResults.size();
        ArrayList results = Lists.newArrayList(baseResults);
        for (int i = 0; i < threadList.size(); ++i) {
            PerformanceThreadCountResult data = threadList.get(i);
            ThreadCpuChartResponse temp = new ThreadCpuChartResponse();
            if (StringUtils.isEmpty((CharSequence)data.getTimestamp()) || data.getTimestamp().length() < 18) continue;
            temp.setTime(data.getTimestamp().substring(11, 19));
            temp.setThreadCount(data.getThreadCount());
            temp.setBaseId(data.getBaseId());
            temp.setTimestamp(Long.valueOf(DateUtils.strToDate((String)data.getTimestamp(), (String)"yyyy-MM-dd HH:mm:ss").getTime()));
            if (cpuSize > 0) {
                int pos = i >= cpuSize ? cpuSize - 1 : i;
                temp.setCpuRate(((BaseServerResult)results.get(pos)).getCpuRate() != null ? new BigDecimal(String.valueOf(((BaseServerResult)results.get(pos)).getCpuRate())).setScale(2, RoundingMode.HALF_UP) : new BigDecimal("0"));
            } else {
                temp.setCpuRate(new BigDecimal("0"));
            }
            responses.add(temp);
        }
        responses.sort((o1, o2) -> Long.compare(o1.getTimestamp(), o2.getTimestamp()));
        return responses;
    }

    public String getThreadStackInfo(String link) {
        return this.performanceThreadDataDAO.getThreadStackInfo(link);
    }

    public void clearData(Integer time) {
        Date nSecond = DateUtils.getPreviousNSecond((int)time);
        this.performanceThreadDataDAO.clearData(DateUtils.dateToString((Date)nSecond, (String)"yyyy-MM-dd HH:mm:ss"));
    }

    private long formatTimestamp(String datetime) {
        long time = io.shulie.tro.web.app.service.risk.util.DateUtil.parseSecondFormatter((String)datetime).getTime();
        String temp = time + "000000";
        return Long.parseLong(temp);
    }
}

