/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.perfomanceanaly.impl;

import com.google.common.collect.Lists;
import com.pamirs.tro.common.util.DateUtils;
import io.shulie.tro.web.app.convert.performace.PressureMachineStatisticsRespConvert;
import io.shulie.tro.web.app.request.perfomanceanaly.PressureMachineStatisticsRequest;
import io.shulie.tro.web.app.response.perfomanceanaly.PressureMachineStatisticsResponse;
import io.shulie.tro.web.app.response.perfomanceanaly.TypeValueDateVo;
import io.shulie.tro.web.app.service.perfomanceanaly.PressureMachineStatisticsService;
import io.shulie.tro.web.data.dao.perfomanceanaly.PressureMachineStatisticsDao;
import io.shulie.tro.web.data.param.perfomanceanaly.PressureMachineStatisticsInsertParam;
import io.shulie.tro.web.data.param.perfomanceanaly.PressureMachineStatisticsQueryParam;
import io.shulie.tro.web.data.result.perfomanceanaly.PressureMachineStatisticsResult;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PressureMachineStatisticsServiceImpl
implements PressureMachineStatisticsService {
    @Autowired
    private PressureMachineStatisticsDao pressureMachineStatisticsDao;

    public void statistics() {
        PressureMachineStatisticsResult statistics = this.getStatistics();
        PressureMachineStatisticsInsertParam insertParam = new PressureMachineStatisticsInsertParam();
        BeanUtils.copyProperties((Object)statistics, (Object)insertParam);
        this.pressureMachineStatisticsDao.insert(insertParam);
    }

    public void insert(PressureMachineStatisticsInsertParam param) {
        this.pressureMachineStatisticsDao.insert(param);
    }

    public PressureMachineStatisticsResponse getNewlyStatistics() {
        PressureMachineStatisticsResult newlyStatistics = this.pressureMachineStatisticsDao.getNewlyStatistics();
        return PressureMachineStatisticsRespConvert.INSTANCE.of(newlyStatistics);
    }

    public List<TypeValueDateVo> queryByExample(PressureMachineStatisticsRequest request) {
        PressureMachineStatisticsQueryParam param = new PressureMachineStatisticsQueryParam();
        BeanUtils.copyProperties((Object)request, (Object)param);
        List list = this.pressureMachineStatisticsDao.queryByExample(param);
        list = this.pointSample(list);
        return this.assembleData(list);
    }

    List<PressureMachineStatisticsResult> pointSample(List<PressureMachineStatisticsResult> source) {
        ArrayList<PressureMachineStatisticsResult> results = new ArrayList();
        int step = 0;
        if (source != null && source.size() > 100) {
            step = source.size() / 100;
            int i = 0;
            while (i + step < source.size()) {
                results.add(source.get(i += step));
                ++i;
            }
            results.add(source.get(source.size() - 1));
        } else {
            results = source;
        }
        return results;
    }

    private List<TypeValueDateVo> assembleData(List<PressureMachineStatisticsResult> list) {
        ArrayList<TypeValueDateVo> resultList = new ArrayList<TypeValueDateVo>();
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        for (PressureMachineStatisticsResult result : list) {
            String time = result.getGmtCreate().substring(0, 19);
            time = time.replaceAll("T", " ");
            TypeValueDateVo totalVo = new TypeValueDateVo();
            totalVo.setType("\u603b\u6570");
            totalVo.setValue((Object)result.getMachineTotal());
            totalVo.setDate(time);
            TypeValueDateVo pressuredVo = new TypeValueDateVo();
            pressuredVo.setDate(time);
            pressuredVo.setValue((Object)result.getMachinePressured());
            pressuredVo.setType("\u538b\u6d4b\u4e2d");
            TypeValueDateVo freeVo = new TypeValueDateVo();
            freeVo.setDate(time);
            freeVo.setValue((Object)result.getMachineFree());
            freeVo.setType("\u7a7a\u95f2");
            TypeValueDateVo offlineVo = new TypeValueDateVo();
            offlineVo.setType("\u79bb\u7ebf");
            offlineVo.setDate(time);
            offlineVo.setValue((Object)result.getMachineOffline());
            resultList.add(totalVo);
            resultList.add(pressuredVo);
            resultList.add(freeVo);
            resultList.add(offlineVo);
        }
        return resultList;
    }

    public PressureMachineStatisticsResult getStatistics() {
        return this.pressureMachineStatisticsDao.statistics();
    }

    public void clearRubbishData() {
        Date previousNDay = DateUtils.getPreviousNDay((int)91);
        this.pressureMachineStatisticsDao.clearRubbishData(DateUtils.dateToString((Date)previousNDay, (String)"yyyy-MM-dd HH:mm:ss"));
    }
}

