/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.perfomanceanaly.impl;

import com.alibaba.fastjson.JSON;
import io.shulie.tro.cloud.open.req.scenemanage.SceneManageQueryByIdsReq;
import io.shulie.tro.cloud.open.resp.scenemanage.SceneManageWrapperResp;
import io.shulie.tro.common.beans.page.PagingList;
import io.shulie.tro.common.beans.response.ResponseResult;
import io.shulie.tro.web.app.input.PressureMachineInput;
import io.shulie.tro.web.app.request.perfomanceanaly.PressureMachineDeleteRequest;
import io.shulie.tro.web.app.request.perfomanceanaly.PressureMachineUpdateRequest;
import io.shulie.tro.web.app.response.perfomanceanaly.PressureMachineResponse;
import io.shulie.tro.web.app.service.perfomanceanaly.PressureMachineService;
import io.shulie.tro.web.app.service.scenemanage.SceneManageService;
import io.shulie.tro.web.app.utils.FileUtils;
import io.shulie.tro.web.data.dao.perfomanceanaly.PressureMachineDao;
import io.shulie.tro.web.data.dao.perfomanceanaly.PressureMachineLogDao;
import io.shulie.tro.web.data.param.machine.PressureMachineDeleteParam;
import io.shulie.tro.web.data.param.machine.PressureMachineInsertParam;
import io.shulie.tro.web.data.param.machine.PressureMachineLogInsertParam;
import io.shulie.tro.web.data.param.machine.PressureMachineQueryParam;
import io.shulie.tro.web.data.param.machine.PressureMachineUpdateParam;
import io.shulie.tro.web.data.result.perfomanceanaly.PressureMachineResult;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PressureMachineServiceImpl
implements PressureMachineService {
    private static final Logger log = Logger.getLogger(PressureMachineServiceImpl.class);
    @Autowired
    private PressureMachineDao pressureMachineDao;
    @Resource
    private PressureMachineLogDao pressureMachineLogDao;
    @Autowired
    private SceneManageService sceneManageService;

    public Long insert(PressureMachineInput input) {
        if (input == null) {
            return 0L;
        }
        PressureMachineQueryParam queryParam = new PressureMachineQueryParam();
        queryParam.setIp(input.getIp());
        PressureMachineResponse dbMachine = this.getByIp(input.getIp());
        Long machineId = null;
        String sceneNames = this.fillSceneName(input.getSceneId());
        if (dbMachine == null) {
            PressureMachineInsertParam param = new PressureMachineInsertParam();
            BeanUtils.copyProperties((Object)input, (Object)param);
            param.setSceneNames(sceneNames);
            try {
                Integer insert = this.pressureMachineDao.insert(param);
                machineId = (long)insert;
            }
            catch (Exception e) {
                log.error((Object)("\u65b0\u589e\u538b\u529b\u673a\u5931\u8d25 --" + e.getMessage()));
            }
        } else {
            PressureMachineUpdateParam updateParam = new PressureMachineUpdateParam();
            BeanUtils.copyProperties((Object)input, (Object)updateParam);
            updateParam.setId(dbMachine.getId());
            updateParam.setSceneNames(sceneNames);
            this.pressureMachineDao.update(updateParam);
            machineId = dbMachine.getId();
        }
        return machineId;
    }

    public void upload(PressureMachineInput input) {
        this.calculateTransmitted(input);
        ArrayList<BigDecimal> baseList = new ArrayList<BigDecimal>();
        baseList.add(input.getCpuUsage());
        baseList.add(input.getMemoryUsed());
        baseList.add(input.getCpuLoad().divide(new BigDecimal(input.getCpu()), 4, RoundingMode.HALF_UP));
        baseList.add(input.getDiskIoWait());
        baseList.add(input.getTransmittedUsage());
        BigDecimal max = (BigDecimal)Collections.max(baseList);
        input.setMachineUsage(max);
        Long machineId = this.insert(input);
        PressureMachineLogInsertParam logInsertParam = new PressureMachineLogInsertParam();
        BeanUtils.copyProperties((Object)input, (Object)logInsertParam);
        logInsertParam.setMachineId(machineId);
        logInsertParam.setSceneNames(this.fillSceneName(input.getSceneId()));
        this.pressureMachineLogDao.insert(logInsertParam);
    }

    public Boolean calculateTransmitted(PressureMachineInput param) {
        boolean isUpdate = false;
        PressureMachineQueryParam queryParam = new PressureMachineQueryParam();
        queryParam.setIp(param.getIp());
        PressureMachineResponse result = this.getByIp(param.getIp());
        if (result != null) {
            isUpdate = true;
        }
        if (result == null || result.getTransmittedTotal() == null || result.getTransmittedTotal() == 0L) {
            param.setTransmittedInUsage(new BigDecimal(0));
            param.setTransmittedOutUsage(new BigDecimal(0));
            param.setTransmittedUsage(new BigDecimal(0));
        } else {
            BigDecimal outPer;
            Long total = (long)result.getTransmittedTotal();
            total = total * 1024L * 1024L;
            BigDecimal inPer = new BigDecimal((double)param.getTransmittedIn().longValue() * 8.0 / (double)total.longValue()).setScale(4, 4);
            BigDecimal per = inPer.compareTo(outPer = new BigDecimal((double)param.getTransmittedOut().longValue() * 8.0 / (double)total.longValue()).setScale(4, 4)) == 1 ? inPer : outPer;
            param.setTransmittedOutUsage(outPer);
            param.setTransmittedInUsage(inPer);
            param.setTransmittedUsage(per);
        }
        return isUpdate;
    }

    public PagingList<PressureMachineResponse> queryByExample(PressureMachineQueryParam param) {
        PagingList pressureMachineResultPage = this.pressureMachineDao.queryByExample(param);
        List outputList = pressureMachineResultPage.getList().stream().map(pressureMachineResult -> {
            PressureMachineResponse response = new PressureMachineResponse();
            BeanUtils.copyProperties((Object)pressureMachineResult, (Object)response);
            response.setDisk(FileUtils.getByteSize((long)pressureMachineResult.getDisk()));
            response.setMemory(FileUtils.getByteSize((long)pressureMachineResult.getMemory()));
            response.setMachineUsage(response.getMachineUsage().multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_DOWN));
            if (response.getStatus() != 1) {
                response.setSceneNames(null);
            }
            return response;
        }).collect(Collectors.toList());
        return PagingList.of(outputList, (long)pressureMachineResultPage.getTotal());
    }

    public void update(PressureMachineUpdateRequest request) {
        PressureMachineUpdateParam param = new PressureMachineUpdateParam();
        BeanUtils.copyProperties((Object)request, (Object)param);
        PressureMachineResult dbData = this.pressureMachineDao.getById(request.getId());
        if (request.getTransmittedTotal() != null) {
            if (request.getTransmittedTotal() == 0L) {
                param.setTransmittedInUsage(new BigDecimal(0));
                param.setTransmittedOutUsage(new BigDecimal(0));
                param.setTransmittedUsage(new BigDecimal(0));
            } else {
                Long total = request.getTransmittedTotal();
                total = total * 1024L * 1024L;
                BigDecimal inPer = new BigDecimal((double)dbData.getTransmittedIn().longValue() * 8.0 / (double)total.longValue()).setScale(2, 4);
                BigDecimal outPer = new BigDecimal((double)dbData.getTransmittedOut().longValue() * 8.0 / (double)total.longValue()).setScale(2, 4);
                BigDecimal per = inPer.doubleValue() >= outPer.doubleValue() ? inPer : outPer;
                param.setTransmittedOutUsage(outPer);
                param.setTransmittedInUsage(inPer);
                param.setTransmittedUsage(per);
            }
        }
        this.pressureMachineDao.update(param);
    }

    public void delete(PressureMachineDeleteRequest request) {
        PressureMachineResult dbData = this.pressureMachineDao.getById(request.getId());
        if (dbData != null && dbData.getStatus() != -1) {
            throw new RuntimeException("\u975e\u79bb\u7ebf\u673a\u5668\u4e0d\u80fd\u5220\u9664\uff01");
        }
        PressureMachineDeleteParam param = new PressureMachineDeleteParam();
        BeanUtils.copyProperties((Object)request, (Object)param);
        this.pressureMachineDao.delete(param);
    }

    public PressureMachineResponse getByIp(String ip) {
        PressureMachineResult byIp = this.pressureMachineDao.getByIp(ip);
        if (byIp == null) {
            return null;
        }
        PressureMachineResponse response = new PressureMachineResponse();
        BeanUtils.copyProperties((Object)byIp, (Object)response);
        return response;
    }

    public void updatePressureMachineStatus(Long id, Integer status) {
        PressureMachineUpdateParam param = new PressureMachineUpdateParam();
        param.setId(id);
        param.setStatus(status);
        this.pressureMachineDao.update(param);
    }

    public String fillSceneName(List<Long> sceneIds) {
        if (CollectionUtils.isEmpty(sceneIds)) {
            return "";
        }
        SceneManageQueryByIdsReq req = new SceneManageQueryByIdsReq();
        req.setSceneIds(sceneIds);
        ResponseResult byIds = this.sceneManageService.getByIds(req);
        List data = (List)byIds.getData();
        ArrayList<String> names = new ArrayList<String>();
        for (Object wrapperResp : data) {
            String s = JSON.toJSONString(wrapperResp);
            SceneManageWrapperResp scene = (SceneManageWrapperResp)JSON.parseObject((String)s, SceneManageWrapperResp.class);
            names.add(scene.getPressureTestSceneName());
        }
        return StringUtils.join(names, (String)"|");
    }
}

