/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.perfomanceanaly.impl;

import com.pamirs.tro.common.util.DateUtils;
import io.shulie.tro.web.app.convert.performace.PerformanceBaseInputConvert;
import io.shulie.tro.web.app.input.PerformanceBaseDataCreateInput;
import io.shulie.tro.web.app.response.perfomanceanaly.ReportTimeResponse;
import io.shulie.tro.web.app.service.async.AsyncService;
import io.shulie.tro.web.app.service.perfomanceanaly.PerformanceBaseDataService;
import io.shulie.tro.web.app.service.perfomanceanaly.ReportDetailService;
import io.shulie.tro.web.data.dao.perfomanceanaly.PerformanceBaseDataDAO;
import io.shulie.tro.web.data.param.perfomanceanaly.PerformanceBaseDataParam;
import io.shulie.tro.web.data.param.perfomanceanaly.PerformanceBaseQueryParam;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PerformanceBaseDataServiceImpl
implements PerformanceBaseDataService {
    private static final Logger log = LoggerFactory.getLogger(PerformanceBaseDataServiceImpl.class);
    @Autowired
    private PerformanceBaseDataDAO performanceBaseDataDAO;
    @Autowired
    private AsyncService asyncService;
    @Autowired
    private ReportDetailService reportDetailService;

    public void cache(PerformanceBaseDataCreateInput input) {
        PerformanceBaseDataParam param = PerformanceBaseInputConvert.INSTANCE.inputToParam(input);
        this.asyncService.savePerformanceBaseData(param);
    }

    public List<String> getProcessName(Long reportId, String appName) {
        PerformanceBaseQueryParam param = new PerformanceBaseQueryParam();
        param.setAppName(appName);
        ReportTimeResponse response = this.reportDetailService.getReportTime(reportId);
        param.setStartTime(response.getStartTime());
        param.setEndTime(response.getEndTime());
        return this.performanceBaseDataDAO.getProcessNameList(param);
    }

    public void clearData(Integer time) {
        Date nSecond = DateUtils.getPreviousNSecond((int)time);
        this.performanceBaseDataDAO.clearData(DateUtils.dateToString((Date)nSecond, (String)"yyyy-MM-dd HH:mm:ss"));
    }
}

