/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.perfomanceanaly.impl;

import com.pamirs.tro.common.util.DateUtils;
import io.shulie.tro.channel.bean.CommandResponse;
import io.shulie.tro.exception.entity.ExceptionReadable;
import io.shulie.tro.web.app.agent.AgentCommandEnum;
import io.shulie.tro.web.app.agent.AgentCommandFactory;
import io.shulie.tro.web.app.exception.ExceptionCode;
import io.shulie.tro.web.app.exception.TroWebException;
import io.shulie.tro.web.app.request.perfomanceanaly.MemoryAnalysisRequest;
import io.shulie.tro.web.app.response.perfomanceanaly.DownloadDumpResponse;
import io.shulie.tro.web.app.response.perfomanceanaly.MemoryAnalysisResponse;
import io.shulie.tro.web.app.response.perfomanceanaly.MemoryModelVo;
import io.shulie.tro.web.app.response.perfomanceanaly.ReportTimeResponse;
import io.shulie.tro.web.app.service.perfomanceanaly.MemoryAnalysisService;
import io.shulie.tro.web.app.service.perfomanceanaly.ReportDetailService;
import io.shulie.tro.web.data.dao.perfomanceanaly.PerformanceBaseDataDAO;
import io.shulie.tro.web.data.param.perfomanceanaly.PerformanceBaseQueryParam;
import io.shulie.tro.web.data.result.perfomanceanaly.PerformanceBaseDataResult;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MemoryAnalysisServiceImpl
implements MemoryAnalysisService {
    private static final Logger log = LoggerFactory.getLogger(MemoryAnalysisServiceImpl.class);
    @Autowired
    private PerformanceBaseDataDAO performanceBaseDataDAO;
    @Autowired
    private ReportDetailService reportDetailService;
    @Autowired
    private AgentCommandFactory agentCommandFactory;

    public MemoryAnalysisResponse queryMemoryDump(MemoryAnalysisRequest request) {
        PerformanceBaseQueryParam param = new PerformanceBaseQueryParam();
        BeanUtils.copyProperties((Object)request, (Object)param);
        ReportTimeResponse timeResponse = this.reportDetailService.getReportTime(request.getReportId());
        param.setStartTime(timeResponse.getStartTime());
        if (timeResponse.getEndTime() != null) {
            param.setEndTime(timeResponse.getEndTime());
        } else {
            param.setEndTime(DateUtils.dateToString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        param.setAppName(request.getAppName());
        String[] splits = StringUtils.split((String)request.getProcessName(), (String)"|");
        param.setAppIp(splits[0]);
        param.setAgentId(splits[1]);
        List baseDataResultList = this.performanceBaseDataDAO.getPerformanceBaseDataList(param);
        return this.assembleData(baseDataResultList);
    }

    public MemoryAnalysisResponse assembleData(List<PerformanceBaseDataResult> list) {
        MemoryAnalysisResponse result = new MemoryAnalysisResponse();
        ArrayList<MemoryModelVo> heapMemoryList = new ArrayList<MemoryModelVo>();
        ArrayList<MemoryModelVo> gcCountList = new ArrayList<MemoryModelVo>();
        ArrayList<MemoryModelVo> gcCostList = new ArrayList<MemoryModelVo>();
        result.setHeapMemory(heapMemoryList);
        result.setGcCount(gcCountList);
        result.setGcCost(gcCostList);
        if (CollectionUtils.isNotEmpty(list)) {
            for (PerformanceBaseDataResult dataResult : list) {
                MemoryModelVo heapMemoryTotal = new MemoryModelVo();
                MemoryModelVo heapMemoryPerm = new MemoryModelVo();
                MemoryModelVo heapMemoryYoung = new MemoryModelVo();
                MemoryModelVo heapMemoryOld = new MemoryModelVo();
                MemoryModelVo heapMemoryTotalNon = new MemoryModelVo();
                MemoryModelVo heapMemoryTotalBufferPool = new MemoryModelVo();
                String time = dataResult.getTime().substring(11, 19);
                heapMemoryTotal.setTime(time);
                heapMemoryTotal.setType("\u603b\u548c");
                heapMemoryTotal.setValue((Object)this.mb2MB(dataResult.getTotalMemory()));
                heapMemoryPerm.setTime(time);
                heapMemoryPerm.setValue((Object)this.mb2MB(dataResult.getPermMemory()));
                heapMemoryPerm.setType("\u6c38\u4e45\u4ee3");
                heapMemoryYoung.setTime(time);
                heapMemoryYoung.setValue((Object)this.mb2MB(dataResult.getYoungMemory()));
                heapMemoryYoung.setType("\u5e74\u8f7b\u4ee3");
                heapMemoryOld.setTime(time);
                heapMemoryOld.setValue((Object)this.mb2MB(dataResult.getOldMemory()));
                heapMemoryOld.setType("\u8001\u5e74\u4ee3");
                heapMemoryTotalNon.setTime(time);
                heapMemoryTotalNon.setValue((Object)this.mb2MB(dataResult.getTotalNonHeapMemory()));
                heapMemoryTotalNon.setType("\u975e\u5806\u5185\u5b58\u603b\u5185\u5b58");
                heapMemoryTotalBufferPool.setTime(time);
                heapMemoryTotalBufferPool.setValue((Object)this.mb2MB(dataResult.getTotalBufferPoolMemory()));
                heapMemoryTotalBufferPool.setType("buffer-pool\u603b\u5185\u5b58");
                heapMemoryList.add(heapMemoryTotal);
                heapMemoryList.add(heapMemoryPerm);
                heapMemoryList.add(heapMemoryYoung);
                heapMemoryList.add(heapMemoryOld);
                heapMemoryList.add(heapMemoryTotalNon);
                heapMemoryList.add(heapMemoryTotalBufferPool);
                MemoryModelVo fullGcCount = new MemoryModelVo();
                MemoryModelVo youngGcCount = new MemoryModelVo();
                fullGcCount.setTime(time);
                fullGcCount.setValue((Object)dataResult.getFullGcCount());
                fullGcCount.setType("Full GC \u6b21\u6570");
                youngGcCount.setTime(time);
                youngGcCount.setValue((Object)dataResult.getYoungGcCount());
                youngGcCount.setType("Young GC \u6b21\u6570");
                gcCountList.add(fullGcCount);
                gcCountList.add(youngGcCount);
                MemoryModelVo fullGcCost = new MemoryModelVo();
                MemoryModelVo youngGcCost = new MemoryModelVo();
                fullGcCost.setTime(time);
                fullGcCost.setValue((Object)dataResult.getFullGcCost());
                fullGcCost.setType("Full GC \u8017\u65f6");
                youngGcCost.setTime(time);
                youngGcCost.setValue((Object)dataResult.getYoungGcCost());
                youngGcCost.setType("Young GC \u8017\u65f6");
                gcCostList.add(fullGcCost);
                gcCostList.add(youngGcCost);
            }
        }
        return result;
    }

    public DownloadDumpResponse downloadDump(String agentId) throws Exception {
        CommandResponse commandResponse = this.agentCommandFactory.send(AgentCommandEnum.PULL_AGENT_DUMP_HEADDUMP_COMMAND, agentId, null);
        if (!commandResponse.isSuccess()) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.DUMP_ERROR, (Object)commandResponse.getMessage());
        }
        return new DownloadDumpResponse((String)commandResponse.getResult());
    }

    public BigDecimal mb2GB(Double source) {
        if (source == null) {
            return new BigDecimal(0);
        }
        return new BigDecimal(source / 1024.0).setScale(2, RoundingMode.HALF_UP);
    }

    public BigDecimal mb2MB(Double source) {
        if (source == null) {
            return new BigDecimal(0).setScale(2, RoundingMode.HALF_UP);
        }
        return new BigDecimal(source).divide(BigDecimal.valueOf(0x100000L), 2, RoundingMode.HALF_UP);
    }
}

