/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.perfomanceanaly;

import com.pamirs.tro.common.util.DateUtils;
import io.shulie.tro.web.app.request.perfomanceanaly.PressureMachineLogQueryRequest;
import io.shulie.tro.web.app.response.perfomanceanaly.PressureMachineLogResponse;
import io.shulie.tro.web.app.response.perfomanceanaly.TypeValueDateVo;
import io.shulie.tro.web.app.service.perfomanceanaly.PressureMachineLogService;
import io.shulie.tro.web.data.dao.perfomanceanaly.PressureMachineLogDao;
import io.shulie.tro.web.data.param.machine.PressureMachineLogQueryParam;
import io.shulie.tro.web.data.result.perfomanceanaly.PressureMachineLogResult;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PressureMachineLogServiceImpl
implements PressureMachineLogService {
    @Autowired
    private PressureMachineLogDao pressureMachineLogDao;

    public PressureMachineLogResponse queryByExample(PressureMachineLogQueryRequest request) {
        String dayStartTime = DateUtils.getDayStartTime((String)request.getQueryTime());
        String dayEndTime = DateUtils.getDayEndTime((String)request.getQueryTime());
        if (dayEndTime == null || dayStartTime == null) {
            throw new RuntimeException("\u65f6\u95f4\u7684\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        PressureMachineLogQueryParam queryParam = new PressureMachineLogQueryParam();
        queryParam.setStartTime(dayStartTime);
        queryParam.setEndTime(dayEndTime);
        queryParam.setMachineId(request.getMachineId());
        queryParam.setCurrent(0);
        queryParam.setPageSize(Integer.valueOf(-1));
        List dbList = this.pressureMachineLogDao.queryList(queryParam);
        List pressureMachineLogResults = this.pointSample(dbList, 200);
        return this.assembleData(pressureMachineLogResults);
    }

    public void clearRubbishData() {
        Date previousNDay = DateUtils.getPreviousNDay((int)21);
        this.pressureMachineLogDao.clearRubbishData(DateUtils.dateToString((Date)previousNDay, (String)"yyyy-MM-dd HH:mm:ss"));
    }

    List<PressureMachineLogResult> pointSample(List<PressureMachineLogResult> source, int pointNum) {
        ArrayList<PressureMachineLogResult> results = new ArrayList();
        int step = 0;
        if (source != null && source.size() > pointNum) {
            step = source.size() / pointNum;
            int i = 0;
            while (i + step < source.size()) {
                results.add(source.get(i += step));
                ++i;
            }
            results.add(source.get(source.size() - 1));
        } else {
            results = source;
        }
        return results;
    }

    public PressureMachineLogResponse assembleData(List<PressureMachineLogResult> resultList) {
        PressureMachineLogResponse response = new PressureMachineLogResponse();
        ArrayList<TypeValueDateVo> cpuUsageList = new ArrayList<TypeValueDateVo>();
        ArrayList<TypeValueDateVo> cpuLoadList = new ArrayList<TypeValueDateVo>();
        ArrayList<TypeValueDateVo> memoryUsageList = new ArrayList<TypeValueDateVo>();
        ArrayList<TypeValueDateVo> ioWaitPerList = new ArrayList<TypeValueDateVo>();
        ArrayList<TypeValueDateVo> transmittedUsageList = new ArrayList<TypeValueDateVo>();
        response.setCpuUsageList(cpuUsageList);
        response.setCpuLoadList(cpuLoadList);
        response.setMemoryUsageList(memoryUsageList);
        response.setIoWaitPerList(ioWaitPerList);
        response.setTransmittedUsageList(transmittedUsageList);
        if (CollectionUtils.isEmpty(resultList)) {
            return response;
        }
        for (PressureMachineLogResult result : resultList) {
            String date = result.getGmtCreate();
            if (StringUtils.isNotBlank((CharSequence)(date = date.replace("T", " ")))) {
                date = date.substring(0, 16);
            }
            BigDecimal multipy = new BigDecimal(100);
            TypeValueDateVo cpuUsageVo = new TypeValueDateVo();
            cpuUsageVo.setDate(date);
            cpuUsageVo.setValue((Object)result.getCpuUsage().multiply(multipy).setScale(2, RoundingMode.HALF_UP));
            cpuUsageVo.setType("cpu \u5229\u7528\u7387");
            cpuUsageList.add(cpuUsageVo);
            TypeValueDateVo cpuLoadVo = new TypeValueDateVo();
            cpuLoadVo.setDate(date);
            cpuLoadVo.setValue((Object)result.getCpuLoad().setScale(2, RoundingMode.HALF_UP));
            cpuLoadVo.setType("cpu load");
            cpuLoadList.add(cpuLoadVo);
            TypeValueDateVo memoryUsageVo = new TypeValueDateVo();
            memoryUsageVo.setDate(date);
            memoryUsageVo.setValue((Object)result.getMemoryUsed().multiply(multipy).setScale(2, RoundingMode.HALF_UP));
            memoryUsageVo.setType("\u5185\u5b58\u5229\u7528\u7387");
            memoryUsageList.add(memoryUsageVo);
            TypeValueDateVo ioWaitPerVo = new TypeValueDateVo();
            ioWaitPerVo.setDate(date);
            ioWaitPerVo.setValue((Object)result.getDiskIoWait().multiply(multipy).setScale(2, RoundingMode.HALF_UP));
            ioWaitPerVo.setType("\u78c1\u76d8I/O\u7b49\u5f85\u7387");
            ioWaitPerList.add(ioWaitPerVo);
            TypeValueDateVo transmittedUsageVo = new TypeValueDateVo();
            transmittedUsageVo.setDate(date);
            transmittedUsageVo.setValue((Object)result.getTransmittedUsage().multiply(multipy).setScale(2, RoundingMode.HALF_UP));
            transmittedUsageVo.setType("\u7f51\u7edc\u5e26\u5bbd\u4f7f\u7528\u7387");
            transmittedUsageList.add(transmittedUsageVo);
        }
        return response;
    }

    public static void main(String[] args) {
    }
}

