/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.mq.receive;

import io.shulie.tro.web.app.service.mq.receive.BaseConsumer;
import io.shulie.tro.web.app.service.mq.receive.GenericsReConsumer;
import io.shulie.tro.web.app.service.mq.receive.GenericsSerializer;
import io.shulie.tro.web.app.service.mq.receive.GenericsSerializerFactory;
import io.shulie.tro.web.app.service.mq.receive.IComsumer;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.common.consumer.ConsumeFromWhere;
import org.apache.rocketmq.common.message.MessageExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericsConcurrentlyReConsumer<T>
extends BaseConsumer
implements GenericsReConsumer<T> {
    static final Logger logger = LoggerFactory.getLogger(GenericsConcurrentlyReConsumer.class);
    private static final long serialVersionUID = 1L;
    protected GenericsSerializer<T> serializer = new GenericsSerializerFactory().getSerializer();
    protected IComsumer<T> messageReConsumer;
    protected DefaultMQPushConsumer consumer = new DefaultMQPushConsumer();

    public DefaultMQPushConsumer getConsumer() {
        return this.consumer;
    }

    public void setConsumer(DefaultMQPushConsumer consumer) {
        this.consumer = consumer;
    }

    public GenericsSerializer<T> getSerializer() {
        return this.serializer;
    }

    public void setSerializer(GenericsSerializer<T> serializer) {
        this.serializer = serializer;
    }

    public IComsumer<T> getMessageReConsumer() {
        return this.messageReConsumer;
    }

    public void setMessageReConsumer(IComsumer<T> messageReConsumer) {
        this.messageReConsumer = messageReConsumer;
    }

    public void startup() throws Exception {
        this.consumer.setInstanceName(this.instanceName);
        this.consumer.setConsumerGroup(this.consumerGroup);
        this.consumer.setNamesrvAddr(this.namesrvAddr);
        this.consumer.setConsumeFromWhere(this.consumeFromWhere);
        this.consumer.subscribe(this.topic, this.tag);
        this.consumer.setPullInterval(this.pullInterval);
        this.consumer.setPullBatchSize(this.pullBatchSize);
        this.consumer.setConsumeMessageBatchMaxSize(this.consumeMessageBatchMaxSize);
        this.consumer.setConsumeThreadMax(this.consumeThreadMax);
        this.consumer.setConsumeThreadMin(this.consumeThreadMin);
        this.consumer.registerMessageListener((MessageListenerConcurrently)new /* Unavailable Anonymous Inner Class!! */);
        this.consumer.setMessageModel(this.messageModel);
        if (this.messageReConsumer == null) {
            throw new Exception("messageConsumer is null,please set it!");
        }
        if (ConsumeFromWhere.CONSUME_FROM_TIMESTAMP.equals((Object)this.consumeFromWhere)) {
            this.consumer.setConsumeTimestamp(this.sConsumeTimestamp);
        }
        this.consumer.start();
    }

    public void shutdown() {
        this.consumer.shutdown();
    }

    public void onProcessing(T task, MessageExt msg) {
        Boolean result = this.messageReConsumer.onConsumer(task, msg);
        if (!Boolean.TRUE.equals(result)) {
            throw new RuntimeException("GenericsMessageReConsumer onReConsume return false then revert");
        }
    }
}

