/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.log;

import com.google.common.collect.Lists;
import io.shulie.tro.common.beans.page.PagingList;
import io.shulie.tro.web.app.request.log.OperationLogCreateRequest;
import io.shulie.tro.web.app.request.log.OperationLogQueryRequest;
import io.shulie.tro.web.app.response.log.OperationLogResponse;
import io.shulie.tro.web.app.service.log.OperationLogService;
import io.shulie.tro.web.data.dao.log.OperationLogDAO;
import io.shulie.tro.web.data.param.log.OperationLogCreateParam;
import io.shulie.tro.web.data.param.log.OperationLogQueryParam;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OperationLogServiceImpl
implements OperationLogService {
    private static final Logger log = LoggerFactory.getLogger(OperationLogServiceImpl.class);
    @Autowired
    OperationLogDAO operationLogDAO;

    public PagingList<OperationLogResponse> list(OperationLogQueryRequest queryRequest) {
        OperationLogQueryParam queryParam = new OperationLogQueryParam();
        BeanUtils.copyProperties((Object)queryRequest, (Object)queryParam);
        PagingList pagingList = this.operationLogDAO.selectPage(queryParam);
        List responseList = pagingList.getList().stream().map(operationLogResult -> {
            OperationLogResponse operationLogResponse = new OperationLogResponse();
            operationLogResponse.setModules((List)Lists.newArrayList((Object[])new String[]{operationLogResult.getModule(), operationLogResult.getSubModule()}));
            operationLogResponse.setContent(operationLogResult.getContent());
            operationLogResponse.setStartTime(operationLogResult.getStartTime());
            operationLogResponse.setType(operationLogResult.getType());
            operationLogResponse.setUserName(operationLogResult.getUserName());
            return operationLogResponse;
        }).collect(Collectors.toList());
        return PagingList.of(responseList, (long)pagingList.getTotal());
    }

    public void record(OperationLogCreateRequest createRequest) {
        OperationLogCreateParam createParam = new OperationLogCreateParam();
        BeanUtils.copyProperties((Object)createRequest, (Object)createParam);
        this.operationLogDAO.insert(createParam);
    }
}

