/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.linkManage.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pamirs.tro.common.constant.TRODictTypeEnum;
import com.pamirs.tro.common.constant.YNEnum;
import com.pamirs.tro.entity.dao.confcenter.TApplicationMntDao;
import com.pamirs.tro.entity.dao.confcenter.TWListMntDao;
import com.pamirs.tro.entity.dao.dict.TDictionaryTypeMapper;
import com.pamirs.tro.entity.dao.user.TUserMapper;
import com.pamirs.tro.entity.domain.dto.linkmanage.InterfaceVo;
import com.pamirs.tro.entity.domain.entity.TApplicationMnt;
import com.pamirs.tro.entity.domain.entity.TDictionaryType;
import com.pamirs.tro.entity.domain.entity.TWList;
import com.pamirs.tro.entity.domain.entity.user.User;
import com.pamirs.tro.entity.domain.query.whitelist.WhiteListCreateListVO;
import com.pamirs.tro.entity.domain.query.whitelist.WhiteListOperateVO;
import com.pamirs.tro.entity.domain.query.whitelist.WhiteListQueryVO;
import io.shulie.tro.common.beans.page.PagingList;
import io.shulie.tro.exception.entity.ExceptionReadable;
import io.shulie.tro.web.amdb.api.ApplicationClient;
import io.shulie.tro.web.amdb.bean.query.application.ApplicationInterfaceQueryDTO;
import io.shulie.tro.web.amdb.enums.MiddlewareTypeGroupEnum;
import io.shulie.tro.web.app.common.RestContext;
import io.shulie.tro.web.app.context.OperationLogContextHolder;
import io.shulie.tro.web.app.exception.ExceptionCode;
import io.shulie.tro.web.app.exception.TroWebException;
import io.shulie.tro.web.app.init.sync.ConfigSyncService;
import io.shulie.tro.web.app.input.whitelist.WhitelistImportFromExcelInput;
import io.shulie.tro.web.app.input.whitelist.WhitelistSearchInput;
import io.shulie.tro.web.app.input.whitelist.WhitelistUpdatePartAppNameInput;
import io.shulie.tro.web.app.request.WhiteListDeleteRequest;
import io.shulie.tro.web.app.request.whitelist.WhiteListUpdateRequest;
import io.shulie.tro.web.app.service.linkManage.WhiteListService;
import io.shulie.tro.web.app.service.linkManage.impl.WhiteListFileService;
import io.shulie.tro.web.common.enums.whitelist.WhitelistTagEnum;
import io.shulie.tro.web.common.util.whitelist.WhitelistUtil;
import io.shulie.tro.web.common.vo.whitelist.WhiteListVO;
import io.shulie.tro.web.common.vo.whitelist.WhitelistPartVO;
import io.shulie.tro.web.data.dao.application.ApplicationDAO;
import io.shulie.tro.web.data.dao.application.ApplicationWhiteListDAO;
import io.shulie.tro.web.data.dao.application.WhiteListDAO;
import io.shulie.tro.web.data.dao.application.WhitelistEffectiveAppDao;
import io.shulie.tro.web.data.mapper.mysql.WhiteListMapper;
import io.shulie.tro.web.data.model.mysql.WhiteListEntity;
import io.shulie.tro.web.data.param.application.ApplicationQueryParam;
import io.shulie.tro.web.data.param.application.ApplicationWhiteListCreateParam;
import io.shulie.tro.web.data.param.whitelist.WhitelistAddPartAppNameParam;
import io.shulie.tro.web.data.param.whitelist.WhitelistEffectiveAppDeleteParam;
import io.shulie.tro.web.data.param.whitelist.WhitelistEffectiveAppSearchParam;
import io.shulie.tro.web.data.param.whitelist.WhitelistGlobalOrPartParam;
import io.shulie.tro.web.data.param.whitelist.WhitelistSaveOrUpdateParam;
import io.shulie.tro.web.data.param.whitelist.WhitelistSearchParam;
import io.shulie.tro.web.data.param.whitelist.WhitelistUpdatePartAppNameParam;
import io.shulie.tro.web.data.result.application.ApplicationDetailResult;
import io.shulie.tro.web.data.result.whitelist.WhitelistEffectiveAppResult;
import io.shulie.tro.web.data.result.whitelist.WhitelistResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WhiteListServiceImpl
implements WhiteListService {
    private static final Logger log = LoggerFactory.getLogger(WhiteListServiceImpl.class);
    @Resource
    private TWListMntDao tWListMntDao;
    @Resource
    private TDictionaryTypeMapper tDictionaryTypeMapper;
    @Resource
    private TApplicationMntDao applicationMntDao;
    @Autowired
    private ApplicationClient applicationClient;
    @Resource
    private TUserMapper TUserMapper;
    @Autowired
    private ConfigSyncService configSyncService;
    @Autowired
    private WhiteListFileService whiteListFileService;
    @Autowired
    private ApplicationWhiteListDAO applicationWhiteListDAO;
    @Autowired
    private ApplicationDAO applicationDAO;
    @Resource
    private WhiteListMapper whiteListMapper;
    @Autowired
    private WhitelistEffectiveAppDao whitelistEffectiveAppDao;
    @Autowired
    private WhiteListDAO whiteListDAO;
    @Value(value="${whitelist.duplicate.name.check:false}")
    private String isCheckDuplicateName;

    private Integer getInterfaceIntType(String interfaceType) {
        int type = -1;
        String interfaceTypeString = String.valueOf(interfaceType);
        switch (interfaceTypeString = MiddlewareTypeGroupEnum.getMiddlewareGroupType((String)interfaceTypeString).getType()) {
            case "HTTP": 
            case "1": {
                type = 1;
                break;
            }
            case "DUBBO": 
            case "2": {
                type = 2;
                break;
            }
            case "UNKNOWN": 
            case "-1": {
                type = -1;
                break;
            }
        }
        return type;
    }

    @Transactional(rollbackFor={Throwable.class})
    public void importWhiteListFromExcel(List<WhitelistImportFromExcelInput> inputs) {
        if (CollectionUtils.isEmpty(inputs)) {
            return;
        }
        Long applicationId = inputs.get(0).getApplicationId();
        ApplicationDetailResult applicationDetailResult = this.applicationDAO.getApplicationById(applicationId);
        if (applicationDetailResult == null) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.EXCEL_IMPORT_ERROR, (Object)"\u672a\u627e\u5230\u5e94\u7528");
        }
        User user = this.TUserMapper.selectById(applicationDetailResult.getUserId());
        List whitelistResults = this.whiteListDAO.listByApplicationId(applicationId);
        Map<String, List<WhitelistResult>> whitelistResultsMap = whitelistResults.stream().collect(Collectors.groupingBy(w -> WhitelistUtil.buildWhiteId((Object)w.getType(), (String)w.getInterfaceName())));
        List armdString = whitelistResults.stream().map(WhitelistResult::getInterfaceName).collect(Collectors.toList());
        List existWhite = this.getExistWhite(armdString, (List)Lists.newArrayList());
        ArrayList saveOrUpdateParams = Lists.newArrayList();
        inputs.forEach(input -> {
            String id = WhitelistUtil.buildWhiteId((Object)input.getInterfaceType(), (String)input.getInterfaceName());
            List results = (List)whitelistResultsMap.get(id);
            WhitelistSaveOrUpdateParam saveOrUpdateParam = new WhitelistSaveOrUpdateParam();
            if (CollectionUtils.isNotEmpty((Collection)results)) {
                WhitelistResult whitelistResult = (WhitelistResult)results.get(0);
                BeanUtils.copyProperties((Object)input, (Object)saveOrUpdateParam);
                saveOrUpdateParam.setWlistId(whitelistResult.getWlistId());
                saveOrUpdateParam.setGmtModified(new Date());
                saveOrUpdateParam.setType(String.valueOf(input.getInterfaceType()));
                saveOrUpdateParam.setUseYn(input.getUseYn());
                if (this.isDuplicate(existWhite, WhitelistUtil.buildWhiteId((Object)saveOrUpdateParam.getType(), (String)saveOrUpdateParam.getInterfaceName()))) {
                    saveOrUpdateParam.setIsGlobal(Boolean.valueOf(!Boolean.parseBoolean(this.isCheckDuplicateName)));
                }
                saveOrUpdateParam.setIsHandwork(input.getIsHandwork());
            } else {
                BeanUtils.copyProperties((Object)input, (Object)saveOrUpdateParam);
                saveOrUpdateParam.setType(String.valueOf(input.getInterfaceType()));
                saveOrUpdateParam.setUseYn(input.getUseYn());
                if (this.isDuplicate(existWhite, WhitelistUtil.buildWhiteId((Object)saveOrUpdateParam.getType(), (String)saveOrUpdateParam.getInterfaceName()))) {
                    saveOrUpdateParam.setIsGlobal(Boolean.valueOf(!Boolean.parseBoolean(this.isCheckDuplicateName)));
                }
                saveOrUpdateParam.setIsHandwork(input.getIsHandwork());
            }
            saveOrUpdateParams.add(saveOrUpdateParam);
        });
        this.whiteListDAO.batchSaveOrUpdate((List)saveOrUpdateParams);
        ArrayList addPartAppNameParams = Lists.newArrayList();
        List againResult = this.whiteListDAO.listByApplicationId(applicationId);
        Map<String, List<WhitelistResult>> againResultsMap = againResult.stream().collect(Collectors.groupingBy(w -> WhitelistUtil.buildWhiteId((Object)w.getType(), (String)w.getInterfaceName())));
        for (WhitelistImportFromExcelInput input2 : inputs) {
            if (CollectionUtils.isEmpty((Collection)input2.getEffectAppNames())) continue;
            String id = WhitelistUtil.buildWhiteId((Object)input2.getInterfaceType(), (String)input2.getInterfaceName());
            List<WhitelistResult> listResult = againResultsMap.get(id);
            input2.getEffectAppNames().forEach(appName -> {
                WhitelistAddPartAppNameParam addPartAppNameParam = new WhitelistAddPartAppNameParam();
                addPartAppNameParam.setInterfaceName(((WhitelistResult)listResult.get(0)).getInterfaceName());
                addPartAppNameParam.setType(((WhitelistResult)listResult.get(0)).getType());
                addPartAppNameParam.setEffectiveAppName(appName);
                addPartAppNameParam.setCustomerId(applicationDetailResult.getCustomerId());
                addPartAppNameParam.setUserId(applicationDetailResult.getUserId());
                addPartAppNameParam.setWlistId(((WhitelistResult)listResult.get(0)).getWlistId());
                addPartAppNameParams.add(addPartAppNameParam);
            });
        }
        List wlistIds = addPartAppNameParams.stream().map(WhitelistAddPartAppNameParam::getWlistId).collect(Collectors.toList());
        WhitelistEffectiveAppDeleteParam deleteParam = new WhitelistEffectiveAppDeleteParam();
        deleteParam.setCustomerId(applicationDetailResult.getCustomerId());
        deleteParam.setWlistIds(wlistIds);
        this.whitelistEffectiveAppDao.batchDelete(deleteParam);
        this.whitelistEffectiveAppDao.addPartAppName((List)addPartAppNameParams);
        this.whiteListFileService.writeWhiteListFile();
        this.configSyncService.syncAllowList(user.getKey(), applicationId.longValue(), applicationDetailResult.getApplicationName());
    }

    @Transactional(rollbackFor={Throwable.class})
    public void saveWhitelist(WhiteListCreateListVO vo) {
        Long applicationId = vo.getApplicationId();
        Integer interfaceType = vo.getInterfaceType();
        List interfaceList = vo.getInterfaceList();
        TDictionaryType tDictionaryType = this.tDictionaryTypeMapper.selectDictionaryByTypeAlias(TRODictTypeEnum.WLIST.name());
        ArrayList duplicateList = Lists.newArrayList();
        ArrayList toAddList = Lists.newArrayList();
        ArrayList toUpdateList = Lists.newArrayList();
        ApplicationDetailResult applicationDetailResult = this.applicationDAO.getApplicationById(applicationId);
        User user = this.TUserMapper.selectById(applicationDetailResult.getUserId());
        List twLists = this.tWListMntDao.queryWListTotalByApplicationId(applicationId);
        List armdString = twLists.stream().map(TWList::getInterfaceName).collect(Collectors.toList());
        List existWhite = this.getExistWhite(armdString, (List)Lists.newArrayList());
        if (CollectionUtils.isEmpty((Collection)twLists)) {
            for (String interfaceName : interfaceList) {
                TWList tWList = TWList.build((String)String.valueOf(applicationId), (String)String.valueOf(interfaceType), (String)interfaceName, (String)String.valueOf(YNEnum.YES.getValue()), (String)tDictionaryType.getId());
                twLists.add(tWList);
            }
            List paramList = twLists.stream().map(twList -> {
                ApplicationWhiteListCreateParam param = new ApplicationWhiteListCreateParam();
                BeanUtils.copyProperties((Object)twList, (Object)param);
                param.setCustomerId(applicationDetailResult.getCustomerId());
                param.setUserId(applicationDetailResult.getUserId());
                param.setIsHandwork(Boolean.valueOf(true));
                if (this.isDuplicate(existWhite, WhitelistUtil.buildWhiteId((Object)param.getType(), (String)param.getInterfaceName()))) {
                    param.setIsGlobal(Boolean.valueOf(!Boolean.parseBoolean(this.isCheckDuplicateName)));
                }
                return param;
            }).collect(Collectors.toList());
            this.applicationWhiteListDAO.insertBatch(paramList);
            this.whiteListFileService.writeWhiteListFile();
            this.configSyncService.syncAllowList(user.getKey(), applicationId.longValue(), applicationDetailResult.getApplicationName());
            return;
        }
        List existInterfaceList = twLists.stream().map(e -> WhitelistUtil.buildWhiteId((Object)e.getType(), (String)e.getInterfaceName())).collect(Collectors.toList());
        for (String interfaceName : interfaceList) {
            if (existInterfaceList.contains(WhitelistUtil.buildWhiteId((Object)interfaceType, (String)interfaceName))) {
                TWList whitelist = twLists.stream().filter(twList -> interfaceName.equals(twList.getInterfaceName())).findFirst().orElse(new TWList());
                whitelist.setHandwork(Boolean.valueOf(true));
                if (String.valueOf(YNEnum.YES.getValue()).equals(whitelist.getUseYn())) {
                    duplicateList.add(whitelist);
                    continue;
                }
                whitelist.setUseYn(String.valueOf(YNEnum.YES.getValue()));
                toUpdateList.add(whitelist);
                continue;
            }
            TWList tWList = TWList.build((String)String.valueOf(applicationId), (String)String.valueOf(interfaceType), (String)interfaceName, (String)String.valueOf(YNEnum.YES.getValue()), (String)tDictionaryType.getId());
            toAddList.add(tWList);
        }
        if (CollectionUtils.isNotEmpty((Collection)toAddList)) {
            List paramList = toAddList.stream().map(twList -> {
                ApplicationWhiteListCreateParam param = new ApplicationWhiteListCreateParam();
                BeanUtils.copyProperties((Object)twList, (Object)param);
                param.setCustomerId(applicationDetailResult.getCustomerId());
                param.setUserId(applicationDetailResult.getUserId());
                if (this.isDuplicate(existWhite, WhitelistUtil.buildWhiteId((Object)param.getType(), (String)param.getInterfaceName()))) {
                    param.setIsGlobal(Boolean.valueOf(!Boolean.parseBoolean(this.isCheckDuplicateName)));
                }
                if (twList.getHandwork() == null) {
                    param.setIsHandwork(Boolean.valueOf(true));
                }
                return param;
            }).collect(Collectors.toList());
            this.applicationWhiteListDAO.insertBatch(paramList);
        }
        if (CollectionUtils.isNotEmpty((Collection)toUpdateList)) {
            List wlistIdList = toUpdateList.stream().map(TWList::getWlistId).collect(Collectors.toList());
            this.tWListMntDao.batchEnableWList(wlistIdList);
        }
        this.whiteListFileService.writeWhiteListFile();
        this.configSyncService.syncAllowList(user.getKey(), applicationId.longValue(), applicationDetailResult.getApplicationName());
    }

    public void operateWhitelist(WhiteListOperateVO vo) {
        if (vo.getApplicationId() == null) {
            throw new RuntimeException("\u6ca1\u6709\u4f20\u5165\u5e94\u7528id");
        }
        List twLists = this.tWListMntDao.getWListByApplicationId(vo.getApplicationId());
        ApplicationDetailResult applicationDetailResult = this.applicationDAO.getApplicationById(vo.getApplicationId());
        Map<Object, Object> twMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)twLists)) {
            twMap = twLists.stream().collect(Collectors.toMap(e -> WhitelistUtil.buildWhiteId((Object)e.getType(), (String)e.getInterfaceName()), e -> e, (ov, nv) -> ov));
        }
        List armdString = twLists.stream().map(TWList::getInterfaceName).collect(Collectors.toList());
        List existWhite = this.getExistWhite(armdString, (List)Lists.newArrayList());
        if (vo.getType() == 1 && CollectionUtils.isNotEmpty((Collection)vo.getIds())) {
            ArrayList beAddList = Lists.newArrayList();
            ArrayList beUpdateList = Lists.newArrayList();
            for (String id : vo.getIds()) {
                TWList twList = (TWList)twMap.get(id);
                if (twList == null) {
                    String[] split = this.splitId(id);
                    twList = new TWList();
                    twList.setInterfaceName(split[0]);
                    twList.setType(String.valueOf(this.getInterfaceIntType(split[1])));
                    twList.setDictType("ca888ed801664c81815d8c4f5b8dff0c");
                    twList.setApplicationId(vo.getApplicationId() + "");
                    twList.setUseYn("1");
                    twList.setCustomerId(applicationDetailResult.getCustomerId());
                    twList.setUserId(applicationDetailResult.getUserId());
                    twList.setGlobal(Boolean.valueOf(true));
                    if (this.isDuplicate(existWhite, WhitelistUtil.buildWhiteId((Object)twList.getType(), (String)twList.getInterfaceName())) && Boolean.parseBoolean(this.isCheckDuplicateName)) {
                        twList.setGlobal(Boolean.valueOf(false));
                    }
                    beAddList.add(twList);
                    continue;
                }
                beUpdateList.add(twList.getWlistId());
            }
            if (CollectionUtils.isNotEmpty((Collection)beAddList)) {
                this.tWListMntDao.batchAddWList((List)beAddList);
            }
            if (CollectionUtils.isNotEmpty((Collection)beUpdateList)) {
                this.tWListMntDao.batchEnableWList((List)beUpdateList);
            }
        }
        if (vo.getType() == 0 && CollectionUtils.isNotEmpty((Collection)vo.getIds())) {
            ArrayList beList = Lists.newArrayList();
            for (String id : vo.getIds()) {
                TWList twList = (TWList)twMap.get(id);
                if (twList == null) continue;
                beList.add(twList.getWlistId());
            }
            if (CollectionUtils.isNotEmpty((Collection)beList)) {
                this.tWListMntDao.batchDisableWList((List)beList);
            }
        }
        TApplicationMnt tApplicationMnt = this.applicationMntDao.queryApplicationinfoById(vo.getApplicationId().longValue());
        User user = this.TUserMapper.selectById(tApplicationMnt.getUserId());
        this.whiteListFileService.writeWhiteListFile();
        this.configSyncService.syncAllowList(user.getKey(), vo.getApplicationId().longValue(), tApplicationMnt.getApplicationName());
    }

    public List<String> getExistWhite(List<String> interfaceNames, List<ApplicationDetailResult> appDetailResults) {
        ArrayList existWhites = Lists.newArrayList();
        List results = this.whiteListDAO.getList(new WhitelistSearchParam());
        if (CollectionUtils.isEmpty(appDetailResults)) {
            appDetailResults = this.getApplicationDetailResults();
        }
        Map<Long, List<ApplicationDetailResult>> appMap = appDetailResults.stream().collect(Collectors.groupingBy(ApplicationDetailResult::getApplicationId));
        List appNameWhiteIds = results.stream().map(result -> {
            List appList = (List)appMap.get(result.getApplicationId());
            return WhitelistUtil.buildAppNameWhiteId((String)(CollectionUtils.isNotEmpty((Collection)appList) ? ((ApplicationDetailResult)appList.get(0)).getApplicationName() : ""), (Object)result.getType(), (String)result.getInterfaceName());
        }).collect(Collectors.toList());
        List list = results.stream().map(result -> WhitelistUtil.buildWhiteId((Object)result.getType(), (String)result.getInterfaceName())).collect(Collectors.toList());
        existWhites.addAll(list);
        ApplicationInterfaceQueryDTO query = new ApplicationInterfaceQueryDTO();
        query.setPageSize(Integer.valueOf(1000));
        query.setServiceName(StringUtils.join(interfaceNames, (String)","));
        List dtos = this.applicationClient.listInterfaces(query);
        if (CollectionUtils.isNotEmpty((Collection)dtos)) {
            List amdbInferfaces = dtos.stream().filter(item -> {
                Integer interfaceType = this.getInterfaceIntType(item.getInterfaceType());
                String appNameWhiteId = WhitelistUtil.buildAppNameWhiteId((String)item.getAppName(), (Object)interfaceType, (String)item.getInterfaceName());
                return appNameWhiteIds.stream().filter(e -> e.equals(appNameWhiteId)).count() == 0L && !"-1".equals(interfaceType);
            }).map(item -> WhitelistUtil.buildWhiteId((Object)this.getInterfaceIntType(item.getInterfaceType()), (String)item.getInterfaceName())).collect(Collectors.toList());
            existWhites.addAll(amdbInferfaces);
        }
        return existWhites;
    }

    public PageInfo<WhiteListVO> queryWhitelist(WhiteListQueryVO vo) {
        List cardingResult;
        HashMap totalResult = Maps.newHashMap();
        List dbResult = this.tWListMntDao.queryDistinctWListTotalByApplicationId(vo.getApplicationId());
        String applicationName = this.applicationMntDao.selectApplicationName(String.valueOf(vo.getApplicationId()));
        ApplicationDetailResult applicationDetailResult = this.applicationDAO.getApplicationById(vo.getApplicationId());
        if (applicationName == null) {
            throw new RuntimeException("\u6839\u636e\u5e94\u7528id \u627e\u4e0d\u5230\u5e94\u7528\u540d");
        }
        if (vo.getUseYn() == null) {
            cardingResult = this.getAllInterface(applicationName);
            if (CollectionUtils.isNotEmpty((Collection)cardingResult)) {
                this.mergeCardingList((Map)totalResult, cardingResult, applicationDetailResult);
            }
            if (CollectionUtils.isNotEmpty((Collection)dbResult)) {
                this.mergeDbList((Map)totalResult, dbResult);
            }
        } else if (vo.getUseYn() == 1) {
            if (CollectionUtils.isNotEmpty((Collection)dbResult)) {
                List dbFilterResult = dbResult.stream().filter(w -> "1".equals(w.getUseYn())).collect(Collectors.toList());
                this.mergeDbList((Map)totalResult, dbFilterResult);
            }
        } else {
            cardingResult = this.getAllInterface(applicationName);
            if (CollectionUtils.isNotEmpty((Collection)cardingResult)) {
                this.mergeCardingList((Map)totalResult, cardingResult, applicationDetailResult);
            }
            if (CollectionUtils.isNotEmpty((Collection)dbResult)) {
                this.mergeDbList((Map)totalResult, dbResult);
                List dbFilterResult = dbResult.stream().filter(w -> "1".equals(w.getUseYn())).collect(Collectors.toList());
                this.mergeOutList((Map)totalResult, dbFilterResult);
            }
        }
        if (totalResult.size() == 0) {
            return new PageInfo((List)Lists.newArrayList());
        }
        Iterator iterator = totalResult.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            if (vo.getInterfaceType() != null && !((WhiteListVO)next.getValue()).getInterfaceType().equals(vo.getInterfaceType())) {
                iterator.remove();
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)vo.getInterfaceName()) || ((WhiteListVO)next.getValue()).getInterfaceName().contains(vo.getInterfaceName())) continue;
            iterator.remove();
        }
        int start = Math.min(vo.getOffset(), totalResult.size());
        int end = Math.min(vo.getOffset() + vo.getPageSize(), totalResult.size());
        List<Object> resList = new ArrayList(totalResult.values());
        resList.sort((arg_0, arg_1) -> this.whiteListCompare(arg_0, arg_1));
        resList = resList.subList(start, end);
        List armdString = resList.stream().map(WhiteListVO::getInterfaceName).collect(Collectors.toList());
        List existWhite = this.getExistWhite(armdString, (List)Lists.newArrayList());
        for (WhiteListVO whiteListVO : resList) {
            List allowEnableDisableUserIdList;
            List allowUpdateUserIdList = RestContext.getUpdateAllowUserIdList();
            if (whiteListVO.getIsDbValue().booleanValue()) {
                if (CollectionUtils.isEmpty((Collection)allowUpdateUserIdList)) {
                    whiteListVO.setCanEdit(Boolean.valueOf(true));
                } else {
                    whiteListVO.setCanEdit(Boolean.valueOf(allowUpdateUserIdList.contains(whiteListVO.getUserId())));
                }
                if (whiteListVO.getIsHandwork() == null) {
                    whiteListVO.setIsHandwork(Boolean.valueOf(true));
                }
                if (!whiteListVO.getIsHandwork().booleanValue()) {
                    whiteListVO.setCanEdit(Boolean.valueOf(false));
                }
            } else {
                whiteListVO.setCanEdit(Boolean.valueOf(false));
                whiteListVO.setIsHandwork(Boolean.valueOf(false));
            }
            whiteListVO.setTags(this.getTags(existWhite, whiteListVO));
            List allowDeleteUserIdList = RestContext.getDeleteAllowUserIdList();
            if (whiteListVO.getIsDbValue().booleanValue()) {
                if (CollectionUtils.isEmpty((Collection)allowDeleteUserIdList)) {
                    whiteListVO.setCanRemove(Boolean.valueOf(true));
                } else {
                    whiteListVO.setCanRemove(Boolean.valueOf(allowDeleteUserIdList.contains(whiteListVO.getUserId())));
                }
                if (!whiteListVO.getIsHandwork().booleanValue()) {
                    whiteListVO.setCanEdit(Boolean.valueOf(false));
                }
            } else {
                whiteListVO.setCanRemove(Boolean.valueOf(false));
            }
            if (!CollectionUtils.isNotEmpty((Collection)(allowEnableDisableUserIdList = RestContext.getEnableDisableAllowUserIdList()))) continue;
            whiteListVO.setCanEnableDisable(Boolean.valueOf(allowEnableDisableUserIdList.contains(whiteListVO.getUserId())));
        }
        PageInfo whiteListDTOPageInfo = new PageInfo(resList);
        whiteListDTOPageInfo.setTotal((long)totalResult.size());
        return whiteListDTOPageInfo;
    }

    public int whiteListCompare(WhiteListVO o1, WhiteListVO o2) {
        int sort = 0;
        if (o1.getGmtUpdate() != null && o2.getGmtUpdate() != null && (sort = -o1.getGmtUpdate().compareTo(o2.getGmtUpdate())) != 0) {
            return sort;
        }
        if (o1.getDbId() != null && o2.getDbId() != null && (sort = -o1.getDbId().compareTo(o2.getDbId())) != 0) {
            return sort;
        }
        return o1.getInterfaceName().compareTo(o2.getInterfaceName());
    }

    private void mergeOutList(Map<String, WhiteListVO> totalResult, List<TWList> dbResult) {
        if (MapUtils.isEmpty(totalResult) || CollectionUtils.isEmpty(dbResult)) {
            return;
        }
        dbResult.forEach(it -> {
            String id = WhitelistUtil.buildWhiteId((Object)it.getType(), (String)it.getInterfaceName());
            totalResult.remove(id);
        });
    }

    private void mergeCardingList(Map<String, WhiteListVO> totalResult, List<InterfaceVo> graphResult, ApplicationDetailResult applicationDetailResult) {
        if (CollectionUtils.isEmpty(graphResult)) {
            return;
        }
        graphResult.forEach(graph -> {
            String interfaceType = graph.getInterfaceType();
            String id = WhitelistUtil.buildWhiteId((Object)interfaceType, (String)graph.getInterfaceName());
            WhiteListVO whiteListVO = new WhiteListVO();
            whiteListVO.setWlistId(id);
            whiteListVO.setUseYn(Integer.valueOf(0));
            whiteListVO.setInterfaceType(this.getInterfaceIntType(interfaceType));
            whiteListVO.setInterfaceName(graph.getInterfaceName());
            whiteListVO.setCustomerId(applicationDetailResult.getCustomerId());
            whiteListVO.setUserId(applicationDetailResult.getUserId());
            whiteListVO.setIsDbValue(Boolean.valueOf(false));
            whiteListVO.setIsGlobal(Boolean.valueOf(true));
            whiteListVO.setIsHandwork(Boolean.valueOf(false));
            totalResult.putIfAbsent(id, whiteListVO);
        });
    }

    private void mergeDbList(Map<String, WhiteListVO> totalResult, List<TWList> dbResults) {
        if (CollectionUtils.isEmpty(dbResults)) {
            return;
        }
        dbResults.forEach(dbResult -> {
            String interfaceType = dbResult.getType();
            String id = WhitelistUtil.buildWhiteId((Object)interfaceType, (String)dbResult.getInterfaceName());
            WhiteListVO whiteListVO = new WhiteListVO();
            whiteListVO.setIsGlobal(dbResult.getGlobal());
            whiteListVO.setIsHandwork(dbResult.getHandwork());
            whiteListVO.setWlistId(id);
            whiteListVO.setUseYn(Integer.valueOf(Integer.parseInt(dbResult.getUseYn())));
            Integer type = this.getInterfaceIntType(interfaceType);
            whiteListVO.setInterfaceType(type);
            whiteListVO.setInterfaceName(dbResult.getInterfaceName());
            whiteListVO.setGmtUpdate(dbResult.getGmtModified());
            whiteListVO.setCustomerId(dbResult.getCustomerId());
            whiteListVO.setUserId(dbResult.getUserId());
            whiteListVO.setIsDbValue(Boolean.valueOf(true));
            whiteListVO.setGmtCreate(dbResult.getCreateTime());
            whiteListVO.setDbId(String.valueOf(dbResult.getWlistId()));
            totalResult.merge(id, whiteListVO, (ov, nv) -> {
                nv.setIsDbValue(Boolean.valueOf(ov.getIsDbValue() & nv.getIsDbValue()));
                return nv;
            });
        });
    }

    public List<TWList> getAllEnableWhitelists(String applicationId) {
        return this.tWListMntDao.getAllEnableWhitelists(applicationId);
    }

    public void updateWhitelist(WhiteListUpdateRequest request) {
        List existWhiteLists;
        List data;
        WhiteListEntity whiteListEntity = (WhiteListEntity)this.whiteListMapper.selectById((Serializable)request.getDbId());
        if (whiteListEntity == null) {
            throw new RuntimeException(String.format("ID[%s]\u5bf9\u5e94\u7684\u767d\u540d\u5355\uff0c\u5728\u6570\u636e\u5e93\u4e2d\u6ca1\u6709\u53d1\u73b0", request.getDbId()));
        }
        if ((!request.getInterfaceType().equals(whiteListEntity.getType()) || request.getInterfaceName().equals(whiteListEntity.getInterfaceName())) && (data = (existWhiteLists = this.tWListMntDao.queryWListTotalByApplicationId(whiteListEntity.getApplicationId())).stream().map(tw -> WhitelistUtil.buildWhiteId((Object)tw.getType(), (String)tw.getInterfaceName())).collect(Collectors.toList())).contains(WhitelistUtil.buildWhiteId((Object)request.getInterfaceType(), (String)request.getInterfaceName()))) {
            throw new RuntimeException(String.format("\u5bf9\u5e94\u7684\u767d\u540d\u5355\uff0c\u5728\u6570\u636e\u5e93\u4e2d\u6709\u91cd\u540d\u767d\u540d\u5355", request.getDbId()));
        }
        WhiteListEntity updateEntity = new WhiteListEntity();
        updateEntity.setInterfaceName(request.getInterfaceName());
        updateEntity.setType(request.getInterfaceType());
        updateEntity.setWlistId(request.getDbId());
        this.whiteListMapper.updateById((Object)updateEntity);
        WhitelistEffectiveAppSearchParam searchParam = new WhitelistEffectiveAppSearchParam();
        searchParam.setWlistId(request.getDbId());
        List appResults = this.whitelistEffectiveAppDao.getList(searchParam);
        List params = appResults.stream().map(result -> {
            WhitelistUpdatePartAppNameParam param = new WhitelistUpdatePartAppNameParam();
            BeanUtils.copyProperties((Object)result, (Object)param);
            param.setInterfaceName(request.getInterfaceName());
            param.setType(request.getInterfaceType());
            param.setGmtModified(new Date());
            return param;
        }).collect(Collectors.toList());
        this.whitelistEffectiveAppDao.updatePartAppName(params);
        this.whiteListFileService.writeWhiteListFile();
        this.configSyncService.syncAllowList(RestContext.getUser().getCustomerKey(), whiteListEntity.getApplicationId().longValue(), null);
    }

    public void deleteWhitelist(WhiteListDeleteRequest request) {
        List listEntities = this.whiteListMapper.selectBatchIds((Collection)request.getDbIds());
        if (CollectionUtils.isEmpty((Collection)listEntities)) {
            return;
        }
        List interfaceNames = listEntities.stream().map(WhiteListEntity::getInterfaceName).collect(Collectors.toList());
        OperationLogContextHolder.addVars((String)"interface", (String)StringUtils.join(interfaceNames, (String)","));
        this.whiteListMapper.deleteBatchIds((Collection)request.getDbIds());
        List ids = listEntities.stream().map(WhiteListEntity::getWlistId).collect(Collectors.toList());
        WhitelistEffectiveAppDeleteParam deleteParam = new WhitelistEffectiveAppDeleteParam();
        deleteParam.setWlistIds(ids);
        this.whitelistEffectiveAppDao.batchDelete(deleteParam);
        this.whiteListFileService.writeWhiteListFile();
        listEntities.forEach(entry -> this.configSyncService.syncAllowList(RestContext.getUser().getCustomerKey(), entry.getApplicationId().longValue(), null));
    }

    public WhitelistPartVO getPart(Long wlistId) {
        WhitelistPartVO vo = new WhitelistPartVO();
        WhitelistEffectiveAppSearchParam appSearchParam = new WhitelistEffectiveAppSearchParam();
        appSearchParam.setCustomerId(RestContext.getCustomerId());
        appSearchParam.setWlistId(wlistId);
        List appResults = this.whitelistEffectiveAppDao.getList(appSearchParam);
        vo.setEffectiveAppNames((List)(CollectionUtils.isNotEmpty((Collection)appResults) ? appResults.stream().map(WhitelistEffectiveAppResult::getEffectiveAppName).collect(Collectors.toList()) : Lists.newArrayList()));
        ApplicationQueryParam queryParam = new ApplicationQueryParam();
        queryParam.setCustomerId(RestContext.getCustomerId());
        List allAppNames = this.applicationDAO.getAllApplicationName(queryParam);
        vo.setAllAppNames(allAppNames);
        return vo;
    }

    @Transactional(rollbackFor={Throwable.class})
    public void part(WhitelistUpdatePartAppNameInput input) {
        WhitelistResult whitelistResult = this.whiteListDAO.selectById(input.getWlistId());
        if (whitelistResult == null) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.WHITELIST_EFFECTIVE_APP_ERROR, (Object)"\u672a\u627e\u5230\u8be5\u767d\u540d\u5355");
        }
        if (CollectionUtils.isEmpty((Collection)input.getEffectiveAppName())) {
            return;
        }
        User user = RestContext.getUser();
        if (user == null) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.WHITELIST_EFFECTIVE_APP_ERROR, (Object)"\u672a\u627e\u5230\u767b\u5f55\u8d26\u53f7\u4fe1\u606f");
        }
        WhitelistEffectiveAppDeleteParam deleteParam = new WhitelistEffectiveAppDeleteParam();
        deleteParam.setCustomerId(user.getCustomerId());
        deleteParam.setWlistId(input.getWlistId());
        this.whitelistEffectiveAppDao.delete(deleteParam);
        ArrayList params = Lists.newArrayList();
        input.getEffectiveAppName().forEach(appName -> {
            WhitelistAddPartAppNameParam param = new WhitelistAddPartAppNameParam();
            param.setInterfaceName(whitelistResult.getInterfaceName());
            param.setType(whitelistResult.getType());
            param.setEffectiveAppName(appName);
            param.setCustomerId(user.getCustomerId());
            param.setUserId(user.getId());
            param.setWlistId(input.getWlistId());
            params.add(param);
        });
        this.whitelistEffectiveAppDao.addPartAppName((List)params);
        WhitelistGlobalOrPartParam param = new WhitelistGlobalOrPartParam();
        param.setIsGlobal(Boolean.valueOf(false));
        param.setWlistId(input.getWlistId());
        this.whiteListDAO.updateWhitelistGlobal(param);
        this.whiteListFileService.writeWhiteListFile();
        this.configSyncService.syncAllowList(RestContext.getUser().getCustomerKey(), whitelistResult.getApplicationId().longValue(), null);
    }

    @Transactional(rollbackFor={Throwable.class})
    public void global(Long wlistId) {
        WhitelistResult whitelistResult = this.whiteListDAO.selectById(wlistId);
        if (whitelistResult == null) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.WHITELIST_EFFECTIVE_APP_ERROR, (Object)"\u672a\u627e\u5230\u8be5\u767d\u540d\u5355");
        }
        if (Boolean.parseBoolean(this.isCheckDuplicateName)) {
            ArrayList amdbString = Lists.newArrayList();
            amdbString.add(whitelistResult.getInterfaceName());
            List existWhite = this.getExistWhite((List)amdbString, (List)Lists.newArrayList());
            if (this.isDuplicate(existWhite, WhitelistUtil.buildWhiteId((Object)whitelistResult.getType(), (String)whitelistResult.getInterfaceName()))) {
                throw new TroWebException((ExceptionReadable)ExceptionCode.WHITELIST_EFFECTIVE_APP_ERROR, (Object)"\u91cd\u540d\u767d\u540d\u5355\u4e0d\u5141\u8bb8\u5168\u5c40\u751f\u6548");
            }
        }
        WhitelistGlobalOrPartParam param = new WhitelistGlobalOrPartParam();
        param.setIsGlobal(Boolean.valueOf(true));
        param.setWlistId(wlistId);
        this.whiteListDAO.updateWhitelistGlobal(param);
        this.whiteListFileService.writeWhiteListFile();
        this.configSyncService.syncAllowList(RestContext.getUser().getCustomerKey(), whitelistResult.getApplicationId().longValue(), null);
    }

    public PagingList<WhiteListVO> pagingList(WhitelistSearchInput input) {
        List appDetailResults = this.getApplicationDetailResults();
        PagingList dbPagingList = this.getDbPagingList(input, appDetailResults);
        PagingList amdbPagingList = this.getAmdbPagingList(input, appDetailResults);
        ArrayList results = Lists.newArrayList();
        if ((long)(input.getPageSize() * (input.getCurrentPage() + 1)) >= dbPagingList.getTotal() || dbPagingList.getTotal() < (long)input.getPageSize()) {
            results.addAll(dbPagingList.getList());
            results.addAll(amdbPagingList.getList());
        } else {
            results.addAll(dbPagingList.getList());
        }
        List armdString = results.stream().map(WhiteListVO::getInterfaceName).collect(Collectors.toList());
        List existWhite = this.getExistWhite(armdString, appDetailResults);
        results.forEach(vo -> vo.setTags(this.getTags(existWhite, vo)));
        return PagingList.of((List)results, (long)(dbPagingList.getTotal() + amdbPagingList.getTotal()));
    }

    private List<ApplicationDetailResult> getApplicationDetailResults() {
        ApplicationQueryParam queryParam = new ApplicationQueryParam();
        queryParam.setCustomerId(RestContext.getCustomerId());
        return this.applicationDAO.getApplicationList(queryParam);
    }

    private PagingList<WhiteListVO> getAmdbPagingList(WhitelistSearchInput input, List<ApplicationDetailResult> appDetailResults) {
        ApplicationInterfaceQueryDTO query = new ApplicationInterfaceQueryDTO();
        query.setPageSize(Integer.valueOf(input.getPageSize()));
        if (StringUtils.isNotBlank((CharSequence)input.getInterfaceName())) {
            query.setServiceName(StringUtils.join((Object[])new String[]{input.getInterfaceName(), ","}));
        }
        if (StringUtils.isNotBlank((CharSequence)input.getAppName())) {
            query.setAppName(input.getAppName());
        }
        List results = this.whiteListDAO.getList(new WhitelistSearchParam());
        Map<Long, List<ApplicationDetailResult>> appMap = appDetailResults.stream().collect(Collectors.groupingBy(ApplicationDetailResult::getApplicationId));
        List appNameWhiteIds = results.stream().map(result -> {
            List appList = (List)appMap.get(result.getApplicationId());
            return WhitelistUtil.buildAppNameWhiteId((String)(CollectionUtils.isNotEmpty((Collection)appList) ? ((ApplicationDetailResult)appList.get(0)).getApplicationName() : ""), (Object)result.getType(), (String)result.getInterfaceName());
        }).collect(Collectors.toList());
        AtomicLong atomicLong = new AtomicLong(0L);
        PagingList dtos = this.applicationClient.pageInterfaces(query);
        if (CollectionUtils.isNotEmpty((Collection)dtos.getList())) {
            List whiteListVOS = dtos.getList().stream().filter(item -> {
                Integer interfaceType = this.getInterfaceIntType(item.getInterfaceType());
                String appNameWhiteId = WhitelistUtil.buildAppNameWhiteId((String)item.getAppName(), (Object)interfaceType, (String)item.getInterfaceName());
                Boolean flag = appNameWhiteIds.stream().filter(e -> e.equals(appNameWhiteId)).count() == 0L && !"-1".equals(interfaceType);
                if (!flag.booleanValue()) {
                    atomicLong.incrementAndGet();
                }
                return flag;
            }).map(item -> {
                WhiteListVO vo = new WhiteListVO();
                vo.setAppName(item.getAppName());
                vo.setInterfaceType(this.getInterfaceIntType(item.getInterfaceType()));
                vo.setInterfaceName(item.getInterfaceName());
                vo.setIsHandwork(Boolean.valueOf(false));
                vo.setUseYn(Integer.valueOf(0));
                vo.setIsGlobal(Boolean.valueOf(true));
                return vo;
            }).collect(Collectors.toList());
            return PagingList.of(whiteListVOS, (long)(dtos.getTotal() - atomicLong.get()));
        }
        return PagingList.empty();
    }

    private PagingList<WhiteListVO> getDbPagingList(WhitelistSearchInput input, List<ApplicationDetailResult> appDetailResults) {
        WhitelistSearchParam param = new WhitelistSearchParam();
        BeanUtils.copyProperties((Object)input, (Object)param);
        if (StringUtils.isNotBlank((CharSequence)input.getAppName())) {
            List ids = appDetailResults.stream().filter(app -> app.getApplicationName().contains(input.getAppName())).map(ApplicationDetailResult::getApplicationId).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(ids)) {
                return PagingList.empty();
            }
            param.setIds(ids);
        }
        if (StringUtils.isNotBlank((CharSequence)input.getInterfaceName())) {
            ArrayList interfaceNames = Lists.newArrayList((Object[])StringUtils.split((String)input.getInterfaceName(), (String)","));
            param.setInterfaceNames((List)interfaceNames);
        }
        PagingList pagingList = this.whiteListDAO.pagingList(param);
        WhitelistEffectiveAppSearchParam searchParam = new WhitelistEffectiveAppSearchParam();
        searchParam.setCustomerId(RestContext.getCustomerId());
        List effectiveAppDaoList = this.whitelistEffectiveAppDao.getList(searchParam);
        Map<Long, List<WhitelistEffectiveAppResult>> appResultsMap = effectiveAppDaoList.stream().collect(Collectors.groupingBy(WhitelistEffectiveAppResult::getWlistId));
        Map<Long, List<ApplicationDetailResult>> appMap = appDetailResults.stream().collect(Collectors.groupingBy(ApplicationDetailResult::getApplicationId));
        pagingList.getList().forEach(vo -> {
            List appList = (List)appMap.get(Long.valueOf(vo.getApplicationId()));
            if (CollectionUtils.isNotEmpty((Collection)appList)) {
                vo.setAppName(((ApplicationDetailResult)appList.get(0)).getApplicationName());
            }
            vo.setInterfaceType(this.getInterfaceIntType(String.valueOf(vo.getInterfaceType())));
            List appResults = (List)appResultsMap.get(Long.valueOf(vo.getWlistId()));
            vo.setEffectiveAppNames((List)(CollectionUtils.isNotEmpty((Collection)appResults) ? appResults.stream().map(WhitelistEffectiveAppResult::getEffectiveAppName).collect(Collectors.toList()) : Lists.newArrayList()));
        });
        return pagingList;
    }

    private List<String> getTags(List<String> list, WhiteListVO vo) {
        ArrayList tags = Lists.newArrayList();
        if (this.isDuplicate(list, WhitelistUtil.buildWhiteId((Object)vo.getInterfaceType(), (String)vo.getInterfaceName()))) {
            tags.add(WhitelistTagEnum.DUPLICATE_NAME.getTagName());
            if (Boolean.parseBoolean(this.isCheckDuplicateName)) {
                vo.setIsGlobal(Boolean.valueOf(false));
            }
        }
        if (vo.getIsHandwork() != null && vo.getIsHandwork().booleanValue()) {
            tags.add(WhitelistTagEnum.MANUALLY_ADD.getTagName());
        }
        return tags;
    }

    private boolean isDuplicate(List<String> list, String buildWhiteId) {
        return CollectionUtils.isNotEmpty(list) && list.stream().filter(e -> e.equals(buildWhiteId)).count() > 1L;
    }

    private String[] splitId(String id) {
        return id.split("@@");
    }

    public List<InterfaceVo> getAllInterface(String appName) {
        ApplicationInterfaceQueryDTO query = new ApplicationInterfaceQueryDTO();
        query.setAppName(appName);
        List applicationInterfaceDTOS = this.applicationClient.listInterfaces(query);
        if (CollectionUtils.isEmpty((Collection)applicationInterfaceDTOS)) {
            return Lists.newArrayList();
        }
        return applicationInterfaceDTOS.stream().map(item -> {
            InterfaceVo interfaceVo = new InterfaceVo();
            interfaceVo.setId(item.getId());
            Integer interfaceType = this.getInterfaceIntType(item.getInterfaceType());
            interfaceVo.setInterfaceType(String.valueOf(interfaceType));
            interfaceVo.setInterfaceName(item.getInterfaceName());
            return interfaceVo;
        }).filter(interfaceVo -> !"-1".equals(interfaceVo.getInterfaceType())).collect(Collectors.toList());
    }
}

