/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.linkManage.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pamirs.tro.common.ResponseOk;
import com.pamirs.tro.common.exception.TROModuleException;
import com.pamirs.tro.entity.dao.confcenter.TApplicationMntDao;
import com.pamirs.tro.entity.dao.confcenter.TBListMntDao;
import com.pamirs.tro.entity.dao.confcenter.TWListMntDao;
import com.pamirs.tro.entity.dao.user.TUserMapper;
import com.pamirs.tro.entity.domain.entity.user.User;
import com.pamirs.tro.entity.domain.query.whitelist.AgentWhiteList;
import com.pamirs.tro.entity.domain.vo.user.UserQueryParam;
import io.shulie.tro.web.app.common.RestContext;
import io.shulie.tro.web.app.service.linkManage.WhiteListService;
import io.shulie.tro.web.common.util.whitelist.WhitelistUtil;
import io.shulie.tro.web.common.vo.agent.AgentBlacklistVO;
import io.shulie.tro.web.data.dao.application.ApplicationDAO;
import io.shulie.tro.web.data.dao.application.WhiteListDAO;
import io.shulie.tro.web.data.dao.application.WhitelistEffectiveAppDao;
import io.shulie.tro.web.data.dao.blacklist.BlackListDAO;
import io.shulie.tro.web.data.param.application.ApplicationQueryParam;
import io.shulie.tro.web.data.param.whitelist.WhitelistEffectiveAppSearchParam;
import io.shulie.tro.web.data.param.whitelist.WhitelistSearchParam;
import io.shulie.tro.web.data.result.application.ApplicationDetailResult;
import io.shulie.tro.web.data.result.blacklist.BlacklistResult;
import io.shulie.tro.web.data.result.whitelist.WhitelistEffectiveAppResult;
import io.shulie.tro.web.data.result.whitelist.WhitelistResult;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class WhiteListFileService {
    private static final Logger log = LoggerFactory.getLogger(WhiteListFileService.class);
    @Value(value="${spring.config.whiteListPath}")
    private String whiteListPath;
    @Autowired
    private TBListMntDao tbListMntDao;
    @Autowired
    private TUserMapper userMapper;
    @Resource
    private TWListMntDao tWListMntDao;
    @Autowired
    private TApplicationMntDao applicationMntDao;
    @Autowired
    private BlackListDAO blackListDAO;
    @Autowired
    private ApplicationDAO applicationDAO;
    @Autowired
    private WhiteListDAO whiteListDAO;
    @Autowired
    private WhitelistEffectiveAppDao whitelistEffectiveAppDao;
    @Autowired
    private WhiteListService whiteListService;
    @Value(value="${whitelist.duplicate.name.check:false}")
    private String isCheckDuplicateName;

    @PostConstruct
    public void init() {
        UserQueryParam userQueryParam = new UserQueryParam();
        userQueryParam.setStatus(Integer.valueOf(0));
        userQueryParam.setUserType(Integer.valueOf(0));
        List users = this.userMapper.selectAllUser(userQueryParam);
        if (CollectionUtils.isNotEmpty((Collection)users)) {
            for (User user : users) {
                this.writeWhiteListFile(user.getId(), user.getKey());
            }
        }
    }

    public void writeWhiteListFile() {
        this.writeWhiteListFile(null, null);
    }

    public void writeWhiteListFile(Long id, String key) {
        try {
            Map result;
            if (RestContext.getUser() != null) {
                id = RestContext.getUser().getCustomerId();
                key = RestContext.getUser().getCustomerKey();
            }
            if (null != (result = this.queryBWList("", id)) && result.size() > 0) {
                File file = new File(this.whiteListPath);
                if (!file.exists()) {
                    file.mkdirs();
                }
                if (file.exists() && !(file = new File(this.whiteListPath + key)).isFile()) {
                    file.createNewFile();
                }
                ResponseOk.ResponseResult response = ResponseOk.result((Object)result);
                String content = JSONObject.toJSONString((Object)response);
                FileWriter fileWriter = new FileWriter(file.getAbsoluteFile(), false);
                BufferedWriter bufferWritter = new BufferedWriter(fileWriter);
                bufferWritter.write(content);
                bufferWritter.close();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    public Map<String, Object> queryBWList(String appName, Long uid) throws TROModuleException {
        List appIdList = this.applicationMntDao.queryIdsByNameAndTenant((List)Lists.newArrayList(), uid);
        List agentWhites = this.agentListWhitelist(appIdList);
        List ids = agentWhites.stream().map(AgentWhiteList::getWlistId).collect(Collectors.toList());
        List agentWhiteLists = agentWhites.stream().distinct().collect(Collectors.toList());
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)30);
        Boolean isCheckFlag = Boolean.parseBoolean(this.isCheckDuplicateName);
        List existWhite = Lists.newArrayList();
        Map<Object, Object> whitelistMap = Maps.newHashMap();
        if (isCheckFlag.booleanValue()) {
            List armdString = agentWhiteLists.stream().map(AgentWhiteList::getInterfaceName).collect(Collectors.toList());
            existWhite = this.whiteListService.getExistWhite(armdString, (List)Lists.newArrayList());
            WhitelistSearchParam param = new WhitelistSearchParam();
            param.setCustomerId(uid);
            param.setUseYn(Integer.valueOf(1));
            List results = this.whiteListDAO.getList(param);
            whitelistMap = results.stream().collect(Collectors.groupingBy(e -> e.getInterfaceName() + "@@" + e.getType()));
        } else {
            WhitelistSearchParam param = new WhitelistSearchParam();
            param.setCustomerId(uid);
            param.setIsGlobal(Boolean.valueOf(true));
            param.setUseYn(Integer.valueOf(1));
            List results = this.whiteListDAO.getList(param);
            whitelistMap = results.stream().collect(Collectors.groupingBy(e -> WhitelistUtil.buildWhiteId((Object)e.getType(), (String)e.getInterfaceName())));
        }
        WhitelistEffectiveAppSearchParam searchParam = new WhitelistEffectiveAppSearchParam();
        searchParam.setCustomerId(uid);
        searchParam.setWlistIds(ids);
        List appResults = this.whitelistEffectiveAppDao.getList(searchParam);
        Map<String, List<WhitelistEffectiveAppResult>> appResultsMap = appResults.stream().collect(Collectors.groupingBy(e -> WhitelistUtil.buildWhiteId((Object)e.getType(), (String)e.getInterfaceName())));
        ArrayList wListsResult = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(agentWhiteLists)) {
            for (AgentWhiteList agentWhiteList : agentWhiteLists) {
                List list;
                String type = agentWhiteList.getType();
                String interfaceName = agentWhiteList.getInterfaceName();
                String id = WhitelistUtil.buildWhiteId((Object)agentWhiteList.getSourceType(), (String)interfaceName);
                if ("2".equals(type) && StringUtils.contains((CharSequence)interfaceName, (CharSequence)"#")) {
                    interfaceName = StringUtils.substringBefore((String)interfaceName, (String)"#");
                }
                HashMap<String, Object> whiteItemNew = new HashMap<String, Object>();
                whiteItemNew.put("TYPE", type);
                whiteItemNew.put("INTERFACE_NAME", interfaceName);
                if (isCheckFlag.booleanValue()) {
                    if (existWhite.stream().filter(e -> e.equals(id)).count() == 1L) {
                        list = (List)whitelistMap.get(id);
                        if (CollectionUtils.isNotEmpty((Collection)list)) {
                            whiteItemNew.put("isGlobal", ((WhitelistResult)list.get(0)).getIsGlobal());
                        } else {
                            whiteItemNew.put("isGlobal", true);
                        }
                    } else if (existWhite.stream().filter(e -> e.equals(id)).count() > 1L) {
                        whiteItemNew.put("isGlobal", false);
                    } else {
                        whiteItemNew.put("isGlobal", true);
                    }
                } else {
                    list = (List)whitelistMap.get(id);
                    whiteItemNew.put("isGlobal", CollectionUtils.isNotEmpty((Collection)list));
                }
                List<WhitelistEffectiveAppResult> appLists = appResultsMap.get(id);
                whiteItemNew.put("appNames", CollectionUtils.isNotEmpty(appLists) ? appLists.stream().map(WhitelistEffectiveAppResult::getEffectiveAppName).distinct().collect(Collectors.toList()) : Lists.newArrayList());
                wListsResult.add(whiteItemNew);
            }
        }
        List newBlacklist = this.getNewBlackList(appIdList);
        List blackList = this.getBlackList(uid);
        resultMap.put("wLists", wListsResult);
        resultMap.put("bLists", blackList);
        resultMap.put("newBlists", newBlacklist);
        return resultMap;
    }

    private List<Map<String, Object>> getBlackList(Long uid) {
        List tbLists = this.tbListMntDao.getAllEnabledBlockList();
        if (CollectionUtils.isEmpty((Collection)tbLists)) {
            return Lists.newArrayList();
        }
        return tbLists.stream().map(tbList -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("REDIS_KEY", tbList.getRedisKey());
            return map;
        }).collect(Collectors.toList());
    }

    private List<AgentBlacklistVO> getNewBlackList(List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        List appIds = list.stream().filter(Objects::nonNull).map(Long::valueOf).collect(Collectors.toList());
        List results = this.blackListDAO.getAllEnabledBlockList(appIds);
        ApplicationQueryParam param = new ApplicationQueryParam();
        if (CollectionUtils.isEmpty((Collection)results)) {
            return Lists.newArrayList();
        }
        List detailResults = this.applicationDAO.getApplicationList(param);
        Map<Long, List<BlacklistResult>> redisMap = results.stream().collect(Collectors.groupingBy(BlacklistResult::getApplicationId));
        Map<Long, List<ApplicationDetailResult>> detailResultMap = detailResults.stream().collect(Collectors.groupingBy(ApplicationDetailResult::getApplicationId));
        ArrayList vos = Lists.newArrayList();
        for (Long id : redisMap.keySet()) {
            List<ApplicationDetailResult> app = detailResultMap.get(id);
            if (CollectionUtils.isEmpty(app)) continue;
            AgentBlacklistVO vo = new AgentBlacklistVO();
            vo.setAppName(app.get(0).getApplicationName());
            List<BlacklistResult> blacklist = redisMap.get(id);
            if (CollectionUtils.isNotEmpty(blacklist)) {
                vo.setBlacklists(blacklist.stream().map(BlacklistResult::getRedisKey).collect(Collectors.toList()));
            } else {
                vo.setBlacklists((List)Lists.newArrayList());
            }
            vos.add(vo);
        }
        return vos;
    }

    private List<AgentWhiteList> agentListWhitelist(List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        List maps = this.tWListMntDao.getWListByAppIds(list);
        return maps.stream().map(it -> {
            AgentWhiteList whiteListDTO = new AgentWhiteList();
            whiteListDTO.setInterfaceName((String)it.get("interfaceName"));
            whiteListDTO.setType(this.getType(Integer.parseInt((String)it.get("type"))));
            whiteListDTO.setSourceType((String)it.get("type"));
            whiteListDTO.setWlistId((Long)it.get("wlistId"));
            return whiteListDTO;
        }).collect(Collectors.toList());
    }

    private String getType(int dbType) {
        String type;
        switch (dbType) {
            case 1: {
                type = "http";
                break;
            }
            case 2: {
                type = "dubbo";
                break;
            }
            case 3: {
                type = "rabbitmq";
                break;
            }
            default: {
                type = "unknow";
            }
        }
        return type;
    }
}

