/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.linkManage;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.pamirs.tro.common.util.DateUtils;
import com.pamirs.tro.entity.dao.confcenter.TApplicationMntDao;
import com.pamirs.tro.entity.dao.linkguard.TLinkGuardMapper;
import com.pamirs.tro.entity.dao.linkmanage.TBusinessLinkManageTableMapper;
import com.pamirs.tro.entity.dao.linkmanage.TLinkManageTableMapper;
import com.pamirs.tro.entity.dao.linkmanage.TMiddlewareInfoMapper;
import com.pamirs.tro.entity.dao.linkmanage.TMiddlewareLinkRelateMapper;
import com.pamirs.tro.entity.dao.linkmanage.TSceneLinkRelateMapper;
import com.pamirs.tro.entity.dao.linkmanage.TSceneMapper;
import com.pamirs.tro.entity.domain.dto.EntranceSimpleDto;
import com.pamirs.tro.entity.domain.dto.linkmanage.BusinessActiveIdAndNameDto;
import com.pamirs.tro.entity.domain.dto.linkmanage.BusinessActiveViewListDto;
import com.pamirs.tro.entity.domain.dto.linkmanage.BusinessFlowDto;
import com.pamirs.tro.entity.domain.dto.linkmanage.BusinessFlowIdAndNameDto;
import com.pamirs.tro.entity.domain.dto.linkmanage.BusinessLinkDto;
import com.pamirs.tro.entity.domain.dto.linkmanage.EntranceDto;
import com.pamirs.tro.entity.domain.dto.linkmanage.ExistBusinessActiveDto;
import com.pamirs.tro.entity.domain.dto.linkmanage.MiddleWareNameDto;
import com.pamirs.tro.entity.domain.dto.linkmanage.MiddleWareVersionDto;
import com.pamirs.tro.entity.domain.dto.linkmanage.SceneDto;
import com.pamirs.tro.entity.domain.dto.linkmanage.SystemProcessIdAndNameDto;
import com.pamirs.tro.entity.domain.dto.linkmanage.SystemProcessViewListDto;
import com.pamirs.tro.entity.domain.dto.linkmanage.TechLinkDto;
import com.pamirs.tro.entity.domain.dto.linkmanage.TopologicalGraphEntity;
import com.pamirs.tro.entity.domain.dto.linkmanage.TopologicalGraphNode;
import com.pamirs.tro.entity.domain.dto.linkmanage.TopologicalGraphRelation;
import com.pamirs.tro.entity.domain.dto.linkmanage.TopologicalGraphVo;
import com.pamirs.tro.entity.domain.dto.linkmanage.linkstatistics.ApplicationRemoteDto;
import com.pamirs.tro.entity.domain.dto.linkmanage.linkstatistics.BusinessCoverDto;
import com.pamirs.tro.entity.domain.dto.linkmanage.linkstatistics.LinkHistoryInfoDto;
import com.pamirs.tro.entity.domain.dto.linkmanage.linkstatistics.LinkRemarkDto;
import com.pamirs.tro.entity.domain.dto.linkmanage.linkstatistics.SystemProcessDto;
import com.pamirs.tro.entity.domain.dto.linkmanage.mapping.LinkDomainEnumMapping;
import com.pamirs.tro.entity.domain.dto.linkmanage.mapping.enums.LinkDomainEnum;
import com.pamirs.tro.entity.domain.dto.linkmanage.mapping.enums.MiddlewareTypeEnum;
import com.pamirs.tro.entity.domain.dto.linkmanage.mapping.enums.NodeClassEnum;
import com.pamirs.tro.entity.domain.entity.linkmanage.BusinessLinkManageTable;
import com.pamirs.tro.entity.domain.entity.linkmanage.LinkManageTable;
import com.pamirs.tro.entity.domain.entity.linkmanage.LinkQueryVo;
import com.pamirs.tro.entity.domain.entity.linkmanage.Scene;
import com.pamirs.tro.entity.domain.entity.linkmanage.SceneAndBusinessLink;
import com.pamirs.tro.entity.domain.entity.linkmanage.SceneLinkRelate;
import com.pamirs.tro.entity.domain.entity.linkmanage.TMiddlewareInfo;
import com.pamirs.tro.entity.domain.entity.linkmanage.figure.LinkEdge;
import com.pamirs.tro.entity.domain.entity.linkmanage.statistics.StatisticsQueryVo;
import com.pamirs.tro.entity.domain.entity.linkmanage.structure.Category;
import com.pamirs.tro.entity.domain.vo.linkmanage.BusinessFlowTree;
import com.pamirs.tro.entity.domain.vo.linkmanage.BusinessFlowVo;
import com.pamirs.tro.entity.domain.vo.linkmanage.BusinessLinkVo;
import com.pamirs.tro.entity.domain.vo.linkmanage.MiddleWareEntity;
import com.pamirs.tro.entity.domain.vo.linkmanage.TechLinkVo;
import com.pamirs.tro.entity.domain.vo.linkmanage.queryparam.BusinessQueryVo;
import com.pamirs.tro.entity.domain.vo.linkmanage.queryparam.SceneQueryVo;
import com.pamirs.tro.entity.domain.vo.linkmanage.queryparam.TechQueryVo;
import io.shulie.tro.web.app.common.Response;
import io.shulie.tro.web.app.common.RestContext;
import io.shulie.tro.web.app.context.OperationLogContextHolder;
import io.shulie.tro.web.app.controller.linkmanage.DictionaryCache;
import io.shulie.tro.web.app.response.application.ApplicationDetailResponse;
import io.shulie.tro.web.app.response.linkmanage.BusinessActivityNameResponse;
import io.shulie.tro.web.app.response.linkmanage.BusinessLinkResponse;
import io.shulie.tro.web.app.response.linkmanage.MiddleWareResponse;
import io.shulie.tro.web.app.response.linkmanage.TechLinkResponse;
import io.shulie.tro.web.app.service.agent.AgentPluginSupportService;
import io.shulie.tro.web.app.service.linkManage.LinkManage;
import io.shulie.tro.web.app.service.linkManage.LinkManageService;
import io.shulie.tro.web.app.utils.CategoryUtils;
import io.shulie.tro.web.app.utils.PageUtils;
import io.shulie.tro.web.auth.api.UserService;
import io.shulie.tro.web.data.dao.application.ApplicationDAO;
import io.shulie.tro.web.data.dao.linkmanage.BusinessLinkManageDAO;
import io.shulie.tro.web.data.dao.linkmanage.LinkManageDAO;
import io.shulie.tro.web.data.dao.linkmanage.SceneDAO;
import io.shulie.tro.web.data.model.mysql.AgentPluginEntity;
import io.shulie.tro.web.data.model.mysql.AgentPluginLibSupportEntity;
import io.shulie.tro.web.data.param.linkmanage.BusinessLinkManageCreateParam;
import io.shulie.tro.web.data.param.linkmanage.BusinessLinkManageQueryParam;
import io.shulie.tro.web.data.param.linkmanage.LinkManageCreateParam;
import io.shulie.tro.web.data.param.linkmanage.LinkManageQueryParam;
import io.shulie.tro.web.data.param.linkmanage.SceneCreateParam;
import io.shulie.tro.web.data.param.linkmanage.SceneQueryParam;
import io.shulie.tro.web.data.result.application.ApplicationResult;
import io.shulie.tro.web.data.result.application.LibraryResult;
import io.shulie.tro.web.data.result.linkmange.BusinessLinkResult;
import io.shulie.tro.web.data.result.linkmange.LinkManageResult;
import io.shulie.tro.web.data.result.linkmange.TechLinkResult;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class LinkManageServiceImpl
implements LinkManageService {
    private static Logger logger = LoggerFactory.getLogger(LinkManageServiceImpl.class);
    private static List<AgentPluginEntity> agentPluginList = Lists.newArrayList();
    private static List<AgentPluginLibSupportEntity> agentPluginLibSupportList = Lists.newArrayList();
    private static String FALSE_CORE = "0";
    @Resource(name="transactionManager")
    DataSourceTransactionManager transactionManager;
    @Resource
    private TLinkManageTableMapper TLinkManageTableMapper;
    @Resource
    private TBusinessLinkManageTableMapper TBusinessLinkManageTableMapper;
    @Resource
    private TSceneLinkRelateMapper TSceneLinkRelateMapper;
    @Resource
    private TSceneMapper TSceneMapper;
    @Resource
    private TLinkGuardMapper TLinkGuardMapper;
    @Resource
    private TMiddlewareInfoMapper TMiddlewareInfoMapper;
    @Resource
    private TMiddlewareLinkRelateMapper TMiddlewareLinkRelateMapper;
    @Resource
    private LinkManage linkManage;
    @Resource
    private TApplicationMntDao tApplicationMntDao;
    @Resource
    private AgentPluginSupportService agentPluginSupportService;
    @Autowired
    private BusinessLinkManageDAO businessLinkManageDAO;
    @Autowired
    private ApplicationDAO applicationDAO;
    @Autowired
    private LinkManageDAO linkManageDAO;
    @Autowired
    private TSceneLinkRelateMapper tSceneLinkRelateMapper;
    @Autowired
    private SceneDAO sceneDAO;
    @Autowired
    private UserService userService;

    private static void iteratorChildNodes(TopologicalGraphNode parentNode, List<Category> childList, List<TopologicalGraphNode> nodes, List<TopologicalGraphRelation> relations) {
        if (CollectionUtils.isEmpty(childList)) {
            return;
        }
        List filterChildList = childList.stream().filter(LinkManageServiceImpl.distinctByName((T c) -> c.getApplicationName())).collect(Collectors.toList());
        int index = 0;
        for (int i = 0; i < filterChildList.size(); ++i) {
            TopologicalGraphNode childNode = new TopologicalGraphNode();
            childNode.setKey(parentNode.getKey() + "." + index);
            NodeClassEnum nodeClassEnum = LinkManageServiceImpl.getNodeClassEnumByApplicationName((String)((Category)filterChildList.get(i)).getApplicationName());
            MiddlewareTypeEnum middlewareTypeEnum = LinkManageServiceImpl.getMiddlewareTypeEnumByApplicationName((String)((Category)filterChildList.get(i)).getApplicationName());
            childNode.setNodeType(nodeClassEnum.getCode());
            childNode.setNodeClass(nodeClassEnum.getDesc());
            if (middlewareTypeEnum != null) {
                childNode.setMiddlewareType(middlewareTypeEnum.getCode());
                childNode.setMiddlewareName(middlewareTypeEnum.getDesc());
            }
            childNode.setNodeName(((Category)filterChildList.get(i)).getApplicationName());
            childNode.setNodeList(((Category)filterChildList.get(i)).getNodeList());
            childNode.setUnKnowNodeList(((Category)filterChildList.get(i)).getUnKnowNodeList());
            nodes.add(childNode);
            TopologicalGraphRelation relation = new TopologicalGraphRelation();
            relation.setFrom(parentNode.getKey());
            relation.setTo(childNode.getKey());
            relations.add(relation);
            if (CollectionUtils.isNotEmpty((Collection)((Category)filterChildList.get(i)).getChildren())) {
                LinkManageServiceImpl.iteratorChildNodes((TopologicalGraphNode)childNode, (List)((Category)filterChildList.get(i)).getChildren(), nodes, relations);
            }
            ++index;
        }
    }

    public static NodeClassEnum getNodeClassEnumByApplicationName(String applicationName) {
        switch (applicationName) {
            case "DB\u4e2d\u95f4\u4ef6": 
            case "MYSQL": 
            case "MYSQL\u4e2d\u95f4\u4ef6": 
            case "ORACLE": 
            case "ORACLE\u4e2d\u95f4\u4ef6": 
            case "SQLSERVER": 
            case "SQLSERVER\u4e2d\u95f4\u4ef6": 
            case "CASSANDRA": 
            case "CASSANDRA\u4e2d\u95f4\u4ef6": 
            case "HBASE": 
            case "HBASE\u4e2d\u95f4\u4ef6": 
            case "MONGODB": 
            case "MONGODB\u4e2d\u95f4\u4ef6": {
                return NodeClassEnum.DB;
            }
            case "ELASTICSEARCH": 
            case "ELASTICSEARCH\u4e2d\u95f4\u4ef6": {
                return NodeClassEnum.ES;
            }
            case "REDIS": 
            case "REDIS\u4e2d\u95f4\u4ef6": 
            case "MEMCACHE": 
            case "MEMCACHE\u4e2d\u95f4\u4ef6": {
                return NodeClassEnum.CACHE;
            }
            case "ROCKETMQ": 
            case "ROCKETMQ\u4e2d\u95f4\u4ef6": 
            case "KAFKA": 
            case "KAFKA\u4e2d\u95f4\u4ef6": 
            case "ACTIVEMQ": 
            case "ACTIVEMQ\u4e2d\u95f4\u4ef6": 
            case "RABBITMQ": 
            case "RABBITMQ\u4e2d\u95f4\u4ef6": {
                return NodeClassEnum.MQ;
            }
            case "DUBBO": 
            case "DUBBO\u4e2d\u95f4\u4ef6": {
                return NodeClassEnum.APP;
            }
        }
        if (applicationName.contains("\u672a\u77e5")) {
            return NodeClassEnum.UNKNOWN;
        }
        return NodeClassEnum.APP;
    }

    public static MiddlewareTypeEnum getMiddlewareTypeEnumByApplicationName(String applicationName) {
        switch (applicationName) {
            case "MYSQL": 
            case "MYSQL\u4e2d\u95f4\u4ef6": {
                return MiddlewareTypeEnum.MySQL;
            }
            case "ORACLE": 
            case "ORACLE\u4e2d\u95f4\u4ef6": {
                return MiddlewareTypeEnum.Oracle;
            }
            case "SQLSERVER": 
            case "SQLSERVER\u4e2d\u95f4\u4ef6": {
                return MiddlewareTypeEnum.SQLServer;
            }
            case "CASSANDRA": 
            case "CASSANDRA\u4e2d\u95f4\u4ef6": {
                return MiddlewareTypeEnum.Cassandra;
            }
            case "HBASE": 
            case "HBASE\u4e2d\u95f4\u4ef6": {
                return MiddlewareTypeEnum.HBase;
            }
            case "MONGODB": 
            case "MONGODB\u4e2d\u95f4\u4ef6": {
                return MiddlewareTypeEnum.MongoDB;
            }
            case "ELASTICSEARCH": 
            case "ELASTICSEARCH\u4e2d\u95f4\u4ef6": {
                return MiddlewareTypeEnum.Elasticsearch;
            }
            case "REDIS": 
            case "REDIS\u4e2d\u95f4\u4ef6": {
                return MiddlewareTypeEnum.Redis;
            }
            case "MEMCACHE": 
            case "MEMCACHE\u4e2d\u95f4\u4ef6": {
                return MiddlewareTypeEnum.Memcache;
            }
            case "ROCKETMQ": 
            case "ROCKETMQ\u4e2d\u95f4\u4ef6": {
                return MiddlewareTypeEnum.RocketMQ;
            }
            case "KAFKA": 
            case "KAFKA\u4e2d\u95f4\u4ef6": {
                return MiddlewareTypeEnum.Kafka;
            }
            case "ACTIVEMQ": 
            case "ACTIVEMQ\u4e2d\u95f4\u4ef6": {
                return MiddlewareTypeEnum.ActiveMQ;
            }
            case "RABBITMQ": 
            case "RABBITMQ\u4e2d\u95f4\u4ef6": {
                return MiddlewareTypeEnum.RabbitMQ;
            }
            case "DUBBO": 
            case "DUBBO\u4e2d\u95f4\u4ef6": {
                return MiddlewareTypeEnum.Dubbo;
            }
        }
        return null;
    }

    static <T> Predicate<T> distinctByName(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    public TechLinkResponse fetchLink(String applicationName, String entrance) {
        return null;
    }

    public TopologicalGraphVo fetchGraph(String body) {
        TopologicalGraphVo topologicalGraphVo = new TopologicalGraphVo();
        if (StringUtils.isNotBlank((CharSequence)body)) {
            Category category = (Category)JSON.parseObject((String)body, Category.class);
            ArrayList<TopologicalGraphNode> nodes = new ArrayList<TopologicalGraphNode>();
            ArrayList<TopologicalGraphRelation> relations = new ArrayList<TopologicalGraphRelation>();
            TopologicalGraphNode userNode = new TopologicalGraphNode();
            userNode.setKey("0");
            userNode.setNodeType(NodeClassEnum.OTHER.getCode());
            userNode.setNodeClass(NodeClassEnum.OTHER.getDesc());
            userNode.setNodeName("user");
            nodes.add(userNode);
            TopologicalGraphNode rootNode = new TopologicalGraphNode();
            rootNode.setKey("1");
            rootNode.setNodeType(NodeClassEnum.APP.getCode());
            rootNode.setNodeClass(NodeClassEnum.APP.getDesc());
            rootNode.setNodeName(category.getApplicationName());
            nodes.add(rootNode);
            TopologicalGraphRelation rootRelation = new TopologicalGraphRelation();
            rootRelation.setFrom(userNode.getKey());
            rootRelation.setTo(rootNode.getKey());
            relations.add(rootRelation);
            List childList = category.getChildren();
            LinkManageServiceImpl.iteratorChildNodes((TopologicalGraphNode)rootNode, (List)childList, nodes, relations);
            topologicalGraphVo.setGraphNodes(nodes);
            topologicalGraphVo.setGraphRelations(relations);
        }
        return topologicalGraphVo;
    }

    public List<EntranceDto> fetchApp() {
        ArrayList<EntranceDto> result = new ArrayList<EntranceDto>();
        List mapList = this.tApplicationMntDao.queryApplicationdata();
        if (mapList == null || mapList.size() == 0) {
            return result;
        }
        for (Map map : mapList) {
            String applicationName;
            if (!map.containsKey(applicationName = "applicationName")) continue;
            EntranceDto entranceDto = new EntranceDto();
            entranceDto.setLabel(String.valueOf(map.get(applicationName)));
            entranceDto.setValue(String.valueOf(map.get(applicationName)));
            result.add(entranceDto);
        }
        return result;
    }

    public List<EntranceDto> fetchAllEntrance(String appName) {
        ArrayList result = Lists.newArrayList();
        ArrayList linkEdges = Lists.newArrayList();
        Map<String, List<LinkEdge>> group = linkEdges.stream().collect(Collectors.groupingBy(LinkEdge::getApplicationName));
        for (Map.Entry<String, List<LinkEdge>> entry : group.entrySet()) {
            EntranceDto dto = new EntranceDto();
            String applicationName = entry.getKey().toString();
            dto.setLabel(applicationName);
            dto.setValue(applicationName);
            ArrayList children = Lists.newArrayList();
            if (entry.getValue() != null) {
                List<LinkEdge> values = entry.getValue();
                values.stream().forEach(value -> {
                    EntranceDto child = new EntranceDto();
                    String entrance = LinkManage.generateEntrance((LinkEdge)value);
                    child.setLabel(entrance);
                    child.setValue(entrance);
                    children.add(child);
                });
            }
            dto.setChildren((List)children);
            result.add(dto);
        }
        return result;
    }

    public List<EntranceDto> fetchEntrance(String applicationName) {
        List allEntrance = this.fetchAllEntrance(applicationName);
        return allEntrance;
    }

    private Response confirmChange(String id, String newName) {
        if (id == null) {
            return Response.fail((String)FALSE_CORE, (String)"id\u4e0d\u80fd\u4e3a\u7a7a", null);
        }
        LinkManageTable oldTable = this.TLinkManageTableMapper.selectByPrimaryKey(Long.valueOf(Long.parseLong(id)));
        if (oldTable != null) {
            LinkManageTable newTable = new LinkManageTable();
            BeanUtils.copyProperties((Object)oldTable, (Object)newTable);
            newTable.setChangeBefore(newTable.getChangeAfter());
            newTable.setIsChange(Integer.valueOf(0));
            newTable.setChangeType(Integer.valueOf(0));
            newTable.setUpdateTime(new Date());
            newTable.setChangeAfter(null);
            newTable.setChangeRemark(null);
            if (StringUtils.isNotBlank((CharSequence)newName)) {
                newTable.setLinkName(newName);
            }
            try {
                this.TLinkManageTableMapper.updateByPrimaryKey(newTable);
                this.confirmBussinessLinkByTechId(newTable);
                this.modifySceneIschange(id);
                return Response.success();
            }
            catch (Exception e) {
                return Response.fail((String)FALSE_CORE, (String)"\u786e\u8ba4\u53d8\u66f4\u5931\u8d25", null);
            }
        }
        return null;
    }

    private int confirmBussinessLinkByTechId(LinkManageTable techTable) {
        BusinessLinkManageTable businessLinkManageTable = new BusinessLinkManageTable();
        businessLinkManageTable.setEntrace(techTable.getEntrace());
        businessLinkManageTable.setIsDeleted(Integer.valueOf(0));
        businessLinkManageTable.setIsChange(Integer.valueOf(0));
        businessLinkManageTable.setRelatedTechLink(String.valueOf(techTable.getLinkId()));
        return this.TBusinessLinkManageTableMapper.updateByTechId(businessLinkManageTable);
    }

    private void modifySceneIschange(String id) {
        List relatedScenes = this.TSceneLinkRelateMapper.selectSceneIdByTechLinkId(id);
        if (!CollectionUtils.isEmpty((Collection)relatedScenes)) {
            Map<Long, List<SceneAndBusinessLink>> maps = relatedScenes.stream().collect(Collectors.groupingBy(SceneAndBusinessLink::getSceneId));
            ArrayList changeToZeroSceneIdList = new ArrayList();
            ArrayList changToOneSceneIdList = new ArrayList();
            maps.keySet().stream().forEach(key -> {
                List value = (List)maps.get(key);
                List techLinkIds = value.stream().map(SceneAndBusinessLink::getTechId).collect(Collectors.toList());
                int count = this.TLinkManageTableMapper.counItemtByTechLinkIds(techLinkIds);
                if (count > 0) {
                    changToOneSceneIdList.add(key);
                } else {
                    changeToZeroSceneIdList.add(key);
                }
            });
            if (CollectionUtils.isNotEmpty(changToOneSceneIdList)) {
                this.TSceneMapper.updateBySceneIdList(changToOneSceneIdList, Integer.valueOf(1));
            }
            if (CollectionUtils.isNotEmpty(changeToZeroSceneIdList)) {
                this.TSceneMapper.updateBySceneIdList(changeToZeroSceneIdList, Integer.valueOf(0));
            }
        }
    }

    public Response storetechLink(TechLinkVo link) {
        List list;
        int count = this.TLinkManageTableMapper.count(link.getLinkName());
        if (count > 0) {
            return Response.fail((String)FALSE_CORE, (String)"\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0\u6280\u672f\u94fe\u8def", null);
        }
        int entranceNum = this.TLinkManageTableMapper.countByEntrance(link.getEntrance());
        if (entranceNum > 0) {
            return Response.fail((String)FALSE_CORE, (String)"\u540c\u4e00\u4e2a\u5165\u53e3\u53ea\u80fd\u6dfb\u52a0\u4e00\u4e2a\u7cfb\u7edf\u6d41\u7a0b", null);
        }
        LinkManageCreateParam createParam = new LinkManageCreateParam();
        String entrance = link.getEntrance();
        createParam.setEntrace(entrance);
        createParam.setLinkName(link.getLinkName());
        if (StringUtils.isNotBlank((CharSequence)link.getBody()) && CollectionUtils.isNotEmpty((Collection)(list = (List)JSON.parseObject((String)link.getBody(), List.class)))) {
            createParam.setChangeBefore(JSON.toJSONString(list.get(0)));
        }
        createParam.setIsDeleted(Integer.valueOf(0));
        createParam.setIsChange(Integer.valueOf(0));
        createParam.setApplicationName(entrance.substring(0, entrance.indexOf("|")));
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)def);
        try {
            this.linkManageDAO.insert(createParam);
            this.transactionManager.commit(status);
            return Response.success();
        }
        catch (Exception e) {
            this.transactionManager.rollback(status);
            logger.error("\u4fdd\u5b58\u6280\u672f\u94fe\u8def\u5931\u8d25,{}", (Object)e.getMessage());
            return Response.fail((String)FALSE_CORE, (String)"\u4fdd\u5b58\u6280\u672f\u94fe\u8def\u5931\u8d25", null);
        }
    }

    public Response deleteLink(String id) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)def);
        try {
            this.TLinkManageTableMapper.logicDeleteByPrimaryKey(Long.valueOf(Long.parseLong(id)));
            this.TMiddlewareLinkRelateMapper.deleteByTechLinkId(id);
            this.transactionManager.commit(status);
            return Response.success();
        }
        catch (Exception e) {
            this.transactionManager.rollback(status);
            return Response.fail((String)FALSE_CORE, (String)"\u5220\u9664\u94fe\u8def\u5931\u8d25", null);
        }
    }

    @Transactional
    public Response modifyLink(TechLinkVo link) {
        if (link == null || link.getLinkId() == null) {
            throw new RuntimeException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long linkId = Long.parseLong(link.getLinkId());
        String frontEntrance = link.getEntrance();
        try {
            int count;
            LinkManageTable oldTable = this.TLinkManageTableMapper.selectByPrimaryKey(linkId);
            if (!StringUtils.equals((CharSequence)oldTable.getLinkName(), (CharSequence)link.getLinkName()) && (count = this.TLinkManageTableMapper.count(link.getLinkName())) > 0) {
                return Response.fail((String)FALSE_CORE, (String)"\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0\u6280\u672f\u94fe\u8def", null);
            }
            String oldEntrance = oldTable.getEntrace();
            if (StringUtils.equals((CharSequence)oldEntrance, (CharSequence)frontEntrance)) {
                String isChange = String.valueOf(oldTable.getIsChange());
                if ("1".equals(isChange)) {
                    this.confirmChange(String.valueOf(linkId), link.getLinkName());
                } else {
                    List list;
                    String newName = link.getLinkName();
                    LinkManageTable newTable = new LinkManageTable();
                    newTable.setLinkName(newName);
                    newTable.setLinkId(linkId);
                    if (StringUtils.isNotBlank((CharSequence)link.getBody()) && CollectionUtils.isNotEmpty((Collection)(list = (List)JSON.parseObject((String)link.getBody(), List.class)))) {
                        newTable.setChangeBefore(JSON.toJSONString(list.get(0)));
                    }
                    this.TLinkManageTableMapper.updateByPrimaryKeySelective(newTable);
                }
            } else {
                int entranceNum = this.TLinkManageTableMapper.countByEntrance(link.getEntrance());
                if (entranceNum > 0) {
                    return Response.fail((String)FALSE_CORE, (String)"\u540c\u4e00\u4e2a\u5165\u53e3\u53ea\u80fd\u6dfb\u52a0\u4e00\u4e2a\u7cfb\u7edf\u6d41\u7a0b", null);
                }
                this.TMiddlewareLinkRelateMapper.deleteByTechLinkId(String.valueOf(link.getLinkId()));
                TechLinkResponse newSystemProcess = this.fetchLink(null, frontEntrance);
                String newEntrance = newSystemProcess.getEntrance();
                String new_body_before = newSystemProcess.getBody_before();
                String new_body_after = newSystemProcess.getBody_after();
                LinkManageTable newTable = new LinkManageTable();
                newTable.setEntrace(newEntrance);
                newTable.setChangeBefore(new_body_before);
                newTable.setChangeAfter(new_body_after);
                newTable.setLinkId(linkId);
                newTable.setLinkName(link.getLinkName());
                newTable.setIsChange(Integer.valueOf(0));
                newTable.setChangeType(Integer.valueOf(0));
                this.TLinkManageTableMapper.updateByPrimaryKeySelective(newTable);
                int count2 = this.TBusinessLinkManageTableMapper.updateEntranceNameBySystemProcessId(link.getLinkId(), newEntrance);
                this.TSceneLinkRelateMapper.updateEntranceNameBySystemProcessId(link.getLinkId(), newEntrance);
            }
            return Response.success();
        }
        catch (Exception e) {
            return Response.fail((String)"0", (String)e.getMessage(), null);
        }
    }

    public Response<List<SystemProcessViewListDto>> gettechLinksViwList(TechQueryVo vo) {
        ArrayList result = new ArrayList();
        LinkQueryVo queryVo = new LinkQueryVo();
        queryVo.setEntrance(vo.getEntrance());
        queryVo.setIsChange(vo.getIschange());
        queryVo.setMiddleWareName(vo.getMiddleWareName());
        queryVo.setMiddleWareType(vo.getMiddleWareType());
        queryVo.setMiddleWareVersion(vo.getMiddleWareVersion());
        queryVo.setName(vo.getLinkName());
        List queryResult = this.TLinkManageTableMapper.selectTechLinkListBySelective2(queryVo);
        List pageDate = PageUtils.getPage((Boolean)true, (Integer)vo.getCurrentPage(), (Integer)vo.getPageSize(), (List)queryResult);
        List userIds = queryResult.stream().filter(data -> null != data.getUserId()).map(TechLinkDto::getUserId).collect(Collectors.toList());
        Map userMap = this.userService.getUserMapByIds(userIds);
        pageDate.stream().forEach(single -> {
            List allowDeleteUserIdList;
            SystemProcessViewListDto dto = new SystemProcessViewListDto();
            dto.setLinkId(single.getLinkId());
            dto.setCandelete(single.getCandelete());
            dto.setCreateTime(single.getCreateTime());
            dto.setTechLinkName(single.getTechLinkName());
            dto.setIsChange(single.getIsChange());
            dto.setManagerId(single.getUserId());
            String userName = Optional.ofNullable(userMap.get(single.getUserId())).map(u -> u.getName()).orElse("");
            dto.setManagerName(userName);
            List allowUpdateUserIdList = RestContext.getUpdateAllowUserIdList();
            if (CollectionUtils.isNotEmpty((Collection)allowUpdateUserIdList)) {
                dto.setCanEdit(Boolean.valueOf(allowUpdateUserIdList.contains(dto.getManagerId())));
            }
            if (CollectionUtils.isNotEmpty((Collection)(allowDeleteUserIdList = RestContext.getDeleteAllowUserIdList()))) {
                dto.setCanRemove(Boolean.valueOf(allowDeleteUserIdList.contains(dto.getManagerId())));
            }
            List middlewareInfos = this.TMiddlewareInfoMapper.selectBySystemProcessId(single.getLinkId());
            List middleWareNames = middlewareInfos.stream().map(entity -> entity.getMiddlewareName() + " " + entity.getMiddlewareVersion()).collect(Collectors.toList());
            dto.setMiddleWareEntities(middleWareNames);
            String before_body = single.getBody_before();
            if (null != before_body) {
                int count = LinkManage.getSubCount((String)before_body, (String)"serviceName");
                dto.setTechLinkCount(String.valueOf(count));
            }
            dto.setChangeType(single.getChangeType());
            result.add(dto);
        });
        PageInfo data2 = new PageInfo(result);
        data2.setTotal((long)queryResult.size());
        return Response.success((PageInfo)data2);
    }

    public Response addBusinessLink(BusinessLinkVo link) {
        BusinessLinkManageCreateParam createParam = new BusinessLinkManageCreateParam();
        createParam.setLinkName(link.getLinkName());
        createParam.setIsCore(link.getIsCore());
        createParam.setLinkLevel(link.getLink_level());
        createParam.setIsDeleted(Integer.valueOf(0));
        createParam.setBusinessDomain(link.getBusinessDomain());
        Integer repeate = this.TBusinessLinkManageTableMapper.countByBussinessName(link.getLinkName());
        if (repeate != 0) {
            return Response.fail((String)FALSE_CORE, (String)"\u4e1a\u52a1\u6d3b\u52a8\u540d\u79f0\u4e0d\u80fd\u91cd\u590d", null);
        }
        String relatedTechLinkId = link.getRelatedTechLinkId();
        if (relatedTechLinkId == null) {
            Response.fail((String)FALSE_CORE, (String)"\u8bf7\u7ed1\u5b9a\u7cfb\u7edf\u6d41\u7a0b", null);
        }
        createParam.setRelatedTechLink(relatedTechLinkId);
        LinkManageTable systemProcessInfo = this.TLinkManageTableMapper.selectByPrimaryKey(Long.valueOf(Long.parseLong(relatedTechLinkId)));
        if (systemProcessInfo != null) {
            createParam.setEntrace(systemProcessInfo.getEntrace());
            createParam.setIsChange(systemProcessInfo.getIsChange());
        }
        createParam.setCanDelete(Integer.valueOf(0));
        int count = this.businessLinkManageDAO.insert(createParam);
        this.TLinkManageTableMapper.cannotdelete(Long.valueOf(Long.parseLong(relatedTechLinkId)), Long.valueOf(1L));
        return count > 0 ? Response.success() : Response.fail((String)FALSE_CORE, (String)"\u65b0\u589e\u4e1a\u52a1\u94fe\u8def\u5931\u8d25", null);
    }

    public Response modifyBussinessLink(BusinessLinkVo link) {
        Integer repeate;
        BusinessLinkManageTable insertTable = new BusinessLinkManageTable();
        insertTable.setLinkName(link.getLinkName());
        insertTable.setIsCore(link.getIsCore());
        insertTable.setLinkLevel(link.getLink_level());
        insertTable.setBusinessDomain(link.getBusinessDomain());
        insertTable.setIsDeleted(Integer.valueOf(0));
        insertTable.setLinkId(Long.valueOf(Long.parseLong(link.getId())));
        String relatedTechLinkId = link.getRelatedTechLinkId();
        BusinessLinkManageTable oldTable = this.TBusinessLinkManageTableMapper.selectByPrimaryKey(Long.valueOf(Long.parseLong(link.getId())));
        if (!StringUtils.equals((CharSequence)oldTable.getLinkName(), (CharSequence)link.getLinkName()) && (repeate = Integer.valueOf(this.TBusinessLinkManageTableMapper.countByBussinessName(link.getLinkName()))) != 0) {
            return Response.fail((String)FALSE_CORE, (String)"\u4e1a\u52a1\u6d3b\u52a8\u540d\u79f0\u4e0d\u80fd\u91cd\u590d", null);
        }
        if (null != relatedTechLinkId) {
            insertTable.setRelatedTechLink(relatedTechLinkId);
            LinkManageTable systemProcessInfo = this.TLinkManageTableMapper.selectByPrimaryKey(Long.valueOf(Long.parseLong(relatedTechLinkId)));
            if (systemProcessInfo != null) {
                insertTable.setEntrace(systemProcessInfo.getEntrace());
            }
        }
        try {
            this.TBusinessLinkManageTableMapper.updateByPrimaryKeySelective(insertTable);
            return Response.success();
        }
        catch (Exception exception) {
            return Response.fail((String)FALSE_CORE, (String)"\u4fee\u6539\u4e1a\u52a1\u94fe\u8def\u5931\u8d25", null);
        }
    }

    public Response getBussisnessLinks(BusinessQueryVo vo) {
        ArrayList result = Lists.newArrayList();
        LinkQueryVo queryVo = new LinkQueryVo();
        queryVo.setMiddleWareVersion(vo.getVersion());
        queryVo.setMiddleWareName(vo.getMiddleWareName());
        queryVo.setMiddleWareType(vo.getMiddleWareType());
        queryVo.setEntrance(vo.getEntrance());
        queryVo.setName(vo.getBusinessLinkName());
        queryVo.setIsChange(vo.getIschange());
        queryVo.setSystemProcessName(vo.getTechLinkName());
        queryVo.setDomain(vo.getDomain());
        List queryResult = this.TBusinessLinkManageTableMapper.selectBussinessLinkListBySelective2(queryVo);
        List userIds = queryResult.stream().filter(data -> null != data.getUserId()).map(BusinessLinkDto::getUserId).collect(Collectors.toList());
        Map userMap = this.userService.getUserMapByIds(userIds);
        List pageData = PageUtils.getPage((Boolean)true, (Integer)vo.getCurrentPage(), (Integer)vo.getPageSize(), (List)queryResult);
        if (CollectionUtils.isNotEmpty((Collection)pageData) && pageData.size() > 0) {
            pageData.stream().forEach(single -> {
                TechLinkDto techLinkDto;
                List allowDeleteUserIdList;
                BusinessActiveViewListDto dto = new BusinessActiveViewListDto();
                dto.setBusinessActiceId(single.getId());
                dto.setBusinessActiveName(single.getLinkName());
                dto.setCandelete(single.getCandelete());
                dto.setCreateTime(single.getCreateTime());
                dto.setIschange(single.getIschange());
                dto.setManagerId(single.getUserId());
                String userName = Optional.ofNullable(userMap.get(single.getUserId())).map(u -> u.getName()).orElse("");
                dto.setManagerName(userName);
                List allowUpdateUserIdList = RestContext.getUpdateAllowUserIdList();
                if (CollectionUtils.isNotEmpty((Collection)allowUpdateUserIdList)) {
                    dto.setCanEdit(Boolean.valueOf(allowUpdateUserIdList.contains(dto.getManagerId())));
                }
                if (CollectionUtils.isNotEmpty((Collection)(allowDeleteUserIdList = RestContext.getDeleteAllowUserIdList()))) {
                    dto.setCanRemove(Boolean.valueOf(allowDeleteUserIdList.contains(dto.getManagerId())));
                }
                if (StringUtils.isNotBlank((CharSequence)single.getBusinessDomain())) {
                    String desc = DictionaryCache.getObjectByParam((String)"domain", (Integer)Integer.parseInt(single.getBusinessDomain())).getLabel();
                    if (StringUtils.isNotBlank((CharSequence)desc)) {
                        dto.setBusinessDomain(desc);
                    } else {
                        LinkDomainEnum domainEnum = LinkDomainEnumMapping.getByCode((String)single.getBusinessDomain());
                        dto.setBusinessDomain(domainEnum == null ? null : domainEnum.getDesc());
                    }
                }
                if ((techLinkDto = single.getTechLinkDto()) != null) {
                    List middlewareInfos = this.TMiddlewareInfoMapper.selectBySystemProcessId(techLinkDto.getLinkId());
                    List middleWareStrings = middlewareInfos.stream().map(entity -> entity.getMiddlewareName() + " " + entity.getMiddlewareVersion()).collect(Collectors.toList());
                    dto.setMiddleWareList(middleWareStrings);
                    dto.setSystemProcessName(single.getTechLinkDto().getTechLinkName());
                }
                result.add(dto);
            });
        }
        return Response.success((List)result, (long)(CollectionUtils.isEmpty((Collection)queryResult) ? 0L : (long)queryResult.size()));
    }

    private void convertBusinessLinkResponse(BusinessLinkResult businessLinkResult, BusinessLinkResponse businessLinkResponse) {
        businessLinkResponse.setId(businessLinkResult.getId());
        businessLinkResponse.setLinkName(businessLinkResult.getLinkName());
        businessLinkResponse.setEntrance(businessLinkResult.getEntrance());
        businessLinkResponse.setIschange(businessLinkResult.getIschange());
        businessLinkResponse.setCreateTime(businessLinkResult.getCreateTime());
        businessLinkResponse.setUpdateTime(businessLinkResult.getUpdateTime());
        businessLinkResponse.setCandelete(businessLinkResult.getCandelete());
        businessLinkResponse.setIsCore(businessLinkResult.getIsCore());
        businessLinkResponse.setLinkLevel(businessLinkResult.getLinkLevel());
        businessLinkResponse.setBusinessDomain(businessLinkResult.getBusinessDomain());
        TechLinkResponse techLinkResponse = new TechLinkResponse();
        businessLinkResponse.setTechLinkResponse(techLinkResponse);
        TechLinkResult techLinkResult = businessLinkResult.getTechLinkResult();
        techLinkResponse.setLinkId(techLinkResult.getLinkId());
        techLinkResponse.setTechLinkName(techLinkResult.getTechLinkName());
        techLinkResponse.setIsChange(techLinkResult.getIsChange());
        techLinkResponse.setChange_remark(techLinkResult.getChangeRemark());
        techLinkResponse.setBody_before(techLinkResult.getBodyBefore());
        techLinkResponse.setBody_after(techLinkResult.getBodyAfter());
        techLinkResponse.setChangeType(techLinkResult.getChangeType());
    }

    public BusinessLinkResponse getBussisnessLinkDetail(String id) {
        if (null == id) {
            throw new RuntimeException("\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LinkQueryVo queryVo = new LinkQueryVo();
        queryVo.setId(Long.valueOf(Long.parseLong(id)));
        BusinessLinkResult businessLinkResult = this.businessLinkManageDAO.selectBussinessLinkById(Long.valueOf(Long.parseLong(id)));
        if (Objects.nonNull(businessLinkResult)) {
            Long systemProcessId;
            BusinessLinkResponse businessLinkResponse = new BusinessLinkResponse();
            this.convertBusinessLinkResponse(businessLinkResult, businessLinkResponse);
            if (businessLinkResponse.getTechLinkResponse() != null && (systemProcessId = businessLinkResponse.getTechLinkResponse().getLinkId()) != null) {
                LinkManageResult linkManageResult = this.linkManageDAO.selecLinkManageById(businessLinkResult.getTechLinkResult().getLinkId());
                businessLinkResponse.getTechLinkResponse().setMiddleWareResponses(this.getMiddleWareResponses(linkManageResult.getApplicationName()));
                TechLinkResponse techLinkResponse = businessLinkResponse.getTechLinkResponse();
                String linkBody = null;
                linkBody = StringUtils.isNotBlank((CharSequence)techLinkResponse.getBody_after()) ? techLinkResponse.getBody_after() : techLinkResponse.getBody_before();
                if (linkBody != null) {
                    Category category = (Category)JSON.parseObject((String)linkBody, Category.class);
                    CategoryUtils.assembleVo((Category)category);
                    ArrayList<Category> list = new ArrayList<Category>();
                    list.add(category);
                    businessLinkResponse.getTechLinkResponse().setLinkNode(JSON.toJSONString(list));
                }
                TopologicalGraphEntity topologicalGraphEntity = new TopologicalGraphEntity();
                if (StringUtils.isNotBlank((CharSequence)techLinkResponse.getBody_before())) {
                    TopologicalGraphVo topologicalGraphBeforeVo = this.fetchGraph(techLinkResponse.getBody_before());
                    topologicalGraphEntity.setTopologicalGraphBeforeVo(topologicalGraphBeforeVo);
                }
                if (StringUtils.isNotBlank((CharSequence)techLinkResponse.getBody_after())) {
                    TopologicalGraphVo topologicalGraphAfterVo = this.fetchGraph(techLinkResponse.getBody_after());
                    topologicalGraphEntity.setTopologicalGraphAfterVo(topologicalGraphAfterVo);
                }
                businessLinkResponse.getTechLinkResponse().setTopologicalGraphEntity(topologicalGraphEntity);
            }
            return businessLinkResponse;
        }
        return new BusinessLinkResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response deleteScene(String sceneId) {
        if (null == sceneId) {
            return Response.fail((String)FALSE_CORE, (String)"primary key cannot be none.", null);
        }
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)def);
        try {
            this.TSceneMapper.deleteByPrimaryKey(Long.valueOf(Long.parseLong(sceneId)));
            List relates = this.TSceneLinkRelateMapper.selectBySceneId(Long.valueOf(Long.parseLong(sceneId)));
            List businessLinkIds = relates.stream().map(relate -> {
                if (relate.getBusinessLinkId() != null) {
                    return Long.parseLong(relate.getBusinessLinkId());
                }
                return 0L;
            }).collect(Collectors.toList());
            this.TSceneLinkRelateMapper.deleteBySceneId(sceneId);
            this.enableBusinessActiveCanDelte(businessLinkIds);
            this.transactionManager.commit(status);
            Response response = Response.success();
            return response;
        }
        catch (Exception e) {
            this.transactionManager.rollback(status);
            Response response = Response.fail((String)FALSE_CORE, (String)"\u5220\u9664\u573a\u666f\u5931\u8d25", (Object[])new Object[]{e.getMessage()});
            return response;
        }
    }

    private void enableBusinessActiveCanDelte(List<Long> businessLinkIds) {
        if (CollectionUtils.isEmpty(businessLinkIds)) {
            return;
        }
        List candeletedList = businessLinkIds.stream().map(single -> {
            long count = this.TSceneLinkRelateMapper.countByBusinessLinkId(single);
            if (count <= 0L) {
                return single;
            }
            return 0L;
        }).collect(Collectors.toList());
        this.TBusinessLinkManageTableMapper.cannotdelete(candeletedList, Long.valueOf(0L));
    }

    public Response<List<SceneDto>> getScenes(SceneQueryVo vo) {
        List sceneDtos = this.TSceneMapper.selectByRelatedQuery(vo);
        List pageData = PageUtils.getPage((Boolean)true, (Integer)vo.getCurrentPage(), (Integer)vo.getPageSize(), (List)sceneDtos);
        List userIds = sceneDtos.stream().filter(data -> null != data.getManagerId()).map(SceneDto::getManagerId).collect(Collectors.toList());
        Map userMap = this.userService.getUserMapByIds(userIds);
        pageData = pageData.stream().map(single -> {
            List allowDeleteUserIdList;
            int count = this.TSceneLinkRelateMapper.countBySceneId(single.getId());
            single.setTechLinkCount(count);
            single.setBusinessLinkCount(count);
            String userName = Optional.ofNullable(userMap.get(single.getManagerId())).map(u -> u.getName()).orElse("");
            single.setManagerName(userName);
            List allowUpdateUserIdList = RestContext.getUpdateAllowUserIdList();
            if (CollectionUtils.isNotEmpty((Collection)allowUpdateUserIdList)) {
                single.setCanEdit(Boolean.valueOf(allowUpdateUserIdList.contains(single.getManagerId())));
            }
            if (CollectionUtils.isNotEmpty((Collection)(allowDeleteUserIdList = RestContext.getDeleteAllowUserIdList()))) {
                single.setCanRemove(Boolean.valueOf(allowDeleteUserIdList.contains(single.getManagerId())));
            }
            return single;
        }).collect(Collectors.toList());
        return Response.success(pageData, (long)(CollectionUtils.isEmpty((Collection)sceneDtos) ? 0L : (long)sceneDtos.size()));
    }

    public Response getMiddleWareInfo(StatisticsQueryVo vo) {
        try {
            List list = this.TMiddlewareInfoMapper.selectforstatistics(vo);
            List pageData = PageUtils.getPage((Boolean)true, (Integer)vo.getCurrentPage(), (Integer)vo.getPageSize(), (List)list);
            pageData = pageData.stream().map(single -> {
                long id = single.getMiddleWareId();
                List techLinkIds = this.TMiddlewareLinkRelateMapper.selectTechIdsByMiddleWareIds(Long.valueOf(id));
                single.setSystemProcessCount(String.valueOf(techLinkIds.size()));
                if (CollectionUtils.isNotEmpty((Collection)techLinkIds)) {
                    int countBusinessProcess = this.TSceneLinkRelateMapper.countByTechLinkIds(techLinkIds);
                    single.setBussinessProcessCount(String.valueOf(countBusinessProcess));
                }
                return single;
            }).collect(Collectors.toList());
            return Response.success(pageData, (long)(CollectionUtils.isEmpty((Collection)list) ? 0L : (long)list.size()));
        }
        catch (Exception e) {
            return Response.fail((String)"0", (String)e.getMessage(), null);
        }
    }

    public LinkRemarkDto getstatisticsInfo() {
        LinkRemarkDto dto = new LinkRemarkDto();
        long businessProcessCount = this.TSceneMapper.count();
        long businessActiveCount = this.TBusinessLinkManageTableMapper.count();
        long systemProcessCount = this.TLinkManageTableMapper.countTotal();
        long systemChangeCount = this.TLinkManageTableMapper.countChangeNum();
        long onLineApplicationCount = this.TLinkManageTableMapper.countApplication();
        long linkGuardCount = this.TLinkGuardMapper.countGuardNum();
        dto.setBusinessProcessCount(String.valueOf(businessProcessCount));
        dto.setBusinessActiveCount(String.valueOf(businessActiveCount));
        dto.setSystemProcessCount(String.valueOf(systemProcessCount));
        dto.setSystemChangeCount(String.valueOf(systemChangeCount));
        dto.setOnLineApplicationCount(String.valueOf(onLineApplicationCount));
        dto.setLinkGuardCount(String.valueOf(linkGuardCount));
        return dto;
    }

    public Response deletBusinessLink(String id) {
        if (null == id) {
            return Response.fail((String)"0", (String)"\u4e3b\u952e\u4e0d\u53ef\u4ee5\u4e3a\u7a7a", null);
        }
        BusinessLinkManageTable table = this.TBusinessLinkManageTableMapper.selectByPrimaryKey(Long.valueOf(Long.parseLong(id)));
        if (table != null) {
            String techLinkId = table.getRelatedTechLink();
            this.TLinkManageTableMapper.cannotdelete(Long.valueOf(Long.parseLong(techLinkId)), Long.valueOf(0L));
        }
        this.TBusinessLinkManageTableMapper.deleteByPrimaryKey(Long.valueOf(Long.parseLong(id)));
        return Response.success();
    }

    public LinkHistoryInfoDto getChart() {
        LinkHistoryInfoDto dto = new LinkHistoryInfoDto();
        String begin = DateUtils.preYear((Date)new Date());
        String end = new SimpleDateFormat("yyyy-MM").format(new Date());
        List dateRange = DateUtils.getRangeSet2((String)begin, (String)end);
        ArrayList businessCoverList = new ArrayList();
        dateRange.stream().forEach(date -> {
            BusinessCoverDto businessCoverDto = new BusinessCoverDto();
            businessCoverDto.setMonth(DateUtils.dateToString((Date)date));
            long count = this.TSceneMapper.countByTime(date);
            businessCoverDto.setCover(String.valueOf(count));
            businessCoverList.add(businessCoverDto);
        });
        dto.setBusinessCover(businessCoverList);
        ArrayList systemProcessList = Lists.newArrayList();
        dateRange.stream().forEach(date -> {
            SystemProcessDto systemProcessDto = new SystemProcessDto();
            systemProcessDto.setMonth(DateUtils.dateToString((Date)date));
            long count = this.TLinkManageTableMapper.countSystemProcessByTime(date);
            systemProcessDto.setCover(String.valueOf(count));
            systemProcessList.add(systemProcessDto);
        });
        dto.setSystemProcess((List)systemProcessList);
        ArrayList applicationRemoteList = Lists.newArrayList();
        dateRange.stream().forEach(date -> {
            ApplicationRemoteDto applicationRemoteDto = new ApplicationRemoteDto();
            applicationRemoteDto.setMonth(DateUtils.dateToString((Date)date));
            long count = this.TLinkManageTableMapper.countApplicationByTime(date);
            applicationRemoteDto.setCover(String.valueOf(count));
            applicationRemoteList.add(applicationRemoteDto);
        });
        dto.setApplicationRemote((List)applicationRemoteList);
        Long businessFlowTotalCountNum = this.TSceneMapper.count();
        String businessFlowTotalCount = String.valueOf(businessFlowTotalCountNum);
        String businessFlowPressureCount = "0";
        String businessFlowPressureRate = businessFlowTotalCountNum == 0L || "0".equals(businessFlowPressureCount) ? "0" : String.valueOf(businessFlowTotalCountNum / Long.parseLong(businessFlowPressureCount));
        dto.setBusinessFlowTotalCount(businessFlowTotalCount);
        dto.setBusinessFlowPressureCount(businessFlowPressureCount);
        dto.setBusinessFlowPressureRate(businessFlowPressureRate);
        long applicationTotalCountNum = this.TLinkManageTableMapper.countTotal();
        String applicationTotalCount = String.valueOf(applicationTotalCountNum);
        String applicationPressureCount = "0";
        String applicationPressureRate = applicationTotalCountNum == 0L || applicationPressureCount.equals("0") ? "0" : String.valueOf(applicationTotalCountNum / Long.parseLong(applicationPressureCount));
        dto.setApplicationTotalCount(applicationTotalCount);
        dto.setApplicationPressureCount(applicationPressureCount);
        dto.setApplicationPressureRate(applicationPressureRate);
        return dto;
    }

    public List<MiddleWareEntity> businessProcessMiddleWares(List<String> ids) {
        List result = Lists.newArrayList();
        List businessIds = ids.stream().map(id -> Long.parseLong(String.valueOf(id))).collect(Collectors.toList());
        List techIds = this.TBusinessLinkManageTableMapper.selectTechIdsByBusinessIds(businessIds);
        if (CollectionUtils.isEmpty((Collection)techIds)) {
            return result;
        }
        List middleWareIds = this.TMiddlewareLinkRelateMapper.selectMiddleWareIdsByTechIds(techIds);
        if (CollectionUtils.isEmpty((Collection)middleWareIds)) {
            return result;
        }
        List midllewareIdslong = middleWareIds.stream().map(id -> Long.parseLong(id)).collect(Collectors.toList());
        List middleWareEntities = this.TMiddlewareInfoMapper.selectByIds(midllewareIdslong);
        result = middleWareEntities;
        return result;
    }

    public List<MiddleWareEntity> getAllMiddleWareTypeList() {
        ArrayList result = Lists.newArrayList();
        List infos = this.TMiddlewareInfoMapper.selectBySelective(new TMiddlewareInfo());
        infos.stream().forEach(info -> {
            MiddleWareEntity entity = new MiddleWareEntity();
            entity.setId(info.getId());
            entity.setMiddleWareType(info.getMiddlewareType());
            entity.setVersion(info.getMiddlewareVersion());
            entity.setMiddleWareName(info.getMiddlewareName());
            result.add(entity);
        });
        List distinct = result.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<MiddleWareEntity>(Comparator.comparing(MiddleWareEntity::getMiddleWareType))), ArrayList::new));
        return distinct;
    }

    public List<SystemProcessIdAndNameDto> ggetAllSystemProcess(String systemProcessName) {
        ArrayList result = Lists.newArrayList();
        LinkManageQueryParam queryParam = new LinkManageQueryParam();
        queryParam.setUserIdList(RestContext.getQueryAllowUserIdList());
        queryParam.setSystemProcessName(systemProcessName);
        List linkManageResultList = this.linkManageDAO.selectList(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)linkManageResultList)) {
            linkManageResultList.stream().forEach(table -> {
                SystemProcessIdAndNameDto dto = new SystemProcessIdAndNameDto();
                dto.setId(String.valueOf(table.getLinkId()));
                dto.setSystemProcessName(table.getLinkName());
                result.add(dto);
            });
        }
        return result;
    }

    public List<SystemProcessIdAndNameDto> getAllSystemProcessCanrelateBusiness(String systemProcessName) {
        ArrayList result = Lists.newArrayList();
        LinkManageTable serachTable = new LinkManageTable();
        serachTable.setLinkName(systemProcessName);
        serachTable.setCanDelete(Integer.valueOf(0));
        List tables = this.TLinkManageTableMapper.selectBySelective(serachTable);
        if (CollectionUtils.isNotEmpty((Collection)tables)) {
            tables.stream().forEach(table -> {
                SystemProcessIdAndNameDto dto = new SystemProcessIdAndNameDto();
                dto.setId(String.valueOf(table.getLinkId()));
                dto.setSystemProcessName(table.getLinkName());
                result.add(dto);
            });
        }
        return result;
    }

    public List<String> entranceFuzzSerach(String entrance) {
        List entrances = this.TLinkManageTableMapper.entranceFuzzSerach(entrance);
        return entrances;
    }

    public List<BusinessActiveIdAndNameDto> businessActiveNameFuzzSearch(String businessActiveName) {
        List<Object> businessActiveIdAndNameDtoList = Lists.newArrayList();
        BusinessLinkManageQueryParam queryParam = new BusinessLinkManageQueryParam();
        queryParam.setUserIdList(RestContext.getQueryAllowUserIdList());
        queryParam.setBussinessActiveName(businessActiveName);
        List businessLinkResultList = this.businessLinkManageDAO.selectList(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)businessLinkResultList)) {
            businessActiveIdAndNameDtoList = businessLinkResultList.stream().map(businessLinkResult -> {
                BusinessActiveIdAndNameDto bActive = new BusinessActiveIdAndNameDto();
                bActive.setId(businessLinkResult.getId());
                bActive.setBusinessActiveName(businessLinkResult.getLinkName());
                return bActive;
            }).collect(Collectors.toList());
        }
        return businessActiveIdAndNameDtoList;
    }

    public TechLinkDto fetchTechLinkDetail(String id) {
        if (id == null) {
            throw new RuntimeException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LinkQueryVo queryVo = new LinkQueryVo();
        queryVo.setId(Long.valueOf(Long.parseLong(id)));
        TechLinkDto dto = this.TLinkManageTableMapper.selectTechLinkById(Long.valueOf(Long.parseLong(id)));
        if (Objects.nonNull(dto)) {
            String isChange = dto.getIsChange();
            Category current = null;
            String body_before = dto.getBody_before();
            String body_after = dto.getBody_after();
            if ("1".equals(isChange)) {
                if (StringUtils.isNotBlank((CharSequence)body_after)) {
                    current = (Category)JSON.parseObject((String)body_after, Category.class);
                }
            } else {
                current = (Category)JSON.parseObject((String)body_before, Category.class);
                CategoryUtils.assembleVo((Category)current);
            }
            ArrayList<Category> list = new ArrayList<Category>();
            if (current != null) {
                list.add(current);
            }
            if (CollectionUtils.isNotEmpty(list)) {
                dto.setLinkNode(JSON.toJSONString(list));
            } else {
                dto.setLinkNode(JSON.toJSONString((Object)Lists.newArrayList()));
            }
            dto.setMiddleWareEntities((List)Lists.newArrayList());
            return dto;
        }
        return new TechLinkDto();
    }

    public void addBusinessFlow(BusinessFlowVo vo) throws Exception {
        if (CollectionUtils.isEmpty((Collection)vo.getRoot())) {
            throw new RuntimeException("\u5173\u8054\u4e1a\u52a1\u6d3b\u52a8\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long sceneId = this.addScene(vo);
        List relates = this.parsingTree(vo, sceneId);
        if (CollectionUtils.isNotEmpty((Collection)relates)) {
            this.infoCompletion(relates);
            this.TSceneLinkRelateMapper.batchInsert(relates);
            this.diableDeleteBusinessActives(relates);
        }
    }

    private void diableDeleteBusinessActives(List<SceneLinkRelate> relates) {
        List relateBusinessLinkIds = relates.stream().map(single -> {
            if (single.getBusinessLinkId() != null) {
                return Long.parseLong(single.getBusinessLinkId());
            }
            return 0L;
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(relateBusinessLinkIds)) {
            this.TBusinessLinkManageTableMapper.cannotdelete(relateBusinessLinkIds, Long.valueOf(1L));
        }
    }

    public List<BusinessFlowIdAndNameDto> businessFlowIdFuzzSearch(String businessFlowName) {
        List<Object> businessFlowIdAndNameDtoList = Lists.newArrayList();
        SceneQueryParam queryParam = new SceneQueryParam();
        queryParam.setUserIdList(RestContext.getQueryAllowUserIdList());
        queryParam.setSceneName(businessFlowName);
        List sceneResultList = this.sceneDAO.selectList(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)sceneResultList)) {
            businessFlowIdAndNameDtoList = sceneResultList.stream().map(sceneResult -> {
                BusinessFlowIdAndNameDto businessFlowIdAndNameDto = new BusinessFlowIdAndNameDto();
                businessFlowIdAndNameDto.setId(String.valueOf(sceneResult.getId()));
                businessFlowIdAndNameDto.setBusinessFlowName(sceneResult.getSceneName());
                return businessFlowIdAndNameDto;
            }).collect(Collectors.toList());
        }
        return businessFlowIdAndNameDtoList;
    }

    private List<SceneLinkRelate> parsingTree(BusinessFlowVo vo, Long sceneId) throws Exception {
        ArrayList relates = Lists.newArrayList();
        List roots = vo.getRoot();
        for (int i = 0; i < roots.size(); ++i) {
            String parentId = null;
            BusinessFlowTree root = (BusinessFlowTree)roots.get(i);
            String businessId = root.getId();
            if (StringUtils.isBlank((CharSequence)businessId)) continue;
            SceneLinkRelate relate = new SceneLinkRelate();
            relate.setSceneId(String.valueOf(sceneId));
            relate.setParentBusinessLinkId(parentId);
            relate.setBusinessLinkId(businessId);
            relate.setIsDeleted(Integer.valueOf(0));
            relate.setFrontUUIDKey(root.getKey());
            relates.add(relate);
            List children = root.getChildren();
            if (!CollectionUtils.isNotEmpty((Collection)children)) continue;
            this.parsing(children, businessId, sceneId, (List)relates);
        }
        return relates;
    }

    private Long addScene(BusinessFlowVo vo) {
        SceneCreateParam param = new SceneCreateParam();
        param.setSceneName(vo.getSceneName());
        param.setSceneLevel(vo.getSceneLevel());
        param.setIsCore(Integer.valueOf(Integer.parseInt(vo.getIsCore())));
        param.setIsChanged(Integer.valueOf(0));
        param.setIsDeleted(Integer.valueOf(0));
        this.sceneDAO.insert(param);
        return param.getId();
    }

    private void infoCompletion(List<SceneLinkRelate> relates) {
        List businessIds = relates.stream().map(relate -> Long.parseLong(relate.getBusinessLinkId())).collect(Collectors.toList());
        List tables = this.TBusinessLinkManageTableMapper.selectByPrimaryKeys(businessIds);
        Map<Long, List<BusinessLinkManageTable>> map = tables.stream().collect(Collectors.groupingBy(BusinessLinkManageTable::getLinkId));
        relates.stream().forEach(relate -> {
            Long businessLinkId = Long.parseLong(relate.getBusinessLinkId());
            List lists = (List)map.get(businessLinkId);
            if (CollectionUtils.isNotEmpty((Collection)lists)) {
                BusinessLinkManageTable table = (BusinessLinkManageTable)lists.get(0);
                relate.setEntrance(table.getEntrace());
                relate.setTechLinkId(table.getRelatedTechLink());
            }
        });
    }

    private List<SceneLinkRelate> parsing(List<BusinessFlowTree> children, String parentId, Long sceneId, List<SceneLinkRelate> result) {
        for (int i = 0; i < children.size(); ++i) {
            List lowerChildren;
            SceneLinkRelate relate = new SceneLinkRelate();
            BusinessFlowTree child = children.get(i);
            String businessId = child.getId();
            if (StringUtils.isNotBlank((CharSequence)businessId)) {
                relate.setBusinessLinkId(child.getId());
                relate.setParentBusinessLinkId(parentId);
                relate.setIsDeleted(Integer.valueOf(0));
                relate.setFrontUUIDKey(child.getKey());
                relate.setSceneId(String.valueOf(sceneId));
                result.add(relate);
            }
            if (!CollectionUtils.isNotEmpty((Collection)(lowerChildren = children.get(i).getChildren()))) continue;
            this.parsing(lowerChildren, child.getId(), sceneId, result);
        }
        return result;
    }

    public BusinessFlowDto getBusinessFlowDetail(String id) {
        BusinessFlowDto dto = new BusinessFlowDto();
        Scene scene = this.TSceneMapper.selectByPrimaryKey(Long.valueOf(Long.parseLong(id)));
        dto.setId(String.valueOf(scene.getId()));
        dto.setIsCode(String.valueOf(scene.getIsCore()));
        dto.setLevel(scene.getSceneLevel());
        dto.setBusinessProcessName(scene.getSceneName());
        List relates = this.TSceneLinkRelateMapper.selectBySceneId(Long.valueOf(Long.parseLong(id)));
        List existBusinessActiveIds = relates.stream().map(relate -> {
            ExistBusinessActiveDto single = new ExistBusinessActiveDto();
            single.setKey(relate.getFrontUUIDKey());
            single.setId(relate.getBusinessLinkId());
            return single;
        }).collect(Collectors.toList());
        dto.setExistBusinessActive(existBusinessActiveIds);
        List roots = this.TSceneLinkRelateMapper.findAllRecursion(id);
        dto.setRoots(roots);
        List techLinkIds = relates.stream().map(relate -> relate.getTechLinkId()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(techLinkIds)) {
            List middleWareIdStrings = this.TMiddlewareLinkRelateMapper.selectMiddleWareIdsByTechIds(techLinkIds);
            List middleWareIds = middleWareIdStrings.stream().map(single -> Long.parseLong(single)).collect(Collectors.toList());
            List middleWareEntityList = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty(middleWareIds)) {
                middleWareEntityList = this.TMiddlewareInfoMapper.selectByIds(middleWareIds);
            }
            dto.setMiddleWareEntities(middleWareEntityList);
        }
        return dto;
    }

    public void modifyBusinessFlow(BusinessFlowVo vo) throws Exception {
        if (CollectionUtils.isEmpty((Collection)vo.getRoot())) {
            throw new RuntimeException("\u5173\u8054\u4e1a\u52a1\u6d3b\u52a8\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.recordBusinessFlowLog(vo);
        this.modifyScene(vo);
        this.enableBusinessDelete(vo);
        this.TSceneLinkRelateMapper.deleteBySceneId(vo.getId());
        List relates = this.parsingTree(vo, Long.valueOf(Long.parseLong(vo.getId())));
        if (CollectionUtils.isNotEmpty((Collection)relates)) {
            this.infoCompletion(relates);
            this.TSceneLinkRelateMapper.batchInsert(relates);
        }
        this.diableDeleteBusinessActives(relates);
    }

    private void recordBusinessFlowLog(BusinessFlowVo vo) throws Exception {
        List businessLinkManageTableList;
        Scene oldScene = this.TSceneMapper.selectByPrimaryKey(Long.valueOf(Long.parseLong(vo.getId())));
        OperationLogContextHolder.addVars((String)"businessProcess", (String)vo.getSceneName());
        List oldSceneLinkRelateList = this.TSceneLinkRelateMapper.selectBySceneId(Long.valueOf(Long.parseLong(vo.getId())));
        List oldBusinessLinkIdList = oldSceneLinkRelateList.stream().map(SceneLinkRelate::getBusinessLinkId).map(Long::parseLong).collect(Collectors.toList());
        List currentSceneLinkRelateList = this.parsingTree(vo, Long.valueOf(Long.parseLong(vo.getId())));
        List currentBusinessLinkIdList = currentSceneLinkRelateList.stream().map(SceneLinkRelate::getBusinessLinkId).map(Long::parseLong).collect(Collectors.toList());
        ArrayList toDeleteIdList = Lists.newArrayList();
        toDeleteIdList.addAll(oldBusinessLinkIdList);
        toDeleteIdList.removeAll(currentBusinessLinkIdList);
        ArrayList toAddIdList = Lists.newArrayList();
        toAddIdList.addAll(currentBusinessLinkIdList);
        toAddIdList.removeAll(oldBusinessLinkIdList);
        String selectiveContent = "";
        if (oldScene.getSceneName().equals(vo.getSceneName()) && CollectionUtils.isEmpty((Collection)toAddIdList) && CollectionUtils.isEmpty((Collection)toDeleteIdList)) {
            OperationLogContextHolder.ignoreLog();
        }
        if (CollectionUtils.isNotEmpty((Collection)toAddIdList) && CollectionUtils.isNotEmpty((Collection)(businessLinkManageTableList = this.TBusinessLinkManageTableMapper.selectBussinessLinkByIdList((List)toAddIdList)))) {
            String addNodeNames = businessLinkManageTableList.stream().map(BusinessLinkManageTable::getLinkName).collect(Collectors.joining(","));
            selectiveContent = selectiveContent + "\uff5c\u65b0\u589e\u8282\u70b9\uff1a" + addNodeNames;
        }
        if (CollectionUtils.isNotEmpty((Collection)toDeleteIdList) && CollectionUtils.isNotEmpty((Collection)(businessLinkManageTableList = this.TBusinessLinkManageTableMapper.selectBussinessLinkByIdList((List)toDeleteIdList)))) {
            String deleteNodeNames = businessLinkManageTableList.stream().map(BusinessLinkManageTable::getLinkName).collect(Collectors.joining(","));
            selectiveContent = selectiveContent + "\uff5c\u5220\u9664\u8282\u70b9\uff1a" + deleteNodeNames;
        }
        OperationLogContextHolder.addVars((String)"selectiveContent", (String)selectiveContent);
    }

    private void enableBusinessDelete(BusinessFlowVo vo) {
        if (vo.getId() == null) {
            return;
        }
        List oldRelates = this.TSceneLinkRelateMapper.selectBySceneId(Long.valueOf(Long.parseLong(vo.getId())));
        if (CollectionUtils.isEmpty((Collection)oldRelates)) {
            return;
        }
        List candeleteList = oldRelates.stream().map(single -> {
            if (single.getBusinessLinkId() == null) {
                return 0L;
            }
            return Long.parseLong(single.getBusinessLinkId());
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(candeleteList)) {
            return;
        }
        this.TBusinessLinkManageTableMapper.cannotdelete(candeleteList, Long.valueOf(0L));
    }

    private void modifyScene(BusinessFlowVo vo) {
        String sceneId = vo.getId();
        String sceneName = vo.getSceneName();
        String isCore = vo.getIsCore();
        String sceneLevel = vo.getSceneLevel();
        Scene updateScene = new Scene();
        updateScene.setId(Long.valueOf(Long.parseLong(sceneId)));
        updateScene.setSceneName(sceneName);
        updateScene.setIsCore(Integer.valueOf(Integer.parseInt(isCore)));
        updateScene.setSceneLevel(sceneLevel);
        this.TSceneMapper.updateByPrimaryKeySelective(updateScene);
    }

    public List<MiddleWareNameDto> cascadeMiddleWareNameAndVersion(String middleWareType) throws Exception {
        List infos;
        ArrayList result = Lists.newArrayList();
        TMiddlewareInfo info = new TMiddlewareInfo();
        if (StringUtils.isNotBlank((CharSequence)middleWareType)) {
            info.setMiddlewareType(middleWareType);
        }
        if (CollectionUtils.isNotEmpty((Collection)(infos = this.TMiddlewareInfoMapper.selectBySelective(info)))) {
            Map<String, List<TMiddlewareInfo>> groupByMiddleWareName = infos.stream().collect(Collectors.groupingBy(TMiddlewareInfo::getMiddlewareName));
            for (Map.Entry<String, List<TMiddlewareInfo>> entry : groupByMiddleWareName.entrySet()) {
                MiddleWareNameDto dto = new MiddleWareNameDto();
                String middleWareName = entry.getKey();
                dto.setLabel(middleWareName);
                dto.setValue(middleWareName);
                List<TMiddlewareInfo> values = entry.getValue();
                if (CollectionUtils.isNotEmpty(values)) {
                    List children = values.stream().map(single -> {
                        MiddleWareVersionDto versionDto = new MiddleWareVersionDto();
                        String version = single.getMiddlewareVersion();
                        versionDto.setLabel(version);
                        versionDto.setValue(version);
                        return versionDto;
                    }).collect(Collectors.toList());
                    dto.setChildren(children);
                }
                result.add(dto);
            }
        }
        return result;
    }

    public List<MiddleWareNameDto> getDistinctMiddleWareName() {
        ArrayList result = Lists.newArrayList();
        List infos = this.TMiddlewareInfoMapper.selectBySelective(new TMiddlewareInfo());
        infos.stream().forEach(single -> {
            MiddleWareNameDto entity = new MiddleWareNameDto();
            entity.setValue(single.getMiddlewareName());
            entity.setLabel(single.getMiddlewareName());
            result.add(entity);
        });
        List distinct = result.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<MiddleWareNameDto>(Comparator.comparing(MiddleWareNameDto::getLabel))), ArrayList::new));
        return distinct;
    }

    public List<EntranceSimpleDto> getEntranceByAppName(String applicationName) {
        return null;
    }

    public List<MiddleWareResponse> getMiddleWareResponses(String applicationName) {
        ArrayList middleWareResponses = Lists.newArrayList();
        List supportList = this.agentPluginSupportService.queryAgentPluginSupportList();
        List applicationResultList = this.applicationDAO.getApplicationByName(Arrays.asList(applicationName));
        if (CollectionUtils.isEmpty((Collection)applicationResultList)) {
            return middleWareResponses;
        }
        LibraryResult[] libraryResults = ((ApplicationResult)applicationResultList.get(0)).getLibrary();
        if (null == libraryResults || libraryResults.length == 0) {
            return middleWareResponses;
        }
        for (LibraryResult libraryResult : libraryResults) {
            MiddleWareResponse middleWareResponse = this.agentPluginSupportService.convertLibInfo(supportList, libraryResult.getLibraryName());
            if (Objects.isNull(middleWareResponse)) continue;
            middleWareResponses.add(middleWareResponse);
        }
        middleWareResponses.sort((a, b) -> {
            if (a.getStatusResponse().getValue() > b.getStatusResponse().getValue()) {
                return 1;
            }
            if (a.getStatusResponse().getValue() < b.getStatusResponse().getValue()) {
                return -1;
            }
            return 0;
        });
        return middleWareResponses;
    }

    public List<BusinessActivityNameResponse> getBusinessActiveByFlowId(Long businessFlowId) {
        List<Object> sceneBusinessActivityRefVOS = new ArrayList<BusinessActivityNameResponse>();
        List sceneLinkRelates = this.tSceneLinkRelateMapper.selectBySceneId(businessFlowId);
        if (CollectionUtils.isNotEmpty((Collection)sceneLinkRelates)) {
            List businessActivityIds = sceneLinkRelates.stream().map(o -> Long.valueOf(o.getBusinessLinkId())).collect(Collectors.toList());
            List businessLinkManageTables = this.TBusinessLinkManageTableMapper.selectBussinessLinkByIdList(businessActivityIds);
            sceneBusinessActivityRefVOS = businessLinkManageTables.stream().map(businessLinkManageTable -> {
                BusinessActivityNameResponse businessActivityNameResponse = new BusinessActivityNameResponse();
                businessActivityNameResponse.setBusinessActivityId(businessLinkManageTable.getLinkId());
                businessActivityNameResponse.setBusinessActivityName(businessLinkManageTable.getLinkName());
                return businessActivityNameResponse;
            }).collect(Collectors.toList());
        }
        return sceneBusinessActivityRefVOS;
    }

    public List<ApplicationDetailResponse> getApplicationDetailsByAppName(String applicationName, String entrance, String linkApplicationName) throws Exception {
        return null;
    }
}

