/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.linkManage;

import com.pamirs.tro.common.constant.AppAccessTypeEnum;
import com.pamirs.tro.entity.dao.confcenter.TApplicationMntDao;
import com.pamirs.tro.entity.dao.linkguard.TLinkGuardMapper;
import com.pamirs.tro.entity.dao.user.TUserMapper;
import com.pamirs.tro.entity.domain.entity.LinkGuardEntity;
import com.pamirs.tro.entity.domain.entity.TApplicationMnt;
import com.pamirs.tro.entity.domain.entity.user.User;
import com.pamirs.tro.entity.domain.query.LinkGuardQueryParam;
import com.pamirs.tro.entity.domain.vo.guardmanage.LinkGuardVo;
import io.shulie.tro.web.app.cache.AgentConfigCacheManager;
import io.shulie.tro.web.app.common.Response;
import io.shulie.tro.web.app.common.RestContext;
import io.shulie.tro.web.app.init.sync.ConfigSyncService;
import io.shulie.tro.web.app.service.ApplicationService;
import io.shulie.tro.web.app.service.auth.TroAuthService;
import io.shulie.tro.web.app.service.linkManage.LinkGuardService;
import io.shulie.tro.web.app.utils.PageUtils;
import io.shulie.tro.web.data.dao.application.ApplicationDAO;
import io.shulie.tro.web.data.dao.application.LinkGuardDAO;
import io.shulie.tro.web.data.param.application.LinkGuardCreateParam;
import io.shulie.tro.web.data.result.application.ApplicationDetailResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LinkGuardServiceImpl
implements LinkGuardService {
    private static final Logger log = LoggerFactory.getLogger(LinkGuardServiceImpl.class);
    private static String FALSE_CORE = "0";
    @Resource
    private TLinkGuardMapper tLinkGuardMapper;
    @Autowired
    private ApplicationService applicationService;
    @Resource
    private TUserMapper TUserMapper;
    @Resource
    private TApplicationMntDao applicationMntDao;
    @Autowired
    private TroAuthService troAuthService;
    @Autowired
    private ConfigSyncService configSyncService;
    @Autowired
    private LinkGuardDAO linkGuardDAO;
    @Autowired
    private AgentConfigCacheManager agentConfigCacheManager;
    @Autowired
    private ApplicationDAO applicationDAO;

    public Response addGuard(LinkGuardVo vo) {
        List dbList;
        Long applicationId;
        if (StringUtils.isBlank((CharSequence)vo.getApplicationId())) {
            LinkGuardEntity linkGuardEntity = this.tLinkGuardMapper.selectById(vo.getId());
            applicationId = linkGuardEntity.getApplicationId();
        } else {
            applicationId = Long.parseLong(vo.getApplicationId());
        }
        if (StringUtils.isBlank((CharSequence)vo.getApplicationName()) || StringUtils.isBlank((CharSequence)vo.getMethodInfo())) {
            return Response.fail((String)FALSE_CORE, (String)"applicationName\u548cmethodInfo\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        if (!vo.getMethodInfo().contains("#")) {
            return Response.fail((String)FALSE_CORE, (String)"\u7c7b\u540d\u65b9\u6cd5\u540d\u7528'#'\u5206\u5272\uff0c\u5982Aa#bb", (Object[])new Object[0]);
        }
        LinkGuardQueryParam param = new LinkGuardQueryParam();
        param.setMethodInfo(vo.getMethodInfo());
        if (vo.getApplicationId() != null && !vo.getApplicationId().isEmpty()) {
            param.setAppId(Long.valueOf(vo.getApplicationId()));
        }
        if ((dbList = this.tLinkGuardMapper.selectByExample(param)) != null && dbList.size() > 0) {
            return Response.fail((String)FALSE_CORE, (String)"\u540c\u4e00\u4e2amethodInfo\u53ea\u80fd\u8bbe\u7f6e\u4e00\u4e2a\u6321\u677f", (Object[])new Object[0]);
        }
        LinkGuardCreateParam createParam = new LinkGuardCreateParam();
        createParam.setIsEnable(vo.getIsEnable());
        createParam.setApplicationName(vo.getApplicationName());
        createParam.setMethodInfo(vo.getMethodInfo());
        createParam.setGroovy(vo.getGroovy());
        createParam.setApplicationId(Long.valueOf(vo.getApplicationId()));
        createParam.setRemark(vo.getRemark());
        ApplicationDetailResult applicationDetailResult = this.applicationDAO.getApplicationById(applicationId);
        createParam.setCustomerId(applicationDetailResult.getCustomerId());
        createParam.setUserId(applicationDetailResult.getUserId());
        try {
            this.linkGuardDAO.insert2(createParam);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Response.fail((String)FALSE_CORE, (String)"\u521b\u5efa\u6321\u677f\u5931\u8d25", (Object[])new Object[0]);
        }
        this.applicationService.modifyAccessStatus(vo.getApplicationId(), AppAccessTypeEnum.UNUPLOAD.getValue(), null);
        User user = RestContext.getUser();
        this.configSyncService.syncGuard(user.getKey(), Long.parseLong(vo.getApplicationId()), vo.getApplicationName());
        this.agentConfigCacheManager.evictGuards(vo.getApplicationName());
        return Response.success();
    }

    public Response updateGuard(LinkGuardVo vo) {
        String applicationId;
        if (vo.getId() == null) {
            return Response.fail((String)FALSE_CORE, (String)"\u66f4\u65b0\u6321\u677fid\u4e0d\u80fd\u4e3anull", null);
        }
        if (StringUtils.isBlank((CharSequence)vo.getApplicationId())) {
            LinkGuardEntity linkGuardEntity = this.tLinkGuardMapper.selectById(vo.getId());
            applicationId = String.valueOf(linkGuardEntity.getApplicationId());
        } else {
            applicationId = vo.getApplicationId();
        }
        LinkGuardEntity entity = new LinkGuardEntity();
        entity.setId(vo.getId());
        entity.setApplicationName(vo.getApplicationName());
        entity.setMethodInfo(vo.getMethodInfo());
        entity.setGroovy(vo.getGroovy());
        entity.setIsEnable(vo.getIsEnable());
        entity.setRemark(vo.getRemark());
        try {
            this.tLinkGuardMapper.update(entity);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Response.fail((String)FALSE_CORE, (String)"\u66f4\u65b0\u6321\u677f\u5931\u8d25", null);
        }
        User user = RestContext.getUser();
        this.configSyncService.syncGuard(user.getKey(), Long.parseLong(applicationId), vo.getApplicationName());
        this.agentConfigCacheManager.evictGuards(vo.getApplicationName());
        return Response.success();
    }

    public Response deleteById(Long id) {
        try {
            LinkGuardEntity linkGuardEntity = this.tLinkGuardMapper.selectById(id);
            this.tLinkGuardMapper.deleteById(id);
            User user = RestContext.getUser();
            this.configSyncService.syncGuard(user.getKey(), linkGuardEntity.getApplicationId().longValue(), null);
            this.agentConfigCacheManager.evictGuards(linkGuardEntity.getApplicationName());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Response.fail((String)FALSE_CORE, (String)"\u5220\u9664\u6321\u677f\u5931\u8d25", null);
        }
        return Response.success();
    }

    public Response<List<LinkGuardVo>> selectByExample(LinkGuardQueryParam param) {
        ArrayList result = new ArrayList();
        List page = new ArrayList();
        List list = null;
        if (param != null && StringUtils.isNotBlank((CharSequence)param.getApplicationId())) {
            param.setAppId(Long.valueOf(param.getApplicationId()));
        }
        try {
            if (RestContext.getTenantUserKey() != null && !RestContext.getTenantUserKey().isEmpty() && param.getApplicationName() != null) {
                String userAppKey = RestContext.getTenantUserKey();
                User user = this.TUserMapper.selectByKey(userAppKey);
                TApplicationMnt applicationMnt = this.applicationMntDao.queryApplicationInfoByNameAndTenant(param.getApplicationName(), user == null ? null : user.getId());
                if (applicationMnt != null) {
                    param.setAppId(Long.valueOf(applicationMnt.getApplicationId()));
                }
            }
            if (null != (list = this.tLinkGuardMapper.selectByExample(param)) && list.size() > 0) {
                page = param.getCurrentPage() == null || param.getPageSize() == null ? list : PageUtils.getPage((Boolean)true, (Integer)param.getCurrentPage(), (Integer)param.getPageSize(), (List)list);
                page.stream().forEach(guardEntity -> result.add(this.entityToVo(guardEntity)));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Response.fail((String)FALSE_CORE, (String)"\u67e5\u8be2\u6321\u677f\u5931\u8d25", null);
        }
        return Response.success(result, (long)(CollectionUtils.isEmpty((Collection)list) ? 0L : (long)list.size()));
    }

    public List<LinkGuardVo> agentSelect(Long customerId, String appName) {
        List results = this.linkGuardDAO.selectByAppNameUnderCurrentUser(appName, customerId);
        return results.stream().map(item -> {
            LinkGuardVo target = new LinkGuardVo();
            BeanUtils.copyProperties((Object)item, (Object)target);
            return target;
        }).collect(Collectors.toList());
    }

    public Response<List<LinkGuardEntity>> selectAll() {
        List list = null;
        try {
            LinkGuardQueryParam param = new LinkGuardQueryParam();
            param.setIsEnable(Boolean.valueOf(true));
            list = this.tLinkGuardMapper.selectByExample(param);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Response.fail((String)FALSE_CORE, (String)"\u67e5\u8be2\u6321\u677f\u5931\u8d25", null);
        }
        return Response.success((Object)list);
    }

    public Response getById(Long id) {
        LinkGuardEntity guardEntity = this.tLinkGuardMapper.selectById(id);
        LinkGuardVo vo = this.entityToVo(guardEntity);
        return Response.success((Object)vo);
    }

    public Response enableGuard(Long id, Boolean target) {
        if (id == null || target == null) {
            return Response.fail((String)FALSE_CORE, (String)"\u6321\u677f\u5f00\u5173", null);
        }
        LinkGuardEntity linkGuardEntity = this.tLinkGuardMapper.selectById(id);
        LinkGuardEntity entity = new LinkGuardEntity();
        entity.setId(id);
        entity.setIsEnable(target);
        this.tLinkGuardMapper.update(entity);
        User user = RestContext.getUser();
        this.configSyncService.syncGuard(user.getKey(), linkGuardEntity.getApplicationId().longValue(), null);
        this.agentConfigCacheManager.evictGuards(linkGuardEntity.getApplicationName());
        return Response.success();
    }

    public List<LinkGuardEntity> getAllEnabledGuard(String applicationId) {
        return this.tLinkGuardMapper.getAllEnabledGuard(applicationId);
    }

    public LinkGuardVo entityToVo(LinkGuardEntity guardEntity) {
        List allowEnableDisableUserIdList;
        List allowDeleteUserIdList;
        if (guardEntity == null) {
            return null;
        }
        LinkGuardVo vo = new LinkGuardVo();
        vo.setId(guardEntity.getId());
        vo.setApplicationName(guardEntity.getApplicationName());
        vo.setMethodInfo(guardEntity.getMethodInfo());
        vo.setGroovy(guardEntity.getGroovy());
        vo.setCreateTime(guardEntity.getCreateTime());
        vo.setUpdateTime(guardEntity.getUpdateTime());
        vo.setRemark(guardEntity.getRemark());
        vo.setIsEnable(guardEntity.getIsEnable());
        List allowUpdateUserIdList = RestContext.getUpdateAllowUserIdList();
        if (CollectionUtils.isNotEmpty((Collection)allowUpdateUserIdList)) {
            vo.setCanEdit(Boolean.valueOf(allowUpdateUserIdList.contains(guardEntity.getUserId())));
        }
        if (CollectionUtils.isNotEmpty((Collection)(allowDeleteUserIdList = RestContext.getDeleteAllowUserIdList()))) {
            vo.setCanRemove(Boolean.valueOf(allowDeleteUserIdList.contains(guardEntity.getUserId())));
        }
        if (CollectionUtils.isNotEmpty((Collection)(allowEnableDisableUserIdList = RestContext.getEnableDisableAllowUserIdList()))) {
            vo.setCanEnableDisable(Boolean.valueOf(allowEnableDisableUserIdList.contains(guardEntity.getUserId())));
        }
        return vo;
    }
}

