/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.linkManage;

import com.google.common.collect.Lists;
import com.pamirs.tro.entity.dao.apimanage.TApplicationApiManageMapper;
import com.pamirs.tro.entity.domain.dto.linkmanage.mapping.EnumResult;
import com.pamirs.tro.entity.domain.entity.ApplicationApiManage;
import com.pamirs.tro.entity.domain.vo.entracemanage.ApiCreateVo;
import com.pamirs.tro.entity.domain.vo.entracemanage.ApiUpdateVo;
import com.pamirs.tro.entity.domain.vo.entracemanage.EntranceApiVo;
import io.shulie.tro.web.app.annotation.AuthVerification;
import io.shulie.tro.web.app.common.Response;
import io.shulie.tro.web.app.common.RestContext;
import io.shulie.tro.web.app.context.OperationLogContextHolder;
import io.shulie.tro.web.app.controller.linkmanage.DictionaryCache;
import io.shulie.tro.web.app.service.linkManage.ApplicationApiService;
import io.shulie.tro.web.app.utils.PageUtils;
import io.shulie.tro.web.auth.api.enums.ActionTypeEnum;
import io.shulie.tro.web.common.vo.application.ApplicationApiManageVO;
import io.shulie.tro.web.data.dao.application.ApplicationApiDAO;
import io.shulie.tro.web.data.dao.application.ApplicationDAO;
import io.shulie.tro.web.data.param.application.ApplicationApiCreateParam;
import io.shulie.tro.web.data.result.application.ApplicationDetailResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApplicationApiServiveImpl
implements ApplicationApiService {
    private static final String EMPTY = " ";
    private static final String HTTP_METHOD_TYPE = "HTTP_METHOD_TYPE";
    @Resource
    private TApplicationApiManageMapper manageMapper;
    @Autowired
    private ApplicationApiDAO applicationApiDAO;
    @Autowired
    private ApplicationDAO applicationDAO;

    public Response registerApi(Map<String, List<String>> register) {
        ArrayList batch = Lists.newArrayList();
        try {
            for (Map.Entry<String, List<String>> entry : register.entrySet()) {
                String appName = String.valueOf(entry.getKey());
                List<String> apis = entry.getValue();
                if (StringUtils.isBlank((CharSequence)appName) || CollectionUtils.isEmpty(apis)) continue;
                ApplicationDetailResult applicationDetailResult = this.applicationDAO.getApplicationByCustomerIdAndName(RestContext.getCustomerId(), appName);
                apis.stream().forEach(api -> {
                    String[] str = api.split("#");
                    String requestMethod = str[1];
                    requestMethod = "[]".equals(requestMethod) ? EMPTY : requestMethod.substring(1, requestMethod.length() - 1);
                    api = str[0];
                    if (api.contains("||")) {
                        String[] splits;
                        for (String split : splits = api.split("\\|\\|")) {
                            ApplicationApiManage manage = new ApplicationApiManage();
                            manage.setApi(split.trim());
                            manage.setApplicationName(appName);
                            manage.setIsDeleted(Byte.valueOf((byte)0));
                            manage.setCreateTime(new Date());
                            manage.setUpdateTime(new Date());
                            manage.setRequestMethod(requestMethod);
                            manage.setApplicationId(applicationDetailResult.getApplicationId());
                            manage.setCustomerId(applicationDetailResult.getCustomerId());
                            manage.setUserId(applicationDetailResult.getUserId());
                            manage.setIsAgentRegiste(Integer.valueOf(1));
                            batch.add(manage);
                        }
                    } else {
                        ApplicationApiManage manage = new ApplicationApiManage();
                        manage.setApi(api.trim());
                        manage.setApplicationName(appName);
                        manage.setIsDeleted(Byte.valueOf((byte)0));
                        manage.setCreateTime(new Date());
                        manage.setRequestMethod(requestMethod);
                        manage.setUpdateTime(new Date());
                        manage.setApplicationId(applicationDetailResult.getApplicationId());
                        manage.setCustomerId(applicationDetailResult.getCustomerId());
                        manage.setUserId(applicationDetailResult.getUserId());
                        manage.setIsAgentRegiste(Integer.valueOf(1));
                        batch.add(manage);
                    }
                });
                this.manageMapper.deleteByAppName(appName);
                this.manageMapper.insertBatch((List)batch);
            }
        }
        catch (Exception e) {
            batch.stream().forEach(single -> {
                try {
                    ApplicationApiManage manage = new ApplicationApiManage();
                    manage.setRequestMethod(single.getRequestMethod());
                    manage.setApi(single.getApi());
                    manage.setApplicationName(single.getApplicationName());
                    manage.setIsDeleted(single.getIsDeleted());
                    manage.setUpdateTime(single.getUpdateTime());
                    manage.setCreateTime(single.getCreateTime());
                    manage.setApplicationId(single.getApplicationId());
                    manage.setCustomerId(single.getCustomerId());
                    manage.setUserId(single.getUserId());
                    manage.setIsAgentRegiste(single.getIsAgentRegiste());
                    this.manageMapper.insertSelective(manage);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        return Response.success();
    }

    public Response pullApi(String appName) {
        List all = this.manageMapper.querySimple(appName);
        if (CollectionUtils.isEmpty((Collection)all)) {
            return Response.success(new HashMap());
        }
        HashMap<String, List> res = new HashMap<String, List>();
        for (ApplicationApiManage applicationApiManage : all) {
            res.computeIfAbsent(applicationApiManage.getApplicationName(), k -> new ArrayList()).add(applicationApiManage.getApi() + "#" + applicationApiManage.getRequestMethod());
        }
        return Response.success(res);
    }

    public Response delete(String id) {
        this.manageMapper.deleteByPrimaryKey(Long.valueOf(Long.parseLong(id)));
        return Response.success();
    }

    @AuthVerification(moduleCode="configCenter_entryRule", needAuth=ActionTypeEnum.QUERY)
    public Response query(EntranceApiVo vo) {
        ApplicationApiManage manage = new ApplicationApiManage();
        manage.setApplicationName(vo.getApplicationName());
        manage.setApi(vo.getApi());
        List reocords = this.manageMapper.selectBySelective(manage);
        reocords.sort(Comparator.comparing(ApplicationApiManage::getCreateTime).reversed());
        List pageData = PageUtils.getPage((Boolean)true, (Integer)vo.getCurrentPage(), (Integer)vo.getPageSize(), (List)reocords);
        ArrayList dtos = new ArrayList();
        pageData.stream().forEach(data -> {
            List allowDeleteUserIdList;
            ApplicationApiManageVO dto = new ApplicationApiManageVO();
            BeanUtils.copyProperties((Object)data, (Object)dto);
            List allowUpdateUserIdList = RestContext.getUpdateAllowUserIdList();
            if (CollectionUtils.isNotEmpty((Collection)allowUpdateUserIdList)) {
                dto.setCanEdit(Boolean.valueOf(allowUpdateUserIdList.contains(data.getUserId())));
            }
            if (CollectionUtils.isNotEmpty((Collection)(allowDeleteUserIdList = RestContext.getDeleteAllowUserIdList()))) {
                dto.setCanRemove(Boolean.valueOf(allowDeleteUserIdList.contains(data.getUserId())));
            }
            dtos.add(dto);
        });
        return Response.success(dtos, (long)reocords.size());
    }

    public Response update(ApiUpdateVo vo) {
        if (Objects.isNull(vo.getId())) {
            return Response.fail((String)"0", (String)"\u4e3b\u952e\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        ApplicationApiManage applicationApiManage = this.manageMapper.selectByPrimaryKey(Long.valueOf(Long.parseLong(vo.getId())));
        if (null == applicationApiManage) {
            return Response.fail((String)"0", (String)"\u8be5\u89c4\u5219\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        }
        String applicationName = Optional.ofNullable(vo.getApplicationName()).orElse(applicationApiManage.getApplicationName());
        if (StringUtils.isNotBlank((CharSequence)vo.getApi()) && !vo.getApi().equals(applicationApiManage.getApi())) {
            OperationLogContextHolder.addVars((String)"applicationName", (String)(applicationName + "\uff0c\u5165\u53e3\u5730\u5740\uff1a" + vo.getApi()));
        } else {
            OperationLogContextHolder.addVars((String)"applicationName", (String)applicationName);
        }
        ApplicationApiManage manage = new ApplicationApiManage();
        manage.setId(Long.valueOf(Long.parseLong(vo.getId())));
        manage.setApplicationName(vo.getApplicationName());
        manage.setApi(vo.getApi());
        manage.setRequestMethod(DictionaryCache.getObjectByParam((String)HTTP_METHOD_TYPE, (Integer)Integer.parseInt(vo.getMethod())).getLabel());
        manage.setUpdateTime(new Date());
        this.manageMapper.updateByPrimaryKeySelective(manage);
        return Response.success();
    }

    @AuthVerification(moduleCode="configCenter_entryRule", needAuth=ActionTypeEnum.CREATE)
    public Response create(ApiCreateVo vo) {
        ApplicationApiCreateParam createParam = new ApplicationApiCreateParam();
        createParam.setRequestMethod(DictionaryCache.getObjectByParam((String)HTTP_METHOD_TYPE, (Integer)Integer.parseInt(vo.getMethod())).getLabel());
        createParam.setApi(vo.getApi());
        createParam.setApplicationName(vo.getApplicationName());
        createParam.setIsDeleted(Byte.valueOf((byte)0));
        createParam.setUpdateTime(new Date());
        createParam.setCreateTime(new Date());
        ApplicationDetailResult applicationDetailResult = this.applicationDAO.getApplicationByCustomerIdAndName(RestContext.getCustomerId(), vo.getApplicationName());
        createParam.setCustomerId(applicationDetailResult.getCustomerId());
        createParam.setUserId(applicationDetailResult.getUserId());
        this.applicationApiDAO.insert(createParam);
        return Response.success();
    }

    public Response queryDetail(String id) {
        EnumResult objectByParam;
        if (Objects.isNull(id)) {
            return Response.fail((String)"0", (String)"id \u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        ApplicationApiManageVO dto = new ApplicationApiManageVO();
        ApplicationApiManage manage = this.manageMapper.selectByPrimaryKey(Long.valueOf(Long.parseLong(id)));
        if (Objects.nonNull(manage)) {
            BeanUtils.copyProperties((Object)manage, (Object)dto);
        }
        if (manage != null && StringUtils.isNotBlank((CharSequence)manage.getRequestMethod()) && (objectByParam = DictionaryCache.getObjectByParamByLabel((String)HTTP_METHOD_TYPE, (String)manage.getRequestMethod())) != null) {
            dto.setRequestMethod(objectByParam.getValue());
        }
        return Response.success((Object)dto);
    }
}

