/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dangdang.ddframe.job.config.JobCoreConfiguration;
import com.dangdang.ddframe.job.config.JobTypeConfiguration;
import com.dangdang.ddframe.job.config.simple.SimpleJobConfiguration;
import com.dangdang.ddframe.job.lite.api.JobScheduler;
import com.dangdang.ddframe.job.lite.api.listener.ElasticJobListener;
import com.dangdang.ddframe.job.lite.config.LiteJobConfiguration;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.pamirs.tro.common.constant.VerifyResultStatusEnum;
import com.pamirs.tro.common.constant.VerifyTypeEnum;
import com.pamirs.tro.entity.domain.dto.scenemanage.SceneManageWrapperDTO;
import com.pamirs.tro.entity.domain.vo.scenemanage.SceneBusinessActivityRefVO;
import io.shulie.tro.cloud.open.req.scenemanage.SceneManageIdReq;
import io.shulie.tro.cloud.open.resp.scenetask.SceneActionResp;
import io.shulie.tro.common.beans.response.ResponseResult;
import io.shulie.tro.exception.entity.ExceptionReadable;
import io.shulie.tro.web.app.exception.ExceptionCode;
import io.shulie.tro.web.app.exception.TroWebException;
import io.shulie.tro.web.app.request.leakcheck.LeakSqlBatchRefsRequest;
import io.shulie.tro.web.app.request.leakverify.LeakVerifyTaskJobParameter;
import io.shulie.tro.web.app.request.leakverify.LeakVerifyTaskRunAssembleRequest;
import io.shulie.tro.web.app.request.leakverify.LeakVerifyTaskRunWithSaveRequest;
import io.shulie.tro.web.app.request.leakverify.LeakVerifyTaskRunWithoutSaveRequest;
import io.shulie.tro.web.app.request.leakverify.LeakVerifyTaskStartRequest;
import io.shulie.tro.web.app.request.leakverify.LeakVerifyTaskStopRequest;
import io.shulie.tro.web.app.response.leakverify.LeakVerifyDetailResponse;
import io.shulie.tro.web.app.response.leakverify.LeakVerifyDsResultResponse;
import io.shulie.tro.web.app.response.leakverify.LeakVerifyTaskResultResponse;
import io.shulie.tro.web.app.service.LeakSqlService;
import io.shulie.tro.web.app.service.VerifyTaskService;
import io.shulie.tro.web.app.service.elasticjoblite.CoordinatorRegistryCenterService;
import io.shulie.tro.web.app.service.elasticjoblite.VerifyJob;
import io.shulie.tro.web.app.service.scenemanage.SceneManageService;
import io.shulie.tro.web.common.vo.component.SelectVO;
import io.shulie.tro.web.data.dao.leakverify.LeakVerifyDetailDAO;
import io.shulie.tro.web.data.dao.leakverify.LeakVerifyResultDAO;
import io.shulie.tro.web.data.param.leakverify.LeakVerifyDetailCreateParam;
import io.shulie.tro.web.data.param.leakverify.LeakVerifyResultCreateParam;
import io.shulie.tro.web.diff.api.scenetask.SceneTaskApi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class VerifyTaskServiceImpl
implements VerifyTaskService {
    private static final Logger log = LoggerFactory.getLogger(VerifyTaskServiceImpl.class);
    public static Map<String, JobScheduler> serviceMap = Maps.newConcurrentMap();
    @Autowired
    private LeakVerifyResultDAO verifyResultDAO;
    @Autowired
    private LeakVerifyDetailDAO verifyDetailDAO;
    @Autowired
    private LeakSqlService leakSqlService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private CoordinatorRegistryCenterService registryCenterService;
    @Autowired
    private SceneTaskApi sceneTaskApi;
    @Autowired
    private SceneManageService sceneManageService;

    @Scheduled(cron="0/10 * *  * * ?")
    public void showdownVerifyTask() {
        if (!serviceMap.isEmpty()) {
            Set keySet = serviceMap.keySet();
            keySet.forEach(mapKey -> {
                String tmpRefId = mapKey.split("\\$")[1];
                Long sceneId = Long.parseLong(tmpRefId);
                SceneManageIdReq req = new SceneManageIdReq();
                req.setId(sceneId);
                ResponseResult response = this.sceneTaskApi.checkTask(req);
                if (!Objects.isNull(response.getData())) {
                    SceneActionResp resp = (SceneActionResp)JSONObject.parseObject((String)JSON.toJSONString((Object)response.getData()), SceneActionResp.class);
                    Long status = resp.getData();
                    if (0L == status) {
                        log.info("\u538b\u6d4b\u573a\u666f\u5df2\u505c\u6b62\uff0c\u5173\u95ed\u9a8c\u8bc1\u4efb\u52a1\uff0c\u573a\u666fID[{}]", (Object)sceneId);
                        JobScheduler jobScheduler = (JobScheduler)serviceMap.get(mapKey);
                        jobScheduler.getSchedulerFacade().shutdownInstance();
                        serviceMap.remove(mapKey);
                        log.info("\u6f0f\u6570\u9a8c\u8bc1\u515c\u5e95\u68c0\u6d4b\uff0c\u573a\u666fID[{}]", (Object)sceneId);
                        LeakVerifyTaskRunWithSaveRequest runRequest = new LeakVerifyTaskRunWithSaveRequest();
                        runRequest.setRefType(VerifyTypeEnum.SCENE.getCode());
                        runRequest.setRefId(sceneId);
                        runRequest.setReportId(resp.getReportId());
                        this.runWithResultSave(runRequest);
                    } else {
                        log.debug("\u538b\u6d4b\u573a\u666f\u4ecd\u5728\u8fd0\u884c\uff0c\u65e0\u6cd5\u5173\u95ed\u9a8c\u8bc1\u4efb\u52a1\uff0c\u72b6\u6001:[{}]" + status);
                    }
                } else {
                    log.error("cloud\u8fd4\u56de\u7684\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5224\u65ad\u538b\u6d4b\u573a\u666f\u72b6\u6001");
                }
            });
        }
    }

    public void start(LeakVerifyTaskStartRequest startRequest) {
        LeakVerifyTaskStopRequest stopRequest = new LeakVerifyTaskStopRequest();
        stopRequest.setRefType(startRequest.getRefType());
        stopRequest.setRefId(startRequest.getRefId());
        this.stop(stopRequest);
        LeakVerifyTaskJobParameter jobParameterObject = new LeakVerifyTaskJobParameter();
        jobParameterObject.setRefType(startRequest.getRefType());
        jobParameterObject.setRefId(startRequest.getRefId());
        jobParameterObject.setTimeInterval(startRequest.getTimeInterval());
        jobParameterObject.setReportId(startRequest.getReportId());
        LeakSqlBatchRefsRequest refsRequest = new LeakSqlBatchRefsRequest();
        refsRequest.setBusinessActivityIds(startRequest.getBusinessActivityIds());
        List verifyTaskConfigList = this.leakSqlService.getVerifyTaskConfig(refsRequest);
        if (CollectionUtils.isEmpty((Collection)verifyTaskConfigList)) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.VERIFY_TASK_RUN_FAILED, (Object)"\u8be5\u4e1a\u52a1\u6d3b\u52a8\u6682\u672a\u914d\u7f6e\u6f0f\u6570\u811a\u672c");
        }
        jobParameterObject.setVerifyTaskConfigList(verifyTaskConfigList);
        String jobParameter = JSON.toJSONString((Object)jobParameterObject);
        JobScheduler jobScheduler = new JobScheduler(this.registryCenterService.getRegistryCenter(), this.createJobConfiguration(jobParameter), new ElasticJobListener[0]);
        jobScheduler.init();
        String mapKey = startRequest.getRefType() + "$" + startRequest.getRefId();
        serviceMap.put(mapKey, jobScheduler);
    }

    private LiteJobConfiguration createJobConfiguration(String jobParameter) {
        LeakVerifyTaskJobParameter jobParameterObjecct = (LeakVerifyTaskJobParameter)JSON.parseObject((String)jobParameter, LeakVerifyTaskJobParameter.class);
        String jobName = "\u9a8c\u8bc1\u4efb\u52a1$" + jobParameterObjecct.getRefType() + "$" + jobParameterObjecct.getRefId();
        int second = Calendar.getInstance().get(13);
        int interval = jobParameterObjecct.getTimeInterval();
        String cron = second + " */" + interval + " * * * ?";
        log.info(jobName + ",cron\u8868\u8fbe\u5f0f:[{}]", (Object)cron);
        JobCoreConfiguration simpleCoreConfig = JobCoreConfiguration.newBuilder((String)jobName, (String)cron, (int)1).jobParameter(jobParameter).build();
        SimpleJobConfiguration simpleJobConfig = new SimpleJobConfiguration(simpleCoreConfig, VerifyJob.class.getCanonicalName());
        return LiteJobConfiguration.newBuilder((JobTypeConfiguration)simpleJobConfig).overwrite(Boolean.TRUE.booleanValue()).build();
    }

    public void stop(LeakVerifyTaskStopRequest stopRequest) {
        Integer refType = stopRequest.getRefType();
        Long refId = stopRequest.getRefId();
        String mapKey = refType + "$" + refId;
        if (serviceMap.containsKey(mapKey)) {
            JobScheduler scheduler = (JobScheduler)serviceMap.get(mapKey);
            log.info("\u5f00\u59cb\u5173\u95ed\u9a8c\u8bc1\u4efb\u52a1:[{},{}]", (Object)Objects.requireNonNull(VerifyTypeEnum.getTypeByCode((Integer)stopRequest.getRefType())).name(), (Object)stopRequest.getRefId());
            scheduler.getSchedulerFacade().shutdownInstance();
            serviceMap.remove(mapKey);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                log.error("error:", (Throwable)e);
            }
            log.info("\u9a8c\u8bc1\u4efb\u52a1\u5df2\u5173\u95ed:[{},{}]", (Object)Objects.requireNonNull(VerifyTypeEnum.getTypeByCode((Integer)stopRequest.getRefType())).name(), (Object)stopRequest.getRefId());
        } else {
            log.debug("\u9a8c\u8bc1\u4efb\u52a1\u4e0d\u5b58\u5728:[{},{}]", (Object)Objects.requireNonNull(VerifyTypeEnum.getTypeByCode((Integer)stopRequest.getRefType())).name(), (Object)stopRequest.getRefId());
        }
    }

    public LeakVerifyTaskResultResponse run(LeakVerifyTaskRunAssembleRequest runAssembleRequest, Boolean isSaveResult) {
        VerifyJob verifyJob = new VerifyJob();
        LeakVerifyTaskJobParameter jobParameter = new LeakVerifyTaskJobParameter();
        Integer refType = runAssembleRequest.getRefType();
        Long refId = runAssembleRequest.getRefId();
        List businessActivityIds = runAssembleRequest.getBusinessActivityIds();
        jobParameter.setRefType(refType);
        jobParameter.setRefId(refId);
        jobParameter.setReportId(runAssembleRequest.getReportId());
        LeakSqlBatchRefsRequest refsRequest = new LeakSqlBatchRefsRequest();
        refsRequest.setBusinessActivityIds(businessActivityIds);
        List verifyTaskConfigList = this.leakSqlService.getVerifyTaskConfig(refsRequest);
        if (CollectionUtils.isEmpty((Collection)verifyTaskConfigList)) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.VERIFY_TASK_RUN_FAILED, (Object)"\u8be5\u4e1a\u52a1\u6d3b\u52a8\u6682\u672a\u914d\u7f6e\u6f0f\u6570\u811a\u672c");
        }
        jobParameter.setVerifyTaskConfigList(verifyTaskConfigList);
        Map resultMap = verifyJob.run(jobParameter);
        if (isSaveResult.booleanValue()) {
            this.saveVerifyResult(jobParameter, resultMap);
            log.info("\u515c\u5e95\u9a8c\u8bc1\u7ed3\u679c\u5165\u5e93:[{},{}]", (Object)Objects.requireNonNull(VerifyTypeEnum.getTypeByCode((Integer)refType)).name(), (Object)refId);
            return null;
        }
        LeakVerifyTaskResultResponse taskResultResponse = new LeakVerifyTaskResultResponse();
        taskResultResponse.setRefType(refType);
        taskResultResponse.setRefId(refId);
        taskResultResponse.setStatus(VerifyResultStatusEnum.UNCHECK.getCode());
        ArrayList dsResultResponseList = Lists.newArrayList();
        verifyTaskConfigList.forEach(verifyTaskConfig -> {
            LeakVerifyDsResultResponse dsResultResponse = new LeakVerifyDsResultResponse();
            dsResultResponse.setDatasourceId(verifyTaskConfig.getDatasourceId());
            dsResultResponse.setDatasourceName(verifyTaskConfig.getDatasourceName());
            dsResultResponse.setJdbcUrl(verifyTaskConfig.getJdbcUrl());
            List sqlList = verifyTaskConfig.getSqls();
            ArrayList detailResponseList = Lists.newArrayList();
            for (int i = 0; i < sqlList.size(); ++i) {
                String sql = (String)sqlList.get(i);
                String keyString = (long)refType.intValue() + refId + verifyTaskConfig.getDatasourceId() + sql;
                Integer mapKey = keyString.hashCode();
                LeakVerifyDetailResponse detailResponse = new LeakVerifyDetailResponse();
                detailResponse.setOrder(Integer.valueOf(i));
                detailResponse.setSql(sql);
                if (resultMap.containsKey(mapKey)) {
                    Integer count = (Integer)resultMap.get(mapKey);
                    switch (count) {
                        case 0: {
                            detailResponse.setStatus(VerifyResultStatusEnum.NORMAL.getCode());
                            break;
                        }
                        case 1: {
                            detailResponse.setStatus(VerifyResultStatusEnum.LEAKED.getCode());
                            break;
                        }
                        case 3: {
                            detailResponse.setStatus(VerifyResultStatusEnum.FAILED.getCode());
                        }
                    }
                } else {
                    detailResponse.setStatus(VerifyResultStatusEnum.UNCHECK.getCode());
                }
                SelectVO vo = new SelectVO();
                vo.setValue(detailResponse.getStatus().toString());
                vo.setLabel(VerifyResultStatusEnum.getLabelByCode((Integer)detailResponse.getStatus()));
                detailResponse.setStatusResponse(vo);
                detailResponseList.add(detailResponse);
            }
            dsResultResponse.setDetailResponseList((List)detailResponseList);
            Map<Integer, List<LeakVerifyDetailResponse>> groupDetailResultMap = detailResponseList.stream().collect(Collectors.groupingBy(LeakVerifyDetailResponse::getStatus));
            if (groupDetailResultMap.containsKey(VerifyResultStatusEnum.LEAKED.getCode())) {
                dsResultResponse.setStatus(VerifyResultStatusEnum.LEAKED.getCode());
            } else if (groupDetailResultMap.containsKey(VerifyResultStatusEnum.FAILED.getCode())) {
                dsResultResponse.setStatus(VerifyResultStatusEnum.FAILED.getCode());
            } else if (groupDetailResultMap.containsKey(VerifyResultStatusEnum.UNCHECK.getCode())) {
                dsResultResponse.setStatus(VerifyResultStatusEnum.UNCHECK.getCode());
            } else {
                dsResultResponse.setStatus(VerifyResultStatusEnum.NORMAL.getCode());
            }
            SelectVO vo = new SelectVO();
            vo.setValue(dsResultResponse.getStatus().toString());
            vo.setLabel(VerifyResultStatusEnum.getLabelByCode((Integer)dsResultResponse.getStatus()));
            dsResultResponse.setStatusResponse(vo);
            dsResultResponseList.add(dsResultResponse);
        });
        Map<Integer, List<LeakVerifyDsResultResponse>> groupDsResultMap = dsResultResponseList.stream().collect(Collectors.groupingBy(LeakVerifyDsResultResponse::getStatus));
        if (groupDsResultMap.containsKey(VerifyResultStatusEnum.LEAKED.getCode())) {
            taskResultResponse.setStatus(VerifyResultStatusEnum.LEAKED.getCode());
        } else if (groupDsResultMap.containsKey(VerifyResultStatusEnum.FAILED.getCode())) {
            taskResultResponse.setStatus(VerifyResultStatusEnum.FAILED.getCode());
        } else if (groupDsResultMap.containsKey(VerifyResultStatusEnum.UNCHECK.getCode())) {
            taskResultResponse.setStatus(VerifyResultStatusEnum.UNCHECK.getCode());
        } else {
            taskResultResponse.setStatus(VerifyResultStatusEnum.NORMAL.getCode());
        }
        taskResultResponse.setDsResultResponseList((List)dsResultResponseList);
        Integer taskStatus = taskResultResponse.getStatus();
        SelectVO vo = new SelectVO();
        vo.setValue(taskStatus.toString());
        vo.setLabel(VerifyResultStatusEnum.getLabelByCode((Integer)taskStatus));
        taskResultResponse.setStatusResponse(vo);
        return taskResultResponse;
    }

    public LeakVerifyTaskResultResponse runWithoutResultSave(LeakVerifyTaskRunWithoutSaveRequest runRequest) {
        LeakVerifyTaskRunAssembleRequest runAssembleRequest = new LeakVerifyTaskRunAssembleRequest();
        runAssembleRequest.setRefType(VerifyTypeEnum.ACTIVITY.getCode());
        runAssembleRequest.setRefId(runRequest.getBusinessActivityId());
        runAssembleRequest.setBusinessActivityIds(Arrays.asList(runRequest.getBusinessActivityId()));
        return this.run(runAssembleRequest, Boolean.FALSE);
    }

    public LeakVerifyTaskResultResponse runWithResultSave(LeakVerifyTaskRunWithSaveRequest runRequest) {
        LeakVerifyTaskRunAssembleRequest runAssembleRequest = new LeakVerifyTaskRunAssembleRequest();
        runAssembleRequest.setRefType(runRequest.getRefType());
        runAssembleRequest.setRefId(runRequest.getRefId());
        runAssembleRequest.setReportId(runRequest.getReportId());
        if (runRequest.getRefType().equals(VerifyTypeEnum.SCENE.getCode())) {
            Long sceneId = runRequest.getRefId();
            ResponseResult webResponse = this.sceneManageService.detailScene(sceneId);
            SceneManageWrapperDTO sceneData = (SceneManageWrapperDTO)JSON.parseObject((String)JSON.toJSONString((Object)webResponse.getData()), SceneManageWrapperDTO.class);
            List businessActivityIds = sceneData.getBusinessActivityConfig().stream().map(SceneBusinessActivityRefVO::getBusinessActivityId).collect(Collectors.toList());
            runAssembleRequest.setBusinessActivityIds(businessActivityIds);
        } else if (!runRequest.getRefType().equals(VerifyTypeEnum.FLOW.getCode())) {
            runAssembleRequest.setBusinessActivityIds(Arrays.asList(runRequest.getRefId()));
        }
        return this.run(runAssembleRequest, Boolean.TRUE);
    }

    public void saveVerifyResult(LeakVerifyTaskJobParameter jobParameter, Map<Integer, Integer> resultMap) {
        if (resultMap.isEmpty()) {
            log.warn("\u9a8c\u8bc1\u7ed3\u679c\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u6f0f\u6570\u7ed3\u679c\u5931\u8d25:[{},{}]", (Object)Objects.requireNonNull(VerifyTypeEnum.getTypeByCode((Integer)jobParameter.getRefType())).name(), (Object)jobParameter.getRefId());
            return;
        }
        this.transactionTemplate.execute(s -> {
            Long refId = jobParameter.getRefId();
            Integer refType = jobParameter.getRefType();
            Long reportId = jobParameter.getReportId();
            List verifyTaskConfigList = jobParameter.getVerifyTaskConfigList();
            verifyTaskConfigList.forEach(verfiyTaskConfig -> {
                Long datasourceId = verfiyTaskConfig.getDatasourceId();
                LeakVerifyResultCreateParam resultCreateParam = new LeakVerifyResultCreateParam();
                resultCreateParam.setRefType(refType);
                resultCreateParam.setRefId(refId);
                resultCreateParam.setReportId(reportId);
                resultCreateParam.setDbresourceId(verfiyTaskConfig.getDatasourceId());
                resultCreateParam.setDbresourceName(verfiyTaskConfig.getDatasourceName());
                resultCreateParam.setDbresourceUrl(verfiyTaskConfig.getJdbcUrl());
                Long resultId = this.verifyResultDAO.insert(resultCreateParam);
                List sqlList = verfiyTaskConfig.getSqls();
                ArrayList detailCreateParamList = Lists.newArrayList();
                sqlList.forEach(sql -> {
                    LeakVerifyDetailCreateParam detailCreateParam = new LeakVerifyDetailCreateParam();
                    detailCreateParam.setResultId(resultId);
                    detailCreateParam.setLeakSql(sql);
                    String keyString = (long)refType.intValue() + refId + datasourceId + sql;
                    Integer sqlKey = keyString.hashCode();
                    if (resultMap.containsKey(sqlKey)) {
                        Integer count = (Integer)resultMap.get(sqlKey);
                        if (VerifyResultStatusEnum.LEAKED.getCode().equals(count)) {
                            SceneActionResp resp;
                            Long status;
                            SceneManageIdReq queryReq = new SceneManageIdReq();
                            queryReq.setId(refId);
                            ResponseResult response = this.sceneTaskApi.checkTask(queryReq);
                            if (!Objects.isNull(response.getData()) && 2L == (status = (resp = (SceneActionResp)JSONObject.parseObject((String)JSON.toJSONString((Object)response.getData()), SceneActionResp.class)).getData())) {
                                SceneManageIdReq stopReq = new SceneManageIdReq();
                                stopReq.setId(refId);
                                this.sceneTaskApi.stopTask(stopReq);
                                log.warn("\u5b58\u5728\u6f0f\u6570\uff0c\u89e6\u53d1SLA\u7ec8\u6b62\u538b\u6d4b\uff0csceneId={}, sql={}", (Object)refId, sql);
                            }
                            detailCreateParam.setStatus(VerifyResultStatusEnum.LEAKED.getCode());
                        } else if (VerifyResultStatusEnum.FAILED.getCode().equals(count)) {
                            detailCreateParam.setStatus(VerifyResultStatusEnum.FAILED.getCode());
                        } else {
                            detailCreateParam.setStatus(VerifyResultStatusEnum.NORMAL.getCode());
                        }
                    } else {
                        detailCreateParam.setStatus(VerifyResultStatusEnum.UNCHECK.getCode());
                    }
                    detailCreateParamList.add(detailCreateParam);
                });
                this.verifyDetailDAO.insertBatch((List)detailCreateParamList);
            });
            return null;
        });
    }

    public Set<String> queryVerifyTask() {
        Set<Object> stringSet = Sets.newHashSet();
        if (!serviceMap.isEmpty()) {
            stringSet = serviceMap.keySet();
        }
        return stringSet;
    }
}

