/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pamirs.tro.common.constant.VerifyResultStatusEnum;
import io.shulie.tro.web.app.request.leakverify.LeakVerifyTaskReportQueryRequest;
import io.shulie.tro.web.app.response.leakverify.LeakVerifyDetailResponse;
import io.shulie.tro.web.app.response.leakverify.LeakVerifyDsResultResponse;
import io.shulie.tro.web.app.response.leakverify.LeakVerifyTaskResultResponse;
import io.shulie.tro.web.app.service.VerifyTaskReportService;
import io.shulie.tro.web.common.vo.component.SelectVO;
import io.shulie.tro.web.data.dao.leakverify.LeakVerifyDetailDAO;
import io.shulie.tro.web.data.dao.leakverify.LeakVerifyResultDAO;
import io.shulie.tro.web.data.param.leakverify.LeakVerifyDetailQueryParam;
import io.shulie.tro.web.data.param.leakverify.LeakVerifyResultQueryParam;
import io.shulie.tro.web.data.result.leakverify.LeakVerifyDetailResult;
import io.shulie.tro.web.data.result.leakverify.LeakVerifyResultResult;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VerifyTaskReportServiceImpl
implements VerifyTaskReportService {
    private static final Logger log = LoggerFactory.getLogger(VerifyTaskReportServiceImpl.class);
    @Autowired
    private LeakVerifyResultDAO resultDAO;
    @Autowired
    private LeakVerifyDetailDAO detailDAO;

    public LeakVerifyTaskResultResponse getVerifyTaskReport(LeakVerifyTaskReportQueryRequest queryRequest) {
        LeakVerifyResultQueryParam resultQueryParam = new LeakVerifyResultQueryParam();
        resultQueryParam.setReportId(queryRequest.getReportId());
        List resultList = this.resultDAO.selectList(resultQueryParam);
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            return null;
        }
        LeakVerifyTaskResultResponse taskResultResponse = new LeakVerifyTaskResultResponse();
        List<Object> dsResultResponseList = Lists.newArrayList();
        taskResultResponse.setStatus(VerifyResultStatusEnum.UNCHECK.getCode());
        taskResultResponse.setRefType(((LeakVerifyResultResult)resultList.get(0)).getRefType());
        taskResultResponse.setRefId(((LeakVerifyResultResult)resultList.get(0)).getRefId());
        List resultIdList = resultList.stream().map(LeakVerifyResultResult::getId).collect(Collectors.toList());
        LeakVerifyDetailQueryParam detailQueryParam = new LeakVerifyDetailQueryParam();
        detailQueryParam.setResultIdList(resultIdList);
        List detailResultList = this.detailDAO.selectList(detailQueryParam);
        HashMap dsResultResponseMap = Maps.newHashMap();
        resultList.forEach(result -> {
            LeakVerifyDsResultResponse dsResultResponse = new LeakVerifyDsResultResponse();
            dsResultResponse.setDatasourceId(result.getDbresourceId());
            dsResultResponse.setDatasourceName(result.getDbresourceName());
            dsResultResponse.setJdbcUrl(result.getDbresourceUrl());
            dsResultResponse.setStatus(VerifyResultStatusEnum.UNCHECK.getCode());
            dsResultResponseMap.putIfAbsent(result.getDbresourceId(), dsResultResponse);
        });
        HashMap<Long, Set> resultIdMap = new HashMap<Long, Set>();
        for (LeakVerifyResultResult leakVerifyResultResult : resultList) {
            Long id = leakVerifyResultResult.getId();
            resultIdMap.computeIfAbsent(leakVerifyResultResult.getDbresourceId(), k -> new HashSet()).add(id);
        }
        for (Map.Entry entry : resultIdMap.entrySet()) {
            Long datasourceId = (Long)entry.getKey();
            Set resultIdSet = (Set)entry.getValue();
            List currentDsDetailResultList = detailResultList.stream().filter(leakVerifyDetailResult -> resultIdSet.contains(leakVerifyDetailResult.getResultId())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(currentDsDetailResultList)) continue;
            Map<String, LeakVerifyDetailResult> detailResultMap = currentDsDetailResultList.stream().collect(Collectors.toMap(LeakVerifyDetailResult::getLeakSql, Function.identity(), BinaryOperator.maxBy(Comparator.comparing(r -> VerifyResultStatusEnum.getWarningLevelByCode((Integer)r.getStatus())))));
            List<Object> detailResponseList = Lists.newArrayList();
            for (Map.Entry<String, LeakVerifyDetailResult> detailResultEntry : detailResultMap.entrySet()) {
                String sql = detailResultEntry.getKey();
                Integer sqlStatus = detailResultEntry.getValue().getStatus();
                LeakVerifyDetailResponse detailResponse = new LeakVerifyDetailResponse();
                detailResponse.setOrder(Integer.valueOf(detailResponseList.size() + 1));
                detailResponse.setSql(sql);
                detailResponse.setStatus(sqlStatus);
                detailResponse.setWarningLevel(VerifyResultStatusEnum.getWarningLevelByCode((Integer)sqlStatus));
                SelectVO vo = new SelectVO();
                vo.setValue(String.valueOf(sqlStatus));
                vo.setLabel(VerifyResultStatusEnum.getLabelByCode((Integer)sqlStatus));
                detailResponse.setStatusResponse(vo);
                detailResponseList.add(detailResponse);
            }
            detailResponseList = detailResponseList.stream().sorted(Comparator.comparing(LeakVerifyDetailResponse::getWarningLevel).reversed()).collect(Collectors.toList());
            Integer dsStatus = detailResponseList.stream().map(LeakVerifyDetailResponse::getStatus).map(VerifyResultStatusEnum::getWarningLevelByCode).filter(Objects::nonNull).max(Integer::compareTo).map(VerifyResultStatusEnum::getCodeByWarningLevel).get();
            LeakVerifyDsResultResponse dsResultResponse = (LeakVerifyDsResultResponse)dsResultResponseMap.get(datasourceId);
            dsResultResponse.setStatus(dsStatus);
            dsResultResponse.setWarningLevel(VerifyResultStatusEnum.getWarningLevelByCode((Integer)dsStatus));
            SelectVO vo = new SelectVO();
            vo.setValue(dsResultResponse.getStatus().toString());
            vo.setLabel(VerifyResultStatusEnum.getLabelByCode((Integer)dsResultResponse.getStatus()));
            dsResultResponse.setStatusResponse(vo);
            dsResultResponse.setDetailResponseList(detailResponseList);
            dsResultResponseList.add(dsResultResponse);
        }
        dsResultResponseList = dsResultResponseList.stream().sorted(Comparator.comparing(LeakVerifyDsResultResponse::getWarningLevel).reversed()).collect(Collectors.toList());
        Integer taskStatus = dsResultResponseList.stream().map(LeakVerifyDsResultResponse::getStatus).map(VerifyResultStatusEnum::getWarningLevelByCode).filter(Objects::nonNull).max(Integer::compareTo).map(VerifyResultStatusEnum::getCodeByWarningLevel).get();
        taskResultResponse.setStatus(taskStatus);
        SelectVO selectVO = new SelectVO();
        selectVO.setValue(taskStatus.toString());
        selectVO.setLabel(VerifyResultStatusEnum.getLabelByCode((Integer)taskStatus));
        taskResultResponse.setStatusResponse(selectVO);
        taskResultResponse.setDsResultResponseList(dsResultResponseList);
        return taskResultResponse;
    }
}

