/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.impl;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.pagehelper.PageHelper;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pamirs.tro.common.constant.LinkLevelEnum;
import com.pamirs.tro.common.constant.TROErrorEnum;
import com.pamirs.tro.common.exception.TROModuleException;
import com.pamirs.tro.common.util.PageInfo;
import com.pamirs.tro.entity.domain.entity.TApplicationMnt;
import com.pamirs.tro.entity.domain.entity.TFirstLinkMnt;
import com.pamirs.tro.entity.domain.entity.TLinkMnt;
import com.pamirs.tro.entity.domain.entity.TSecondBasic;
import com.pamirs.tro.entity.domain.entity.TSecondLinkMnt;
import com.pamirs.tro.entity.domain.vo.TLinkServiceMntVo;
import io.shulie.tro.web.app.common.CommonService;
import io.shulie.tro.web.app.service.TSecondLinkMntService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TSecondLinkMntServiceImpl
extends CommonService
implements TSecondLinkMntService {
    @Transactional(rollbackFor={Exception.class})
    public void saveSecondLink(TSecondLinkMnt secondLinkMnt) throws Exception {
        String linkName = secondLinkMnt.getLinkName();
        int linkExist = this.secondLinkMntDao.saveSecondLinkExist(linkName);
        if (linkExist > 0) {
            throw new TROModuleException(TROErrorEnum.CONFCENTER_SECOND_LINK_DUPICATE_EXCEPTION);
        }
        Long secondLinkId = this.snowflake.next();
        secondLinkMnt.setLinkId(secondLinkId + "");
        secondLinkMnt.setTestStatus("0");
        this.secondLinkMntDao.addSecondLink(secondLinkMnt);
        String baseLinks = secondLinkMnt.getBaseLinks();
        this.saveRelationLink(secondLinkId, baseLinks, "t_second_basic");
    }

    public PageInfo<TSecondLinkMnt> queryLinkList(String linkName, String baseLinkName, Integer pageNum, Integer pageSize) throws TROModuleException {
        List secondLinkList;
        if (pageSize == null || pageNum == null) {
            throw new TROModuleException(TROErrorEnum.PAGE_PARAM_EXCEPTION);
        }
        if (pageSize != -1) {
            PageHelper.startPage((int)pageNum, (int)pageSize);
        }
        if (StringUtils.isEmpty((CharSequence)baseLinkName)) {
            secondLinkList = this.secondLinkMntDao.queryLinkList(linkName);
        } else {
            HashMap<String, String> paramMap = new HashMap<String, String>(10);
            paramMap.put("linkName", linkName);
            paramMap.put("baseLinkName", baseLinkName);
            secondLinkList = this.secondLinkMntDao.querySecondLinkList(paramMap);
        }
        for (TSecondLinkMnt secondLink : secondLinkList) {
            List basicLinkList = this.getRelationLinkRelationShip("t_second_basic", secondLink.getLinkId());
            secondLink.setBaseLinks(JSON.toJSONString((Object)basicLinkList));
            String linkTpsRule = secondLink.getLinkTpsRule();
            String linkTpsRuleName = this.getBaseLinkNameByStr(linkTpsRule);
            secondLink.setLinkTpsRule(linkTpsRuleName);
        }
        return new PageInfo(secondLinkList);
    }

    public Map<String, Object> queryLinkMapByLinkId(String linkId) {
        TSecondLinkMnt secondLinkMnt = this.secondLinkMntDao.queryLinkByLinkId(linkId);
        HashMap<String, Object> secondLinkMap = new HashMap<String, Object>(15);
        ArrayList nodesList = Lists.newArrayList();
        if (secondLinkMnt != null) {
            try {
                String secondLinkName = secondLinkMnt.getLinkName();
                int linkBankCount = this.secondBasicDao.getBasicLinkBankCount(linkId);
                List baseLinkList = this.getRelationLinkRelationShip("t_second_basic", linkId);
                List linkTpsRuleList = this.getLinkDetail(secondLinkMnt.getLinkTpsRule());
                secondLinkMap.put("linkId", secondLinkMnt.getLinkId());
                secondLinkMap.put("linkName", secondLinkName);
                secondLinkMap.put("aswanId", secondLinkMnt.getAswanId());
                secondLinkMap.put("baseLinks", baseLinkList);
                secondLinkMap.put("createTime", secondLinkMnt.getCreateTime());
                secondLinkMap.put("linkTps", secondLinkMnt.getLinkTps());
                secondLinkMap.put("linkTpsRule", linkTpsRuleList);
                secondLinkMap.put("remark", secondLinkMnt.getRemark());
                secondLinkMap.put("updateTime", secondLinkMnt.getUpdateTime());
                secondLinkMap.put("useYn", secondLinkMnt.getUseYn());
                secondLinkMap.put("testStatus", secondLinkMnt.getTestStatus());
                List linkRelation = this.getLinkRelation(linkId, secondLinkName);
                secondLinkMap.put("links", linkRelation);
                HashMap<String, String> secondNodeMap = new HashMap<String, String>();
                secondNodeMap.put("bank", String.valueOf(0));
                secondNodeMap.put("name", secondLinkName);
                secondNodeMap.put("secondLinkId", linkId);
                secondNodeMap.put("x", String.valueOf(1));
                secondNodeMap.put("y", linkBankCount % 2 == 0 ? String.valueOf((double)(linkBankCount / 2) + 0.5) : String.valueOf(linkBankCount / 2 + 1));
                secondNodeMap.put("key", linkId + "0");
                nodesList.add(secondNodeMap);
                List basicNodesList = this.getBasicNodesList(linkId);
                nodesList.addAll(basicNodesList);
                secondLinkMap.put("nodes", nodesList);
            }
            catch (Exception e) {
                this.LOGGER.error("\u57fa\u7840\u94fe\u8def\u89e3\u6790\u5f02\u5e38", (Throwable)e);
                e.printStackTrace();
            }
        }
        return secondLinkMap;
    }

    private List<Map<String, Object>> getBasicNodesList(String secondLinkId) {
        ArrayList<Map<String, Object>> basicNodesList = new ArrayList<Map<String, Object>>();
        List tBasicLinkList = this.secondBasicDao.querySecondBasicLinkRelationBySecondLinkId(secondLinkId);
        HashMap coordinateMap = Maps.newHashMap();
        if (tBasicLinkList != null) {
            for (TLinkMnt basicLink : tBasicLinkList) {
                HashMap basicNodesMap = Maps.newHashMap();
                String bLinkBank = String.valueOf(basicLink.getBLinkBank());
                String basicLinkId = String.valueOf(basicLink.getLinkId());
                ArrayList basicLinkIdList = coordinateMap.get(bLinkBank) == null ? Lists.newArrayList() : (List)coordinateMap.get(bLinkBank);
                basicLinkIdList.add(basicLinkId);
                coordinateMap.put(bLinkBank, basicLinkIdList);
                basicNodesMap.put("name", basicLink.getLinkName());
                basicNodesMap.put("bank", bLinkBank);
                basicNodesMap.put("basicLinkId", basicLinkId);
                basicNodesMap.put("key", basicLinkId + bLinkBank);
                basicNodesList.add(basicNodesMap);
            }
        }
        List linkBankList = this.secondBasicDao.queryBasicLinkBank(secondLinkId);
        for (int i = 0; i < linkBankList.size(); ++i) {
            String linkBank = String.valueOf(linkBankList.get(i));
            List basicLinkIdList = (List)coordinateMap.get(linkBank);
            if (basicLinkIdList == null) continue;
            for (int j = 0; j < basicLinkIdList.size(); ++j) {
                String linkId = (String)basicLinkIdList.get(j);
                for (Map map : basicNodesList) {
                    String basicLinkId = (String)map.get("basicLinkId");
                    String basicLinkBank = (String)map.get("bank");
                    if (!linkBank.equals(basicLinkBank)) continue;
                    map.put("y", String.valueOf(i + 1));
                    if (!linkId.equals(basicLinkId)) continue;
                    map.put("x", String.valueOf(j + 2));
                }
            }
        }
        return basicNodesList;
    }

    private List<Map<String, Object>> getLinkRelation(String secondLinkId, String secondLinkName) {
        HashMap linkParamMap = Maps.newHashMap();
        List tBasicLinkList = this.secondBasicDao.querySecondBasicLinkRelationBySecondLinkId(secondLinkId);
        ArrayList relationList = Lists.newArrayList();
        if (tBasicLinkList != null) {
            for (TLinkMnt basicLink : tBasicLinkList) {
                ArrayList tLinkMnts = linkParamMap.get(String.valueOf(basicLink.getBLinkBank())) == null ? Lists.newArrayList() : (List)linkParamMap.get(String.valueOf(basicLink.getBLinkBank()));
                tLinkMnts.add(basicLink);
                linkParamMap.put(String.valueOf(basicLink.getBLinkBank()), tLinkMnts);
                for (Map.Entry stringListEntry : linkParamMap.entrySet()) {
                    HashMap linkMap = Maps.newHashMap();
                    HashMap secondLinkMap = Maps.newHashMap();
                    secondLinkMap.put("source", secondLinkName);
                    secondLinkMap.put("target", ((TLinkMnt)((List)stringListEntry.getValue()).get(0)).getLinkName());
                    secondLinkMap.put("from", secondLinkId + "0");
                    secondLinkMap.put("to", String.valueOf(((TLinkMnt)((List)stringListEntry.getValue()).get(0)).getLinkId()) + String.valueOf(((TLinkMnt)((List)stringListEntry.getValue()).get(0)).getBLinkBank()));
                    if (!relationList.contains(secondLinkMap)) {
                        relationList.add(secondLinkMap);
                    }
                    List value = (List)stringListEntry.getValue();
                    for (int i = 0; i < value.size() - 1; ++i) {
                        linkMap.put("source", ((TLinkMnt)value.get(i)).getLinkName());
                        linkMap.put("target", ((TLinkMnt)value.get(i + 1)).getLinkName());
                        linkMap.put("from", String.valueOf(((TLinkMnt)value.get(i)).getLinkId()) + String.valueOf(((TLinkMnt)value.get(i)).getBLinkBank()));
                        linkMap.put("to", String.valueOf(((TLinkMnt)value.get(i + 1)).getLinkId()) + String.valueOf(((TLinkMnt)value.get(i + 1)).getBLinkBank()));
                        if (relationList.contains(linkMap)) continue;
                        relationList.add(linkMap);
                        linkMap = Maps.newHashMap();
                    }
                }
            }
        }
        return relationList;
    }

    @Deprecated
    public List<List<Map<String, Object>>> getBasicLinkBySecondLinkId(String secondLinkId) {
        List tSecondBasics = this.secondBasicDao.querySecondBasicLinkBySecondLinkIdModify(secondLinkId);
        ConcurrentMap<String, List<Map>> groupBasicLink = tSecondBasics.stream().collect(Collectors.groupingByConcurrent(map -> MapUtils.getString((Map)map, (Object)"BLINK_BANK")));
        ArrayList baseLinkList = Lists.newArrayListWithCapacity((int)groupBasicLink.size());
        groupBasicLink.forEach((string, mapList) -> {
            Iterator iterator = mapList.iterator();
            while (iterator.hasNext()) {
                ((Map)iterator.next()).remove("BLINK_BANK");
            }
            baseLinkList.add(mapList);
        });
        return baseLinkList;
    }

    public TSecondLinkMnt queryLinkByLinkId(String linkId) {
        return this.secondLinkMntDao.queryLinkByLinkId(linkId);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteLinkByLinkIds(String linkIds) {
        List linkIdLists = Arrays.stream(linkIds.split(",")).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
        this.secondLinkMntDao.deleteLinkByLinkIds(linkIdLists);
        this.secondBasicDao.deleteRefBySecondLinkId(linkIdLists);
        ArrayList logList = Lists.newArrayList();
        List secondLinkList = this.secondLinkMntDao.querySecondLinkListByIds(linkIdLists);
        List secondBasicLinkList = this.secondBasicDao.querySecondBasicLinkListByIds(linkIdLists);
        logList.add(secondLinkList);
        logList.add(secondBasicLinkList);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateLinkinfo(TSecondLinkMnt secondLinkMnt) throws TROModuleException {
        String secondLinkId = secondLinkMnt.getLinkId();
        TSecondLinkMnt originSecondLinkMnt = this.secondLinkMntDao.queryLinkByLinkId(secondLinkId);
        if (Objects.isNull(originSecondLinkMnt)) {
            this.LOGGER.info(TROErrorEnum.CONFCENTER_NOT_FOUND_SECOND_LINKID_EXCEPTION.getErrorMessage());
            throw new TROModuleException(TROErrorEnum.CONFCENTER_NOT_FOUND_SECOND_LINKID_EXCEPTION);
        }
        TSecondLinkMnt secondLink = this.queryLinkByLinkId(secondLinkId);
        secondLink.setUseYn(secondLinkMnt.getUseYn());
        secondLink.setAswanId(secondLinkMnt.getAswanId());
        secondLink.setBaseLinks(secondLinkMnt.getBaseLinks());
        secondLink.setLinkName(secondLinkMnt.getLinkName());
        secondLink.setLinkTpsRule(secondLinkMnt.getLinkTpsRule());
        secondLink.setRemark(secondLinkMnt.getRemark());
        this.secondLinkMntDao.updateLink(secondLink);
        this.secondBasicDao.deleteRefBySecondLinkId(Collections.singletonList(secondLinkId));
        this.saveRelationLink(Long.valueOf(Long.parseLong(secondLinkId)), secondLinkMnt.getBaseLinks(), "t_second_basic");
    }

    public void updateSecondLinkStatus(String secondLinkId, String testStatus) {
        TSecondLinkMnt tSecondLinkMnt = this.queryLinkByLinkId(secondLinkId);
        tSecondLinkMnt.setTestStatus(testStatus);
        this.secondLinkMntDao.updateLink(tSecondLinkMnt);
    }

    public Map<String, List<TApplicationMnt>> queryApplicationListByLinkInfo(String linkId, String linkLevel) throws TROModuleException {
        HashMap<String, List<TApplicationMnt>> resultMap = new HashMap<String, List<TApplicationMnt>>();
        if (LinkLevelEnum.BASE_LINK_LEVEL.getName().equals(linkLevel)) {
            resultMap.put(linkId, this.queryApplicationByBaseLinkId(linkId));
        }
        if (LinkLevelEnum.SECOND_LINK_LEVEL.getName().equals(linkLevel)) {
            resultMap.putAll(this.queryApplicationBySecondLinkId(linkId));
        }
        if (LinkLevelEnum.FIRST_LINK_LEVEL.getName().equals(linkLevel)) {
            resultMap.putAll(this.queryApplicationByFirstLinkId(linkId));
        }
        return resultMap;
    }

    private Map<String, List<TApplicationMnt>> queryApplicationByFirstLinkId(String linkId) throws TROModuleException {
        TFirstLinkMnt firstLinkMnt = this.firstLinkMntDao.queryLinkByLinkId(linkId);
        HashMap<String, List<TApplicationMnt>> resultMap = new HashMap<String, List<TApplicationMnt>>();
        if (firstLinkMnt != null) {
            String[] secondLinkIdArr;
            String secondLinks = firstLinkMnt.getSecondLinks();
            if (secondLinks == null) {
                this.LOGGER.error("\u4e8c\u7ea7\u57fa\u7840\u94fe\u8def\u4e3aNULL\uff01");
                throw new TROModuleException(TROErrorEnum.CONFCENTER_SECOND_LINKID_LIST_IS_NULL_EXCEPTION);
            }
            for (String secondLinkId : secondLinkIdArr = secondLinks.split(",")) {
                resultMap.putAll(this.queryApplicationBySecondLinkId(secondLinkId));
            }
        }
        return resultMap;
    }

    private Map<String, List<TApplicationMnt>> queryApplicationBySecondLinkId(String secondLinkId) {
        HashMap<String, List<TApplicationMnt>> resultMap = new HashMap<String, List<TApplicationMnt>>();
        List secondBasicList = this.secondBasicDao.querySecondBasicLinkBySecondLinkId(secondLinkId);
        if (secondBasicList != null && secondBasicList.size() > 0) {
            for (TSecondBasic secondBasic : secondBasicList) {
                long basicLinkId = secondBasic.getBasicLinkId();
                String linkId = String.valueOf(basicLinkId);
                resultMap.put(linkId, this.queryApplicationByBaseLinkId(linkId));
            }
        }
        return resultMap;
    }

    private List<TApplicationMnt> queryApplicationByBaseLinkId(String baseLinkId) {
        return this.secondLinkMntDao.queryApplicationByBaseLinkId(baseLinkId);
    }

    @Deprecated
    private void saveSecondBasicLinkRef(Long secondLinkId, String baseLinks) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        List jsonList = (List)mapper.readValue(baseLinks, List.class);
        for (int j = 0; j < jsonList.size(); ++j) {
            List baseLinkList = (List)jsonList.get(j);
            for (int i = 0; i < baseLinkList.size(); ++i) {
                String baseLink = (String)baseLinkList.get(i);
                TSecondBasic secondBasic = new TSecondBasic();
                secondBasic.setSecondLinkId(secondLinkId.longValue());
                secondBasic.setBasicLinkId(Long.parseLong(baseLink));
                secondBasic.setBlinkOrder(i + 1);
                secondBasic.setBlinkBank(j + 1);
                this.secondBasicDao.saveSecondBasicLink(secondBasic);
            }
        }
    }

    private String getBaseLinkNameByStr(String linkIds) {
        List linkIdList = Splitter.on((String)",").omitEmptyStrings().trimResults().splitToList((CharSequence)linkIds);
        return Joiner.on((String)",").join((Iterable)this.tLinkMnDao.transferBusinessLinkName(linkIdList));
    }

    private List<Map<String, Object>> getLinkDetail(String linkIds) {
        List linkIdList = Splitter.on((String)",").omitEmptyStrings().trimResults().splitToList((CharSequence)linkIds);
        return this.tLinkMnDao.transferBusinessLinkNameAndId(linkIdList);
    }

    @Deprecated
    private List<Map<String, Object>> getLinkDetailByIds(String linkIds) {
        String[] linkIdArr;
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (String linkId : linkIdArr = linkIds.split(",")) {
            TLinkServiceMntVo linkServiceMntVo = this.tLinkMnDao.queryLinkByLinkId(linkId);
            if (linkServiceMntVo == null) continue;
            HashMap<String, String> map = new HashMap<String, String>(5);
            String linkName = linkServiceMntVo.getLinkName();
            map.put("label", linkName);
            map.put("value", linkId);
            list.add(map);
        }
        return list;
    }
}

