/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Joiner;
import com.google.gson.Gson;
import com.pamirs.tro.common.constant.LinkLevelEnum;
import com.pamirs.tro.common.constant.TROErrorEnum;
import com.pamirs.tro.common.constant.TimeUnits;
import com.pamirs.tro.common.exception.TROModuleException;
import com.pamirs.tro.common.util.DateUtils;
import com.pamirs.tro.common.util.HmacSha1Signature;
import com.pamirs.tro.common.util.NumberUtil;
import com.pamirs.tro.entity.domain.entity.TAlarm;
import com.pamirs.tro.entity.domain.entity.TApplicationIp;
import com.pamirs.tro.entity.domain.entity.TApplicationMnt;
import com.pamirs.tro.entity.domain.entity.TReport;
import com.pamirs.tro.entity.domain.query.Result;
import com.pamirs.tro.entity.domain.query.ResultList;
import com.pamirs.tro.entity.domain.query.TAlarmQuery;
import com.pamirs.tro.entity.domain.query.TReportQuery;
import com.pamirs.tro.entity.domain.vo.TLinkBasicVO;
import com.pamirs.tro.entity.domain.vo.TLinkServiceMntVo;
import com.pamirs.tro.entity.domain.vo.TReportAppIpDetail;
import com.pamirs.tro.entity.domain.vo.TReportDetail;
import com.pamirs.tro.entity.domain.vo.TReportResult;
import com.pamirs.tro.entity.domain.vo.TScenario;
import io.shulie.tro.web.app.common.CommonService;
import io.shulie.tro.web.app.service.TReportService;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.stereotype.Service;

@Service
public class TReportServiceImpl
extends CommonService
implements TReportService {
    public Result<Void> add(TReport tReport) {
        Result result = new Result();
        try {
            int count = this.tReportDao.insert((Object)tReport);
            if (count != 1) {
                result.setSuccess(Boolean.FALSE.booleanValue());
                result.setErrorMessage(TROErrorEnum.MONITOR_DB_ADD_EXCEPTION.getErrorMessage());
            }
        }
        catch (Exception e) {
            this.LOGGER.error(MessageFormat.format("error:{0},model:{1}", TROErrorEnum.MONITOR_DB_ADD_EXCEPTION.getErrorMessage(), JSON.toJSONString((Object)tReport)), (Throwable)e);
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage(TROErrorEnum.MONITOR_DB_ADD_EXCEPTION.getErrorMessage());
        }
        return result;
    }

    public Result<Void> modify(TReport tReport) {
        Result result = new Result();
        if (null == tReport || null == tReport.getId()) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            return result;
        }
        try {
            int count = this.tReportDao.update((Object)tReport);
            TReport tReportfromDb = (TReport)this.tReportDao.selectOneById(tReport.getId());
            Date startTime = tReportfromDb.getStartTime();
            Date endTime = tReportfromDb.getEndTime();
            String secondLinkId = tReportfromDb.getSecondLinkId();
            if (StringUtils.isNotEmpty((CharSequence)secondLinkId) && startTime != null && endTime != null) {
                Map baseLinkIdToApplication = this.tSecondLinkMntService.queryApplicationListByLinkInfo(secondLinkId, LinkLevelEnum.SECOND_LINK_LEVEL.getName());
                String linkBasic = tReportfromDb.getLinkBasic();
                List tLinkBasicVOS = Collections.EMPTY_LIST;
                if (StringUtils.isNotEmpty((CharSequence)linkBasic)) {
                    tLinkBasicVOS = JSON.parseArray((String)linkBasic, TLinkBasicVO.class);
                }
                if (baseLinkIdToApplication != null && baseLinkIdToApplication.size() > 0) {
                    for (Map.Entry baseLinkIdToApplicationEntry : baseLinkIdToApplication.entrySet()) {
                        List applicationList;
                        if (tLinkBasicVOS.stream().noneMatch(tLinkBasicVO -> tLinkBasicVO.getLinkId().equals(baseLinkIdToApplicationEntry.getKey())) || CollectionUtils.isEmpty((Collection)(applicationList = (List)baseLinkIdToApplicationEntry.getValue()))) continue;
                        for (TApplicationMnt app : applicationList) {
                            List appIpList = this.tApplicationIpDao.queryApplicationIpByNameList(app.getApplicationName());
                            if (appIpList == null) continue;
                            for (TApplicationIp appIpObj : appIpList) {
                                String endMin;
                                String startMin;
                                Map map;
                                String type = appIpObj.getType();
                                String ip = appIpObj.getIp();
                                if (StringUtils.isEmpty((CharSequence)ip) || (map = this.aopsService.getAopsData(ip, startMin = HmacSha1Signature.getDateMinuteModified((Date)new Date(), (Date)startTime), endMin = HmacSha1Signature.getDateMinuteModified((Date)new Date(), (Date)endTime), StringUtils.substringBefore((String)(System.currentTimeMillis() / 1000L + ""), (String)"."))) == null || map.size() <= 0) continue;
                                String averageMemoryPercent = (String)map.get("averageMemoryPercent");
                                String averageCpuPercent = (String)map.get("averageCpugpuPercent");
                                String averagetotalIoWriterSpeed = (String)map.get("averagetotalIoWriterSpeed");
                                String averagetotalIoReaderSpeed = (String)map.get("averagetotalIoReaderSpeed");
                                String averagetotalIoSpeed = (String)map.get("averagetotalIoSpeed");
                                List tReportAppIpDetails = this.tReportAppIpDetailDao.countMechine(String.valueOf(tReport.getId()), app.getApplicationName(), (String)baseLinkIdToApplicationEntry.getKey(), ip);
                                if (tReportAppIpDetails != null && tReportAppIpDetails.size() > 0) {
                                    tReportAppIpDetails.forEach(tReportAppIpDetail -> {
                                        tReportAppIpDetail.setCpu(averageCpuPercent);
                                        tReportAppIpDetail.setIoall(averagetotalIoSpeed);
                                        tReportAppIpDetail.setIoread(averagetotalIoReaderSpeed);
                                        tReportAppIpDetail.setIowrite(averagetotalIoWriterSpeed);
                                        tReportAppIpDetail.setMemory(averageMemoryPercent);
                                        tReportAppIpDetail.setType(type);
                                        tReportAppIpDetail.setSystemName(appIpObj.getSystemName());
                                        this.tReportAppIpDetailDao.update(tReportAppIpDetail);
                                    });
                                    continue;
                                }
                                TReportAppIpDetail appIpDetail = new TReportAppIpDetail();
                                appIpDetail.setId(UUID.randomUUID().toString());
                                appIpDetail.setLinkId((String)baseLinkIdToApplicationEntry.getKey());
                                appIpDetail.setReportId(tReport.getId() + "");
                                appIpDetail.setApplicationName(app.getApplicationName());
                                appIpDetail.setCpu(averageCpuPercent);
                                appIpDetail.setIoall(averagetotalIoSpeed);
                                appIpDetail.setIoread(averagetotalIoReaderSpeed);
                                appIpDetail.setIowrite(averagetotalIoWriterSpeed);
                                appIpDetail.setMemory(averageMemoryPercent);
                                appIpDetail.setIp(ip);
                                appIpDetail.setType(type);
                                appIpDetail.setSystemName(appIpObj.getSystemName());
                                this.tReportAppIpDetailDao.insert((Object)appIpDetail);
                            }
                        }
                    }
                }
            }
            if (count != 1) {
                result.setSuccess(Boolean.FALSE.booleanValue());
                result.setErrorMessage(TROErrorEnum.MONITOR_DB_UPDATE_EXCEPTION.getErrorMessage());
            }
        }
        catch (TROModuleException e) {
            this.LOGGER.error(MessageFormat.format("error:{0},model:{1}", TROErrorEnum.MONITOR_DB_UPDATE_EXCEPTION.getErrorMessage(), JSON.toJSONString((Object)tReport)), (Throwable)e);
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage(TROErrorEnum.MONITOR_DB_UPDATE_EXCEPTION.getErrorMessage());
        }
        return result;
    }

    public Result<Void> deleteById(Long id) {
        Result result = new Result();
        if (null == id) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            return result;
        }
        try {
            int count = this.tReportDao.delete(id);
            if (count != 1) {
                result.setSuccess(Boolean.FALSE.booleanValue());
                result.setErrorMessage(TROErrorEnum.MONITOR_DB_DELETE_EXCEPTION.getErrorMessage());
            }
        }
        catch (Exception e) {
            this.LOGGER.error(MessageFormat.format("error:{0},id:{1}", TROErrorEnum.MONITOR_DB_DELETE_EXCEPTION.getErrorMessage(), id), (Throwable)e);
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage(TROErrorEnum.MONITOR_DB_DELETE_EXCEPTION.getErrorMessage());
        }
        return result;
    }

    public ResultList<TReport> queryListByQuery(TReportQuery query) {
        ResultList resultList = new ResultList();
        try {
            query.setOrderBy("start_time desc");
            List tReportList = this.tReportDao.selectList(query);
            long count = this.tReportDao.selectListCount(query);
            resultList = new ResultList((long)query.getStart(), count, query.getPageSize(), (Collection)tReportList);
            return resultList;
        }
        catch (Exception e) {
            this.LOGGER.error(MessageFormat.format("error:{0},query:{1}", TROErrorEnum.MONITOR_DB_QUERYLIST_EXCEPTION.getErrorMessage(), JSON.toJSONString((Object)query)), (Throwable)e);
            resultList.setSuccess(Boolean.FALSE.booleanValue());
            resultList.setErrorMessage(TROErrorEnum.MONITOR_DB_QUERYLIST_EXCEPTION.getErrorMessage());
            return resultList;
        }
    }

    public Result<TReport> queryOneById(Long id) {
        Result result = new Result();
        if (null == id) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            return result;
        }
        try {
            TReport tReport = (TReport)this.tReportDao.selectOneById(id);
            result.setData((Object)tReport);
        }
        catch (Exception e) {
            this.LOGGER.error(MessageFormat.format("error:{0},id:{1}", TROErrorEnum.MONITOR_DB_QUERY_EXCEPTION.getErrorMessage(), id), (Throwable)e);
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage(TROErrorEnum.MONITOR_DB_QUERY_EXCEPTION.getErrorMessage());
        }
        return result;
    }

    public Result<TReport> queryOneByScenarioId(Long id, Integer status) {
        Result result = new Result();
        if (null == id || null == status) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            return result;
        }
        try {
            TReport tReport = this.tReportDao.selectScenarioId(id, status);
            result.setData((Object)tReport);
        }
        catch (Exception e) {
            this.LOGGER.error(MessageFormat.format("error:{0},id:{1}", TROErrorEnum.MONITOR_DB_QUERY_EXCEPTION.getErrorMessage(), id), (Throwable)e);
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage(TROErrorEnum.MONITOR_DB_QUERY_EXCEPTION.getErrorMessage());
        }
        return result;
    }

    public List<TReportAppIpDetail> queryMachineDetail(TReport tReport) {
        List list = this.tReportAppIpDetailDao.queryMachineDetail(tReport.getId() + "");
        return list;
    }

    public List<TReport> queryBySecondLinkIdAndStatus(String secondLinkId, String status) {
        return this.tReportDao.queryBySecondLinkIdAndStatus(secondLinkId, status);
    }

    public List<TReport> queryStatus(String status) {
        return this.tReportDao.queryByStatus(status);
    }

    public TReportDetail queryReportDetail(Long reportId) {
        Result reportResult = this.queryOneById(reportId);
        TReportDetail tReportDetail = new TReportDetail();
        if (reportResult.isSuccess() && null != reportResult.getData()) {
            TReport tReport = (TReport)reportResult.getData();
            List list = (List)new Gson().fromJson(tReport.getLinkBasicName().trim(), new /* Unavailable Anonymous Inner Class!! */.getType());
            String basicLinkName = Joiner.on((String)",").join((Iterable)list.stream().flatMap(mapList -> mapList.stream()).map(map -> MapUtils.getString((Map)map, (Object)"label")).distinct().collect(Collectors.toList()));
            tReport.setLinkBasicName(basicLinkName);
            tReportDetail.setPass(Boolean.valueOf(true));
            tReportDetail.settReport(tReport);
            ArrayList<TReportResult> tReportResults = new ArrayList<TReportResult>();
            String linkBasic = tReport.getLinkBasic();
            List tLinkBasicVOS = JSON.parseArray((String)linkBasic, TLinkBasicVO.class);
            if (CollectionUtils.isEmpty((Collection)tLinkBasicVOS)) {
                tReportDetail.setPass(Boolean.valueOf(false));
            }
            for (TLinkBasicVO tLinkBasicVO : tLinkBasicVOS) {
                TScenario statistics = tLinkBasicVO.getStatistics();
                TReportResult tReportResult = new TReportResult();
                tReportResult.setPass(Boolean.valueOf(true));
                TLinkServiceMntVo tLinkServiceMntVo = new TLinkServiceMntVo();
                tLinkServiceMntVo.setLinkId(Long.valueOf(tLinkBasicVO.getLinkId()).longValue());
                tLinkServiceMntVo.setLinkName(tLinkBasicVO.getLinkName());
                tLinkServiceMntVo.setRtSa(tLinkBasicVO.getRtSa());
                tLinkServiceMntVo.setRt(tLinkBasicVO.getRt());
                tLinkServiceMntVo.setTps(tLinkBasicVO.getTps());
                tLinkServiceMntVo.setTargetSuccessRate(tLinkBasicVO.getTargetSuccessRate());
                tLinkServiceMntVo.setAswanId(tLinkBasicVO.getAswanId());
                tReportResult.settLinkServiceMntVo(tLinkServiceMntVo);
                if (statistics != null) {
                    boolean flag;
                    tReportResult.settScenario(statistics);
                    Integer actualTps = Objects.isNull(statistics.getTps()) ? 0 : statistics.getTps();
                    Integer targetTps = NumberUtils.createInteger((String)(StringUtils.isEmpty((CharSequence)tLinkBasicVO.getTps()) ? "0" : tLinkBasicVO.getTps()));
                    BigDecimal actualRt = Objects.isNull(statistics.getRt()) ? BigDecimal.ZERO : statistics.getRt();
                    BigDecimal targetRt = NumberUtils.createBigDecimal((String)(StringUtils.isEmpty((CharSequence)tLinkBasicVO.getRt()) ? "0" : tLinkBasicVO.getRt()));
                    BigDecimal actualSuccessRate = Objects.isNull(statistics.getSuccessRate()) ? BigDecimal.ZERO : statistics.getSuccessRate();
                    BigDecimal targetSuccessRate = NumberUtils.createBigDecimal((String)(StringUtils.isEmpty((CharSequence)tLinkBasicVO.getTargetSuccessRate()) ? "0" : tLinkBasicVO.getTargetSuccessRate()));
                    BigDecimal actualRtRate = Objects.isNull(statistics.getRtRate()) ? BigDecimal.ZERO : statistics.getRtRate();
                    BigDecimal targetRtSa = NumberUtils.createBigDecimal((String)(StringUtils.isEmpty((CharSequence)tLinkBasicVO.getRtSa()) ? "0" : tLinkBasicVO.getRtSa()));
                    boolean bl = flag = actualTps < targetTps || actualRt.compareTo(targetRt) > 0 || actualSuccessRate.compareTo(targetSuccessRate) < 0 || actualRtRate.compareTo(targetRtSa) < 0;
                    if (flag) {
                        tReportDetail.setPass(Boolean.valueOf(false));
                        tReportResult.setPass(Boolean.valueOf(false));
                    }
                } else {
                    tReportDetail.setPass(Boolean.valueOf(false));
                    tReportResult.setPass(Boolean.valueOf(false));
                }
                tReportResult.setDuration(Long.valueOf(DateUtils.gapTime((Date)tLinkBasicVO.getStartTime(), (Date)tLinkBasicVO.getEndTime(), (TimeUnits)TimeUnits.MINUTES)));
                List tReportAppIpDetails = this.queryApplicationIpByIpList(String.valueOf(reportId), String.valueOf(tLinkBasicVO.getLinkId()));
                tReportResult.settReportAppIpDetails(tReportAppIpDetails);
                HashMap<String, ArrayList<TReportAppIpDetail>> serverGroup = new HashMap<String, ArrayList<TReportAppIpDetail>>(10);
                for (TReportAppIpDetail tReportAppIpDetail2 : tReportAppIpDetails) {
                    String type = tReportAppIpDetail2.getType();
                    if ("web".equals(type)) {
                        ArrayList<TReportAppIpDetail> webServerArray = (ArrayList<TReportAppIpDetail>)serverGroup.get("web");
                        if (CollectionUtils.isEmpty((Collection)webServerArray)) {
                            webServerArray = new ArrayList<TReportAppIpDetail>();
                        }
                        webServerArray.add(tReportAppIpDetail2);
                        serverGroup.put("web", webServerArray);
                        continue;
                    }
                    if ("db".equals(type)) {
                        ArrayList<TReportAppIpDetail> dbServerArray = (ArrayList<TReportAppIpDetail>)serverGroup.get("db");
                        if (CollectionUtils.isEmpty((Collection)dbServerArray)) {
                            dbServerArray = new ArrayList<TReportAppIpDetail>();
                        }
                        dbServerArray.add(tReportAppIpDetail2);
                        serverGroup.put("db", dbServerArray);
                        continue;
                    }
                    ArrayList<TReportAppIpDetail> middlewareServerArray = (ArrayList<TReportAppIpDetail>)serverGroup.get("other");
                    if (CollectionUtils.isEmpty((Collection)middlewareServerArray)) {
                        middlewareServerArray = new ArrayList<TReportAppIpDetail>();
                    }
                    middlewareServerArray.add(tReportAppIpDetail2);
                    serverGroup.put("other", middlewareServerArray);
                }
                if (serverGroup.size() > 0) {
                    List webServer = (List)serverGroup.get("web");
                    HashMap<String, Float> webServerInfo = new HashMap<String, Float>();
                    webServerInfo.put("maxCpuUsageRate", webServer == null ? Float.valueOf(0.0f) : webServer.stream().map(tReportAppIpDetail -> Float.valueOf(NumberUtil.getFloat((String)tReportAppIpDetail.getCpu()))).max(Comparator.comparing(u -> u)).orElse(Float.valueOf(0.0f)));
                    webServerInfo.put("maxMemoryUsageRate", webServer == null ? Float.valueOf(0.0f) : webServer.stream().map(tReportAppIpDetail -> Float.valueOf(NumberUtil.getFloat((String)tReportAppIpDetail.getMemory()))).max(Comparator.comparing(u -> u)).orElse(Float.valueOf(0.0f)));
                    tReportResult.setWebServer(webServerInfo);
                    List dbServerInfo = (List)serverGroup.get("db");
                    HashMap<String, Float> dbServer = new HashMap<String, Float>();
                    dbServer.put("maxCpuUsageRate", dbServerInfo == null ? Float.valueOf(0.0f) : dbServerInfo.stream().map(tReportAppIpDetail -> Float.valueOf(NumberUtil.getFloat((String)tReportAppIpDetail.getCpu()))).max(Comparator.comparing(u -> u)).orElse(Float.valueOf(0.0f)));
                    dbServer.put("maxMemoryUsageRate", dbServerInfo == null ? Float.valueOf(0.0f) : dbServerInfo.stream().map(tReportAppIpDetail -> Float.valueOf(NumberUtil.getFloat((String)tReportAppIpDetail.getMemory()))).max(Comparator.comparing(u -> u)).orElse(Float.valueOf(0.0f)));
                    tReportResult.setDbServer(dbServer);
                    List otherServerInfo = (List)serverGroup.get("other");
                    HashMap<String, Float> otherServer = new HashMap<String, Float>();
                    otherServer.put("maxCpuUsageRate", dbServerInfo == null ? Float.valueOf(0.0f) : otherServerInfo.stream().map(tReportAppIpDetail -> Float.valueOf(NumberUtil.getFloat((String)tReportAppIpDetail.getCpu()))).max(Comparator.comparing(u -> u)).orElse(Float.valueOf(0.0f)));
                    otherServer.put("maxMemoryUsageRate", dbServerInfo == null ? Float.valueOf(0.0f) : otherServerInfo.stream().map(tReportAppIpDetail -> Float.valueOf(NumberUtil.getFloat((String)tReportAppIpDetail.getMemory()))).max(Comparator.comparing(u -> u)).orElse(Float.valueOf(0.0f)));
                    tReportResult.setMiddlewareServer(otherServer);
                }
                tReportResult.settScenarioList(tLinkBasicVO.getStatisticsPerMinute());
                tReportResults.add(tReportResult);
            }
            tReportDetail.settReportResults(tReportResults);
            List reportAppIpDetailList = this.queryMachineDetail(tReport);
            TAlarmQuery query = new TAlarmQuery();
            TAlarm tAlarm = new TAlarm();
            query.setQuery((Object)tAlarm);
            query.setBeginAlarmDate(DateUtils.dateToString((Date)tReport.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            query.setEndAlarmDate(DateUtils.dateToString((Date)tReport.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            query.setWarNames(reportAppIpDetailList.stream().map(reportAppIpDetail -> reportAppIpDetail.getApplicationName()).collect(Collectors.toList()));
            tReportDetail.setPass(Boolean.valueOf(true));
        }
        return tReportDetail;
    }

    public List<TReportAppIpDetail> queryApplicationIpByIpList(String reportId, String linkId) {
        return this.tReportAppIpDetailDao.queryReportAppIpListByReportIdAndLinkId(reportId, linkId);
    }
}

